//
//
//

#include "stdafx.h"
#include "Pathfinder.h"
#include "PathNodeSet.h"


cPathNodeSet::cPathNodeSet()
{
	mPointArray = NULL;
	mCurrentUseIndex = 0;
	mpPathfinder = NULL;
	mTotalPathCount = 0;
	
}

cPathNodeSet::~cPathNodeSet()
{
	MemoryDestory();
	
}

void cPathNodeSet::MemoryDestory()
{
	mPosvectorlist.Clear();

	if(mPointArray)
	{
		delete[] mPointArray; mPointArray = NULL;
	}
}

bool cPathNodeSet::Create(cPathfinder* pathfinder)
{
	MemoryDestory();
	
	mpPathfinder = pathfinder;
	
	
	mPosvectorlist.Clear();
	mPointArray = new POINT[31];

	return true;
}


void cPathNodeSet::RayPath( float destx, float desty )
{

	mCurrentUseIndex = 0;
	mTotalPathCount = 1;

	mPosvectorlist.Clear();

	Point2 pos = {destx,desty};
	mPosvectorlist.PushBack(pos);
	//mPosvectorlist[0].x = destx;
	//mPosvectorlist[0].y = desty;
	//mPosvectorlist[1] = NiPoint2(destx,desty);

}

/* ------------------------------------------------------------------
* Լ̸ :	ResetPath
*      :    θ ٽ  Լ(ü)
* ǻ :    
* ------------------------------------------------------------------ */

void cPathNodeSet::ResetPath(float startx,float starty,float destx,float desty)
{
	mCurrentUseIndex = 0;
	mTotalPathCount = 0;

	float onetilesize = mpPathfinder->GetOneTileSize();

	startx	= startx/onetilesize;
	starty	= starty/onetilesize;
	destx	= destx/onetilesize;
	desty	= desty/onetilesize;

	if(startx < 0)
	{
		assert(0);
		return;
	}
	if(starty < 0)
	{
		assert(0);
		return;
	}
	if(destx < 0)
	{
		assert(0);
		return;
	}
	if(desty < 0)
	{
		assert(0);
		return;
	}

	mpPathfinder->DoRefind((unsigned int)startx,(unsigned int)starty,(unsigned int)destx,(unsigned int)desty);
	
	if(mpPathfinder->GetLastResult() == PATH_BLOCK)
	{
		return;
	}
	
	mTotalPathCount = mpPathfinder->FindUpdate(0);

	if(mTotalPathCount > 0)
	{
		mpPathfinder->CopyPathArray(mPointArray,31,mTotalPathCount,false);

		MakeRealPosition();
	}
}

/* ------------------------------------------------------------------
* Լ̸ :	GetPathArray
*      :     迭ε  Լ
* ǻ :    
* ------------------------------------------------------------------ */

void cPathNodeSet::GetPathArray(POINT* array , const unsigned int maxcopycount, unsigned int& copycount)
{
	mpPathfinder->CopyPathArray(array, maxcopycount, copycount, true);

	for(unsigned int i = 0; i < copycount; ++i)
	{
		mPointArray[i] = array[i];
	}

	MakeRealPosition();
}

/* ------------------------------------------------------------------
* Լ̸ :	InsertPathArray
*      :     迭ε ִ Լ
* ǻ :    
* ------------------------------------------------------------------ */

void cPathNodeSet::SetPathArray(POINT* array, const unsigned int count)
{
	mCurrentUseIndex = 0;

	mTotalPathCount = count;

	for(unsigned int i = 0; i < count; ++i)
	{
		mPointArray[i] = array[i];
	}

	MakeRealPosition();
}

/* ------------------------------------------------------------------
* Լ̸ :	MakeRealPosition
*      :      Լ   ε  ʿ ϴ 
				ġ Ͽ ؿ   Ѵ.
* ǻ :    
* ------------------------------------------------------------------ */

void cPathNodeSet::MakeRealPosition()
{
	float onetilesize = mpPathfinder->GetOneTileSize();
	float halfsize = onetilesize/2;

	Point2 element;

	for(unsigned int i = 0; i < mTotalPathCount; ++i)
	{
		element.x = (float)(mPointArray[i].x*onetilesize + halfsize);
		element.y = (float)(mPointArray[i].y*onetilesize + halfsize);

		mPosvectorlist.PushBack(element);
	}
}


/* ------------------------------------------------------------------
* Լ̸ :	DetailPathMake
*      :    ؿ  ġ ̿Ͽ  ϰ Ʋ   ߰ 
带 Ͽ   ε巴 ̵ ϱ 

* ǻ :    
* ------------------------------------------------------------------ */
/*
void cPathObserver::DetailPathMake(cObstacle* pObstacle)
{
/// Ͽ ο  ߰ϸ Ű ´.
int count = mStack.GetCount();

D3DXVECTOR3 FirstVec;
D3DXVECTOR3 NextVec;

///Ŀ     ̻ Ѿ
///̻   ʴ ڵ尡 ߰Ǿ Ѵ.
int finallistcount = 0;

///ó ⺻ 
mPosvectorlist[0] = mTempvectorlist[0];
finallistcount++;

for(int i = 1; i < (count-1); ++i)
{
if(mPosvectorlist[finallistcount-1] == mPosvectorlist[finallistcount-2] && finallistcount > 1)
{
finallistcount --;
}

FirstVec = mTempvectorlist[i] - mTempvectorlist[i-1];
NextVec = mTempvectorlist[i+1] - mTempvectorlist[i];

///յ   45 ũ ߰  Ѵ.

float f = D3DXVec3Dot(D3DXVec3Normalize(&FirstVec,&FirstVec),
D3DXVec3Normalize(&NextVec,&NextVec));

if( f >= 0.25f && f <= 0.75f)
{
mPosvectorlist[finallistcount] = mTempvectorlist[i];
finallistcount++;

if(mPosvectorlist[finallistcount-1] == mPosvectorlist[finallistcount-2] && finallistcount > 1)
{
finallistcount --;
}

sElement element1 = mStack.GetElementArray()[i];

sElement element2 = mStack.GetElementArray()[i+1];

/// ϴ Ƿ 

int x = element2.Xindex;
int y = element1.Yindex;

if(this->IsObstacle(x,y) == 1)
{
x = element1.Xindex;
y = element2.Yindex;
}

D3DXVECTOR3 dir = pObstacle->GetIndexCenterPos(x,y) - mTempvectorlist[i];

mPosvectorlist[finallistcount] = mTempvectorlist[i] + dir*0.5f;
finallistcount++;

if(mPosvectorlist[finallistcount-1] == mPosvectorlist[finallistcount-2] && finallistcount > 1)
{
finallistcount --;
}

dir = pObstacle->GetIndexCenterPos(x,y) - mTempvectorlist[i+1];

mPosvectorlist[finallistcount] = mTempvectorlist[i+1] + dir*0.5f;
finallistcount++;

if(mPosvectorlist[finallistcount-1] == mPosvectorlist[finallistcount-2] && finallistcount > 1)
{
finallistcount --;
}
}
else
{
mPosvectorlist[finallistcount] = mTempvectorlist[i];

finallistcount++;

if(mPosvectorlist[finallistcount-1] == mPosvectorlist[finallistcount-2] && finallistcount > 1)
{
finallistcount --;
}
}
}

mPosvectorlist[finallistcount] = mTempvectorlist[count-1];
finallistcount++;

mFinalCountIndex = finallistcount;

}
*/

NiPoint2 cPathNodeSet::GetCurrentPathNode(const unsigned int& curnode)
{
	NiPoint2 pos;

	pos.x = mPosvectorlist[curnode].x;
	pos.y = mPosvectorlist[curnode].y;

	return pos;
}

/* ------------------------------------------------------------------
* Լ̸ :	GetNext
*      :    ܺη Ǵ ̽ ߿  󵵼  Լ
 ؿ    ϳϳ .

* ǻ :    
* ------------------------------------------------------------------ */
NiPoint2 cPathNodeSet::GetNextPath()
{
	NiPoint2 p; p.x = mPosvectorlist[mCurrentUseIndex].x; p.y = mPosvectorlist[mCurrentUseIndex].y;

	mCurrentUseIndex++;

	return p;
}

/* ------------------------------------------------------------------
* Լ̸ :	IsFinalPath
*      :     ΰ   üũϴ Լ

* ǻ :    
* ------------------------------------------------------------------ */

bool cPathNodeSet::IsFinalPath()
{
	if(mTotalPathCount == 0) return true;
	
	else if(mCurrentUseIndex >= mTotalPathCount) return true;

	return false;
}
