/* ==========================================================================
*    : ̼
*    : 2007.10.08
*      : ã
* ǻ : 
*===========================================================================*/
#pragma once

class cNaviField;

/// ã 
class cPathNode
{
	friend class cPathFinder;
	friend class cPathNodeCompare;

private:
	/// ǥ
	unsigned short mXIndex;
	unsigned short mYIndex;

	/// θ
	cPathNode* mParent;

	/// ڽ
	cPathNode* mChild[8];

	///  (ã Ŀ ΰ Ǵ ڽ)
	cPathNode* mNext;

	/// Ѻ (f = g + h)
	unsigned short mTotalCost;

	///     (g)
	unsigned short mCostFromStart;

	///  忡 ǥ  (h)
	unsigned short mCostToGoal;

	///  
	bool mClosed;
};

class cPathNodeCompare
{
public:
	bool operator () ( void* x, void* y ) const
	{
		return ((cPathNode*)x)->mTotalCost < ((cPathNode*)y)->mTotalCost;
	}
};

/// ã
class cPathFinder
{
	static const unsigned int MAX_PATH_COUNT = 2048;

public:
	cPathFinder( unsigned int capacity );
	~cPathFinder();

	/// 
	void Clear();

	/// ʱȭ
	void Init( const cNaviField* naviField );

	/// ã
	bool FindPath( NiPoint2* pathArray, unsigned int* pathCount, unsigned int maxCount, const NiPoint2& start, const NiPoint2& goal );
	bool FindPath( NiPoint2* pathArray, unsigned int* pathCount, unsigned int maxCount, const NiPoint2& start, const NiPoint2& goal, unsigned short sx, unsigned short sy, unsigned short gx, unsigned short gy );

	///
	bool IsPassible( float x, float y ) const;
	bool IsPassible( const NiPoint2& start, const NiPoint2& goal ) const;

protected:
	/// ׸ ũ⸦ ˻
	bool CheckCellCount( unsigned int cellCount );

	/// ߰  
	unsigned short CalcHeuristic( unsigned short x, unsigned short y );

protected:
	/// ׸ ũ  
	unsigned int mCellCount;
	unsigned int mLineCount;

	///  迭
	cPathNode** mNodes;
	cPathNode*** mCells;
	cPathNode mTempNode;

	///  ť
	typedef tPriorityQueue<void*, cPathNodeCompare> cOpenQueue;
	cOpenQueue mOpenQueue;

	/// ǥ
	unsigned short mGoalX;
	unsigned short mGoalY;
};

inline
bool cPathFinder::IsPassible( float x, float y ) const
{
	unsigned short xi = (unsigned short)((x + 50.0f) / 100.0f);
	unsigned short yi = (unsigned short)((y + 50.0f) / 100.0f);

	assert( mCells );
	return mCells[yi][xi] != 0;
}
