/* ====================================================================
*      :	
*      :	
*    :	
*    :	2006.08.29
*
* ߰ :
*		߰¥	۾	߰
*		2006.08.29		
* 
* ǻ :	
* =================================================================== */
#pragma once

#include "GameSrvDefines.h"

#include "BaseObject.h"
#include "Player_Common.h"
#include "Npc_Common.h"
#include "Stage_Common.h"
#include "Tarot_Common.h"
#include "Quest_Common.h"
#include "Chat_Common.h"
#include "RangeCheck.h"

#include "ItemCountPool.h"
#include "CooltimePool.h"
#include "SQLGameStmt.h"

///  ġ ִ밪/߽ɰ
const int FOLLOW_POS_MAX = 9;
const int FOLLOW_POS_CENTER = 4;

/// ų Ʈ  ġ
const unsigned char SKILL_LEVELUP_POINT = 2;

/// ð ϰ ð
const unsigned long BATCH_SAVE_TIME = 10 * MINUTE;

struct MAKESKILL_SELECT;
struct MAKESKILL_INSERT;

enum eREQUEST_REJECTION
{
	eREQREJCT_NONE,			/// û   (û)
	eREQREJCT_GAMEFINISH,	///   
	eREQREJCT_REQWAIT,		/// û  
	eREQREJCT_DUEL,			///  
	eREQREJCT_PARTY,		/// Ƽ 
	eREQREJCT_GUILD,		///  
};

enum ePLAYER_PARTYSTATE
{
	ePARTY_NONE,		/// Ƽ 
	ePARTY_COMPLETE,	/// Ƽ
	ePARTY_SENDJOIN,	/// Ƽ ʴ
	ePARTY_RECVJOIN,	/// Ƽʴ ޴
};

enum XCOPY_INVENTORY_OPT
{
	XCOPY_INVENTORY_ALL = 0,
	XCOPY_INVENTORY_COUNT,
	XCOPY_INVENTORY_SWAP,
};

//  Ʈ 
#define ARMOR_SETS_NONE					0x0000
#define ARMOR_SETS_ROBES				0x001F
#define ARMOR_SETS_LIGHT_ARMOR			0x03E0
#define ARMOR_SETS_HEAVY_ARMOR			0x7C00

#define ROBES_HAT						0x0001
#define ROBES_UPPER						0x0002
#define ROBES_LOWER						0x0004
#define ROBES_ONEPIECE					0x0006
#define ROBES_HANDS						0x0008
#define ROBES_FEET						0x0010

#define LIGHT_ARMOR_HAT					0x0020
#define LIGHT_ARMOR_UPPER				0x0040
#define LIGHT_ARMOR_LOWER				0x0080
#define LIGHT_ARMOR_ONEPIECE			0x00C0
#define LIGHT_ARMOR_HANDS				0x0100
#define LIGHT_ARMOR_FEET				0x0200

#define HEAVY_ARMOR_HAT					0x0400
#define HEAVY_ARMOR_UPPER				0x0800
#define HEAVY_ARMOR_LOWER				0x1000
#define HEAVY_ARMOR_ONEPIECE			0x1800
#define HEAVY_ARMOR_HANDS				0x2000
#define HEAVY_ARMOR_FEET				0x4000

/*-- Ǹų  
*/

// Ǹž ü
struct StallSellItem
{
	eStallSellItemStatus status;	// 
	TB_INVENTORY*        inventory;	// κ丮 
	unsigned long        price;		// ()
};

struct sGameOption
{
	union
	{
		struct
		{
			bool showGauge				: 1;	// 
			bool showBubble				: 1;	//
			bool showHeroNameCard		: 1;	//
			bool showHeroTotal			: 1;	//
			bool showPlayerNameCard		: 1;	//
			bool showPlayerTotal		: 1;	//
			bool showNPCNameCard		: 1;	//
			bool showMonsterNameCard	: 1;	//
			bool showHelmet				: 1;	//
			bool showTip				: 1;	//

			bool rejectionTrade			: 1;	//
			bool rejectionDuel			: 1;	//
			bool rejectionWhisper		: 1;	//
			bool rejectionParty			: 1;	//
			bool rejectionFriend		: 1;	//
			bool rejectionNote			: 1;	//
		} option1;
		long optionData1;
	};
};
/// default 0x1111 1111 1100 0000 0000 0000 0000 0000

class cPlayer : public cBaseObject
{
public:
	cPlayer();
	~cPlayer();

	void* operator new    ( size_t n ); 
	void  operator delete ( void* ptr, size_t n );

	///   ʱȭ
	bool				Init             ( unsigned long connectionIdx, unsigned long playerIdx, unsigned long money, unsigned long deposit );

	/// ÷̾ Ʈ μ
	void				Update           ( unsigned long elapsedTime, unsigned long accumTime );

	/// inline functions
	unsigned long		GetConnectionIdx ( ) { return mConnectionIdx; }

	sPlayerInfo*		GetPlayerInfo    ( ) { return &mPlayerInfo;        }
	sPlayerExrInfo*		GetExrInfo       ( ) { return &mPlayerExrInfo;     }
	sHeroInfo*			GetHeroInfo      ( ) { return &mHeroInfo;          }

	wchar_t*			GetUserID        ( ) { return NULL; }

	wchar_t*			GetName          ( ) { return mPlayerInfo.strName; }
	char				GetRace          ( ) { return mPlayerInfo.Race;    }
	char				GetGender        ( ) { return mPlayerInfo.Gender;  }

	eWEAPON_STATE		GetWeaponState   ( ) { return mPlayerWeaponState; }

	void				SetName          ( wchar_t* name );
	void				SetRace          ( char race );
	void				SetGender        ( char gender );

	void				SetStaticFaceIndex( unsigned long faceIdx );

	/// 070607 PKH ÷̾   
	bool				GetStateDie( )	{ return mPlayerExrInfo.mState == eOBJECT_STATE_DIE; }

	/// 070115 PKH ÷̾ 
	unsigned char		GetLevel( ) { return mPlayerInfo.Level; }
	void				LevelUp( unsigned char upLevel ); 
	/// 070115 PKH 
	ePLAYER_JOB			GetJob() { return mPlayerInfo.Job; }
	void				SetJob(ePLAYER_JOB job, unsigned long* skillList, unsigned char skillListCnt );

	/// 070528 PKH ų 
	unsigned char		GetSkillLevel() { return mHeroInfo.SkillLevel; }
	void				SkillLevelUp( unsigned char upLevel );
	/// ų ʱȭ
	unsigned char		SkillReset( unsigned short itemSlotNum );

	/// exp/sxp 
	void				AddExpSxp( unsigned long exp, unsigned long sxp );
	void				AddExpSxpNoPer( unsigned long exp, unsigned long sxp );

	/// 070807 PKH HPʱ 
	void				InitHP( unsigned long HP );
	void				InitMP( unsigned long MP );

	/// 070807 PKH HP/MP ˷
	unsigned long		GetHP()	{ return mPlayerExrInfo.RestHP; }
	unsigned long		GetMP()	{ return mPlayerExrInfo.RestMP; }

	/// 070807 PKH HP
	unsigned long		HPDamage( unsigned long damage, bool *die, bool msgSend, bool cri = false );
	/// 070807 PKH İ HP
	void				HPHeal( unsigned long hp, bool msgSend, unsigned long healerIdx, long distressPoint, eTAKEDAMAGE_TYPE type );
	bool                SendHPHeal( );
	void				SendMaxHP();

	/// 070807 PKH mpó
	void				MPDamage( unsigned long mp, bool msgSend );
	void				MPHeal( unsigned long mp, bool msgSend );
	bool                SendMPHeal( );
	void				SendMaxMP();

	inline unsigned int	GetRaceGender(){return (mPlayerInfo.Race*eGENDER_MAX + mPlayerInfo.Gender);}

	/// 061208 PKH ÷̾ ̵  
	void				SetMoveTargetPos( float x, float y );
	float				GetMoveTargetPosX( ) { return mGotoX; }
	float				GetMoveTargetPosY( ) { return mGotoY; }

	bool				IsMovePossible( NiPoint2 startPos, NiPoint2 goalPos );

	void				SetRangeTarget( float tPosX, float tPosY, sObject& tInfo, float range );
	void				InitRangeTarget()	{ mRange = 0.0f; }

	/// Ʈ Ÿ üũ  Ÿ -  
	float				GetFixedObjectSize()	{ return mFixedObjectSize; }
	void				SetFixedObjectSizePer( short sizePer );
	unsigned short		GetFixedObjectSizePer()	{ return mPlayerExrInfo.mFixedObjectSizePer; }

	///   
	unsigned long		GetChgMonsterIdx()	{ return mPlayerExrInfo.mChgMonsterIdx; }
	void				SetChgMonster( unsigned long infObjectIdx, unsigned long monsterIdx );
	void				EndChgMonster();

	///  ģе/Ʈ
	void				SetForceType( unsigned char forceType, bool msgSend = true );
	unsigned char		GetForceType()	{ return mPlayerExrInfo.mForceType; }
	void				FirePointPlus( unsigned long firePoint, bool msgSend = true );
	void				FireFriendlyPlus( unsigned long fireFriendly, bool msgSend = true );
	void				WaterPointPlus( unsigned long waterPoint, bool msgSend = true );
	void				WaterFriendlyPlus( unsigned long waterFriendly, bool msgSend = true );
	void				WindPointPlus( unsigned long windPoint, bool msgSend = true );
	void				WindFriendlyPlus( unsigned long windFriendly, bool msgSend = true );
	void				EarthPointPlus( unsigned long earthPoint, bool msgSend = true );
	void				EarthFriendlyPlus( unsigned long earthFriendly, bool msgSend = true );

	unsigned long		GetGuildIndex() { return mPlayerExrInfo.mGuildIndex; }
	unsigned char		GetGuildPosition() { return mPlayerExrInfo.mGuildPosition; }

public:

	/// 
	void				InitStatus2()	{ memset( &mStatus2, 0 , sizeof(mStatus2) ); }
	const sStatus1*		GetStatus1()	{ return &mStatus1; }
	void				SetStatus1( ePLAYER_STATUS statusBase, float value );
	const sStatus1*		GetStatus1Plus()	{ return &mStatus1Plus; }
	void				SetStatus1Plus( ePLAYER_STATUS statusBasePlus, float value );
	float*				GetPointerStatus2Plus()	{ return mStatus2Plus; }
	float*				GetPointerStatus2Per()	{ return mStatus2Per; }
	float				GetStatus2Plus( ePLAYER_STATUS_EXT extStatus );
	float				GetStatus2Per( ePLAYER_STATUS_EXT extStatus );
	const sStatus2*		GetStatus2()	{ return &mStatus2; }
	void				SetStatus2( ePLAYER_STATUS_EXT extStatus, float value );
	const sStatusEtc*	GetStatusEtc()	{ return &mStatusEtc; }
	void				SetStatusEtc( ePLAYER_STATUS_EXT_ADD statusAdd, float value );

	const sDamageCalc*	GetDamagecalc()	{ return &mDamageCalc; }
	void				SetDamageCalc( ePLAYER_STATUS_DAMAGE statusDamage, unsigned long value );

	unsigned long		DamageCalc( sObject target, unsigned long skillIdx, unsigned long aType, unsigned long rType );
	bool				AttackSuccess( sObject target, unsigned long skillIdx, unsigned long aType, unsigned short accuracyValue );
	bool				CriticalSuccess( sObject target, unsigned long skillIdx, unsigned long aType, unsigned short criticalValue );
	///    ųȿ()  
	void				CalcInstantSkill( unsigned long statusType1, unsigned long value1, unsigned long statusType2, unsigned long value2 );

	unsigned long		GetMaxHP()	{ return FloatToInt( mStatus2.mMaxHP ); }
	unsigned long		GetMaxMP()	{ return FloatToInt( mStatus2.mMaxMP ); }

	long				GetMoveSpeed( );

	float				CalcStatusSkillRange( float skillRange, eRANGETYPE mRangeType, bool itemPlus );

	/// 070215 PKH  
	sPlayerWeaponInfo*	GetWeaponInfo( ) { return &mPlayerWeaponInfo; }
	sPlayerWearInfo*	GetWearInfo  ( ) { return &mPlayerWearInfo;   }

	/// 070216 PKH ð 
	void				SetLoseTime( unsigned long loseTime );

	/// Player  
	unsigned int		GetState() { return mPlayerExrInfo.mState; }
	bool				IsChangeState( unsigned int newState, bool resurrection = false );
	bool				ChangeState( unsigned int newState, bool resurrection = false );

	/// Ƽ 
	void				SetPartyState( ePLAYER_PARTYSTATE state ) { mPartyState = state; }
	ePLAYER_PARTYSTATE	GetPartyState() { return mPartyState; }

	/// ȭ/ 
	void				SetStateIdle( unsigned char stateIdle )	{ mPlayerExrInfo.mStateIdle = stateIdle; }
	void				SetStateStop( unsigned char stateStop )	{ mPlayerExrInfo.mStateStop = stateStop; }

	unsigned char		GetStateStop() { return mPlayerExrInfo.mStateStop; }

	/// 070628 PKH  ȭ npcidx
	unsigned long		GetNpcIdx() { return mNpcIdx; }
	void				SetNpcIdx( unsigned long npcIdx ) { mNpcIdx = npcIdx; }

	/// 070702 PKH ÷̾ Ȱ
	void				Resurrection( unsigned long resurrectionType );
	bool				SkillResurrection();	/// ų Ȱ 
	void				PvPResurrection( bool timeCheck = true );

	///  Ʈ  
	void				AddTargetingMonster( unsigned long monsterIdx );
	void				DelTargetingMonster( unsigned long monsterIdx );
	void				ClearTargetingMonster();
	void				DietargetingMonster();
	/// ÷̾    Ϳ  Ʈ 
	void				HealAttackToMonster( unsigned long healerIdx, unsigned long heal, long distressPoint, eTAKEDAMAGE_TYPE type );


	/// ȿ 
	bool				AddInfluence( unsigned long uniqueIdx, unsigned long influenceIdx );
	tHashSet<unsigned long>* GetInfluenceSet() { return &mInfluenceSet; }
	void				DeleteInfluence( unsigned long influenceIdx );
	void				ReleaseInfluenceSet(); 
	void				DieDeleteInfluence(); 
	void				InfluenceProcessStart();
	void				InfluenceProcessStop();

	bool				IsParentEqual( unsigned long parentUniqueIdx );

	void				SkillResurrectionHP( unsigned long HP );
	void				SkillResurrectionMP( unsigned long MP );

	/// SkillPoint
	unsigned short		GetSkillPoint()	{ return mHeroInfo.SkillPointRemain; }
	unsigned short		GetJobUsedSkillPoint( unsigned char jobstep );
	bool				SkillPointMinus( unsigned short minusSP );
	bool				SkillPointMinusRestore( unsigned short minusSP );
	bool				SkillPointPlus( unsigned short plusSP );
	void				SetSkillReset( unsigned short skillPoint, TB_CHARACTER_SKILL* pSkill, long cnt );
	void				SendSkillPoint();

	/// 080619 KCJ ̵ û.
	bool                IsMapChange ( ) { return mMapChange; }
	void                MapChange ( bool boolean ) { mMapChange = boolean; }
	bool				MapChange( unsigned long posIdx );
	bool				CheatMapChange( unsigned short mapNumber, float x, float y );
	bool				PvPMapChange( unsigned short mapNumber, unsigned short mapDataNumber, unsigned char teamType, float x, float y );
	bool				IsItemMapChange( unsigned long posIdx );
	bool				ItemMapChange( unsigned long posIdx );
	unsigned short		GetPvPMapDataNumber()	{ return mPvPMapDataNumber; }


	///
	/// 071025 PKH ̵ ġ.
	void                SetMapTargetPos( sTargetPos targetPos ) { mMapTargetPos = targetPos; }
	void                ApplyMapTargetPos( );

	/// Ͱ ϴ  
	bool				MonsterImportancePlus( unsigned char importance );
	void				MonsterImportanceMinus( unsigned char importance );

	void				MoveStop()	{ mGotoX = GetXPos(); mGotoY = GetYPos(); mRange = 0.0f; }

	///  氪 Ŭ̾Ʈ 
	void				SendMoveSpeed();		/// ̵ ӵ
	void				SendAttackSpeed();		///  ӵ
	void				SendPlayerSize();		/// ĳ ũ
//	void				SendSynStatus();		/// ü

	void				SetGameIn();
	void				SetGameOut()	{ mGameIn = false; }
	bool				GetGameIn()     { return mGameIn; }

	bool                IsGameFinish();		/// updatecomplete    üũ

	void				CalcNatureRecovery();

	/// ĳ ó ӽ  Ŀ  hp mp
	void				SetInitRestHP();
	void				SetInitRestMP();
	void				ApplyInitRest();

	/// Ȱ ų
	void				SetCommunitySkill( unsigned long communitySkillIdx);

	/// Ͱ ÷̾ ϴ ġ
	unsigned char		SelectFollowPos( unsigned char followPos );
	void				UnSelectFollowPos( unsigned char followPos );

	///  亯 ޼ 
	bool				IsRequestRejection()	{ return mIsRequestRejection != eREQREJCT_NONE; }
	unsigned long		GetRequestRejection()	{ return mIsRequestRejection; }
	void				StartRequestRejection( eREQUEST_REJECTION IsRequestRejection );
	void				EndRequestRejection( eREQUEST_REJECTION IsRequestRejection );

	/// ġ ϶
	unsigned long		ExpDown( unsigned long minimum, unsigned long maximum );	

	/// ÷̾  DB 
	void				DBUpdate( bool updateComplete = true );

	/// ̵
	void				SetBlink( float x, float y )	{ mBlinkPos.x = x; mBlinkPos.y = y; }
	void				Blink(); 

	///  Ž Ÿ ó
	bool				IsChgMonCoolTimeEnd( eMONSTERATTACK_TYPE type );
	void				UpdateChgMonCoolTime( eMONSTERATTACK_TYPE type );
	void				SendCoolTimeChgMon();

	/*---------------  ---------------*/
	///  ȣ
	unsigned long		GetDuelIdx()	{ return mDuelIdx; }
	void				SetDuelIdx( unsigned long duelIdx );

	///   
	void				SetDuelPlayerIdx( unsigned long playerIdx, bool IsAttacker )	{ mDuelPlayerIdx = playerIdx; mIsDuelRequester = IsAttacker; }
	unsigned long		GetDuelPlayerIdx()	{ return mDuelPlayerIdx; }

	///   ڿ   ó
	void				DuelEnd();

	///  
	void				SetDuelWin()	{ ++mDuelStraightWin; }
	void				ClearDuelWin()	{ mDuelStraightWin = 0; }
	unsigned long		GetDuelWin()	{ return mDuelStraightWin; }

	///      
	void				DuelEndDebuffClear( unsigned long enemyIdx );

	/// pvp 
	bool				IsPvPJoin()	{ return mPlayerExrInfo.mIsPvPJoin; }
	bool				CheckPvPJoin();
	void				PvPOut();
	void				AutoPvPOut();
	unsigned short		GetPvPJoinBeforeMapIdx()	{ return mPvPJoinBeforeMapIdx; }
	NiPoint2			GetPvPJoinBeforePos()	{ return mPvPJoinBeforPos; }
	unsigned long		GetPvPDMIdx()	{ return mPvPDMIdx; }
	unsigned long		GetPvPDMTeam()	{ return mPlayerExrInfo.mPvPDMTeamType; }
	bool				SendPvPTeamChat( char* msg, int length );
	void				PvPScorePlus( unsigned long plusScore )	{ mHeroInfo.mPvPPoint = mHeroInfo.mPvPPoint + plusScore; }

	///   pvp ھ 
	void				AddTakeDamage( sObject attacker, unsigned long damage, long distressPoint, eTAKEDAMAGE_TYPE type );

	/*---------------  ̻ ---------------*/
	void				StateOddity( long* pOddity );
	void				SendOddity( eODDITYTYPE pos, bool apply );
	unsigned long		GetStateOddity( eODDITYTYPE oddityType )	{ return mODDITY[oddityType]; }

	bool				IsCantSkill()	{ return mODDITY[eODDITYTYPE_CANTSKILL] != 0 || mODDITY[eODDITYTYPE_SLEEP] != 0 || mODDITY[eODDITYTYPE_STUN] != 0; }
	bool				IsCantMove()	{ return mODDITY[eODDITYTYPE_CANTMOVE] != 0 || mODDITY[eODDITYTYPE_SLEEP] != 0 || mODDITY[eODDITYTYPE_STUN] != 0; }

	/// Ÿ 
//	void				DeleteTarget( sObject target, unsigned long range );
	void				MonsterInTargeting( tArray<sMultiTarget>* targetAry, float range );

	///    SP 
	void				UpdateJobUsedSP();

	void				StatusCalc();

	unsigned long		GetGatheringIdx()	{ return mGatheringIdx; }
	void				SetGatheringIdx( unsigned long gatheringIdx )	{ mGatheringIdx = gatheringIdx; }
	bool				CancelGathering( unsigned long gatheringIdx );

	/// ų
	unsigned char		AddMakeSkill( unsigned short itemSlotNum );
	void				SetMakeSkill( MAKESKILL_INSERT* pInsert );

	unsigned char		ReqDelMakeSkill( unsigned char makeSkill );
	void				DelMakeSkill( unsigned char makeSkillIdx );

	unsigned char		AddRecipe( unsigned short itemSlotNum );
	void				SetRecipe( unsigned char makeSkill, unsigned long recipeIdx );
	void				SetRecipeGroup( sRecipeGroupInfo* groupInfo, unsigned long cnt );

	bool				InitMakeSkill( MAKESKILL_SELECT* pMakeSkill );
	void				SendMsgRecipeList();
	bool				IsMakeSkill( unsigned char makeSkillIdx );

	int					ItemMixReq( unsigned char makeSkill, unsigned long mixRecipeIdx );	/// Ŭ̾Ʈ  û - μ ࿩ üũ
	int					ItemMixEnd();		///  
	void				ItemMixCoolTime();	///    
	void				ItemMixCancel();	///  
	bool				SaveRecipeCoolTime( RECIPE_COOLTIME* skillCoolTime );

	/// Ż
	void				SetVehicle( unsigned long infObjectIdx, unsigned long vehicleIdx );
	void				SendEndVehicle();
	bool				IsVehicle()	{ return mPlayerExrInfo.mVehicleIdx != 0 ? true : false; }
	/// Ŭ̾Ʈ Ż  û ó
	void				EndVehicleClient( bool sendSync );
	void				SendEndVehicleExcept();
	/// Ż     Ż  ó
	void				EndVehicleItem( unsigned long skillClassIdx );

protected:
	sPlayerInfo			mPlayerInfo;
	sPlayerExrInfo		mPlayerExrInfo;
    
	sPlayerWeaponInfo	mPlayerWeaponInfo;
	sPlayerWearInfo		mPlayerWearInfo;

	sHeroInfo			mHeroInfo;

	bool				mIsSleep;
	bool				mIsStun;

	typedef tArray<void*> cAry;

	/// 1 ⺻
	sStatus1			mStatus1;
	/// 1 +
	sStatus1			mStatus1Plus;
	/// 2 +
	float				mStatus2Plus[ePLAYER_STATUS_EXT_MAX];
	/// 2 %
	float				mStatus2Per[ePLAYER_STATUS_EXT_MAX];
	/// 2 
	sStatus2			mStatus2;

	/// ݿ 
	sStatusEtc			mStatusEtc;

	///   ȿ 
	sDamageCalc			mDamageCalc;

	///    ݰ ġ  ִ üũ  尪
	unsigned long		mLastMaxHP;
	unsigned long		mLastMaxMP;

	/// 071016 PKH ȸ()  ߰ ġ - ⺻ġ  ʰ ũƮ Էµȴ.
	float				mHealBuffPlus;
	float				mHealBuffPer;

	eWEAPON_STATE		mPlayerWeaponState;

	unsigned long		mConnectionIdx;	

	/// 061208 PKH ̵  ǥ
	float				mGotoX;
	float				mGotoY;

	///
	float				mRange;
	NiPoint2			mRangeTargetPos;
	sObject				mRangeTarget;

	ePLAYER_PARTYSTATE	mPartyState;
	bool				mIsGuildAddReq;		//  ʴ븦 ϰ ִ 

	/// 070216 PKH ð
	unsigned int		mLoseTime;

	/// 070628 PKH  ȭ npcidx
	unsigned long		mNpcIdx;

	typedef tHashSet<unsigned long> cSkillInfluenceSet;
	cSkillInfluenceSet	mInfluenceSet;

	typedef tArray<unsigned short> cJobUsedSpArr;
	cJobUsedSpArr	mJobUsedSpArr;

	typedef tHashSet<unsigned long> cTargetingMonsterSet;
	cTargetingMonsterSet mTargetingMonsterSet;

	/// Ȱ
	bool				mIsSkillResurrection;
	unsigned long		mSkillResurrectionHP;
	unsigned long		mSkillResurrectionMP;

	/// 080619 KCJ ̵ û.
	bool                mMapChange;

	/// 071025 PKH ̵ ġ.
	sTargetPos          mMapTargetPos;

	/// Ʈ Ÿ üũ  Ÿ -  
	float				mFixedObjectSize;

	/// ÷̾ Ѿƿ   հ
	long				mMonsterImportance;

	///  ȿ   
	bool				mGameIn;

	/// ڿ ȸ   ð
	unsigned long		mNextNatureRecoveryTime;

	/// 081209 PKH ڿȸ 2  
	unsigned long		mSitDownStartTime;
	bool				mSitDownStatusCalc;

	/// ĳ ó ӽ  Ŀ  hp mp
	unsigned long		mInitRestHP;
	unsigned long		mInitRestMP;

	/// Ȱ ų ð
	float				mCommunitySkillEndTime;

	/// Ⱚ
	float				mDirection;

	///  ġ ڸ 
	bool				mFollowPos[FOLLOW_POS_MAX];

	cRangeCheck			mRangeCheck;

	/// û   
	eREQUEST_REJECTION	mIsRequestRejection;

	///  
	unsigned long		mDuelIdx;			/// ȣ
	unsigned long		mDuelPlayerIdx;		///  
	bool				mIsDuelRequester;	///   û 
	unsigned long		mDuelStraightWin;	///   īƮ

	unsigned long		mBatchSaveTime;

	NiPoint2			mBlinkPos;			/// ̵  ǥ


	long				mODDITY[eODDITYTYPE_MAX];

	eCHEAT_SPEEDUP		mCheatSpeedUp;

	unsigned long		mChgMonCoolTime[eMONSTERATTACK_MAX];

	unsigned long		mPvPDMIdx;
	unsigned short		mPvPJoinBeforeMapIdx;
	NiPoint2			mPvPJoinBeforPos;
	unsigned long		mPvPDieTime;
	unsigned short		mPvPMapDataNumber;

	unsigned long		mGatheringIdx;

	///  ų &  
	typedef tHashMap<unsigned long, unsigned long> cRecipeGroup;
	cRecipeGroup		mRecipeGroup1;		/// ų Ǳ׷ 
	cRecipeGroup		mRecipeGroup2;		

	///    
	unsigned long		mItemMixEndTime;	///  Ϸ ð
	unsigned char		mMixMakeSkill;
	unsigned long		mMixRecipeIdx;

	unsigned long		mChgMonsterInfIdx;	///   ȿ  ȣ
	unsigned long		mVehicleInfIdx;		/// Ż ȿ ȣ

	// ݾ & ġݾ  .
private:
	unsigned long       mMoney;
	unsigned long       mDeposit;

	// ݾ & ġݾ   ޼ҵ.
public:
	unsigned long       GetMoney                 ( ) { return mMoney; }
	bool                IsAddMoney               ( long money );
	long                AddMoney                 ( sObject object, long money, bool save=true );
	bool                SaveMoney                ( sObject object, unsigned long befor, unsigned long after, long money );
	bool                SendMoney                ( sObject object, long addMoney=0 );

	unsigned long       GetDeposit               ( ) { return mDeposit; }
	long                AddDeposit               ( sObject object, long deposit );
	bool                SaveDeposit              ( sObject object, unsigned long befor, unsigned long after, long deposit );
	bool                SendDeposit              ( sObject object, long addDeposit=0 );

	void                NpcDeposit               ( MSG_REQ_NPC_DEPOSIT* msg );
	void                NpcWithdraw              ( MSG_REQ_NPC_WITHDRAW* msg );

	// Ʈ  ޼ҵ.
public:
	unsigned long       GetTarotPoint            ( ) { return mHeroInfo.TarotPoint; }
	long                AddTarotPoint            ( long point );
	bool                SaveTarotPoint           ( long point );
	bool                SendTarotPoint           ( long point );

	unsigned long       GetPvPPoint              ( ) { return mHeroInfo.mPvPPoint; }
	long                AddPvPPoint              ( long point );
	bool                SavePvPPoint             ( long point );
	bool                SendPvPPoint             ( long point );

	//  & κ丮  .
private:
	TB_INVENTORY        mInventory[ MAX_INVENTORY ];

	eItemActiveWeapon   mItemActiveWeapon;

	unsigned short      mItemWeight;
	sEquipAbility       mEquipAbility;
	unsigned short      mArmorSets;

	DWORD               mItemEnhancedSeed;
	DWORD               mItemChangeSeed;

	ItemCountRoot       mItemCountRoot;
	CooltimeRoot        mCooltimeRoot;

	//  & κ丮  ޼ҵ.
public:
	bool                IsInventory              ( TB_INVENTORY* inventory );
	bool                IsInventoryRange         ( unsigned short number );
	bool                IsInventoryEquip         ( unsigned short number );
	bool                IsInventoryQuest         ( unsigned short number );
	bool                IsInventoryMall          ( unsigned short number );
	bool                IsInventoryWarehouse     ( unsigned short number );
	bool                IsInventoryMove          ( unsigned short number1, unsigned short number2, unsigned short& except, int& depth );
	bool                IsInventoryMerge         ( unsigned short number1, unsigned short number2 );
	bool                IsInventoryDivide        ( unsigned short number1, unsigned short number2, unsigned short divide );

	short               GetEmptyBagNumber        ( short number=INVENTORY_BAG_BEGIN );
	short               GetEmptyQuestNumber      ( short number=INVENTORY_QUEST_BEGIN );

	void                InventorySwap            ( unsigned short number1, unsigned short number2 );
	void                InventoryMove            ( unsigned short number1, unsigned short number2 );
	void                InventoryExcept          ( unsigned short number1, unsigned short number2 );

	short               GetItemCount             ( long itemDefineIndex );

	bool                IsItem                   ( long itemDefineIndex );
	bool                IsItemUse                ( long itemDefineIndex, unsigned short count=1 );
	bool                ItemUse                  ( long itemDefineIndex, unsigned short count=1 );
	long                IsItemMapChange          ( short number, long itemDefineIndex, long itemAbilityInfluence );
	long                IsItemVehicle            ( short number, long itemDefineIndex, long itemAbilityInfluence );
	bool                ItemUseMapChange         ( long inventoryIdx );
	bool                SendItemUse              ( TB_INVENTORY* inventory );

	unsigned int        IsItemReward             ( long inventoryIdx, eDisjointItem* items, int maxCount );
	unsigned int        IsItemReward             ( sQuestItem* items, int maxCount );
	unsigned int        IsItemTake               ( sQuestItem* items, int maxCount );
	unsigned int		GetQuestItemCount		 ( long itemDefineIndex, int maxCount );

	void                SetActiveWeapon          ( eItemActiveWeapon activeWeapone ) { mItemActiveWeapon = activeWeapone; }
	eItemActiveWeapon   GetActiveWeapon          ( ) { return mItemActiveWeapon; }

	void                EquipItems               ( );
	void                CalcItemWeight           ( );
	unsigned short      GetItemWeight            ( ) { return mItemWeight; }

	void                AddEquipAbility          ( short opt, short value );
	void                AddEquipAbility          ( TB_ITEM_ABILITY* itemAbility );
	void                AddEquipEnhanced         ( TB_ITEM_ENHANCED* itemEnhanced, BYTE enhanced );
	void                AddEquipCards            ( TB_INVENTORY* inventory );
	sEquipAbility*      GetEquipAbility          ( ) { return &mEquipAbility; }

	void                ResetArmorSets           ( );
	unsigned short      GetArmorSets             ( ) { return mArmorSets; }

	ItemCountRoot*      GetItemCountRoot         ( ) { return &mItemCountRoot; }

	CooltimeRoot*       GetCooltimeRoot          ( ) { return &mCooltimeRoot; }
	void                AddCooltime              ( TB_INVENTORY_COOLTIME* table );

	bool                CheckInventory           ( long itemDefineIndex, int itemCount );

	TB_INVENTORY*       XCopyInventory           ( TB_INVENTORY* destination, TB_INVENTORY* source, XCOPY_INVENTORY_OPT opt=XCOPY_INVENTORY_ALL );
	TB_INVENTORY*       XCopyInventory           ( TB_INVENTORY* inventory, XCOPY_INVENTORY_OPT opt=XCOPY_INVENTORY_ALL );

	TB_INVENTORY*		SelectInventory          ( short number=MIN_INVENTORY );
	TB_INVENTORY*		SelectInventoryIdx       ( long idx );
	TB_INVENTORY*       CreateInventory          ( TB_ITEM_DEFINE* itemDefine, short number, short count, short* pcbValue );
	TB_INVENTORY*       CreateInventory          ( long itemDefineIndex, short number, short count, short* pcbValue );
	short               UpdateInventory          ( TB_INVENTORY* inventory, short count );
	short               UpdateInventory          ( short number, short count );
	bool                RemoveInventory          ( TB_INVENTORY* inventory );
	bool                RemoveInventory          ( short number );

	void                ItemUseInventory         ( ULONG_PTR socketContext, MSG_REQ_ITEM_USE_INVENTORY* msg );
	void                ItemDelInventory         ( ULONG_PTR socketContext, MSG_REQ_ITEM_DEL_INVENTORY* msg );
	void                ItemSwiInventory         ( ULONG_PTR socketContext, MSG_REQ_ITEM_SWI_INVENTORY* msg );
	void                ItemDivideInventory      ( ULONG_PTR socketContext, MSG_REQ_ITEM_DIVIDE_INVENTORY* msg );
	void                ItemMov2Inventory        ( ULONG_PTR socketContext, MSG_REQ_NPC_ITEM_MOV2_INVENTORY* msg );
	void                ItemEnhancedInventory    ( ULONG_PTR socketContext, MSG_REQ_ITEM_ENHANCED_END* msg );
	void                ItemDisjointInventory    ( ULONG_PTR socketContext, MSG_REQ_ITEM_DISJOINT_INVENTORY* msg );
	void                ItemPutCardInventory     ( ULONG_PTR socketContext, MSG_REQ_ITEM_PUT_CARD_INVENTORY* msg );
	void                ItemChangeInventory      ( ULONG_PTR socketContext, MSG_REQ_ITEM_CHANGE_INVENTORY* msg );

	void                ItemSell                 ( ULONG_PTR socketContext, MSG_REQ_NPC_ITEM_SELL* msg );
	void                ItemBuy                  ( ULONG_PTR socketContext, MSG_REQ_NPC_ITEM_BUY* msg );
	void                ItemCollect              ( ULONG_PTR socketContext, MSG_REQ_ITEM_COLLECT* msg );

	bool                SendInventory            ( ULONG_PTR socketContext );
	bool                SendInventoryCooltime    ( ULONG_PTR socketContext );

	bool				SetWearInfoWithSendMsg   ( eWEAR_TYPE type, unsigned long itemDefineIndex );
	void				SetWeaponInfoWithSendMsg ( TB_INVENTORY* left, TB_INVENTORY* right );

	// ݱ  .
private:
	bool                mItemGetOpen;
	unsigned long       mItemGetIdx;

	int  				mItemGetCount;
	sItemData			mItemGetData[ MAX_ITEMS ];

	// ݱ  ޼ҵ.
public:
	void                ItemGetOpen              ( MSG_REQ_ITEM_GET_OPEN* msg );
	void                ItemGetClose             ( MSG_REQ_ITEM_GET_CLOSE* msg );
	void                ItemGetClose             ( );
	void                ItemGet                  ( MSG_REQ_ITEM_GET* msg );

	unsigned short      ItemGetAutoPush          ( unsigned long itemDefineIndex, unsigned short count );
	bool				ItemGetAutoEnd           ( bool apply );

	bool                ItemGetQuest             ( unsigned long itemDefineIndex, unsigned short count );

	// ݱ  ޼ҵ.
private:
	bool                SendItemGetOpen          ( cBaseObject* baseObject );
	bool                SendItemGetClose         ( );
	bool                SendItemGetLeave         ( cBaseObject* baseObject );
	bool                SendItemGatheringOpen    ( cBaseObject* baseObject );

	// ŷ  .
private:
	eItemExchangeStatus mExchangeStatus;
	sObject             mExchangeTarget;
	unsigned long       mExchangeItems;
	unsigned long       mExchangeMoney;

	// ŷ  ޼ҵ.
public:
	eItemExchangeStatus GetExchangeStatus        ( ) { return mExchangeStatus; }
	long                GetExchangeMoney         ( ) { return mExchangeMoney; }

	void                ExchangeDie              ( );
	void                ExchangeShutdown         ( bool shutdown=false );

	void                ExchangeAsk              ( MSG_REQ_ITEM_EXCHANGE_ASK* msg );
	void                ExchangeAsk              ( sObject object );
	void                ExchangeReply            ( MSG_REQ_ITEM_EXCHANGE_REP* msg );
	void                ExchangeReply            ( BYTE type );

	void                ExchangeAdd              ( MSG_REQ_ITEM_EXCHANGE_ADD* msg );
	void                ExchangeAdd              ( TB_INVENTORY* inventory );
	void                ExchangeAdd              ( unsigned long money );
	void                ExchangeDel              ( MSG_REQ_ITEM_EXCHANGE_DEL* msg );
	void                ExchangeDel              ( TB_INVENTORY* inventory );

	void                ExchangeOk               ( MSG_REQ_ITEM_EXCHANGE_OK* msg );
	void                ExchangeRetry            ( MSG_REQ_ITEM_EXCHANGE_RETRY* msg );
	void                ExchangeRetry            ( );
	void                ExchangeCancel           ( MSG_REQ_ITEM_EXCHANGE_CANCEL* msg );
	void                ExchangeCancel           ( );

	void                ExchangeEnd              ( MSG_REQ_ITEM_EXCHANGE_END* msg );
	void                ExchangeEnd              ( TB_INVENTORY* table, unsigned long rowCount );

	bool                SendMsgResExchange       ( char category, char protocol, int error );
	bool                SendMsgResExchangeEnd    ( TB_INVENTORY* table, unsigned long rowCount );

	//   .
private:
	//  (ITEM)
	bool                mStallSell;
	wchar_t             mStallSellTitle[ MAX_STALL_TITLE_LEN ];
	StallSellItem       mStallSellItems[ MAX_STALL_ITEM ];
	unsigned long       mStallSellItemOffset;

	unsigned long       mStallSellGuests[ MAX_STALL_GUEST ];
	unsigned long       mStallSellGuestOffset;

	//  ԽƮ(GUEST)
	sObject             mStallSellOwner;

	//   ޼ҵ.
public:
	void                StallSellSearch          ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_SEARCH* msg );

	bool                IsStallSellOpen          ( ) { return mStallSell; }
	void                StallSellOpen            ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_OPEN* msg );
	void                StallSellClose           ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_CLOSE* msg );

	void                StallSellOpenDie         ( );
	void                StallSellOpenShutdown    ( bool shutdown=false );

	void                StallSellUseDie          ( );
	void                StallSellUseShutdown     ( bool shutdown=false );

	StallSellItem*      GetStallSellItem         ( TB_INVENTORY* inventory, long price );
	StallSellItem*      GetStallSellItem         ( TB_INVENTORY* inventory );
	bool                ReleaseStallSellItem     ( StallSellItem* stallSellItem );
	void                ClearStallSellItem       ( );

	bool                GetStallSellGuest        ( unsigned long characterIdx );
	bool                ReleaseStallSellGuest    ( unsigned long characterIdx );
	void                ReleaseStallSellAllGuests( );

	void                StallSellRename          ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_RENAME* msg );

	void                StallSellAdd             ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_ADD* msg );
	void                StallSellDel             ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_DEL* msg );
	void                StallSellMod             ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_MOD* msg );

	void                StallSellJoin            ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_JOIN* msg );
	void                StallSellJoin            ( cPlayer* player );
	void                StallSellLeave           ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_LEAVE* msg );
	bool                StallSellLeave           ( cPlayer* player );
	void                StallSellLeave           ( int error );
	void                StallSellGet             ( ULONG_PTR socketContext, MSG_REQ_ITEM_STALL_SELL_GET* msg );

	bool                SendMsgResStallSell      ( char category, char protocol, int error );
	void                SendMsgSynStallSell      ( char category, char protocol, TB_INVENTORY* inventory, long price );

	// Ÿ  .
private:
	wchar_t             mTarotTitle[ MAX_TAROT_TITLE ];
	unsigned long       mTarotPrice;
	unsigned short      mTarotUserCount;
	short               mTarotItemCount;
	bool                mTarotCloseReserved;

	unsigned long       mTarotGuests[ MAX_TAROT_GUEST ];
	int					mTarotGuestOffset;

	unsigned long       mTarotReaderIdx;
	TB_INVENTORY*       mTarotCards[ MAX_TAROT_CARDS ];
	TB_INVENTORY*       mSpread[ MAX_SPREAD ];
	int                 mSpreadOffset;

	unsigned long       mTarotResultIndex;
	unsigned long       mTarotResultValue;

	// Ÿ  ޼ҵ - Ÿδ Reader Seeker .
public:
	void                SetTarotResultIndex      ( long index ) { mTarotResultIndex=index; }
	void                SetTarotResultValue      ( long value ) { mTarotResultValue=value; }

	wchar_t*            GetTarotTitle            ( ) { return mTarotTitle; }
	unsigned long       GetTarotPrice            ( ) { return mTarotPrice; }

	bool				IsTarotReaderClose       ( );

	void				TarotReaderReady         ( ULONG_PTR socketContext, MSG_REQ_TAROT_READER_READY* msg );
	void				TarotReaderOpen          ( ULONG_PTR socketContext, MSG_REQ_TAROT_READER_OPEN* msg );
	void				TarotReaderClose         ( ULONG_PTR socketContext, MSG_REQ_TAROT_READER_CLOSE* msg );
	void				TarotReaderClose         ( int error );

	bool                GetTarotCloseReserved    ( ) { return mTarotCloseReserved; }
	bool                GetTarotGuest            ( unsigned long characterIdx );
	bool                ReleaseTarotGuest        ( unsigned long characterIdx );
	void                ReleaseTarotAllGuests    ( );

	bool                GetTarotCards            ( TB_INVENTORY* inventory[] );
	void                GetSpreads               ( TB_INVENTORY* inventory[], int& offset );
	short               GetTarotItemCount        ( ) { return mTarotItemCount; }
	void                UseTarotCard             ( sObject object, long money, long itemDefineIndex );

	void                TarotSeekerOpen          ( ULONG_PTR socketContext, MSG_REQ_TAROT_SEEKER_OPEN* msg );
	void                TarotSeekerClose         ( ULONG_PTR socketContext, MSG_REQ_TAROT_SEEKER_CLOSE* msg );
	void                TarotSeekerJoin          ( ULONG_PTR socketContext, MSG_REQ_TAROT_SEEKER_JOIN* msg );
	void                TarotSeekerResult        ( ULONG_PTR socketContext, MSG_REQ_TAROT_SEEKER_RESULT* msg );
	void                TarotSeekerAccept        ( ULONG_PTR socketContext, MSG_REQ_TAROT_SEEKER_ACCEPT* msg );

	void                TarotReaderDie           ( );
	void                TarotSeekerDie           ( );
	void                TarotReaderShutdown      ( bool shutdown=false );
	void                TarotSeekerShutdown      ( bool shutdown=false );

	bool                SendMsgResTarot          ( char category, char protocol, int error );

	bool                SendTarotReaderJoin      ( wchar_t* seekerName );
	bool                SendTarotReaderLeave     ( wchar_t* seekerName );

	bool                SendTarotStoreOpen       ( wchar_t* readerName, wchar_t* tarotTitle, unsigned long price );
	bool                SendTarotStoreJoin       ( wchar_t* tarotTitle, unsigned long price );

	// Ʈ  
private:
	///	  Ʈ
	TB_QUEST_PROGRESS	mQuest[ MAX_KEEPQUEST ];

	/// ش  npc  
	typedef tHashMap<unsigned long, eNpcQuestStatus> cNpcQuestStatusMap;
	cNpcQuestStatusMap	mNpcStatusMap;

	/// Ϸ Ʈ  (  )
	typedef	tHashSet<unsigned long> cCompleteQuestSet;
	cCompleteQuestSet	mCompleteQuestSet;

	/// Ϸ Ʈ ׷ 
	typedef	tHashSet<unsigned int> cCompleteGroupQuestSet;
	cCompleteGroupQuestSet	mCompleteGroupQuestSet;

	// Ʈ  ޼ҵ
public:
	TB_QUEST_PROGRESS*  GetQuest				 ( int number );
	bool                SendQuest		         ( ULONG_PTR socketContext );
	bool				SaveQuestProgress		 ( ULONG_PTR socketContext );	/// DB  Ʈ  		
	bool				SendDefaultReward		 ( unsigned long questIdx, unsigned long* skillList, unsigned char skillListCnt );
	bool				SendRewardBuff			 ( unsigned long buffIdx );
	bool				SendLimitPenalty		 ( unsigned long questIdx, bool gameIn = false );	///  ɱ
	bool				SendFailPenalty			 ( unsigned long questIdx );	/// з  гƼ
	bool				SendEndPenalty			 ( unsigned long questIdx );	/// Ʈ  ó

	/// Ʈ  ˻ ( targetIdx : , npc ε )
	void				UpdateDutyHunt			 ( unsigned int classIdx );	
	void				UpdateDutyItem			 ( );
//	void				UpdateDutyItem			 ( unsigned long itemIndex, unsigned int count );

	int					IsRegistQuest			 ( eQUESTADD_TYPE type, unsigned long questIdx, unsigned long npcIdx );	/// ű԰ Ʈ ˻
	int					IsRegistQuestItem		 ( unsigned long questIdx );	/// ű԰ Ʈ ˻
	bool				IsEquipQuestItem		 ( unsigned long questIdx );	/// Ʈ  ϰ ִ ˻
	int					IsUseQuestItem			 ( unsigned int number, unsigned long& questIdx );		/// Ƿھ Ҽ ִ üũ
	bool				QuestMapChange			 ( unsigned long posIdx );
	void				InitQuestAura            ( );
	bool				IsCompleteGathering		 ( unsigned long questIndex );

	int					IsKeepQuest				 ( int arrIdx, long questIdx ); ///  Ʈ ˻
	int					IsKeepQuest				 ( long questIdx );
	int					IsKeepGroupQuest		 ( long questIdx );				/// ش Ʈ  ׷ Ʈ  ˻
	bool				IsCompleteQuest			 ( long questIdx );				///  Ϸ Ʈ ˻
	bool				IsCompleteGrouptQuest	 ( long questIdx );				/// ش Ʈ  ׷ Ʈ Ϸߴ ˻
	bool				AddCompleteQuest		 ( unsigned long questIdx );	///  Ϸ Ʈ 
	int					FindEmptyQuest			 ( );
	void				ClearQuestList			 ( );
	void				ClearCompleteList		 ( );
	void				DeleteQuest				 ( int arrIdx );	
	unsigned int		GetDropItemCount		 ( unsigned int arrIdx, unsigned long itemIdx );	///   ʿ   

	bool				ResetQuestNpcStatus		 ( );							///   ü npc Ʈ  ʱȭ (map)
	bool				ResNpcQuestStatus		 ( HANDLE handle, void* msg );
	bool				ResNpcQuestStatus		 ( );							/// NPC  SEND
	bool				SendMapChangeNpcStatus	 ( );							/// ü ش  ü npc  üũ  send 
	bool				SendNpcQuestStatus		 ( );
	bool				SendNpcNewQuestList		 ( unsigned long npcIdx );		/// npc Ŭ ű  Ʈ  ֱ

	int					SaveQuestInsert			  ( ULONG_PTR socketContext, long characterIdx, long questIdx );
	int					SaveQuestInsertByItem	  ( ULONG_PTR socketContext, long characterIdx, unsigned long questIndex, unsigned short number );
	int					SaveQuestComplete		  ( ULONG_PTR socketContext, MSG_REQ_NPC_QUEST_COMPLETE* msg, unsigned int dbIdx );	
	int                 SaveQuestReward           ( ULONG_PTR socketContext, MSG_REQ_NPC_QUEST_REWARD* msg, unsigned int dbIdx );
	bool				SaveQuestDelete			  ( ULONG_PTR socketContext, MSG_REQ_QUEST_DEL* msg, unsigned int dbIdx );
	bool				SaveQuestDeleteAuto		  ( ULONG_PTR socketContext, MSG_REQ_QUEST_DELAUTO* msg, unsigned int dbIdx );
	void				GetQuestStatus            ( eNpcQuestStatus& status, unsigned long npcIdx );

	// Ŀ´Ƽ ޼ҵ - ģ.
private:
	TB_FRIEND           mFriends[ MAX_FRIEND ];

public:
	void                ClearFriends             ( );
	TB_FRIEND*          SelectFriend             ( short offset=0 );
	bool                UpdateFriend             ( );
	void                SendFriendList           ( ULONG_PTR socketContext );

	// Ʈũ  ޼ҵ.
public:
	bool                SendPlayerInfo           ( char category, char protocol, ULONG_PTR socketContext );
	bool                SendSightIn              ( char category, char protocol, unsigned long connectionIdx );
	bool                SendSightOut             ( char category, char protocol, unsigned long connectionIdx );
	bool				SendBuff				 ( char protocol, unsigned long connectionIdx );

	bool				SendHeroInfo();

	/// ġƮ
protected:
	bool mCheatHideMode;
	bool mCheatUndeadMode;
	unsigned long mCheatChatDuration;
	unsigned long mCheatChatAccumTime;
	unsigned long mCheatStopDuration;

public:
	void SetCheatHideMode( bool hide );
	bool GetCheatHideMode() const;

	void SetCheatUndeadMode( bool undead );
	void CheatRecover();
	void CheatRebirth();

	void CheatStop( unsigned long duration );
	void CheatCancelStop();

	void SetCheatSpeedUp( unsigned long speedUp );
	void CalcCheatSpeedUp();

	/// ȣĪ
private:
	/// ÷̾  ȣĪ 
	typedef tPointerHashSet<unsigned long> cHaveTitleSet;
	cHaveTitleSet mHaveTitleSet;

	/// ȣĪ    ȿ  ε( ȿ   )
	unsigned long mTitleUniqIndex;
	
public:
	bool SendHaveTitleList( ULONG_PTR socketContext );	///  ȣĪ  send
	void SendHaveTitle( unsigned long titleIdx );		///  ȣĪ send
	
	void ClearHaveTitleList();							///  ȣĪ  ʱȭ
	bool AddHaveTitle( unsigned long titleIdx );		///  ȣĪ ߰

	bool InitTitle();
	bool ChangeTitle( unsigned long titleIdx );			///  ȣĪ 

public:
	void				SetPartyIndex( unsigned long idx );
	unsigned long		GetPartyIndex()	{ return mPlayerExrInfo.mPartyIndex; }

public:
	void SetGuildAddReq( bool set ) { mIsGuildAddReq = set; }
	bool IsGuildAddReq() { return mIsGuildAddReq; }		///  ʴϰ ִ 

	bool ChangeGuild( unsigned long guildIndex, char position, wchar_t* name, unsigned long markIndex );
	void ChangeGuildPosition( char position );
	void ChangeGuildMarkIndex( unsigned long markIndex );

private:
	/// ɼ 
	sGameOption		mOptionData1;

public:
	void		SetOptionData( long option ) { mOptionData1.optionData1 = option; }
	sGameOption*		GetOptionData() { return &mOptionData1; }

private:
	/// NPC  ̿
	TIMESTAMP_STRUCT mFortuneThru[5];

public:
	TIMESTAMP_STRUCT* GetFortuneThru( int i );
	bool SaveFortuneData( ULONG_PTR socketContext );

	bool SendInitTodayWord();
	bool ChangeTodayWord( ULONG_PTR socketContext, wchar_t* word, unsigned long color );


	//    
public:
	bool   mBlockApply;
	time_t mBlockValidThru;

	//   ޼ҵ 
public:
	bool IsBlock  ( );
	bool SetBlock ( bool apply, unsigned long second );
};

inline void cPlayer::SetName( wchar_t* name ) 
{
	::wcsncpy( mPlayerInfo.strName, name, MAX_NAME_SIZE ); 
	mPlayerInfo.strName[MAX_NAME_SIZE] = 0;
}

inline void cPlayer::SetRace( char race )
{
	mPlayerInfo.Race = race;
}

inline void cPlayer::SetGender( char gender )
{
	mPlayerInfo.Gender = gender;
}

inline void	cPlayer::SetStaticFaceIndex( unsigned long faceIdx )
{
	mPlayerInfo.HeadInfo[eHEAD_FACE_STATIC] = faceIdx;
}

inline void cPlayer::SetRangeTarget( float tPosX, float tPosY, sObject& tInfo, float range )
{
	mRange = range;
	mRangeTargetPos = NiPoint2(tPosX, tPosY);
	mRangeTarget = tInfo;
}

inline bool cPlayer::MonsterImportancePlus( unsigned char importance )
{
	if( mMonsterImportance + importance > 100 )
	{
		//printf("\n 100 < importancePlus [%d]\n", mMonsterImportance + importance );
		return false;
	}

	//printf("\n mMonsterImportance[%d] + ", mMonsterImportance );
	mMonsterImportance = mMonsterImportance + importance;
	//printf("importance[%d] = MonsterImportancePlus[%d] \n", importance, mMonsterImportance );
	return true;
}

inline void cPlayer::MonsterImportanceMinus( unsigned char importance )
{
	if( mMonsterImportance - importance < 0 )
	{
		//printf("\n 0 > importancePlus [%d]\n", mMonsterImportance - importance );
		mMonsterImportance = 0;
		return;
	}

	//printf("\n mMonsterImportance[%d] - ", mMonsterImportance );
	mMonsterImportance = mMonsterImportance - importance;
	//printf("importance[%d] = MonsterImportancePlus[%d] \n", importance, mMonsterImportance);

}

inline void cPlayer::ApplyMapTargetPos( )
{
	mMapNumber = mMapTargetPos.mMapNumber;
	mGotoX = mObjectPos.x = mMapTargetPos.mPosX;
	mGotoY = mObjectPos.y = mMapTargetPos.mPosY;
	mDirection = mMapTargetPos.mRotAngle;
}

inline bool cPlayer::IsInventory(TB_INVENTORY* inventory)
{
	if ( inventory != NULL )
		return ((inventory->idx > 0) && (inventory->count > 0));
	return false;
}

inline bool cPlayer::IsInventoryRange(unsigned short number)
{
	return !(number > MAX_INVENTORY);
}

inline bool cPlayer::IsInventoryEquip(unsigned short number)
{
	return !(number > INVENTORY_EQUIP_END);
}

inline bool cPlayer::IsInventoryQuest(unsigned short number)
{
	return !(number < INVENTORY_QUEST_BEGIN || number > INVENTORY_QUEST_END);
}

inline bool cPlayer::IsInventoryMall(unsigned short number)
{
	return !(number < INVENTORY_MALL_BEGIN || number > INVENTORY_MALL_END);
}

inline bool cPlayer::IsInventoryWarehouse(unsigned short number)
{
	return !(number < INVENTORY_WAREHOUSE_BEGIN || number > INVENTORY_WAREHOUSE_END);
}

inline TB_INVENTORY* cPlayer::SelectInventory(short number)
{
	return (number < MIN_INVENTORY || number > MAX_INVENTORY) ? (NULL) : (mInventory + number);
}

inline TIMESTAMP_STRUCT* cPlayer::GetFortuneThru( int i )
{
	return ( i >= 0 && i < 5 ) ? mFortuneThru + i : NULL;
}

/// 迭 ε 
inline TB_QUEST_PROGRESS* cPlayer::GetQuest( int number )
{
	return (number < 0 || number > MAX_KEEPQUEST ) ? (NULL) : (mQuest + number);
}

inline void cPlayer::ClearQuestList()
{
	memset( mQuest, 0, sizeof(mQuest) );
}

inline void cPlayer::ClearCompleteList()
{
	mCompleteQuestSet.Clear();
	mCompleteGroupQuestSet.Clear();
}

/// ġƮ
inline
bool cPlayer::GetCheatHideMode() const
{
	return mCheatHideMode;
}

inline
void cPlayer::SetCheatUndeadMode( bool mode )
{
	mCheatUndeadMode = mode;
}

//inline
//void cPlayer::SetCheatWatch( bool mode )
//{
//	mCheatWatch = mode;
//}

