// Include
#include "gamesrv.h"
#include "playernamepool.h"

// Local definitions

// Global data
cPlayerNamePool* cPlayerNamePool::mpPlayerNamePool = NULL;

// CooltimeCmpIndex Prototype
int WINAPI PlayerNameCmpWChar(void* arg1, void* arg2)
{
	return wcscmp( ((PerPlayerName*)arg1)->name, ((PerPlayerName*)arg2)->name );
}

// CooltimeCmpValue Prototype
int WINAPI PlayerNameCmpValue(void* arg1, void* arg2)
{
	return wcscmp( ((PerPlayerName*)arg1)->name, (wchar_t*)arg2 );
}

// cPlayerNamePool Constructor
cPlayerNamePool::cPlayerNamePool( )
{
	// Global Variable
	mpPlayerNamePool = this;

	// Pool Usage Pointer
	mNonPagedPoolUsage = NULL;

	mPlayerNameRoot.pool = NULL;
	mPlayerNameRoot.root = NULL;
}

// ~cPlayerNamePool Destructor.
cPlayerNamePool::~cPlayerNamePool(void)
{
	// cPlayerNamePool .
	Shutdown();

	// Global Variable
	mpPlayerNamePool = NULL;
}

// Shutdown Method
void cPlayerNamePool::Shutdown()
{
	PerPlayerName* temp;
	// Pool Usage Shutdown - NonPagedPoolUsage
	while ( mNonPagedPoolUsage != NULL )
	{
		temp               = mNonPagedPoolUsage;
		mNonPagedPoolUsage = (PerPlayerName*)mNonPagedPoolUsage->next;
		MEMORY_POOL->FreeNode( (void**)&temp  );
	}
}

// Search Method
PerPlayerName* cPlayerNamePool::Search(wchar_t* name)
{
	return (PerPlayerName*)MEMORY_POOL->SearchNode( &mPlayerNameRoot, name, &PlayerNameCmpValue );
}

// GetPlayerName Method - Ʈ HEAD Ѱش.
// ReleasePlayerName Բ LIFO ̷. LIFO Context Switching ּȭ ϱ  
PerPlayerName* cPlayerNamePool::GetPlayerName(ULONG connectionIdx, ULONG characterIdx, wchar_t* name)
{
	PerPlayerName* perPlayerName = (PerPlayerName*)MEMORY_POOL->GetPool( (PerNode**)&mNonPagedPoolUsage, sizeof(PerPlayerName) );
	if ( perPlayerName )
	{
		perPlayerName->connectionIdx = connectionIdx;
		perPlayerName->characterIdx  = characterIdx;
		wcscpy( perPlayerName->name, name );

		// BST-õ.
		if ( MEMORY_POOL->AttachBst( &mPlayerNameRoot.root, perPlayerName, PlayerNameCmpWChar ) )
		{
			MEMORY_POOL->AttachPool( (PerNode**)&mPlayerNameRoot.pool, perPlayerName );
			return perPlayerName;	// Ἲ.
		}
		else
		{
			MEMORY_POOL->AttachPool( (PerNode**)&mNonPagedPoolUsage, perPlayerName );
			return NULL;		// .
		}
	}
	return perPlayerName;
}

// ReleasePlayerName Method - Ʈ HEAD ȸѴ.
// GetPlayerName Բ LIFO ̷. LIFO Context Switching ּȭ ϱ  
void cPlayerNamePool::ReleasePlayerName(PerPlayerName* perPlayerName)
{
	// BST - .
	MEMORY_POOL->DetachBst( (PerNode**)&mPlayerNameRoot.root, (PerNode*)perPlayerName );

	//   Ǯ 뷮 .
	MEMORY_POOL->DetachPool( (PerNode**)&mPlayerNameRoot.pool, (PerNode*)perPlayerName );

	//  ȵ Ǯ 뷮 .
	MEMORY_POOL->ReleasePool( (PerNode**)&mNonPagedPoolUsage, (PerNode*)perPlayerName );
}
