#include "stdafx.h"
#include "Player_Common.h"
#include "ObjectManager.h"
#include "SkillManager.h"
#include "BaseObject.h"
#include "DamageCalc.h"
#include "Protocol.h"
#include "Player.h"
#include "Monster.h"
#include "gamesrv.h"
#include "Drop.h"
#include "StatusCalc_Server.h"


cPlayerSkillObject::cPlayerSkillObject()
{
	mSkillIdx = 0;
	mSkillStep = 0;
}



cPlayerSkillObject::~cPlayerSkillObject()
{
}



void* cPlayerSkillObject::operator new( size_t n )
{
	if( n != sizeof(cPlayerSkillObject) ) 
	{
		assert(0);
		return NULL;
	}

	return SKILLMANAGER->AllocPlayerSkillObject();
}



void cPlayerSkillObject::operator delete( void* ptr, size_t n )
{
	/// NULL  ˻
	if( ptr == 0 )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cPlayerSkillObject) ) 
	{
		assert(0);
		return;
	}

	SKILLMANAGER->FreePlayerSkillObject( static_cast<cPlayerSkillObject*>(ptr) );

	return;
}



unsigned char cPlayerSkillObject::InitPlayerNormalAttack( unsigned long playerIdx, sObject target, unsigned long skillIdx, 
												unsigned long uniqueIdx, float speedFactor, unsigned long mapNumber )
{

	///  idx 
	mUniqueIdx = uniqueIdx;

	/// ųidx  .
	mSkillIdx = skillIdx;

	///  
	mAttacker.index = playerIdx;
	mAttacker.type = eOBJECTTYPE_PLAYER;

	mSpeedFactor = speedFactor;

	/// Ÿ 
	mCenterTarget = target;

	mMapNumber = mapNumber;

	/// ų Ʈ  ð
	mCreationTime = NETWORK2->GetAccumTime();

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerNormalAttack, playerIdx error [%d]", playerIdx);
		return 1;
	}

	///  ũƮ Ͽ ð  о
	cDramaturgyInfo* pDramaInfo = DRAMATURGYMAN->GetPlayerDramaturgyInfo( skillIdx, (unsigned short)pPlayer->GetWeaponState(), 
		pPlayer->GetRace(), pPlayer->GetGender(), &mDramaKey );
	if( pDramaInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerNormalAttack, pDramaInfo error [%d,%d,%d,%d,%d]", 
			playerIdx, skillIdx, (unsigned short)pPlayer->GetWeaponState(), pPlayer->GetRace(), pPlayer->GetGender() );
		return 2;
	}
	sDramaState* pDramaState = pDramaInfo->GetDramaState();
	if( pDramaState == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerSkill, GetDramaState error [%d,%d,%d,%d,%d]", 
			playerIdx, skillIdx, (unsigned short)pPlayer->GetWeaponState(), pPlayer->GetRace(), pPlayer->GetGender() );
		return 3;
	}

	mDetailCnt = pDramaState->GetDamageCount();
	mpDetailBegin = (sDramaAction*)pDramaState->GetDamageBegin();
	mpDetailEnd = (sDramaAction*)pDramaState->GetDamageEnd();

	/// ߻ü 
	mIsProjectile = pDramaInfo->IsBullet();
	/// ߻ü ӵ
	mProjectileSpeed = pDramaInfo->GetBulletSpeed();
	/// ߵ ð
	mActivityTime = pDramaInfo->GetActivityEndTime();
	///  ġ = ߻繰 ġ
	mProjectilePos = pPlayer->GetPos();

	/// ߻繰 Ÿġ    ߻繰 óҴ  ٲ۴.
	mCenterPos.x = pPlayer->GetXPos();
	mCenterPos.y = pPlayer->GetYPos();
	mCenterPos.z = pPlayer->Height();

	mSkillState = eSKILLPROCESS_ACTIVITY;
	mCastingTime = 0;

	/// skill pc о
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pSkillInfo == NULL )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerNormalAttack - GetPlayerSkillInfo(%d)", skillIdx );
		return false; 
	}

	///  ų üũ
	cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillIdx );
	if( !pPlayerHaveSkill )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerNormalAttack - GetPlayerHaveSkill(%d,%d)", mAttacker.index, skillIdx  );
		return false; 
	}

	/// ų  о
	mSkillStep = pPlayerHaveSkill->GetSkillStep();
	if( mSkillStep >= pSkillInfo->mStepCount )
	{
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerNormalAttack - mSkillStep(%d)", mSkillStep );
		return false; 
	}
	sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[mSkillStep];

	mDistressPoint = pStepInfo->mDistressValue;

	/// Ÿ 
	SKILLMANAGER->UpdateSkillCoolTime( mAttacker, mSkillIdx, mSkillStep, NETWORK2->GetAccumTime(), speedFactor );

	///  ׸忡 شϴ ÷̾  о  ߼ ܿ ִ´.
	cPlayer* pMsgTarget = GRIDMANAGER->FindFirstPlayer( pPlayer, true );
	while( pMsgTarget != NULL )
	{
		mSendTargetSet.Insert( pMsgTarget->GetConnectionIdx() );
		pMsgTarget = GRIDMANAGER->FindNextPlayer( true );
	}

	return 0;
}



bool cPlayerSkillObject::InitPlayerSkill( unsigned long skillIdx, unsigned char skillStep, unsigned long uniqueIdx, cPlayer* pAttacker, cBaseObject* pTarget, unsigned long castingTime )
{
	if( pAttacker == 0 )
		return false;

	///  idx 
	mUniqueIdx =  uniqueIdx;

	/// ųidx  .
	mSkillIdx = skillIdx;
	mSkillStep = skillStep;

	///  
	mAttacker.index = pAttacker->GetObjectID();
	mAttacker.type = eOBJECTTYPE_PLAYER;

	/// Ÿ 
	if( pTarget )
	{
		mCenterTarget.index = pTarget->GetObjectID();
		mCenterTarget.type = pTarget->GetObjectType();
	}
	else
	{
		mCenterTarget.index = 0;
		mCenterTarget.type = eOBJECTTYPE_NONE;
	}

	mMapNumber = pAttacker->GetMapNumber();

	/// ų Ʈ  ð
	mCreationTime = NETWORK2->GetAccumTime();

	cDramaturgyInfo* pDramaInfo;
	///  ũƮ Ͽ ð  о
	pDramaInfo = DRAMATURGYMAN->GetPlayerDramaturgyInfo( skillIdx, (unsigned short)pAttacker->GetWeaponState(), 
		pAttacker->GetRace(), pAttacker->GetGender(), &mDramaKey );
	if( pDramaInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent( "InitPlayerSkill - pDramaInfo error[%d,%d,%d,%d]", skillIdx, (unsigned short)pAttacker->GetWeaponState(), 
			pAttacker->GetRace(), pAttacker->GetGender() );
		return false;
	}
	
	sDramaState* pDramaState = pDramaInfo->GetDramaState();
	if( pDramaState == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerSkill, GetDramaState error [%d,%d,%d,%d,%d]", 
			mAttacker.index, skillIdx, (unsigned short)pAttacker->GetWeaponState(), pAttacker->GetRace(), pAttacker->GetGender() );
		return false;
	}

	mDetailCnt = pDramaState->GetDamageCount();
	mpDetailBegin = (sDramaAction*)pDramaState->GetDamageBegin();
	mpDetailEnd = (sDramaAction*)pDramaState->GetDamageEnd();

	/// ߻ü 
	mIsProjectile = pDramaInfo->IsBullet();
	/// ߻ü ӵ
	mProjectileSpeed = pDramaInfo->GetBulletSpeed();
	/// ߵ ð
	mActivityTime = pDramaInfo->GetActivityEndTime();
	///  ġ = ߻繰 ġ
	mProjectilePos = pAttacker->GetPos();

	/// ߻繰 Ÿġ    ߻繰 óҴ  ٲ۴.
	mCenterPos.x = pAttacker->GetXPos();
	mCenterPos.y = pAttacker->GetYPos();
	mCenterPos.z = pAttacker->Height();

	mCastingTime = castingTime;
	if( mCastingTime != 0 )
	{
		mSkillState = eSKILLPROCESS_CASTING;
	}
	else
	{
		mSkillState = eSKILLPROCESS_ACTIVITY;

		/// Ÿ 
		SKILLMANAGER->UpdateSkillCoolTime( mAttacker, mSkillIdx, mSkillStep, NETWORK2->GetAccumTime(), mSpeedFactor );
	}

	/// skill pc о
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pSkillInfo == NULL )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerSkill - GetPlayerSkillInfo(%d)", skillIdx );
		return false; 
	}

	///  ų üũ
	cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillIdx );
	if( !pPlayerHaveSkill )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerSkill - GetPlayerHaveSkill(%d,%d)", mAttacker.index, skillIdx  );
		return false; 
	}

	/// ų  о
	mSkillStep = pPlayerHaveSkill->GetSkillStep();
	if( mSkillStep >= pSkillInfo->mStepCount )
	{
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerSkill - mSkillStep(%d)", mSkillStep );
		return false; 
	}
	sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[mSkillStep];

	mDistressPoint = pStepInfo->mDistressValue;

	/// Ÿ  ų
	if( pStepInfo->mApplyValueType2 == eSTATUSPLUS_DELETE_TARGETING || pStepInfo->mApplyValueType2 == eSTATUSPLUS_DELETE_TARGETING)
        mDelTarget = true;

	///  ׸忡 شϴ ÷̾  о  ߼ ܿ ִ´.
	cPlayer* pMsgTarget = GRIDMANAGER->FindFirstPlayer( pAttacker, true );
	while( pMsgTarget != NULL )
	{
		mSendTargetSet.Insert( pMsgTarget->GetConnectionIdx() );
		pMsgTarget = GRIDMANAGER->FindNextPlayer( true );
	}

	if( pTarget )
	{
		/// Ÿ ׸忡 شϴ ÷̾  о  ߼ ܿ ִ´.
		pMsgTarget = GRIDMANAGER->FindFirstPlayer( pTarget, true );
		while( pMsgTarget != NULL )
		{
			mSendTargetSet.Insert( pMsgTarget->GetConnectionIdx() );
			pMsgTarget = GRIDMANAGER->FindNextPlayer( true );
		}
	}

	return true;
}



bool cPlayerSkillObject::InitPlayerSkillPosition( unsigned long playerIdx, float targetXPos, float targetYPos,
												 unsigned long skillIdx, unsigned long uniqueIdx, bool casting, unsigned long mapNumber )
{
	///  idx 
	mUniqueIdx = uniqueIdx;

	/// ųidx  .
	mSkillIdx = skillIdx;

	mMapNumber = mapNumber;

	///  
	mAttacker.index = playerIdx;
	mAttacker.type = eOBJECTTYPE_PLAYER;

	/// ŸٿƮ .
	mCenterTarget.index = 0;
	mCenterTarget.type = eOBJECTTYPE_NONE;

	mIsFieldTarget = true;

	/// ų Ʈ  ð
	mCreationTime = NETWORK2->GetAccumTime();

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerSkillPosition - playerIdx[%d]", playerIdx );
		return false;
	}

	///  ũƮ Ͽ ð  о
	cDramaturgyInfo* pDramaInfo = DRAMATURGYMAN->GetPlayerDramaturgyInfo( skillIdx, (unsigned short)pPlayer->GetWeaponState(), 
		pPlayer->GetRace(), pPlayer->GetGender() ,&mDramaKey );
	if( pDramaInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerSkillPosition - pDramaInfo[%d,%d,%d,%d]", skillIdx, (unsigned short)pPlayer->GetWeaponState(), 
			pPlayer->GetRace(), pPlayer->GetGender() );
		return false;
	}

	sDramaState* pDramaState = pDramaInfo->GetDramaState();
	if( pDramaState == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerSkill, GetDramaState error [%d,%d,%d,%d,%d]", 
			playerIdx, skillIdx, (unsigned short)pPlayer->GetWeaponState(), pPlayer->GetRace(), pPlayer->GetGender() );
		return false;
	}

	mDetailCnt = pDramaState->GetDamageCount();
	mpDetailBegin = (sDramaAction*)pDramaState->GetDamageBegin();
	mpDetailEnd = (sDramaAction*)pDramaState->GetDamageEnd();

	/// ߻ü 
	mIsProjectile = pDramaInfo->IsBullet();
	/// ߻ü ӵ
	mProjectileSpeed = pDramaInfo->GetBulletSpeed();
	/// ߵ ð
	mActivityTime = pDramaInfo->GetActivityEndTime();
	///  ġ = ߻繰 ġ
	mProjectilePos = pPlayer->GetPos();

	/// ǥ 
	mCenterPos.x = targetXPos;
	mCenterPos.y = targetYPos;
	AIMANAGER->CalcHeight( pPlayer->GetMapNumber(), &mCenterPos.z, mCenterPos.x, mCenterPos.y );

	/// skill pc о
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( pSkillInfo == NULL )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerSkillPosition - GetPlayerSkillInfo(%d)", skillIdx );
		return false; 
	}

	///  ų üũ
	cHaveSkillObject* pPlayerHaveSkill = SKILLMANAGER->GetPlayerHaveSkill( mAttacker.index, skillIdx );
	if( !pPlayerHaveSkill )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerSkillPosition - GetPlayerHaveSkill(%d,%d)", mAttacker.index, skillIdx  );
		return false; 
	}

	/// ų  о
	mSkillStep = pPlayerHaveSkill->GetSkillStep();
	if( mSkillStep >= pSkillInfo->mStepCount )
	{
		assert(NULL); 
		NETWORK2->PostServerEvent("InitPlayerSkillPosition - mSkillStep(%d)", mSkillStep );
		return false; 
	}
	sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[mSkillStep];

	mDistressPoint = pStepInfo->mDistressValue;

	if( pSkillInfo->mShotType == eSHOTTYPE_CASTING )
		mCastingTime = pStepInfo->mCastingTime;
	else
		mCastingTime = 0;

	if( casting == true )
		mSkillState = eSKILLPROCESS_CASTING;
	else
	{
		mSkillState = eSKILLPROCESS_ACTIVITY;
		/// Ÿ 
		SKILLMANAGER->UpdateSkillCoolTime( mAttacker, mSkillIdx, mSkillStep, NETWORK2->GetAccumTime(), mSpeedFactor );
	}

	return true;
}

bool cPlayerSkillObject::InitPlayerMapChange( unsigned long skillIdx, unsigned long uniqueIdx, cPlayer* pAttacker, unsigned long useItemDBIdx, unsigned long castingTime )
{
	if( pAttacker == 0 )
		return false;

	///  idx 
	mUniqueIdx =  uniqueIdx;

	/// ųidx  .
	mSkillIdx = skillIdx;
	mMapNumber = pAttacker->GetMapNumber();

	///  
	mAttacker.index = pAttacker->GetObjectID();
	mAttacker.type = eOBJECTTYPE_PLAYER;

	/// Ÿ 
	sMultiTarget multiTarget;
	multiTarget.mTarget.type = eOBJECTTYPE_PLAYER;
	multiTarget.mTarget.index = pAttacker->GetObjectID();
	multiTarget.mApplyHP = true;
	mTargetAry.PushBack( multiTarget );

	/// ų Ʈ  ð
	mCreationTime = NETWORK2->GetAccumTime();

	if( useItemDBIdx == 0 )
		return false;

	mCreateType = eSKILLCREATETYPE_MAPCHANGE;
	mUseItemIdx = useItemDBIdx;

	cDramaturgyInfo* pDramaInfo;
	///  ũƮ Ͽ ð  о
	pDramaInfo = DRAMATURGYMAN->GetPlayerDramaturgyInfo( skillIdx, (unsigned short)eWEAPON_STATE_NONE, 
		pAttacker->GetRace(), pAttacker->GetGender(), &mDramaKey );
	if( pDramaInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent( "InitPlayerMapchange - pDramaInfo error[%d,%d,%d,%d]", skillIdx, (unsigned short)eWEAPON_STATE_NONE, 
			pAttacker->GetRace(), pAttacker->GetGender() );
		return false;
	}

	sDramaState* pDramaState = pDramaInfo->GetDramaState();
	if( pDramaState == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerMapchange, GetDramaState error [%d,%d,%d,%d,%d]", 
			mAttacker.index, skillIdx, (unsigned short)eWEAPON_STATE_NONE, pAttacker->GetRace(), pAttacker->GetGender() );
		return false;
	}

	mDetailCnt = 0;
	mpDetailBegin = 0;
	mpDetailEnd = 0;

	/// ߻ü 
	mIsProjectile = false;
	/// ߻ü ӵ
	mProjectileSpeed = 0;
	/// ߵ ð
	mActivityTime = pDramaInfo->GetActivityEndTime();
	///  ġ = ߻繰 ġ
	mProjectilePos = pAttacker->GetPos();

	/// skill pc о
	mCastingTime = castingTime;
	if( mCastingTime != 0 )
		mSkillState = eSKILLPROCESS_CASTING;
	else
		mSkillState = eSKILLPROCESS_ACTIVITY;

	///  ׸忡 شϴ ÷̾  о  ߼ ܿ ִ´.
	cPlayer* pMsgTarget = GRIDMANAGER->FindFirstPlayer( pAttacker, true );
	while( pMsgTarget != NULL )
	{
		mSendTargetSet.Insert( pMsgTarget->GetConnectionIdx() );
		pMsgTarget = GRIDMANAGER->FindNextPlayer( true );
	}

	return true;
}


bool cPlayerSkillObject::InitPlayerVehicle( unsigned long skillIdx, unsigned long uniqueIdx, cPlayer* pAttacker, unsigned long useItemIdx, unsigned long castingTime )
{
	if( pAttacker == 0 )
		return false;

	///  idx 
	mUniqueIdx =  uniqueIdx;

	/// ųidx  .
	mSkillIdx = skillIdx;
	mMapNumber = pAttacker->GetMapNumber();

	///  
	mAttacker.index = pAttacker->GetObjectID();
	mAttacker.type = eOBJECTTYPE_PLAYER;

	/// Ÿ 
	sMultiTarget multiTarget;
	multiTarget.mTarget.type = eOBJECTTYPE_PLAYER;
	multiTarget.mTarget.index = pAttacker->GetObjectID();
	multiTarget.mApplyHP = true;
	mTargetAry.PushBack( multiTarget );

	/// ų Ʈ  ð
	mCreationTime = NETWORK2->GetAccumTime();

	if( useItemIdx == 0 )
		return false;

	mCreateType = eSKILLCREATETYPE_VEHICLE;
	mUseItemIdx = useItemIdx;

	cDramaturgyInfo* pDramaInfo;
	///  ũƮ Ͽ ð  о
	pDramaInfo = DRAMATURGYMAN->GetPlayerDramaturgyInfo( skillIdx, (unsigned short)eWEAPON_STATE_NONE, 
		pAttacker->GetRace(), pAttacker->GetGender(), &mDramaKey );
	if( pDramaInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent( "InitPlayerVehicle - pDramaInfo error[%d,%d,%d,%d]", skillIdx, (unsigned short)eWEAPON_STATE_NONE, 
			pAttacker->GetRace(), pAttacker->GetGender() );
		return false;
	}

	sDramaState* pDramaState = pDramaInfo->GetDramaState();
	if( pDramaState == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("InitPlayerVehicle, GetDramaState error [%d,%d,%d,%d,%d]", 
			mAttacker.index, skillIdx, (unsigned short)eWEAPON_STATE_NONE, pAttacker->GetRace(), pAttacker->GetGender() );
		return false;
	}

	mDetailCnt = 0;
	mpDetailBegin = 0;
	mpDetailEnd = 0;

	/// ߻ü 
	mIsProjectile = false;
	/// ߻ü ӵ
	mProjectileSpeed = 0;
	/// ߵ ð
	mActivityTime = pDramaInfo->GetActivityEndTime();
	///  ġ = ߻繰 ġ
	mProjectilePos = pAttacker->GetPos();

	/// skill pc о
	mCastingTime = castingTime;
	if( mCastingTime != 0 )
		mSkillState = eSKILLPROCESS_CASTING;
	else
		mSkillState = eSKILLPROCESS_ACTIVITY;

	///  ׸忡 شϴ ÷̾  о  ߼ ܿ ִ´.
	cPlayer* pMsgTarget = GRIDMANAGER->FindFirstPlayer( pAttacker, true );
	while( pMsgTarget != NULL )
	{
		mSendTargetSet.Insert( pMsgTarget->GetConnectionIdx() );
		pMsgTarget = GRIDMANAGER->FindNextPlayer( true );
	}

	return true;
}


bool cPlayerSkillObject::CastingObjectCheck( cBaseObject* pAttacker )
{

	unsigned char errorCode = FAIL_SKILL_CASTING_DONT_TARGET;

	///   Ȯ
	if( pAttacker->GetStateDie() == false && ((cPlayer*)pAttacker)->IsCantSkill() == false )
	{
		sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( mSkillIdx );
		if( pSkillInfo == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cPlayerSkillObject[%d]::CastingObjectCheck pSkillInfo[%d] == NULL", pAttacker->GetObjectID(), mSkillIdx );
			SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
			return false;
		}

		///  Ŀ  Ÿ ü Ȯ 
		switch( pSkillInfo->mBoundType )
		{
		case eBOUNDTYPE_SELF_NOTARGET:
		case eBOUNDTYPE_FIELD:
			return true;
		case eBOUNDTYPE_NONE:			///  
		case eBOUNDTYPE_TARGET:			/// Ÿ ع
		case eBOUNDTYPE_SELF_TARGET:	/// (ڽ) ع - ߵ Ÿ 
			{
				/// ڽ  ̸ 
				if( pSkillInfo->mApplyType == eAPPLYTYPE_SELF ) 
					return true;
			}
		}

		/// Ÿ ü üũ
		cBaseObject* pTarget = OBJECTMANAGER->GetObject( mCenterTarget.type, mCenterTarget.index );
		if( pTarget != NULL )	
		{ 
			/// Ȱ ų üũ
			bool isResurrection = false;
			if( pSkillInfo->mApplyType == eAPPLYTYPE_DIEBUDDY )
				isResurrection = true;

			///   üũ
			if( pTarget->GetStateDie() == false && isResurrection == false )
				return true;

			/// Ȱ ų  
			if( pTarget->GetStateDie() == true && isResurrection == true )
				return true;
		}
	}
	else
		errorCode = FAIL_SKILL_CASTING_DONT_ATTACKER;

	/// ĳ ߵ  ޼ 
	MSG_SYN_SKILL_CAST_ACTIVITY_FAIL failMsg;
	failMsg.Category = NM_SKILL;
	failMsg.Protocol = NM_SKILL_CAST_ACTIVITY_FAIL_SYN;
	failMsg.mAttacker = mAttacker;
	failMsg.mSkillIndex = mUniqueIdx;
	failMsg.mFailCode = errorCode;

	NETWORK2->QuickSend( pAttacker, (char*)&failMsg, sizeof(failMsg) );

	///  ϴ  ܿ return true   °   ϴ 
	return false;
}



///  : ĳ ϴ 츸 Լ 
bool cPlayerSkillObject::RequireValue( cBaseObject* pAttacker )
{	
	/// skill pc  о
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( mSkillIdx );
	if( pSkillInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cPlayerSkillObject[%d]::RequireValue pSkillInfo[%d] == NULL", 
			pAttacker->GetObjectID(), mSkillIdx );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return false;
	}

	if( mSkillStep > pSkillInfo->mStepCount )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cPlayerSkillObject[%d]::RequireValue mSkillStep[%d] > pSkillInfo->mStepCount", 
			pAttacker->GetObjectID(), mSkillStep );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return false;
	}
	sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[mSkillStep];

	/// Ҹ üũ
	switch( mCreateType )
	{
	case eSKILLCREATETYPE_NORMAL:
		{
			if( pAttacker->GetHP() <= pStepInfo->mUseHP || 
				pAttacker->GetMP() < pStepInfo->mUseMP ||
				( pSkillInfo->mUseItem != 0 && ((cPlayer*)pAttacker)->IsItemUse( pSkillInfo->mUseItem, pStepInfo->mUseItemCount ) == false	) )
			{ 
				/// ĳ ߵ  ޼ 
				MSG_SYN_SKILL_CAST_ACTIVITY_FAIL failMsg;
				failMsg.Category = NM_SKILL;
				failMsg.Protocol = NM_SKILL_CAST_ACTIVITY_FAIL_SYN;
				failMsg.mAttacker = mAttacker;
				failMsg.mSkillIndex = mUniqueIdx;
				failMsg.mFailCode = FAIL_SKILL_CASTING_MP_EMPTY;

				NETWORK2->QuickSend( pAttacker, (char*)&failMsg, sizeof(failMsg) );

				return false; 
			}

			if( pStepInfo->mUseItemCount != 0 )
				((cPlayer*)pAttacker)->ItemUse( pSkillInfo->mUseItem, pStepInfo->mUseItemCount );


			/// MP Ҹ ϴ ų
			if( pStepInfo->mUseMP != 0 )
				pAttacker->MPDamage( pStepInfo->mUseMP, false );

			/// HP Ҹ ϴ ų
			if( pStepInfo->mUseHP != 0 )
			{
				/// HP Ҹ & ޼ ߼
				bool die;
				pAttacker->HPDamage( pStepInfo->mUseHP, &die, true );
			}

			/// Ÿ 
			SKILLMANAGER->UpdateSkillCoolTime( mAttacker, mSkillIdx, mSkillStep, NETWORK2->GetAccumTime(), mSpeedFactor );
		}
		break;
	case eSKILLCREATETYPE_MAPCHANGE:
		{
			/// item 
			if( ((cPlayer*)pAttacker)->ItemUseMapChange( mUseItemIdx ) == false )
			{
				/// ĳ ߵ  ޼ 
				MSG_SYN_SKILL_CAST_ACTIVITY_FAIL failMsg;
				failMsg.Category = NM_SKILL;
				failMsg.Protocol = NM_SKILL_CAST_ACTIVITY_FAIL_SYN;
				failMsg.mAttacker = mAttacker;
				failMsg.mSkillIndex = mUniqueIdx;
				failMsg.mFailCode = FAIL_SKILL_CASTING_DONT_MAPCHANGE;

				NETWORK2->QuickSend( pAttacker, (char*)&failMsg, sizeof(failMsg) );

				return false; 
			}
		}
		break;
	case eSKILLCREATETYPE_VEHICLE:
		{
			/// item  Ȯ
			if( ((cPlayer*)pAttacker)->IsItem( mUseItemIdx ) == false )
			{
				/// ĳ ߵ  ޼ 
				MSG_SYN_SKILL_CAST_ACTIVITY_FAIL failMsg;
				failMsg.Category = NM_SKILL;
				failMsg.Protocol = NM_SKILL_CAST_ACTIVITY_FAIL_SYN;
				failMsg.mAttacker = mAttacker;
				failMsg.mSkillIndex = mUniqueIdx;
				failMsg.mFailCode = FAIL_SKILL_CASTING_DONT_MAPCHANGE;

				NETWORK2->QuickSend( pAttacker, (char*)&failMsg, sizeof(failMsg) );

				return false; 
			}
		}
		break;
	}

	/// ĳ ų ߵ mpҸ ߵ ˸ ũ 
	MSG_SYN_SKILL_CAST_ACTIVE msgEtc;
	msgEtc.Category = NM_SKILL;
	if( pSkillInfo->mBoundType == eBOUNDTYPE_FIELD )
		msgEtc.Protocol = NM_SKILL_POS_CAST_ACTIVE_SYN;
	else
		msgEtc.Protocol = NM_SKILL_CAST_ACTIVE_SYN;
	msgEtc.mSkillIndex = mUniqueIdx;
	msgEtc.mAttacker = mAttacker;
	msgEtc.mAttackerPosX = pAttacker->GetXPos();
	msgEtc.mAttackerPosY = pAttacker->GetYPos();
	msgEtc.mObjectMP = pAttacker->GetMP();
	msgEtc.mObjectMaxMp = pAttacker->GetMaxMP();
	NETWORK2->QuickSend( pAttacker, (char*)&msgEtc, sizeof(msgEtc) );

	return true;
}



bool cPlayerSkillObject::SetCenterPos()
{

	/// skill pc  о
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( mSkillIdx );
	if( pSkillInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cPlayerSkillObject::SetCenterPos pSkillInfo[%d] == NULL", mSkillIdx );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return false;
	}

	///     ġǥ 
	switch( pSkillInfo->mBoundType )
	{
	case eBOUNDTYPE_NONE:			///   ƴ
	case eBOUNDTYPE_TARGET:			/// Ÿ ع
		{
			/// Ÿ üũ  ΰ ʿ 
			if( pSkillInfo->mApplyType != eAPPLYTYPE_SELF )
			{ 
				cBaseObject* pObject = OBJECTMANAGER->GetObject( mCenterTarget.type, mCenterTarget.index );
				/// ߵ  Ÿ   ̽
				if( pObject == NULL || pObject->GetMapNumber() != mMapNumber )	
					return false;

				mCenterPos.x = pObject->GetXPos();
				mCenterPos.y = pObject->GetYPos();
				mCenterPos.z = pObject->Height();

				/// ! TODO mtarget ݰ  üũ
			}
		}break;
	}

	return true;
}


void cPlayerSkillObject::TargetSelect( cBaseObject* pAttacker )
{

	/// skill pc  о
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( mSkillIdx );
	if( pSkillInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cPlayerSkillObject[%d]::TargetSelect pSkillInfo[%d] == NULL", pAttacker->GetObjectID(), mSkillIdx );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return;
	}

	if( mSkillStep > pSkillInfo->mStepCount )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cPlayerSkillObject[%d]::TargetSelect mSkillStep[%d] > pSkillInfo->mStepCount", pAttacker->GetObjectID(), mSkillStep );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return;
	}
	sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[mSkillStep];

	bool applyHP = pSkillInfo->mType == eSKILLTYPE_MPDAMAGE ? false : true;

	/// ߻ü Ÿ    Ÿ   ̽ó 
	if( mNoTargetNoDamage == true )
		return;

	/// Ÿ 
	if( pSkillInfo->mBoundType != eBOUNDTYPE_NONE )
	{
		switch( pSkillInfo->mApplyType )
		{
		case eAPPLYTYPE_SELF:
			{
				sMultiTarget multiTarget;
				multiTarget.mTarget.type = eOBJECTTYPE_PLAYER;
				multiTarget.mTarget.index = pAttacker->GetObjectID();
				multiTarget.mApplyHP = applyHP;
				mTargetAry.PushBack( multiTarget );
			}
			break;
		case eAPPLYTYPE_BUDDY:
			{
				mTargetAry.Clear();

				float tempRange = OBJECTMANAGER->ObjectSizeRange( pAttacker, NULL, pStepInfo->mBoundDist );

				OBJECTMANAGER->PlayerInCenterPoint( mCenterPos, tempRange, &mTargetAry, applyHP );
			}
			break;
		case eAPPLYTYPE_PARTY:
			{
				mTargetAry.Clear();

				/// ڽ  
				sObject targetObject;
				targetObject.index = pAttacker->GetObjectID();
				targetObject.type = eOBJECTTYPE_PLAYER;
				sMultiTarget multiTarget;
				multiTarget.mTarget = targetObject;
				multiTarget.mApplyHP = applyHP;
				mTargetAry.PushBack( multiTarget );


				/// Ƽ ˻
				cParty* pParty = PARTYMAN->GetParty( ((cPlayer*)pAttacker)->GetPartyIndex() );
				if( pParty != NULL )
				{
					cPlayer* partyUser = 0;
					unsigned long* userArr = pParty->GetUserArr();
					unsigned int partyCount = pParty->GetCount();
					NiPoint2 attackerPos = pAttacker->GetPos();
					NiPoint2 partyUserPos = NiPoint2::ZERO;

					for( unsigned int i = 0 ; i < partyCount ; ++i )
					{
						/// Ƽ   ø óϱ ڽ   ־
						if( pAttacker->GetObjectID() == userArr[i] )
							continue;

						/// Ÿ ü Ȯ
						partyUser = OBJECTMANAGER->GetPlayer( userArr[i] );
						if( partyUser == NULL )
							continue;

						partyUserPos = partyUser->GetPos();

						float tempRange = OBJECTMANAGER->ObjectSizeRange( pAttacker, partyUser, pStepInfo->mBoundDist );
						/// Ÿ Ȯ
						mRangeCheck.SetRadius( tempRange );
						if( mRangeCheck.IsRange( attackerPos, partyUserPos ) == true )
						{
							/// Ÿٿ ߰
							targetObject.type = eOBJECTTYPE_PLAYER;
							targetObject.index = userArr[i];

							sMultiTarget multiTarget;
							multiTarget.mTarget = targetObject;
							multiTarget.mApplyHP = applyHP;
							mTargetAry.PushBack( multiTarget );
						}
					}
				}
			}
			break;
		case eAPPLYTYPE_ENEMY:
			{
				mTargetAry.Clear();

				float tempRange = OBJECTMANAGER->ObjectSizeRange( pAttacker, NULL, pStepInfo->mBoundDist );

				if( mDelTarget )
					((cPlayer*)pAttacker)->MonsterInTargeting( &mTargetAry, tempRange );
				else
					OBJECTMANAGER->MonsterInCenterPoint( mCenterPos, tempRange, &mTargetAry, applyHP );

				OBJECTMANAGER->PlayerInCenterPoint( mCenterPos, tempRange, &mTargetAry, 
					pAttacker->GetObjectID(), applyHP );

			}
			break;
		}
	}
	else
	{
		sMultiTarget multiTarget;
		multiTarget.mTarget = mCenterTarget;
		multiTarget.mApplyHP = applyHP;
		mTargetAry.PushBack( multiTarget );
	}
}

void cPlayerSkillObject::ApplyDamage( cBaseObject* pAttacker )
{
	/// skill pc  о
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( mSkillIdx );
	if( pSkillInfo == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cPlayerSkillObject[%d]::ApplyDamage pSkillInfo[%d] == NULL", pAttacker->GetObjectID(), mSkillIdx );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return;
	}

	if( mSkillStep > pSkillInfo->mStepCount )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cPlayerSkillObject[%d]::ApplyDamage mSkillStep[%d] > pSkillInfo->mStepCount", pAttacker->GetObjectID(), mSkillStep );
		SKILLMANAGER->InsertDeleteSkillObject( mAttacker, mUniqueIdx );
		return;
	}
	sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[mSkillStep];

	/// ŸԺ  ó
	switch( pSkillInfo->mType )
	{
	case eSKILLTYPE_DAMAGE:
		{
			SendDamage( pAttacker, pSkillInfo->mShotType, pSkillInfo->mAttributeType, pSkillInfo->mRangeType,
				pStepInfo->mApplyValueType1, pStepInfo->mApplyValueType2, pStepInfo->mApplyValue1, pStepInfo->mApplyValue2,
				pStepInfo->mInfulenceIdx, pStepInfo->mAccuracyValue, pStepInfo->mCriticalValue, true );	
		}
		break;
	case eSKILLTYPE_HEAL:
		{
			SendHeal( pAttacker, pSkillInfo->mShotType, 
				pStepInfo->mApplyValueType1, pStepInfo->mApplyValueType2, pStepInfo->mApplyValue1, pStepInfo->mApplyValue2,
				pStepInfo->mInfulenceIdx );
		}
		break;
	case eSKILLTYPE_NONACTIVE:
		{
			if( mDelTarget )
			{
				SendDelTarget( pAttacker, pStepInfo->mAccuracyValue );
			}
			else
			{
				SendApply( pAttacker, pSkillInfo->mShotType, 
					pStepInfo->mApplyValueType1, pStepInfo->mApplyValueType2, 
					pStepInfo->mApplyValue1, pStepInfo->mApplyValue2, pStepInfo->mInfulenceIdx );

			}
		}
		break;
	case eSKILLTYPE_MPDAMAGE:
		{
			SendDamage( pAttacker, pSkillInfo->mShotType, pSkillInfo->mAttributeType, pSkillInfo->mRangeType,
				pStepInfo->mApplyValueType1, pStepInfo->mApplyValueType2, pStepInfo->mApplyValue1, pStepInfo->mApplyValue2,
				pStepInfo->mInfulenceIdx, pStepInfo->mAccuracyValue, pStepInfo->mCriticalValue, false );	
		}
		break;
	case eSKILLTYPE_TOTEM:
		{
			AddTotem( pAttacker, ((cPlayer*)pAttacker)->GetPartyIndex(), pSkillInfo->mApplyType, pSkillInfo->mAttributeType, pStepInfo->mInfulenceIdx );
		}
		break;
	}
}
