/* ==========================================================================
*      : QuestManager.h
*      : 
*    : 谡
*    : 2008-03-07
* ǻ :
*===========================================================================*/
#pragma once
#include "Lexer.h"
#include "Quest_Common.h"
#include "QuestDefine.h"

const DWORD	QUEST_SAVETIME = 600000;

/// NPC  Ʈ Ʈ
struct sNpcQuestList
{
	tHashSet<unsigned long> mQuestSet;
};

struct sQuestMonster
{
	///  Ʈ ε
	tArray<unsigned long> mMonsterArr;
};

/// ÷̾ ȯ  
struct sQuestMonsterInfo
{
	/// Ʈε, sQuestMonster*
	tPointerHashMap<unsigned long, void*> mQuestMonInfoMap;
};

/// Ʈ Ŵ
class cParser;
class cQuestDefine;
class cTrigger;
class cPlayer;
class cQuestManager
{
public:
	static cQuestManager* mpSingleton;

public:
	cQuestManager();
	~cQuestManager();

	bool Init();
	void Clear();

	/// ȿ ˻
	bool IsValid( cQuestDefine* define );

	/// Ϸ  ˻ ( ÷̾, Ʈ 迭ε )
	bool IsPossibleComplete( unsigned long playerIdx, int arrIdx );

	/// ú ִ  ˻
	unsigned int IsSelectRewardItem( unsigned long questIdx, unsigned long ItemIdx );		///  

	/// ú ִ  ˻
	bool IsSelectRewardBuff( unsigned long questIdx, unsigned long buffIdx );				///  

	/// ش Ʈ  npc ߴ ˻
	bool IsHaveQuest( unsigned long questIdx, unsigned long npcClassIdx );

	///  ȯ 
	bool AddQuestMonster( unsigned long playerIdx, unsigned long questIdx, unsigned long monsterIdx );
	void DeleteQuestMonster( unsigned long playerIdx, unsigned long questIdx );
	void DeleteAllQuestMonster( unsigned long playerIdx );

	cQuestDefine* GetQuestDefine( unsigned long questIdx );
	cQuestReward* GetDefaultReward( unsigned long questIdx );
	int IsDuty( unsigned long questIdx, eDutyType type, unsigned long targetIdx );

	///
	tPointerHashMap<unsigned long, void*>* GetQuestDefineMap() { return &mQuestDefine; }
	sNpcQuestList* GetNpcQuestMap( unsigned long npcClassIdx );

public:
	static cQuestManager* GetSingleton();
	
protected:
	bool Load( const cString& pathname );
	bool LoadNpcQuest( const cString& pathname );
	bool LoadQuests( const cString& pathname );
	bool LoadQuestData( cParser& parser, cQuestDefine* p, cTrigger* trigger );

	/// 
	bool LoadTrigger( cParser& parser, cTrigger* trigger );
	bool LoadDuty( cParser& parser, cQuestDuty* duty, __int64& complete );
	bool LoadLimit( cParser& parser, cQuestLimit* limit );
	bool LoadEnd( cParser& parser, cQuestEnd* end );
	bool LoadDefault( cParser& parser, cQuestReward* reward );
	bool LoadSelect( cParser& parser, cQuestReward* select );
	bool LoadFail( cParser& parser, cQuestFail* fail );

private:
	/// Ʈ ũƮ  
	typedef tPointerHashMap<unsigned long, void*> cQuestDefineMap;
	cQuestDefineMap mQuestDefine;

	/// NPC  üƮ   ( npc ε, sNpcQuestList ) 
	typedef tPointerHashMap<unsigned long, void*> cNpcQuestMap;
	cNpcQuestMap mNpcQuestMap;

	/// PLYAER   ȯ  ( player ε, sQuestMonsterInfo )
	typedef tPointerHashMap<unsigned long, void*> cQuestMonsterMap;
	cQuestMonsterMap	mQuestMonsterMap;
};

inline cQuestManager* cQuestManager::GetSingleton()
{
	return mpSingleton;
}

#define QUESTMAN cQuestManager::GetSingleton()


//////////////////////////////////////////////////////////////////
// Ʈ ũƮ ū
enum
{
	/// Ʈ 
	eTOKEN_QUEST = 100,
	eTOKEN_TITLE,
	eTOKEN_TYPE,
	eTOKEN_DESC,
	eTOKEN_REPEAT,
	eTOKEN_GROUP,

	eTOKEN_GIVENPC,
	eTOKEN_TAKENPC,
	eTOKEN_TAKEMAP,
	eTOKEN_GIVEITEM,
	eTOKEN_TAKEITEM,
	eTOKEN_SELECTCOUNT,
	eTOKEN_LEVEL,
	
	eTOKEN_NORMALTYPE,
	eTOKEN_SCENARIOTYPE,
	eTOKEN_RACETYPE,
	eTOKEN_CHANGEJOBTYPE,

	eTOKEN_CHALLEANGE,
	eTOKEN_REPETITION,

	eTOKEN_ALL,
	eTOKEN_ORDER,

	eTOKEN_DUTY,
	eTOKEN_LIMIT,
	eTOKEN_END,
	eTOKEN_DEFAULT,
	eTOKEN_SELECT,
	eTOKEN_FAIL,

	eTOKEN_TALKNPC,
	eTOKEN_HUNT,
	eTOKEN_COLLECT,

	eTOKEN_BUFF,
	eTOKEN_DEBUFF,
	eTOKEN_EQUIPITEM,
	eTOKEN_TIMETYPE,
	eTOKEN_TIME,
	eTOKEN_MAPCHANGEPOS,
	eTOKEN_MONSTER,
	eTOKEN_MONSTERTIME,

	eTOKEN_CHANGEJOB,
	eTOKEN_FORCETYPE,
	eTOKEN_GIVETITLE,

	eTOKEN_EXP,
	eTOKEN_SXP,
	eTOKEN_MONEY,
	eTOKEN_SKILLPOINT,
	eTOKEN_ITEM,

	/// Ʈ ̺Ʈ 
	eTOKEN_TRIGGER,
	eTOKEN_TE_LEVEL,
	eTOKEN_TE_RACE,
	eTOKEN_TE_JOB,
	eTOKEN_TE_HAVEITEM,
	eTOKEN_TE_LINKQUEST,
	eTOKEN_TE_SKILL,

	eTOKEN_HUMAN,
	eTOKEN_ELF,
	eTOKEN_BEAST,

	eTOKEN_TRUE,
	eTOKEN_FALSE,

	/// NPC Ʈ Ʈ ũƮ
	eTOKEN_NPC,
};

/// Ʈ ũƮ  м
class cQuestLexer : public cLexer
{
public:
	cQuestLexer( const char* buffer, unsigned int size );
};