#include "gamesrv.h"

#include "stdafx.h"

#include "SkillManager.h"
#include "ObjectManager.h"

#include "BasicString.h"

#include "Skill_Common.h"
#include "Npc_Common.h"
#include "GameFile.h"
#include "BaseObject.h"
#include "Protocol.h"
#include "Player.h"
#include "Monster.h"
#include "Totem.h"
#include "StatusCalc_Server.h"
#include "SkillScript.h"
#include "CommunityScript.h"
#include "MakeSkillScript.h"
#include "RangeCheck.h"
#include "AppTimer.h"
#include "InfluenceObject.h"
#include "DuelManager.h"
#include "StatusCalc_Server.h"


cSkillManager* cSkillManager::mpSkillManager = NULL;


cSkillManager::cSkillManager()
{
	if(mpSkillManager)
	{
		MessageBox(NULL,"cSkillManager :  Ŭ ü Ѱü(singleton)̾ մϴ.\
			 ü ϴ  ü  Ͻʽÿ.","",MB_OK);
	}
	else
	{
		mpSkillManager = this;
	}
}



cSkillManager::~cSkillManager()
{
	ReleasePlayerHaveSkill();
	ReleaseInfluence();
	Release();
}



bool cSkillManager::Init()
{
	mPlayerSkillObjectPool.Reserve(1000,100);
	mMonsterSkillObjectPool.Reserve(2000,100);
	mPlayerMonSkillObjectPool.Reserve(1000,100);
	mInfluenceObjectPool.Reserve(5000,100);
	mPlayerHaveSkillPool.Reserve(40000,100);

	mpSkillScript = new cSkillScript;
	if( !mpSkillScript->Init() )
	{
		return false;
	}

	mpCommuScript = new cCommunityScript;
	if( !mpCommuScript->Init() )
	{
		return false;
	}

	if( !mDramaturgyManager.Init() )
	{
		return false;
	}

	mpMakeSkillScript = new cMakeSkillScript;
	if( !mpMakeSkillScript->Init() )
	{
		return false;
	}

	return true;
}



void cSkillManager::Release()
{
	SAFE_DELETE( mpMakeSkillScript );
	SAFE_DELETE( mpCommuScript );
	SAFE_RELEASE_DELETE( mpSkillScript );	

	cPointerHashMap::cIterator iter;

	cBaseSkillObject* pPlayerSkillObj = NULL;
	cMonsterSkillObject* pMonsterSkillObj = NULL;

	cArray* pSkillArray = NULL;
	for(iter = mPlayerSkillMap.Begin(); iter != mPlayerSkillMap.End(); ++iter)
	{
		pSkillArray = (cArray*)(*iter).mSecond;

		if( pSkillArray == NULL )
			continue;

		for( unsigned int i = 0 ; pSkillArray->GetSize() > i ; ++i )
		{
			pPlayerSkillObj = (cBaseSkillObject*)(*pSkillArray)[i];
			SAFE_DELETE( pPlayerSkillObj );
		}
		pSkillArray->Clear();

		SAFE_DELETE( pSkillArray );
	}
	mPlayerSkillMap.Clear();

	for(iter = mMonsterSkillMap.Begin(); iter != mMonsterSkillMap.End(); ++iter)
	{
		pSkillArray = (cArray*)(*iter).mSecond;

		if( pSkillArray == NULL )
			continue;

		for( unsigned int i = 0 ; pSkillArray->GetSize() > i ; ++i )
		{
			pMonsterSkillObj = (cMonsterSkillObject*)(*pSkillArray)[i];
			SAFE_DELETE( pMonsterSkillObj );
		}
		pSkillArray->Clear();

		SAFE_DELETE( pSkillArray );
	}
	mMonsterSkillMap.Clear();
}


void cSkillManager::Process( unsigned long elapsedTime, unsigned long accumTime )
{
	cBaseSkillObject*    pPlayerSkillObj  = NULL;
	cMonsterSkillObject* pMonsterSkillObj = NULL;
	cInfluenceObject*    pInfluenceObject = NULL;

	cPointerHashMap::cIterator begin;
	cPointerHashMap::cIterator end;

try {

	/// ÷̾ Ƽ ų μ
	end = mPlayerSkillMap.End();
	for( begin = mPlayerSkillMap.Begin() ; begin != end; ++begin )
	{
		cArray* pSkillArray = (cArray*)(*begin).mSecond;

		if( pSkillArray != NULL )
		{
			unsigned int arraySize = pSkillArray->GetSize();
			for( unsigned int i = arraySize ; i > 0 ; --i )
			{
				pPlayerSkillObj = (cBaseSkillObject*)(*pSkillArray)[i-1];
				if( pPlayerSkillObj != NULL )
					pPlayerSkillObj->Process( elapsedTime, accumTime );
				else
				{				
					NETWORK2->PostServerEvent( "cSkillManager::Process() pPlayerSkillObj == NULL" );
					pSkillArray->PopAt( i-1 );
				}
			}
		}
		else if ( end != mPlayerSkillMap.End( ) )
		{
			NETWORK2->PostServerEvent( "In if ( end != mPlayerSkillMap.End( ) ) { ... }. Throwing 'cSkillManager::Process' exception." );
		}
		else
			assert(NULL);
	}

} catch ( ... ) {
	NETWORK2->PostServerEvent( "In for( mPlayerSkillMap ) { (0x%x)->Process( %u, %u ); }. Throwing 'cSkillManager::Process' exception.", pPlayerSkillObj, elapsedTime, accumTime );
	throw;
}

try {

	///  Ƽ ų μ
	end = mMonsterSkillMap.End();
	for( begin = mMonsterSkillMap.Begin() ; begin != end; ++begin )
	{
		cArray* pSkillArray = (cArray*)(*begin).mSecond;
		if( pSkillArray != NULL )
		{
			unsigned int arraySize = pSkillArray->GetSize( );
			for( unsigned int i = arraySize ; i > 0 ; --i )
			{
				pMonsterSkillObj = (cMonsterSkillObject*)(*pSkillArray)[i-1];
				if( pMonsterSkillObj != NULL )
					pMonsterSkillObj->Process( elapsedTime, accumTime );
				else
				{
					NETWORK2->PostServerEvent("cSkillManager::Process() pMonsterSkillObj == NULL");
					pSkillArray->PopAt( i-1 );
				}
			}
		}
		else if ( end != mMonsterSkillMap.End( ) )
		{
			NETWORK2->PostServerEvent( "In if ( end != mMonsterSkillMap.End( ) ) { ... }. Throwing 'cSkillManager::Process' exception." );
		}
		else
			assert(NULL);
	}

} catch ( ... ) {
	NETWORK2->PostServerEvent( "In for( mMonsterSkillMap ) { (0x%x)->Process( %u, %u ) }. Throwing 'cSkillManager::Process' exception.", pMonsterSkillObj, elapsedTime, accumTime );
	throw;
}


try {

	/// ȿ Ʈ μ
	end = mInfluenceMap.End();
	for( begin = mInfluenceMap.Begin() ; begin != end; ++begin )
	{
		pInfluenceObject = (cInfluenceObject*)((*begin).mSecond);
		if( pInfluenceObject != NULL )
		{
			if( pInfluenceObject->Process( elapsedTime, accumTime ) == false )
                mDeleteInfluenceAry.PushBack( pInfluenceObject->GetUniqueIdx() );
		}
		else if ( end != mInfluenceMap.End( ) )
			NETWORK2->PostServerEvent( "In if ( end != mInfluenceMap.End( ) ) { ... }. Throwing 'cSkillManager::Process' exception." );
		else
			assert(NULL);
	}

	for( unsigned long i = 0 ; mAura.GetSize() > i ; ++i )
	{
		AddInfChildAura( mAura[i].attacker, mAura[i].target, mAura[i].influenceClassIdx, 0, mAura[i].parentUniqueIdx, true );
	}
	mAura.Clear();

} catch ( ... ) {
	NETWORK2->PostServerEvent( "In for( mInfluenceMap ) { (0x%x)->Process( %u, %u ) }. Throwing 'cSkillManager::Process' exception.", pInfluenceObject, elapsedTime, accumTime );
	throw;
}

try {

	/// ÷̾,  Ƽ ų 
	unsigned int DelSkillArySize = mDeleteSkillAry.GetSize( );

	sDelSkillInfo* info;
	for( unsigned int i = 0 ; i < DelSkillArySize ; ++i )
	{
		info = &mDeleteSkillAry[i];
		if( info != NULL )
		{
			if( DeleteSkillObject( info->skillUser.type, info->skillUser.index, info->mSkillIdx ) == false )
				NETWORK2->PostServerEvent( "cSkillManager::Process DeleteSkillObject[%d,%d,%d]", info->skillUser.type, info->skillUser.index, info->mSkillIdx );
		}                		
	}
	mDeleteSkillAry.Clear();

} catch ( ... ) {
	NETWORK2->PostServerEvent( "In for( mDeleteSkillAry ) { ... }. Throwing 'cSkillManager::Process' exception." );
	throw;
}

try {

	/// ȿ   ó
	unsigned int mDelSize = mDeleteInfluenceAry.GetSize( );
	for( unsigned int i = 0; i < mDelSize; ++i )
	{
		unsigned long uniqueIdx = mDeleteInfluenceAry[i];
		cInfluenceObject* pInf = GetInfluence( uniqueIdx );
		if( pInf != NULL )
			DeleteInfluence( pInf->GetTarget(), uniqueIdx );
	}
	mDeleteInfluenceAry.Clear();

} catch ( ... ) {
	NETWORK2->PostServerEvent( "In for( mDeleteInfluenceAry ) { ... }. Throwing 'cSkillManager::Process' exception." );
	throw;
}

}



bool cSkillManager::IsUsingSkill( unsigned char type, unsigned long objectIdx ) 
{
	switch( type )
	{
	case eOBJECTTYPE_MONSTER:
		{
			cArray* pSkillArray = (cArray*)mMonsterSkillMap.GetAt( objectIdx );
			if( pSkillArray == NULL )
			{
				return false;
			}

			cMonsterSkillObject* pSkillObject = NULL;
			for( unsigned int i = 0 ; i < pSkillArray->GetSize() ; ++i )
			{
				pSkillObject = (cMonsterSkillObject*)(*pSkillArray)[i];
				if( pSkillObject == NULL )
					continue;

				///    ̸ܰ ų  
				if( pSkillObject->GetSkillState() < eSKILLPROCESS_PROJECTILE )
					return true;
			}
		}
		break;
	case eOBJECTTYPE_HERO:
	case eOBJECTTYPE_PLAYER:
		{
			cArray* pSkillArray = (cArray*)mPlayerSkillMap.GetAt( objectIdx );
			if( pSkillArray == NULL )
			{
				return false;
			}

			cBaseSkillObject* pSkillObject = NULL;
			for( unsigned int i = 0 ; i < pSkillArray->GetSize() ; ++i )
			{
				pSkillObject = (cBaseSkillObject*)(*pSkillArray)[i];
				if( pSkillObject == NULL )
					continue;

				if( pSkillObject->IsProjectile() == false )
				{
					///    ̸ܰ ų  
					if( pSkillObject->GetSkillState() < eSKILLPROCESS_HP || pSkillObject->IsDetailEnd() == false )
						return true;
				}
				else
				{
					///    ̸ܰ ų  
					if( pSkillObject->GetSkillState() < eSKILLPROCESS_PROJECTILE )
						return true;
				}
			}
		}
		break;		
	default:
		assert(NULL);
		NETWORK2->PostServerEvent("IsUsingSkill type error[%d]", type );
		return false;
	}

	return false;
}


unsigned long cSkillManager::SkillLeftEndTime( unsigned char type, unsigned long objectIdx ) 
{
	switch( type )
	{
	case eOBJECTTYPE_MONSTER:
		{
			cArray* pSkillArray = (cArray*)mMonsterSkillMap.GetAt( objectIdx );
			if( pSkillArray == NULL )
			{
				return 0;
			}

			cMonsterSkillObject* pSkillObject = NULL;
			for( unsigned int i = 0 ; i < pSkillArray->GetSize() ; ++i )
			{
				pSkillObject = (cMonsterSkillObject*)(*pSkillArray)[i];
				if( pSkillObject == NULL )
					continue;

				///    ̸ܰ ų  
				if( pSkillObject->GetSkillState() < eSKILLPROCESS_PROJECTILE )
					return pSkillObject->SkillEndTime();
			}
		}
		break;
	case eOBJECTTYPE_HERO:
	case eOBJECTTYPE_PLAYER:
		{
			cArray* pSkillArray = (cArray*)mPlayerSkillMap.GetAt( objectIdx );
			if( pSkillArray == NULL )
			{
				return 0;
			}

			cBaseSkillObject* pSkillObject = NULL;
			for( unsigned int i = 0 ; i < pSkillArray->GetSize() ; ++i )
			{
				pSkillObject = (cBaseSkillObject*)(*pSkillArray)[i];
				if( pSkillObject == NULL )
					continue;

				if( pSkillObject->IsProjectile() == false )
				{
					///    ̸ܰ ų  
					if( pSkillObject->GetSkillState() < eSKILLPROCESS_HP || pSkillObject->IsDetailEnd() == false )
						return pSkillObject->SkillEndTime();
				}
				else
				{
					///    ̸ܰ ų  
					if( pSkillObject->GetSkillState() < eSKILLPROCESS_PROJECTILE )
						return pSkillObject->SkillEndTime();
				}
			}
		}
		break;		
	default:
		assert(NULL);
		NETWORK2->PostServerEvent("IsUsingSkill type error[%d]", type );
		return 0;
	}

	return 0;
}


void cSkillManager::CastSkillCancel( sObject attacker )
{
	cPlayer* pAttacker = OBJECTMANAGER->GetPlayer(attacker.index);
	if( pAttacker == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("CastSkillCancel - attacker.index[%d]", attacker.index );
		return;
	}

	unsigned long skillIndex = 0;

	cArray* pSkillArray = (cArray*)mPlayerSkillMap.GetAt( attacker.index );
	if( pSkillArray != NULL )
	{
		cBaseSkillObject* pSkillObject = NULL;
		for( unsigned int i = 0 ; i < pSkillArray->GetSize() ; ++i )
		{
			pSkillObject = (cBaseSkillObject*)(*pSkillArray)[i];
			if( pSkillObject == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("CastSkillCancel - mPlayerSkillMap.GetAt( %d )", attacker.index );
				continue;
			}

			/// Ϸ ų ü ĳ ƴϸ ĳ  ޼  ʴ´.
			if( pSkillObject->GetSkillState() != eSKILLPROCESS_CASTING )
			{
				Verbose->WriteLog("State() != eSKILLPROCESS_CASTING");
				return;
			}
			else
			{
				skillIndex = pSkillObject->GetUniqueIdx();
				/// ĳ ó
				DeleteSkillObject( attacker.type, attacker.index, skillIndex );
				if( pAttacker->ChangeState( eOBJECT_STATE_IDLE ) == false )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cSkillManager::CastSkillCancel pAttacker[%d,%d,%d,%d]->ChangeState( eOBJECT_STATE_IDLE ) == false",
						attacker.index, pAttacker->GetState(), pAttacker->GetStateStop(), pAttacker->GetRequestRejection() );
				}

				break;
			}
		}
	}
	else
	{
		/// ̹ ų ü ⶧ ĳ  ޼ 
		NETWORK2->PostServerEvent("CastSkillCancel - none skillobject");
		assert(NULL);
	}

	/// ĳ   ޼  ÿ ߼۵ȴ.
	HANDLE                     handle  = NULL;
	MSG_RES_SKILL_CAST_CANCEL* pResMsg = (MSG_RES_SKILL_CAST_CANCEL*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

	if ( pResMsg != NULL )
	{
		pResMsg->Category = NM_SKILL;
		pResMsg->Protocol = NM_SKILL_CAST_CANCEL_RES;
		pResMsg->mSkillIndex = skillIndex;
		NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_CAST_CANCEL) );
	}

	MSG_SYN_SKILL_CAST_CANCEL pSynMsg;
	pSynMsg.Category = NM_SKILL;
	pSynMsg.Protocol = NM_SKILL_CAST_CANCEL_SYN;
	pSynMsg.mSkillIndex = skillIndex;
	NETWORK2->QuickSendExcept( pAttacker, (char*)&pSynMsg, sizeof(pSynMsg) );
}


void cSkillManager::PlayerNormalAttackRequest( unsigned long characterIdx, MSG_REQ_SKILL_USED* pMsg )
{

	/// Լ    Ÿ ÷̾ ̴.
	sObject attacker = { eOBJECTTYPE_PLAYER, characterIdx };

	sObject target = pMsg->mTarget;
	unsigned long skillIdx = pMsg->mSkillClassIndex;
	unsigned long clientIdx = pMsg->mManagedKey;

	///  hero 
	if( target.type == eOBJECTTYPE_HERO )
		target.type = eOBJECTTYPE_PLAYER;

	///  ü üũ
	cPlayer* pAttacker = (cPlayer*)OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL )	
	{ 
		NETWORK2->PostServerEvent("PlayerNormalAttackRequest - GetObject( %d, %d )", attacker.type, attacker.index );
		assert(NULL);
		return; 
	}

	pAttacker->MoveStop();

	try
	{
		/// ⺻  ų ε ƴ
		if( skillIdx > NORMAL_ATTACK_SKILL_MAX )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerNormalAttackRequest - skillIdx[%d] > NORMAL_ATTACK_SKILL_MAX", skillIdx );
			throw SKILL_USED_ERR_SKILLTYPE;
		}


		/// Ÿ ü üũ
		cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
		if( pTarget == NULL )	
			throw SKILL_USED_ERR_TARGETOBJECT;


		if( pTarget->GetStateDie() == true )	
			throw SKILL_USED_ERR_TARGETOBJECT;


		if( pAttacker->GetChgMonsterIdx() != 0 )
			throw SKILL_USED_ERR_CHG_MONSTER;


		/// ڿ Ÿ Ѵ
		pAttacker->SetTarget( target.type, target.index );


		/// ÷̾  ϱ ݸ޼    
		mRangeCheck.SetRadius( SYNC_MOVE_RANGE );
		NiPoint2 clientPos( pMsg->mClientPosX, pMsg->mClientPosY );
		NiPoint2 serverPos = pAttacker->GetPos();

		if( mRangeCheck.IsRange( serverPos, clientPos ) == false )
		{
			/// ̵ ̴  
			pAttacker->SetMoveTargetPos( serverPos.x, serverPos.y );

			Verbose->WriteLog("sPos[%.2f,%.2f],cPos[%.2f,%.2f] = [%.2f]", serverPos.x, serverPos.y, clientPos.x, clientPos.y, (serverPos - clientPos).Length() );

			HANDLE             handle = NULL;
			MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

			if ( posMsg != NULL )
			{
				posMsg->Category      = NM_SKILL;
				posMsg->Protocol      = NM_SKILL_USED_POS_ERROR_RES;
				posMsg->mAttacker     = attacker;
				posMsg->mAttackerPosX = pAttacker->GetXPos( );
				posMsg->mAttackerPosY = pAttacker->GetYPos( );
				posMsg->mTarget       = target;
				posMsg->mTargetPosX   = pTarget->GetXPos( );
				posMsg->mTargetPosY   = pTarget->GetYPos( );

				NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
			}

			throw SKILL_USED_ERR_ATTAKCERPOS;
		}


		/// ̹ ų  üũ
		if( IsUsingSkill( pAttacker->GetObjectType(), pAttacker->GetObjectID() ) == true )	
			throw SKILL_USED_ERR_USING;


		/// ųindex üũ
		sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
		if( pSkillInfo == NULL )	
		{ 
			/// ų ũƮ  ȹ 
			assert(NULL); 
			NETWORK2->PostServerEvent("playerNormalAttackRequest skillScript[%d]", skillIdx );
			throw SKILL_ADD_ERR_SCRIPT;
		}


		/// Ƽ ų ƴ 
		if( pSkillInfo->mType == eSKILLTYPE_PASSIVE )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("playerNormalAttackRequest eSKILLTYPE_PASSIVE[%d,%d]", skillIdx, pSkillInfo->mType );
			throw SKILL_USED_ERR_PASSIVE;
		}


		/// ⺻ ݵ Ÿ üũ ؾ ϱ  ų Ʈ ǥȣ(1) ִ´.
		cHaveSkillObject* pPlayerHaveSkill = GetPlayerHaveSkill( attacker.index, NORMAL_ATTACK_SKILL );
		if( !pPlayerHaveSkill )	
		{ 
			assert(NULL);
			NETWORK2->PostServerEvent("playerNormalAttackRequest GetPlayerHaveSkill[%d,%d]", attacker.index, NORMAL_ATTACK_SKILL );
			throw SKILL_USED_ERR_DONTHAVE;
		}


		/// ų ũƮ  о
		unsigned int stepIdx = pPlayerHaveSkill->GetSkillStep();
		sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[stepIdx];

		///   ´ üũ
		eWEAPON_STATE weaponState = pAttacker->GetWeaponState();
		bool IsEquipment = true;
		if( pSkillInfo->mUseEquipment )
		{
			///   üũ
			switch( pSkillInfo->mUseEquipment )
			{
			case eEQUIPTYPE_SWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment = false;
				break;
			case eEQUIPTYPE_LONGSWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD:
				if( weaponState != eWEAPON_STATE_SHORTSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_GUN:
				if( weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_STAFF:
				if( weaponState != eWEAPON_STATE_STAFF )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHIELD:
				if( weaponState != eWEAPON_STATE_SHEILD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD_GUN:
				if( weaponState != eWEAPON_STATE_SHORTSWORD &&
					weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_CLOTH:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_ROBES )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LIGHTARMOR:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_LIGHT_ARMOR )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_HEAVYARMOR:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_HEAVY_ARMOR )
					IsEquipment =  false;
				break;
			}
		}

		if( IsEquipment == false )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("player[%d]NormalAttack[%d]Request IsEquipment[%d,%d]== false", 
				attacker.index, weaponState,pAttacker->GetArmorSets(), skillIdx );
			throw SKILL_USED_ERR_EQUIPMENT;
		}

		/// Ÿ  üũ
		if( target.type != eOBJECTTYPE_MONSTER )
		{
			if( DUELMANAGER->IsAttack( pAttacker->GetDuelIdx(), attacker.index, target.index ) == false )
				throw SKILL_USED_ERR_TARGETSELECT;
		}

		/// ų++ȿ Ÿ
		float range = pAttacker->CalcStatusSkillRange( pStepInfo->mTargetDist, pSkillInfo->mRangeType, true );

		range = OBJECTMANAGER->ObjectSizeRange( pAttacker, pTarget, range );

		/// ݿ  ݼӵ ( ,   )
		float normalAttackSpeed = pAttacker->GetStatus2()->mAttackSpeed;

		if( normalAttackSpeed <= 0.0f )
			normalAttackSpeed = 0.1f;

        if( normalAttackSpeed > 2.0f )
			normalAttackSpeed = 2.0f;

		/// Ŭ,  ð ̸ŭ Ÿ ġ
		cRangeCheck skillRangeCheck( range + SYNC_MOVE_RANGE );

		NiPoint3 attackerPos( pAttacker->GetXPos(), pAttacker->GetYPos(), pAttacker->Height() );
		NiPoint3 targetPos( pTarget->GetXPos(), pTarget->GetYPos(), pTarget->Height() );

		/// ų Ÿ ۿ Ÿ ִ.
		if( !skillRangeCheck.IsRange( attackerPos, targetPos ) )	
		{ 
			Verbose->WriteLog("aPos[%.2f,%.2f,%.2f],tPos[%.2f,%.2f,%.2f] = [%.2f]", attackerPos.x, attackerPos.y, attackerPos.z,
				targetPos.x, targetPos.y, targetPos.z, (attackerPos - targetPos).Length() );

			HANDLE             handle  = NULL;
			MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

			if ( posMsg != NULL )
			{
				posMsg->Category      = NM_SKILL;
				posMsg->Protocol      = NM_SKILL_USED_POS_ERROR_RES;
				posMsg->mAttacker     = attacker;
				posMsg->mAttackerPosX = pAttacker->GetXPos( );
				posMsg->mAttackerPosY = pAttacker->GetYPos( );
				posMsg->mTarget       = target;
				posMsg->mTargetPosX   = pTarget->GetXPos( );
				posMsg->mTargetPosY   = pTarget->GetYPos( );

				NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
			}

			throw SKILL_USED_ERR_TARGETDIST;
		}


		unsigned long currentTime = NETWORK2->GetAccumTime();

		/// Ÿ
		if( pStepInfo->mCoolTime != 0 && pPlayerHaveSkill->GetEndCoolTime() > currentTime )	
		{ 
			NETWORK2->PostServerEvent( "ų:%d   [%d - %d = %d]", skillIdx, pPlayerHaveSkill->GetEndCoolTime(), currentTime, pPlayerHaveSkill->GetEndCoolTime() - currentTime );
			Verbose->WriteLog( "ų:%d   [%d - %d = %d]", skillIdx, pPlayerHaveSkill->GetEndCoolTime(), currentTime, pPlayerHaveSkill->GetEndCoolTime() - currentTime );

			throw SKILL_USED_ERR_COOLTIME;
		}

		/// Ű 
		unsigned long skillUniqueIdx = mSkillGen.GeneratIdx();
		if( skillUniqueIdx == 0 )	
		{ 
			assert(NULL);
			NETWORK2->PostServerEvent( "playerNormalAttackRequest GeneratIdx[%d]", skillUniqueIdx );
			throw SKILL_USED_ERR_UNIQUEIDX;
		}

		/// ų ü 
		cPlayerSkillObject* pSkillObject = new cPlayerSkillObject;
		if( pSkillObject->InitPlayerNormalAttack( characterIdx, target, skillIdx, skillUniqueIdx, 
			normalAttackSpeed, pAttacker->GetMapNumber() ) != 0 )
		{ 
			NETWORK2->PostServerEvent( "playerNormalAttackRequest new SkillObject == false" );
			SAFE_DELETE( pSkillObject );
			throw SKILL_USED_ERR_OBJECTINIT;
		}

		/// ÷̾  üũѴ.
		if( pAttacker->ChangeState( eOBJECT_STATE_ATTACK ) == false )
		{
			SAFE_DELETE( pSkillObject );
			///  °  Ұ 
			throw SKILL_USED_ERR_ATTACKERSTATE;
		}

		/// ų Ʈ 
		InsertPlayerSkillMap( characterIdx, pSkillObject );

		/// ų   ޼ ش ο 
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL, NM_SKILL_USED_RES );

		if ( resMsg != NULL )
		{
			resMsg->ErrorCode        = 0;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;
			resMsg->mSkillIndex      = skillUniqueIdx;
			resMsg->mObjectMP        = pAttacker->GetMP();
			resMsg->mMaxMP           = pAttacker->GetMaxMP();

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}

		/// ų  ޼ ٸ Ŭ̾Ʈ 
		MSG_SYN_SKILL_USED synMsg;
		synMsg.Category = NM_SKILL;
		synMsg.Protocol = NM_SKILL_USED_SYN;
		synMsg.mSkillClassIndex = skillIdx;
		synMsg.mSkillIndex = skillUniqueIdx;
		synMsg.mAttacker = attacker;
		synMsg.mAttackerPosX = pAttacker->GetXPos();
		synMsg.mAttackerPosY = pAttacker->GetYPos();
		synMsg.mTarget = target;
		synMsg.mTargetPosX = pTarget->GetXPos();
		synMsg.mTargetPosY = pTarget->GetYPos();
		synMsg.mObjectMP = pAttacker->GetMP();
		synMsg.mObjectMaxMP = pAttacker->GetMaxMP();
		NETWORK2->QuickSendExcept( pAttacker, (char*)&synMsg, sizeof(synMsg) );

		return;

	}
	catch ( int error )
	{
		/// ų  ޼
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL, NM_SKILL_USED_RES );

		if ( resMsg != NULL )
		{
			resMsg->ErrorCode        = error;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}
	}
}


void cSkillManager::PlayerObjectSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_USED* pMsg, bool casting )
{

	/// Լ    Ÿ ÷̾ ̴.
	sObject attacker = { eOBJECTTYPE_PLAYER, characterIdx };

	sObject target = pMsg->mTarget;
	unsigned long skillIdx = pMsg->mSkillClassIndex;
	unsigned long clientIdx = pMsg->mManagedKey;

	///  hero 
	if( target.type == eOBJECTTYPE_HERO )
		target.type = eOBJECTTYPE_PLAYER;


	///  ü üũ
	cPlayer* pAttacker = (cPlayer*)OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL )	
	{ 
		NETWORK2->PostServerEvent("PlayerObjectSkillRequest - GetObject( %d, %d )", attacker.type, attacker.index );
		assert(NULL);
		return; 
	}

	pAttacker->MoveStop();

	try
	{
		/// ⺻  ų εΰ 
		if( skillIdx <= NORMAL_ATTACK_SKILL_MAX )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerObjectSkillRequest - skillIdx[%d] > NORMAL_ATTACK_SKILL_MAX", skillIdx );
			throw SKILL_USED_ERR_SKILLTYPE;
		}


		/// ų  Ұ
		if( pAttacker->IsCantSkill() == true )
			throw SKILL_USED_ERR_USEVALUE;


		if( pAttacker->GetChgMonsterIdx() != 0 )
			throw SKILL_USED_ERR_CHG_MONSTER;


		/// ų  üũ
		if( IsUsingSkill( pAttacker->GetObjectType(), pAttacker->GetObjectID() ) == true )	
			throw SKILL_USED_ERR_USING;


		/// ųindex üũ
		sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
		if( pSkillInfo == NULL )	
		{ 
			/// ų ũƮ  ȹ 
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerObjectSkillRequest skillScript[%d]", skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}


		if( pSkillInfo->mShotType == eSHOTTYPE_CASTING && casting != true )
		{
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerObjectSkillRequest[%d] ShotType != eSHOTTYPE_CASTING[%d]", characterIdx, skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}


		if( pSkillInfo->mShotType != eSHOTTYPE_CASTING && casting == true )
		{
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerObjectSkillRequest[%d] ShotType == eSHOTTYPE_CASTING[%d]", characterIdx, skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}


		/// Ƽ ų ƴ 
		if( pSkillInfo->mType == eSKILLTYPE_PASSIVE )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerObjectSkillRequest eSKILLTYPE_PASSIVE[%d,%d]", skillIdx, pSkillInfo->mType );
			throw SKILL_USED_ERR_PASSIVE;
		}


		///  ų üũ
		cHaveSkillObject* pPlayerHaveSkill = GetPlayerHaveSkill( attacker.index, skillIdx );
		if( !pPlayerHaveSkill )	
		{ 
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerObjectSkillRequest GetPlayerHaveSkill[%d,%d]", attacker.index, NORMAL_ATTACK_SKILL );
			throw SKILL_USED_ERR_DONTHAVE;
		}


		/// ų ũƮ  о
		unsigned char stepIdx = pPlayerHaveSkill->GetSkillStep();
		sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[stepIdx];

		///   ´ üũ
		bool IsEquipment = true;
		if( pSkillInfo->mUseEquipment )
		{
			eWEAPON_STATE weaponState = pAttacker->GetWeaponState();

			///   üũ
			switch( pSkillInfo->mUseEquipment )
			{
			case eEQUIPTYPE_SWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment = false;
				break;
			case eEQUIPTYPE_LONGSWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD:
				if( weaponState != eWEAPON_STATE_SHORTSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_GUN:
				if( weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_STAFF:
				if( weaponState != eWEAPON_STATE_STAFF )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHIELD:
				if( weaponState != eWEAPON_STATE_SHEILD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD_GUN:
				if( weaponState != eWEAPON_STATE_SHORTSWORD &&
					weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_CLOTH:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_ROBES )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LIGHTARMOR:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_LIGHT_ARMOR )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_HEAVYARMOR:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_HEAVY_ARMOR )
					IsEquipment =  false;
				break;
			}
		}

		if( IsEquipment == false )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerObjectSkillRequest IsEquipment == false" );
			throw SKILL_USED_ERR_EQUIPMENT;
		}

		/// ĳ 
		if( pSkillInfo->mUseState != 0 ) // 
		{
			switch( pSkillInfo->mUseState )
			{
			case 1:	// HPUP
				if( pStepInfo->mUseStateValue > ( pAttacker->GetHP() * PERCENT_HUNDRED / pAttacker->GetMaxHP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			case 2: // HPDONW:	
				if( pStepInfo->mUseStateValue < ( pAttacker->GetHP() * PERCENT_HUNDRED / pAttacker->GetMaxHP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			case 3: // MPUP:		
				if( pStepInfo->mUseStateValue > ( pAttacker->GetMP() * PERCENT_HUNDRED / pAttacker->GetMaxMP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			case 4: // MPDOWN:	
				if( pStepInfo->mUseStateValue < ( pAttacker->GetMP() * PERCENT_HUNDRED / pAttacker->GetMaxMP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			default:
				assert(NULL);
				NETWORK2->PostServerEvent("PlayerObjectSkillRequest pSkillInfo->mUseState[%d]", pSkillInfo->mUseState );
				throw SKILL_USED_ERR_SCRIPT;
			}
		}


		/// Ҹ MP ġ üũ
		if( pStepInfo->mUseMP > pAttacker->GetMP() )	
			throw SKILL_USED_ERR_USEVALUE;


		/// Ҹ HP ġ üũ
		if( pStepInfo->mUseHP >= pAttacker->GetHP() )	
			throw SKILL_USED_ERR_USEVALUE;


		/// Ҹ IDX
		if( pStepInfo->mUseItemCount != 0 )
		{
			if( pAttacker->IsItemUse( pSkillInfo->mUseItem, pStepInfo->mUseItemCount ) == false )
				throw SKILL_USED_ERR_USEVALUE;
		}

		cBaseObject* pTarget = NULL;
		NiPoint3 targetPos = NiPoint3::ZERO;

		/// Ÿ Ÿ üũ
		switch( pSkillInfo->mBoundType )
		{
		case eBOUNDTYPE_SELF_NOTARGET:			/// ڽ  ġ Ÿüũ 	
			{
				/// ڽ Ÿ 
				target = attacker;
				targetPos.x = pAttacker->GetXPos();
				targetPos.y = pAttacker->GetYPos();
				targetPos.z = pAttacker->Height();
				pTarget = pAttacker;
			}
			break;
		case eBOUNDTYPE_NONE:					///  
		case eBOUNDTYPE_TARGET:					/// Ÿ ع
		case eBOUNDTYPE_SELF_TARGET:			/// (ڽ) ع - ߵ Ÿ 
			{

				/// ڽ ϰ Ÿüũ 
				if( pSkillInfo->mApplyType == eAPPLYTYPE_SELF ) 
				{
					/// ڽ Ÿ 
					target = attacker;
					targetPos.x = pAttacker->GetXPos();
					targetPos.y = pAttacker->GetYPos();
					targetPos.z = pAttacker->Height();
					pTarget = pAttacker;
					break;
				}

				/// Ÿ ִ ų Ÿ 0 ɼ . - ũƮ ۼ 
				if( pStepInfo->mTargetDist == 0 )
				{
					assert(NULL);
					NETWORK2->PostServerEvent( "PlayerObjectSkillRequest[%d] mTargetDist == 0", skillIdx );
					throw SKILL_USED_ERR_SCRIPT;
				}

				pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
				/// Ÿ ü Ȯ
				if( pTarget == NULL )	
					throw SKILL_USED_ERR_TARGETOBJECT;

				targetPos.x = pTarget->GetXPos();
				targetPos.y = pTarget->GetYPos();
				targetPos.z = pTarget->Height();

				/// Ȱ ų üũ
				bool isResurrection = false;

				if( pSkillInfo->mApplyType == eAPPLYTYPE_DIEBUDDY )
					isResurrection = true;

				/// Ÿ   üũ
				if( pTarget->GetStateDie() == true && isResurrection == false )
					throw SKILL_USED_ERR_TARGETOBJECT;
				else if( pTarget->GetStateDie() == false && isResurrection == true )
					throw SKILL_USED_ERR_TARGETOBJECT;

				/// Ÿ Ÿ üũ
				switch( pSkillInfo->mApplyType ) 
				{
				case eAPPLYTYPE_SELF:
					break;
				case eAPPLYTYPE_ENEMY:
					{
						/// Ÿ  üũ
						if( target.type != eOBJECTTYPE_MONSTER )
						{
							if( DUELMANAGER->IsAttack( pAttacker->GetDuelIdx(), attacker.index, target.index ) == false )
								throw SKILL_USED_ERR_TARGETSELECT;
						}
					}
					break;
				case eAPPLYTYPE_BUDDY:
					{
						/// pvp ؾ
						if( target.type != eOBJECTTYPE_PLAYER )
							throw SKILL_USED_ERR_TARGETSELECT;
					}
					break;
				case eAPPLYTYPE_PARTY:
					{
						/// ڽ  
						if( target.index == pAttacker->GetObjectID() && target.type == pAttacker->GetObjectType() )
							break;

						bool isParty = false;
						/// Ÿ Ƽ üũ
						cParty* pParty = PARTYMAN->GetParty( ((cPlayer*)pAttacker)->GetPartyIndex() );
						if( pParty != NULL )
						{
							unsigned long* userArr = pParty->GetUserArr();
							unsigned int partyCount = pParty->GetCount();

							for( unsigned int i = 0 ; i < partyCount ; ++i )
							{
								/// Ÿ Ƽ Ȯ
								if( target.index == userArr[i] )
								{
									isParty = true;
									break;
								}
							}
						}

						/// Ÿ Ƽ ƴ 
						if( isParty == false )
							throw SKILL_USED_ERR_TARGETSELECT;
					}
					break;
				}

				/// ų++ȿ Ÿ
				float range = pAttacker->CalcStatusSkillRange( pStepInfo->mTargetDist, pSkillInfo->mRangeType, false );

				range = OBJECTMANAGER->ObjectSizeRange( pAttacker, pTarget, range );

				/// ų Ÿ ۿ Ÿ ִ.
				cRangeCheck skillRangeCheck( range + SYNC_MOVE_RANGE );
				NiPoint3 attackerPos( pAttacker->GetXPos(), pAttacker->GetYPos(), pAttacker->Height() );

				if( !skillRangeCheck.IsRange( attackerPos, targetPos ) )	
				{ 
					HANDLE             handle = NULL;
					MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

					if ( posMsg != NULL )
					{
						posMsg->Category      = NM_SKILL;
						posMsg->Protocol      = NM_SKILL_USED_POS_ERROR_RES;
						posMsg->mAttacker     = attacker;
						posMsg->mAttackerPosX = pAttacker->GetXPos( );
						posMsg->mAttackerPosY = pAttacker->GetYPos( );
						posMsg->mTarget       = target;
						posMsg->mTargetPosX   = targetPos.x;
						posMsg->mTargetPosY   = targetPos.y;

						NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
					}

					throw SKILL_USED_ERR_TARGETDIST;
				}

				/// ڿ Ÿ Ѵ
				pAttacker->SetTarget( target.type, target.index );

			}break;
			/// ʵΰ Լ ü 
		case eBOUNDTYPE_FIELD:
		default:
			{
				/// ũƮ  ߸ƴ.
				assert(NULL);
				NETWORK2->PostServerEvent("PlayerObjectSkillRequest mBoundType[%d,%d]", skillIdx, pSkillInfo->mBoundType );
				throw SKILL_USED_ERR_SCRIPT;
			}
		}	

		/// ÷̾  ϱ ݸ޼    
		mRangeCheck.SetRadius( SYNC_MOVE_RANGE );
		NiPoint2 clientPos( pMsg->mClientPosX, pMsg->mClientPosY );
		NiPoint2 serverPos = pAttacker->GetPos();

		if( mRangeCheck.IsRange( serverPos, clientPos ) == false )
		{
			/// ̵ ̴  
			pAttacker->SetMoveTargetPos( serverPos.x, serverPos.y );

			HANDLE             handle = NULL;
			MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

			if ( posMsg != NULL )
			{
				posMsg->Category = NM_SKILL;
				posMsg->Protocol = NM_SKILL_USED_POS_ERROR_RES;
				posMsg->mAttacker = attacker;
				posMsg->mAttackerPosX = pAttacker->GetXPos( );
				posMsg->mAttackerPosY = pAttacker->GetYPos( );
				posMsg->mTarget = target;
				posMsg->mTargetPosX = targetPos.x;
				posMsg->mTargetPosY = targetPos.y;

				NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
			}

			throw SKILL_USED_ERR_ATTAKCERPOS;
		}

		unsigned long currentTime = NETWORK2->GetAccumTime();

		/// Ÿ
		if( pStepInfo->mCoolTime != 0 && pPlayerHaveSkill->GetEndCoolTime() > currentTime )	
		{ 
			NETWORK2->PostServerEvent( "ų:%d   [%d - %d = %d]", skillIdx, pPlayerHaveSkill->GetEndCoolTime(), currentTime, pPlayerHaveSkill->GetEndCoolTime() - currentTime );
			Verbose->WriteLog( "ų:%d   [%d - %d = %d]", skillIdx, pPlayerHaveSkill->GetEndCoolTime(), currentTime, pPlayerHaveSkill->GetEndCoolTime() - currentTime );

			throw SKILL_USED_ERR_COOLTIME;
		}

		/// Ű 
		unsigned long skillUniqueIdx = mSkillGen.GeneratIdx();
		if( skillUniqueIdx == 0 )	
		{ 
			assert(NULL);
			NETWORK2->PostServerEvent( "PlayerObjectSkillRequest GeneratIdx[%d]", skillUniqueIdx );
			throw SKILL_USED_ERR_UNIQUEIDX;
		}

		/// ĳ  ʴ ų̸ ų Ҹ׸ 
		if( casting == false )
		{
			/// MP Ҹ ϴ ų
			if( pStepInfo->mUseMP != 0 )
			{
				pAttacker->MPDamage( pStepInfo->mUseMP, false );
			}

			/// HP Ҹ ϴ ų
			if( pStepInfo->mUseHP != 0 )
			{
				/// HP Ҹ & ޼ ߼
				bool die;
				pAttacker->HPDamage( pStepInfo->mUseHP, &die, true );
			}

			/// Ҹ IDX
			if( pStepInfo->mUseItemCount != 0 )
			{
				if( pAttacker->ItemUse( pSkillInfo->mUseItem, pStepInfo->mUseItemCount ) == false )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("ERROR - item use skill itemidx[%d], itemcnd[%d]", pSkillInfo->mUseItem, pStepInfo->mUseItemCount );
				}
			}
		}


		/// ų ü 
		cPlayerSkillObject* pSkillObject = new cPlayerSkillObject;
		bool init = pSkillObject->InitPlayerSkill( skillIdx, stepIdx, skillUniqueIdx, pAttacker, pTarget,  pStepInfo->mCastingTime );
		if( init == false )
		{ 
			/// ų ü  
			assert(NULL);
			SAFE_DELETE( pSkillObject );
			NETWORK2->PostServerEvent( "PlayerObjectSkillRequest new SkillObject" );		
			throw SKILL_USED_ERR_OBJECTINIT;			
		}

		/// ÷̾  üũѴ.
		if( pAttacker->ChangeState( eOBJECT_STATE_ATTACK ) == false )
		{
			SAFE_DELETE( pSkillObject );
			///  °  Ұ 
			throw SKILL_USED_ERR_ATTACKERSTATE;
		}

		/// ų Ʈ 
		InsertPlayerSkillMap( characterIdx, pSkillObject );

		/// ų   ޼ ش ο 
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			/// ĳ ο  ޼  
			if( casting == true )
				resMsg->Protocol = NM_SKILL_CAST_USED_RES;
			else
				resMsg->Protocol = NM_SKILL_USED_RES;

			resMsg->ErrorCode        = 0;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;
			resMsg->mSkillIndex      = skillUniqueIdx;
			resMsg->mObjectMP        = pAttacker->GetMP();
			resMsg->mMaxMP           = pAttacker->GetMaxMP();

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}

		/// ų  ޼ ٸ Ŭ̾Ʈ 
		MSG_SYN_SKILL_USED synMsg;
		synMsg.Category = NM_SKILL;
		/// ĳ ο  ޼  
		if( casting == true )
			synMsg.Protocol = NM_SKILL_CAST_USED_SYN;
		else
			synMsg.Protocol = NM_SKILL_USED_SYN;
		synMsg.mSkillClassIndex = skillIdx;
		synMsg.mSkillIndex = skillUniqueIdx;
		synMsg.mAttacker = attacker;
		synMsg.mAttackerPosX = pAttacker->GetXPos();
		synMsg.mAttackerPosY = pAttacker->GetYPos();
		synMsg.mTarget = target;
		synMsg.mTargetPosX = targetPos.x;
		synMsg.mTargetPosY = targetPos.y;
		synMsg.mObjectMP = pAttacker->GetMP();
		synMsg.mObjectMaxMP = pAttacker->GetMaxMP();
		NETWORK2->QuickSendExcept( pAttacker, (char*)&synMsg, sizeof(synMsg) );
	}
	catch ( int error )
	{
		/// ų  ޼
		HANDLE handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			if( casting == true )
				resMsg->Protocol = NM_SKILL_CAST_USED_RES;
			else
				resMsg->Protocol = NM_SKILL_USED_RES;

			resMsg->ErrorCode        = error;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}
	}
}



void cSkillManager::PlayerPositionSkillRequest( unsigned long characterIdx, MSG_REQ_POS_USED* pMsg, bool casting )
{

	/// Լ    Ÿ ÷̾ ̴.
	sObject attacker = { eOBJECTTYPE_PLAYER, characterIdx };

	float targetXPos = pMsg->mTargetPosX;
	float targetYPos = pMsg->mTargetPosY;
	unsigned long skillIdx = pMsg->mSkillClassIndex;
	unsigned long clientIdx = pMsg->mManagedKey;


	///  ü üũ
	cPlayer* pAttacker = (cPlayer*)OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL )	
	{ 
		NETWORK2->PostServerEvent("PlayerPositionSkillRequest - GetObject( %d, %d )", attacker.type, attacker.index );
		assert(NULL);
		return; 
	}

	pAttacker->MoveStop();
	pAttacker->SetBlink( targetXPos, targetYPos );

	try
	{
		/// ⺻  ų εΰ 
		if( skillIdx <= NORMAL_ATTACK_SKILL_MAX )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerPositionSkillRequest - skillIdx[%d] > NORMAL_ATTACK_SKILL_MAX", skillIdx );
			throw SKILL_USED_ERR_SKILLTYPE;
		}


		/// ų  Ұ
		if( pAttacker->IsCantSkill() == true )
			throw SKILL_USED_ERR_USEVALUE;


		if( pAttacker->GetChgMonsterIdx() != 0 )
			throw SKILL_USED_ERR_CHG_MONSTER;


		/// ̹ ų  üũ
		if( IsUsingSkill( pAttacker->GetObjectType(), pAttacker->GetObjectID() ) == true )	
			throw SKILL_USED_ERR_USING;


		/// ڿ Ÿ Ѵ
		pAttacker->SetTarget( eOBJECTTYPE_NONE, 0 );


		/// ÷̾  ϱ ݸ޼    
		mRangeCheck.SetRadius( SYNC_MOVE_RANGE );
		NiPoint2 clientPos( pMsg->mClientPosX, pMsg->mClientPosY );
		NiPoint2 serverPos( pAttacker->GetXPos(), pAttacker->GetYPos() );

		if( mRangeCheck.IsRange( serverPos, clientPos ) == false )
		{
			/// ̵ ̴  
			pAttacker->SetMoveTargetPos( serverPos.x, serverPos.y );

			Verbose->WriteLog("sPos[%.2f,%.2f],cPos[%.2f,%.2f] = [%.2f]", serverPos.x, serverPos.y,
				clientPos.x, clientPos.y, (serverPos - clientPos).Length() );

			HANDLE             handle = NULL;
			MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

			if ( posMsg != NULL )
			{
				posMsg->Category      = NM_SKILL;
				posMsg->Protocol      = NM_SKILL_USED_POS_ERROR_RES;
				posMsg->mAttacker     = attacker;
				posMsg->mAttackerPosX = pAttacker->GetXPos( );
				posMsg->mAttackerPosY = pAttacker->GetYPos( );
				posMsg->mTarget.type  = eOBJECTTYPE_NONE;
				posMsg->mTargetPosX   = 0.0f;
				posMsg->mTargetPosY   = 0.0f;

				NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
			}

			throw SKILL_USED_ERR_ATTAKCERPOS;
		}


		/// ųindex üũ
		sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
		if( pSkillInfo == NULL )	
		{ 
			/// ų ũƮ  ȹ 
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerPositionSkillRequest skillScript[%d]", skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}


		if( pSkillInfo->mShotType == eSHOTTYPE_CASTING && casting != true )
		{
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerPositionSkillRequest[%d] ShotType != eSHOTTYPE_CASTING[%d]", characterIdx, skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}


		if( pSkillInfo->mShotType != eSHOTTYPE_CASTING && casting == true )
		{
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerPositionSkillRequest[%d] ShotType == eSHOTTYPE_CASTING[%d]", characterIdx, skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}


		/// Ƽ ų ƴ 
		if( pSkillInfo->mType == eSKILLTYPE_PASSIVE )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerPositionSkillRequest eSKILLTYPE_PASSIVE[%d,%d]", skillIdx, pSkillInfo->mType );
			throw SKILL_USED_ERR_PASSIVE;
		}


		///  ų üũ
		cHaveSkillObject* pPlayerHaveSkill = GetPlayerHaveSkill( attacker.index, skillIdx );
		if( !pPlayerHaveSkill )	
		{ 
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerPositionSkillRequest GetPlayerHaveSkill[%d,%d]", attacker.index, NORMAL_ATTACK_SKILL );
			throw SKILL_USED_ERR_DONTHAVE;
		}


		/// ų ũƮ  о
		unsigned int stepIdx = pPlayerHaveSkill->GetSkillStep();
		sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[stepIdx];

		///   ´ üũ
		bool IsEquipment = true;
		if( pSkillInfo->mUseEquipment )
		{
			eWEAPON_STATE weaponState = pAttacker->GetWeaponState();

			///   üũ
			switch( pSkillInfo->mUseEquipment )
			{
			case eEQUIPTYPE_SWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment = false;
				break;
			case eEQUIPTYPE_LONGSWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD:
				if( weaponState != eWEAPON_STATE_SHORTSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_GUN:
				if( weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_STAFF:
				if( weaponState != eWEAPON_STATE_STAFF )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHIELD:
				if( weaponState != eWEAPON_STATE_SHEILD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD_GUN:
				if( weaponState != eWEAPON_STATE_SHORTSWORD &&
					weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_CLOTH:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_ROBES )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LIGHTARMOR:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_LIGHT_ARMOR )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_HEAVYARMOR:
				if( pAttacker->GetArmorSets() != ARMOR_SETS_HEAVY_ARMOR )
					IsEquipment =  false;
				break;
			}
		}

		if( IsEquipment == false )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerPositionSkillRequest IsEquipment == false" );
			throw SKILL_USED_ERR_EQUIPMENT;
		}

		/// ĳ 
		if( pSkillInfo->mUseState != 0 ) // 
		{
			switch( pSkillInfo->mUseState )
			{
			case 1:	// HPUP
				if( pStepInfo->mUseStateValue > ( pAttacker->GetHP() * PERCENT_HUNDRED / pAttacker->GetMaxHP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			case 2: // HPDONW:	
				if( pStepInfo->mUseStateValue < ( pAttacker->GetHP() * PERCENT_HUNDRED / pAttacker->GetMaxHP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			case 3: // MPUP:		
				if( pStepInfo->mUseStateValue > ( pAttacker->GetMP() * PERCENT_HUNDRED / pAttacker->GetMaxMP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			case 4: // MPDOWN:	
				if( pStepInfo->mUseStateValue < ( pAttacker->GetMP() * PERCENT_HUNDRED / pAttacker->GetMaxMP() ) )	
				{ 
					throw SKILL_USED_ERR_USEVALUE;
				}break;
			default:
				assert(NULL);
				NETWORK2->PostServerEvent("PlayerPositionSkillRequest pSkillInfo->mUseState[%d]", pSkillInfo->mUseState );
				throw SKILL_USED_ERR_SCRIPT;
			}
		}


		/// Ҹ MP
		if( pStepInfo->mUseMP > pAttacker->GetMP() )	
			throw SKILL_USED_ERR_USEVALUE;


		/// Ҹ HP
		if( pStepInfo->mUseHP >= pAttacker->GetHP() )	
			throw SKILL_USED_ERR_USEVALUE;


		/// Ҹ IDX
		if( pStepInfo->mUseItemCount != 0 )
		{
			if( pAttacker->IsItemUse( pSkillInfo->mUseItem, pStepInfo->mUseItemCount ) == false )
				throw SKILL_USED_ERR_USEVALUE;
		}


		/// Ÿ Ÿ üũ
		switch( pSkillInfo->mBoundType )
		{
			/// ʵΰ츸 Լ 
		case eBOUNDTYPE_FIELD:
			{
				NiPoint3 targetPos( targetXPos, targetYPos, 0.0f );
				AIMANAGER->CalcHeight( pAttacker->GetMapNumber(), &targetPos.z, targetXPos, targetYPos );

				NiPoint3 attackerPos( pAttacker->GetXPos(), pAttacker->GetYPos(), pAttacker->Height() );

				/// ų++ȿ Ÿ
				float range = pAttacker->CalcStatusSkillRange( pStepInfo->mTargetDist, pSkillInfo->mRangeType, false );

				range = OBJECTMANAGER->ObjectSizeRange( pAttacker, NULL, range );

				/// ų Ÿ ۿ Ÿ ִ.
				cRangeCheck skillRangeCheck( range + SYNC_MOVE_RANGE );
				if( !skillRangeCheck.IsRange( attackerPos, targetPos ) )
				{ 
					HANDLE             handle = NULL;
					MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

					if ( posMsg != NULL )
					{
						posMsg->Category      = NM_SKILL;
						posMsg->Protocol      = NM_SKILL_USED_POS_ERROR_RES;
						posMsg->mAttacker     = attacker;
						posMsg->mAttackerPosX = pAttacker->GetXPos();
						posMsg->mAttackerPosY = pAttacker->GetYPos();
						posMsg->mTarget.type  = eOBJECTTYPE_NONE;
						posMsg->mTargetPosX   = 0.0f;
						posMsg->mTargetPosY   = 0.0f;

						NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
					}

					throw SKILL_USED_ERR_TARGETDIST;
				}

			}break;
		default:
			{
				/// ũƮ  ߸ƴ.
				assert(NULL);
				NETWORK2->PostServerEvent("PlayerPositionSkillRequest pSkillInfo->mBoundType[%d]", pSkillInfo->mBoundType );
				throw SKILL_USED_ERR_SCRIPT;
			}
		}	


		unsigned long currentTime = NETWORK2->GetAccumTime();

		/// Ÿ
		if( pStepInfo->mCoolTime != 0 && pPlayerHaveSkill->GetEndCoolTime() > currentTime )	
		{ 
			NETWORK2->PostServerEvent( "ų:%d   [%d - %d = %d]", skillIdx, pPlayerHaveSkill->GetEndCoolTime(), currentTime, pPlayerHaveSkill->GetEndCoolTime() - currentTime );
			Verbose->WriteLog( "ų:%d   [%d - %d = %d]", skillIdx, pPlayerHaveSkill->GetEndCoolTime(), currentTime, pPlayerHaveSkill->GetEndCoolTime() - currentTime );

			throw SKILL_USED_ERR_COOLTIME;
		}


		/// Ű 
		unsigned long skillUniqueIdx = mSkillGen.GeneratIdx();
		if( skillUniqueIdx == 0 )	
		{ 
			assert(NULL);
			NETWORK2->PostServerEvent( "PlayerPositionSkillRequest GeneratIdx[%d]", skillUniqueIdx );
			throw SKILL_USED_ERR_UNIQUEIDX;
		}

		/// ĳ  ʴ ų̸ ų Ҹ׸ 
		if( casting == false )
		{
			/// MP Ҹ ϴ ų
			if( pStepInfo->mUseMP != 0 )
				pAttacker->MPDamage( pStepInfo->mUseMP, false );

			/// HP Ҹ ϴ ų
			if( pStepInfo->mUseHP != 0 )
			{
				/// HP Ҹ & ޼ ߼
				bool die;
				pAttacker->HPDamage( pStepInfo->mUseHP, &die, true );
			}


			/// Ҹ IDX
			if( pStepInfo->mUseItemCount != 0 )
			{
				if( pAttacker->ItemUse( pSkillInfo->mUseItem, pStepInfo->mUseItemCount ) == false )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("ERROR - item use skill itemidx[%d], itemcnd[%d]", pSkillInfo->mUseItem, pStepInfo->mUseItemCount );
				}
			}
		}


		/// ų ü 
		cPlayerSkillObject* pSkillObject = new cPlayerSkillObject;
		bool init = pSkillObject->InitPlayerSkillPosition( characterIdx, targetXPos, targetYPos, skillIdx,
			skillUniqueIdx, casting, pAttacker->GetMapNumber() );
		if( init == false )
		{ 
			/// ų ü  
			assert(NULL);
			SAFE_DELETE( pSkillObject );
			NETWORK2->PostServerEvent( "PlayerPositionSkillRequest new SkillObject" );
			throw SKILL_USED_ERR_OBJECTINIT;
		}

		/// ÷̾  üũѴ.
		if( pAttacker->ChangeState( eOBJECT_STATE_ATTACK ) == false )
		{
			///  °  Ұ 
			assert(NULL);
			NETWORK2->PostServerEvent( "PlayerPositionSkillRequest ChangeState ERROR" );
			throw SKILL_USED_ERR_ATTACKERSTATE;
		}


		/// ų Ʈ 
		InsertPlayerSkillMap( characterIdx, pSkillObject );


		/// ų   ޼ ش ο 
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ), NM_SKILL );

		if ( resMsg != NULL )
		{
			/// ĳ ο  ޼  
			if( casting == true )
				resMsg->Protocol = NM_SKILL_POS_CAST_USED_RES;
			else
				resMsg->Protocol = NM_SKILL_POS_USED_RES;

			resMsg->ErrorCode        = 0;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;
			resMsg->mSkillIndex      = skillUniqueIdx;
			resMsg->mObjectMP        = pAttacker->GetMP();
			resMsg->mMaxMP           = pAttacker->GetMaxMP();

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}

		/// ų  ޼ ٸ Ŭ̾Ʈ 
		MSG_SYN_POS_USED synMsg;
		synMsg.Category = NM_SKILL;
		/// ĳ ο  ޼  
		if( casting == true )
			synMsg.Protocol = NM_SKILL_POS_CAST_USED_SYN;
		else
			synMsg.Protocol = NM_SKILL_POS_USED_SYN;
		synMsg.mSkillClassIndex = skillIdx;
		synMsg.mSkillIndex = skillUniqueIdx;
		synMsg.mAttacker = attacker;
		synMsg.mAttackerPosX = pAttacker->GetXPos();
		synMsg.mAttackerPosY = pAttacker->GetYPos();
		synMsg.mTargetPosX = targetXPos;
		synMsg.mTargetPosY = targetYPos;
		synMsg.mObjectMP = pAttacker->GetMP();
		synMsg.mObjectMaxMP = pAttacker->GetMaxMP();
		NETWORK2->QuickSendExcept( pAttacker, (char*)&synMsg, sizeof(synMsg) );
	}
	catch( int error )
	{
		/// ų  ޼
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ), NM_SKILL );
		if ( resMsg != NULL )
		{
			if( casting == true )
				resMsg->Protocol = NM_SKILL_CAST_USED_RES;
			else
				resMsg->Protocol = NM_SKILL_USED_RES;

			resMsg->ErrorCode        = error;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}
	}
}


void cSkillManager::PlayerMonSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_USED* pMsg, bool casting )
{
	eMONSTERATTACK_TYPE attackType = (eMONSTERATTACK_TYPE)pMsg->mSkillClassIndex;

	/// Լ    Ÿ ÷̾ ̴.
	sObject attacker = { eOBJECTTYPE_PLAYER, characterIdx };

	sObject target = pMsg->mTarget;
	unsigned long clientIdx = pMsg->mManagedKey;

	///  hero 
	if( target.type == eOBJECTTYPE_HERO )
		target.type = eOBJECTTYPE_PLAYER;

	///  ü üũ
	cPlayer* pAttacker = (cPlayer*)OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL )	
	{ 
		NETWORK2->PostServerEvent("PlayerMonSkillRequest - GetObject( %d, %d )", attacker.type, attacker.index );
		assert(NULL);
		return; 
	}

	unsigned long monsterClassIdx = pAttacker->GetChgMonsterIdx();

	pAttacker->MoveStop();

	try
	{
		/// ⺻  ų εΰ 
		if( attackType >= eMONSTERATTACK_MAX )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("PlayerMonSkillRequest - attackType[%d] > eMONSTERATTACK_MAX", attackType );
			throw SKILL_USED_ERR_SKILLTYPE;
		}


		/// ų  Ұ
		if( pAttacker->IsCantSkill() == true )
			throw SKILL_USED_ERR_USEVALUE;


		if( pAttacker->GetChgMonsterIdx() == 0 )
			throw SKILL_USED_ERR_CHG_MONSTER;


		/// ų  üũ
		if( IsUsingSkill( pAttacker->GetObjectType(), pAttacker->GetObjectID() ) == true )	
			throw SKILL_USED_ERR_USING;


		/// ųindex üũ
		sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( monsterClassIdx, attackType );
		if( pSkillInfo == NULL )	
		{ 
			/// ų ũƮ  ȹ 
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerMonSkillRequest skillScript[%d,%d]", monsterClassIdx, attackType );
			throw SKILL_USED_ERR_SCRIPT;
		}


		if( pSkillInfo->mShotType == eSHOTTYPE_CASTING && casting != true )
		{
			NETWORK2->PostServerEvent("PlayerMonSkillRequest[%d,%d] ShotType != eSHOTTYPE_CASTING[%d]", characterIdx, monsterClassIdx, attackType );
			throw SKILL_USED_ERR_SCRIPT;
		}


		if( pSkillInfo->mShotType != eSHOTTYPE_CASTING && casting == true )
		{
			assert(NULL); 
			NETWORK2->PostServerEvent("PlayerMonSkillRequest[%d,%d] ShotType == eSHOTTYPE_CASTING[%d]", characterIdx, monsterClassIdx, attackType );
			throw SKILL_USED_ERR_SCRIPT;
		}


		/// Ҹ MP ġ üũ
		if( pSkillInfo->mUseMP > pAttacker->GetMP() )	
			throw SKILL_USED_ERR_USEVALUE;


		cBaseObject* pTarget = NULL;
		NiPoint3 targetPos = NiPoint3::ZERO;


		/// Ÿ Ÿ üũ
		switch( pSkillInfo->mBoundType )
		{
		case eBOUNDTYPE_SELF_NOTARGET:			/// ڽ  ġ Ÿüũ 	
			break;
		case eBOUNDTYPE_NONE:			///  
		case eBOUNDTYPE_TARGET:			/// Ÿ ع
		case eBOUNDTYPE_SELF_TARGET:	/// (ڽ) ع - ߵ Ÿ 
			{

				/// ڽ ϰ Ÿüũ 
				if( pSkillInfo->mApplyType == eAPPLYTYPE_SELF ) 
				{
					/// ڽ Ÿ 
					target = attacker;
					targetPos.x = pAttacker->GetXPos();
					targetPos.y = pAttacker->GetYPos();
					targetPos.z = pAttacker->Height();
					pTarget = pAttacker;
					break;
				}

				/// Ÿ ִ ų Ÿ 0 ɼ . - ũƮ ۼ 
				if( pSkillInfo->mTargetDist == 0 )
				{
					assert(NULL);
					NETWORK2->PostServerEvent( "PlayerMonSkillRequest pStepInfo[%d,%d]->mTargetDist == 0", monsterClassIdx, attackType );
					throw SKILL_USED_ERR_SCRIPT;
				}

				pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
				/// Ÿ ü Ȯ
				if( pTarget == NULL )	
					throw SKILL_USED_ERR_TARGETOBJECT;

				targetPos.x = pTarget->GetXPos();
				targetPos.y = pTarget->GetYPos();
				targetPos.z = pTarget->Height();

				/// Ÿ   üũ
				if( pTarget->GetStateDie() == true  )
					throw SKILL_USED_ERR_TARGETOBJECT;

				/// Ÿ Ÿ üũ
				switch( pSkillInfo->mApplyType ) 
				{
				case eAPPLYTYPE_SELF:
					break;
				case eAPPLYTYPE_ENEMY:
					{
						/// Ÿ  üũ
						if( target.type != eOBJECTTYPE_MONSTER )
						{
							if( DUELMANAGER->IsAttack( pAttacker->GetDuelIdx(), attacker.index, target.index ) == false )
								throw SKILL_USED_ERR_TARGETSELECT;
						}
					}
					break;
				case eAPPLYTYPE_BUDDY:
					{
						/// pvp ؾ
						if( target.type != eOBJECTTYPE_PLAYER )
							throw SKILL_USED_ERR_TARGETSELECT;
					}
					break;
				}

				/// ų++ȿ Ÿ
				float range = pAttacker->CalcStatusSkillRange( pSkillInfo->mTargetDist, pSkillInfo->mRangeType, false );

				range = OBJECTMANAGER->ObjectSizeRange( pAttacker, pTarget, range );

				/// ų Ÿ ۿ Ÿ ִ.
				cRangeCheck skillRangeCheck( range + SYNC_MOVE_RANGE );
				NiPoint3 attackerPos( pAttacker->GetXPos(), pAttacker->GetYPos(), pAttacker->Height() );

				if( !skillRangeCheck.IsRange( attackerPos, targetPos ) )	
				{ 
					HANDLE             handle = NULL;
					MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

					if ( posMsg != NULL )
					{
						posMsg->Category      = NM_SKILL;
						posMsg->Protocol      = NM_SKILL_USED_POS_ERROR_RES;
						posMsg->mAttacker     = attacker;
						posMsg->mAttackerPosX = pAttacker->GetXPos( );
						posMsg->mAttackerPosY = pAttacker->GetYPos( );
						posMsg->mTarget       = target;
						posMsg->mTargetPosX   = targetPos.x;
						posMsg->mTargetPosY   = targetPos.y;

						NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
					}

					throw SKILL_USED_ERR_TARGETDIST;
				}

				/// ڿ Ÿ Ѵ
				pAttacker->SetTarget( target.type, target.index );

			}break;
			/// ʵΰ Լ ü 
		case eBOUNDTYPE_FIELD:
		default:
			{
				/// ũƮ  ߸ƴ.
				assert(NULL);
				NETWORK2->PostServerEvent("PlayerMonSkillRequest mBoundType[%d,%d]", monsterClassIdx, pSkillInfo->mBoundType );
				throw SKILL_USED_ERR_SCRIPT;
			}
		}	


		/// ÷̾  ϱ ݸ޼    
		mRangeCheck.SetRadius( SYNC_MOVE_RANGE );
		NiPoint2 clientPos( pMsg->mClientPosX, pMsg->mClientPosY );
		NiPoint2 serverPos = pAttacker->GetPos();


		if( mRangeCheck.IsRange( serverPos, clientPos ) == false )
		{
			/// ̵ ̴  
			pAttacker->SetMoveTargetPos( serverPos.x, serverPos.y );

			HANDLE             handle = NULL;
			MSG_RES_SKILL_POS* posMsg = (MSG_RES_SKILL_POS*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx( ) );

			if ( posMsg != NULL )
			{
				posMsg->Category = NM_SKILL;
				posMsg->Protocol = NM_SKILL_USED_POS_ERROR_RES;
				posMsg->mAttacker = attacker;
				posMsg->mAttackerPosX = pAttacker->GetXPos( );
				posMsg->mAttackerPosY = pAttacker->GetYPos( );
				posMsg->mTarget = target;
				posMsg->mTargetPosX = targetPos.x;
				posMsg->mTargetPosY = targetPos.y;

				NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_POS) );
			}

			throw SKILL_USED_ERR_ATTAKCERPOS;
		}

		if( pAttacker->IsChgMonCoolTimeEnd( attackType ) == false )
			throw SKILL_USED_ERR_COOLTIME;


		/// Ű 
		unsigned long skillUniqueIdx = mSkillGen.GeneratIdx();
		if( skillUniqueIdx == 0 )	
		{ 
			assert(NULL);
			NETWORK2->PostServerEvent( "PlayerPositionSkillRequest GeneratIdx[%d]", skillUniqueIdx );
			throw SKILL_USED_ERR_UNIQUEIDX;
		}


		/// ĳ  ʴ ų̸ ų Ҹ׸ 
		if( casting == false )
		{
			/// MP Ҹ ϴ ų
			if( pSkillInfo->mUseMP != 0 )
			{
				pAttacker->MPDamage( pSkillInfo->mUseMP, false );
			}
		}


		/// ų ü 
		cPlayerMonSkillObject* pSkillObject = new cPlayerMonSkillObject;
		bool init = pSkillObject->InitPlayerMonAttack( characterIdx, pAttacker->GetChgMonsterIdx(), 
			attackType, target, skillUniqueIdx, casting, 
			pAttacker->GetStatus2()->mAttackSpeed,	pAttacker->GetMapNumber() );
		if( init == false )
		{ 
			/// ų ü  
			assert(NULL);
			SAFE_DELETE( pSkillObject );
			NETWORK2->PostServerEvent( "PlayerObjectSkillRequest new SkillObject" );		
			throw SKILL_USED_ERR_OBJECTINIT;			
		}


		/// ÷̾  üũѴ.
		if( pAttacker->ChangeState( eOBJECT_STATE_ATTACK ) == false )
		{
			SAFE_DELETE( pSkillObject );
			///  °  Ұ 
			throw SKILL_USED_ERR_ATTACKERSTATE;
		}


		/// ų Ʈ 
		InsertPlayerSkillMap( characterIdx, pSkillObject );


		/// ų   ޼ ش ο 
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			/// ĳ ο  ޼  
			if( casting == true )
				resMsg->Protocol = NM_SKILL_CAST_USED_MON_RES;
			else
				resMsg->Protocol = NM_SKILL_USED_MON_RES;

			resMsg->ErrorCode        = 0;
			resMsg->mSkillClassIndex = pMsg->mSkillClassIndex;
			resMsg->mManagedKey      = pMsg->mManagedKey;
			resMsg->mSkillIndex      = skillUniqueIdx;
			resMsg->mObjectMP        = pAttacker->GetMP();
			resMsg->mMaxMP           = pAttacker->GetMaxMP();

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}


		/// ų  ޼ ٸ Ŭ̾Ʈ 
		MSG_SYN_SKILL_USED synMsg;
		synMsg.Category = NM_SKILL;
		/// ĳ ο  ޼  
		if( casting == true )
			synMsg.Protocol = NM_SKILL_CAST_USED_SYN;
		else
			synMsg.Protocol = NM_SKILL_USED_SYN;
		synMsg.mSkillClassIndex = attackType;
		synMsg.mSkillIndex = skillUniqueIdx;
		synMsg.mAttacker = attacker;
		synMsg.mAttackerPosX = pAttacker->GetXPos();
		synMsg.mAttackerPosY = pAttacker->GetYPos();
		synMsg.mTarget = target;
		synMsg.mTargetPosX = targetPos.x;
		synMsg.mTargetPosY = targetPos.y;
		synMsg.mObjectMP = pAttacker->GetMP();
		synMsg.mObjectMaxMP = pAttacker->GetMaxMP();
		NETWORK2->QuickSendExcept( pAttacker, (char*)&synMsg, sizeof(synMsg) );
	}
	catch ( int error )
	{
		/// ų  ޼
		HANDLE handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			if( casting == true )
				resMsg->Protocol = NM_SKILL_CAST_USED_MON_RES;
			else
				resMsg->Protocol = NM_SKILL_USED_MON_RES;

			resMsg->ErrorCode        = error;
			resMsg->mSkillClassIndex = attackType;
			resMsg->mManagedKey      = clientIdx;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}
	}
}


void cSkillManager::MapChangeSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_ITEMMAPCHANGE* pMsg )
{
	/// Լ    Ÿ ÷̾ ̴.
	sObject attacker = { eOBJECTTYPE_PLAYER, characterIdx };

	sObject target = pMsg->mTarget;
	unsigned long skillIdx = pMsg->mSkillClassIndex;
	unsigned long clientIdx = pMsg->mManagedKey;

	///  hero 
	if( target.type == eOBJECTTYPE_HERO )
		target.type = eOBJECTTYPE_PLAYER;

	///  ü üũ
	cPlayer* pAttacker = (cPlayer*)OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::MapChangeSkillRequest - GetObject( %d, %d )", attacker.type, attacker.index );
		return; 
	}

	pAttacker->MoveStop();

	try
	{
		/// ų  üũ
		if( IsUsingSkill( pAttacker->GetObjectType(), pAttacker->GetObjectID() ) == true )	
			throw SKILL_USED_ERR_USING;

		///  üũ
		if( pAttacker->IsChangeState( eOBJECT_STATE_ATTACK ) == false )
			throw SKILL_USED_ERR_ATTACKERSTATE;

		/// ųindex üũ
		sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
		if( pSkillInfo == NULL )	
		{ 
			/// ų ũƮ  ȹ 
			NETWORK2->PostServerEvent("cSkillManager::MapChangeSkillRequest skillScript[%d]", skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}
		sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[0];

		/// inventory ..
		long useItemDBIdx = pAttacker->IsItemMapChange( pMsg->mSlotNumber, pSkillInfo->mUseItem, skillIdx );
		if( useItemDBIdx == 0 )
			throw SKILL_USED_ERR_USEVALUE;

		/// ̵  üũ
		if( pStepInfo->mApplyValueType1 == eSTATUSPLUS_MAPCHANGE )
		{
			if( pAttacker->IsItemMapChange( pStepInfo->mApplyValue1 ) == false )
				throw SKILL_USED_ERR_ATTACKERSTATE;
		}
		else if( pStepInfo->mApplyValueType2 == eSTATUSPLUS_MAPCHANGE )
		{
			if( pAttacker->IsItemMapChange( pStepInfo->mApplyValue2 ) == false )
				throw SKILL_USED_ERR_ATTACKERSTATE;
		}
		else
			throw SKILL_USED_ERR_ATTACKERSTATE;

		/// Ű 
		unsigned long skillUniqueIdx = mSkillGen.GeneratIdx();
		if( skillUniqueIdx == 0 )	
		{ 
			NETWORK2->PostServerEvent( "cSkillManager::MapChangeSkillRequest GeneratIdx[%d]", skillUniqueIdx );
			throw SKILL_USED_ERR_UNIQUEIDX;
		}

		/// ų ü 
		cPlayerSkillObject* pSkillObject = new cPlayerSkillObject;
		bool init = pSkillObject->InitPlayerMapChange( skillIdx, skillUniqueIdx, pAttacker, useItemDBIdx, pStepInfo->mCastingTime );
		if( init == false )
		{ 
			/// ų ü  
			SAFE_DELETE( pSkillObject );
			NETWORK2->PostServerEvent( "cSkillManager::MapChangeSkillRequest new SkillObject" );		
			throw SKILL_USED_ERR_OBJECTINIT;			
		}

		/// ÷̾  
		pAttacker->ChangeState( eOBJECT_STATE_ATTACK );

		/// ų Ʈ 
		InsertPlayerSkillMap( characterIdx, pSkillObject );

		/// ų   ޼ ش ο 
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			/// ĳ ο  ޼  
			resMsg->Protocol = NM_SKILL_ITEMMAPCHANGE_RES;
			resMsg->ErrorCode        = 0;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;
			resMsg->mSkillIndex      = skillUniqueIdx;
			resMsg->mObjectMP        = pAttacker->GetMP();
			resMsg->mMaxMP           = pAttacker->GetMaxMP();

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}

		/// ų  ޼ ٸ Ŭ̾Ʈ 
		MSG_SYN_SKILL_USED synMsg;
		synMsg.Category = NM_SKILL;
		synMsg.Protocol = NM_SKILL_ITEMMAPCHANGE_SYN;
		synMsg.mSkillClassIndex = skillIdx;
		synMsg.mSkillIndex = skillUniqueIdx;
		synMsg.mAttacker = attacker;
		synMsg.mAttackerPosX = pAttacker->GetXPos();
		synMsg.mAttackerPosY = pAttacker->GetYPos();
		synMsg.mTarget = target;
		synMsg.mTargetPosX = pAttacker->GetXPos();
		synMsg.mTargetPosY = pAttacker->GetYPos();
		synMsg.mObjectMP = pAttacker->GetMP();
		synMsg.mObjectMaxMP = pAttacker->GetMaxMP();
		NETWORK2->QuickSendExcept( pAttacker, (char*)&synMsg, sizeof(synMsg) );
	}
	catch ( int error )
	{
		/// ų  ޼
		HANDLE handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			resMsg->Protocol = NM_SKILL;
			resMsg->Protocol = NM_SKILL_ITEMMAPCHANGE_RES;
			resMsg->ErrorCode        = error;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}
	}
}


void cSkillManager::VehiCleSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_VEHICLE* pMsg )
{
	/// Լ    Ÿ ÷̾ ̴.
	sObject attacker = { eOBJECTTYPE_PLAYER, characterIdx };

	sObject target = pMsg->mTarget;
	unsigned long skillIdx = pMsg->mSkillClassIndex;
	unsigned long clientIdx = pMsg->mManagedKey;

	///  hero 
	if( target.type == eOBJECTTYPE_HERO )
		target.type = eOBJECTTYPE_PLAYER;

	///  ü üũ
	cPlayer* pAttacker = (cPlayer*)OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::VehicleSkillRequest - GetObject( %d, %d )", attacker.type, attacker.index );
		return; 
	}

	pAttacker->MoveStop();

	try
	{
		/// ų  üũ
		if( IsUsingSkill( pAttacker->GetObjectType(), pAttacker->GetObjectID() ) == true )	
			throw SKILL_USED_ERR_USING;

		///  üũ
		if( pAttacker->IsChangeState( eOBJECT_STATE_ATTACK ) == false )
			throw SKILL_USED_ERR_ATTACKERSTATE;

		/// ųindex üũ
		sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
		if( pSkillInfo == NULL )	
		{ 
			/// ų ũƮ  ȹ 
			NETWORK2->PostServerEvent("cSkillManager::VehicleSkillRequest skillScript[%d]", skillIdx );
			throw SKILL_USED_ERR_SCRIPT;
		}
		sPlayerSkillStepInfo* pStepInfo = &pSkillInfo->mpSetpInfoArray[0];

		/// inventory ..
		long useItemDBIdx = pAttacker->IsItemVehicle( pMsg->mSlotNumber, pSkillInfo->mUseItem, skillIdx );
		if( useItemDBIdx == 0 )
			throw SKILL_USED_ERR_USEVALUE;

		///   ̸  Ұ
		if( pAttacker->GetChgMonsterIdx() != 0 )
			throw SKILL_USED_ERR_ATTACKERSTATE;

		/// Ű 
		unsigned long skillUniqueIdx = mSkillGen.GeneratIdx();
		if( skillUniqueIdx == 0 )	
		{ 
			NETWORK2->PostServerEvent( "cSkillManager::VehicleSkillRequest GeneratIdx[%d]", skillUniqueIdx );
			throw SKILL_USED_ERR_UNIQUEIDX;
		}

		/// ų ü 
		cPlayerSkillObject* pSkillObject = new cPlayerSkillObject;
		bool init = pSkillObject->InitPlayerVehicle( skillIdx, skillUniqueIdx, pAttacker, pSkillInfo->mUseItem, pStepInfo->mCastingTime );
		if( init == false )
		{ 
			/// ų ü  
			SAFE_DELETE( pSkillObject );
			NETWORK2->PostServerEvent( "cSkillManager::VehicleSkillRequest new SkillObject" );		
			throw SKILL_USED_ERR_OBJECTINIT;			
		}

		/// ÷̾  
		pAttacker->ChangeState( eOBJECT_STATE_ATTACK );

		/// ų Ʈ 
		InsertPlayerSkillMap( characterIdx, pSkillObject );

		/// ų   ޼ ش ο 
		HANDLE              handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			/// ĳ ο  ޼  
			resMsg->Protocol = NM_SKILL_ITEMVEHICLE_RES;
			resMsg->ErrorCode        = SKILL_USED_ERR_SUCCESS;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;
			resMsg->mSkillIndex      = skillUniqueIdx;
			resMsg->mObjectMP        = pAttacker->GetMP();
			resMsg->mMaxMP           = pAttacker->GetMaxMP();

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}

		/// ų  ޼ ٸ Ŭ̾Ʈ 
		MSG_SYN_SKILL_USED synMsg;
		synMsg.Category = NM_SKILL;
		synMsg.Protocol = NM_SKILL_ITEMVEHICLE_SYN;
		synMsg.mSkillClassIndex = skillIdx;
		synMsg.mSkillIndex = skillUniqueIdx;
		synMsg.mAttacker = attacker;
		synMsg.mAttackerPosX = pAttacker->GetXPos();
		synMsg.mAttackerPosY = pAttacker->GetYPos();
		synMsg.mTarget = target;
		synMsg.mTargetPosX = pAttacker->GetXPos();
		synMsg.mTargetPosY = pAttacker->GetYPos();
		synMsg.mObjectMP = pAttacker->GetMP();
		synMsg.mObjectMaxMP = pAttacker->GetMaxMP();
		NETWORK2->QuickSendExcept( pAttacker, (char*)&synMsg, sizeof(synMsg) );
	}
	catch ( int error )
	{
		/// ų  ޼
		HANDLE handle = NULL;
		MSG_RES_SKILL_USED* resMsg = (MSG_RES_SKILL_USED*)NETWORK2->GetMsgRoot( &handle, pAttacker->GetConnectionIdx(), NM_SKILL );

		if ( resMsg != NULL )
		{
			resMsg->Protocol = NM_SKILL;
			resMsg->Protocol = NM_SKILL_ITEMVEHICLE_RES;
			resMsg->ErrorCode        = error;
			resMsg->mSkillClassIndex = skillIdx;
			resMsg->mManagedKey      = clientIdx;

			NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_USED) );
		}
	}
}


bool cSkillManager::MonsterAttack( unsigned long monsterIdx, eMONSTERATTACK_TYPE attackType, sObject target )
{

	if( attackType == eMONSTERATTACK_MAX )
		return false;

	/// Լ    Ÿ  ̴.
	sObject attacker = { eOBJECTTYPE_MONSTER, monsterIdx };


	///  ü üũ
	cMonster* pAttacker = OBJECTMANAGER->GetMonster( attacker.index );
	if( pAttacker == NULL )	
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent("MonsterAttack - attacker.index[%d]", attacker.index );
		return false; 
	}


	/// ̹ ų  üũ
	if( IsUsingSkill( pAttacker->GetObjectType(), pAttacker->GetObjectID() ) == true )	
		return false; 


	/// Ÿ ü üũ
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( pTarget == NULL || pTarget->GetStateDie() == true )	
		return false; 


	/// ųindex üũ
	sMonsterSkillScript* pSkillInfo = SKILLSCRIPT->GetMonsterSkillInfo( pAttacker->GetRaceGender(), attackType );
	if( pSkillInfo == NULL )	
	{ 
		/// ų ũƮ  ȹ 
		assert(NULL); 
		NETWORK2->PostServerEvent("MonsterAttack - GetMonsterSkillInfo[%d,%d]", pAttacker->GetRaceGender(), attackType );
		return false; 
	}


	/// Ÿ  üũ 
	if( target.type != eOBJECTTYPE_PLAYER )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("MonsterAttack - target.type[%d]", target.type );
		return false;
	}

	/// Ҹ MP ġ üũ
	if( pSkillInfo->mUseMP > pAttacker->GetMP() )	
		return false;

	float range = pAttacker->CalcStatusSkillRange( pSkillInfo->mTargetDist, pSkillInfo->mRangeType );

	range = OBJECTMANAGER->ObjectSizeRange( pAttacker, pTarget, range );

	/// ų Ÿ ۿ Ÿ ִ.
	cRangeCheck skillRangeCheck( range );

	NiPoint3 attackerPos( pAttacker->GetXPos(), pAttacker->GetYPos(), pAttacker->Height() );
	NiPoint3 targetPos( pTarget->GetXPos(), pTarget->GetYPos(), pTarget->Height() );

	if( !skillRangeCheck.IsRange( attackerPos, targetPos ) )	
		return false; 


	bool casting = false;
	if( pSkillInfo->mShotType == eMONSTERSHOTTYPE_CASTING )
		casting = true;


	/// ų ȣ 
	unsigned long skillUniqueIdx = mSkillGen.GeneratIdx();
	if( skillUniqueIdx == 0 )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent( "MonsterAttack skillUniqueIdx[%d]", skillUniqueIdx );
		return false; 
	}

	float attackSpeed = 1.0f;

	/// Ϲ ݸ Ӱ 
	if( eMONSTERATTACK_NORMAL1 == attackType || eMONSTERATTACK_NORMAL2 == attackType )
	{
		attackSpeed = pAttacker->GetAttackSpeed();
	}

	/// ų ü 
	cMonsterSkillObject* pSkillObject = new cMonsterSkillObject;
	bool init = pSkillObject->InitMonsterAttack( monsterIdx, pAttacker->GetRaceGender(), attackType, 
		target, skillUniqueIdx, casting, attackSpeed, pAttacker->GetMapNumber() );
	if( init == false )
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent( "MonsterAttack new SkillObject" );
		SAFE_DELETE( pSkillObject );
		return false;
	}

	/// ĳ  ʴ ų̸ ų Ҹ׸ 
	if( casting == false )
	{
		/// MP Ҹ ϴ ų
		if( pSkillInfo->mUseMP != 0 )
			pAttacker->MPDamage( pSkillInfo->mUseMP, false );
	}

	/// ų Ʈ 
	InsertMonsterSkillMap( monsterIdx, pSkillObject );

	pAttacker->SetAttackType( attackType );
	pAttacker->ModeSkillEnd();

	pAttacker->UpdateSkillCoolTime( attackType );

	/// ų  ⺻ ݸ 縦 Ѵ.
	///   ų   ʰ  ȯ 忡 شϴ 縸 Ѵ.
	if( attackType < eMONSTERATTACK_MAX )
		pAttacker->SendSpeech( attackType + eMONSTERTALK_ATTACKSTART );

	/// ų  ޼ ٸ Ŭ̾Ʈ 
	MSG_SYN_MONSTER_SKILL_USED synMsg;
	synMsg.Category = NM_SKILL;
	if( casting == true )
		synMsg.Protocol = NM_SKILL_MONSTER_CAST_USED_SYN;
	else
		synMsg.Protocol = NM_SKILL_MONSTER_USED_SYN;
	synMsg.mSkillIndex = skillUniqueIdx;
	synMsg.mAttacker.type = eOBJECTTYPE_MONSTER;
	synMsg.mAttackType = (unsigned char)attackType;
	synMsg.mAttacker.index = monsterIdx;
	synMsg.mAttackerPosX = pAttacker->GetXPos();
	synMsg.mAttackerPosY = pAttacker->GetYPos();
	synMsg.mAttackSpeedFactor = attackSpeed;
	synMsg.mTarget = target;
	NETWORK2->QuickSendExcept( pAttacker, (char*)&synMsg, sizeof(synMsg) );

	pAttacker->MoveStop();

	return true;
}


bool cSkillManager::DeleteSkillObject( unsigned char type, unsigned long objectIdx, unsigned long skillUniqueIdx )
{
	switch( type )
	{
	case eOBJECTTYPE_MONSTER:
		{
			cMonsterSkillObject* pSkillObject = NULL;

			cArray* pArray = (cArray*)mMonsterSkillMap.GetAt( objectIdx );
			if( pArray == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("cSkillManager::DeleteSkillObject(%d,%d,%d) pArray == NULL", type, objectIdx, skillUniqueIdx );
				return false;
			}

			for( unsigned int i = pArray->GetSize() ; i > 0 ; --i )
			{
				pSkillObject = (cMonsterSkillObject*)(*pArray)[i-1];
				if( pSkillObject == NULL )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cSkillManager::DeleteSkillObject(%d,%d,%d) pSkillObject == NULL", type, objectIdx, skillUniqueIdx );
					pArray->PopAt( i-1 );
					continue;
				}

				if( pSkillObject->GetUniqueIdx() == skillUniqueIdx )
				{
					SAFE_DELETE( pSkillObject );
					pArray->PopAt( i-1 );
					return true;
				}
			}
		}
		break;
	case eOBJECTTYPE_HERO:
	case eOBJECTTYPE_PLAYER:
		{
			cBaseSkillObject* pSkillObject = NULL;

			cArray* pArray = (cArray*)mPlayerSkillMap.GetAt( objectIdx );
			if( pArray == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("cSkillManager::DeleteSkillObject(%d,%d,%d) pArray == NULL", type, objectIdx, skillUniqueIdx );
				return false;
			}

			for( unsigned int i = pArray->GetSize() ; i > 0 ; --i )
			{
				pSkillObject = (cBaseSkillObject*)(*pArray)[i-1];
				if( pSkillObject == NULL )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cSkillManager::DeleteSkillObject(%d,%d,%d) pSkillObject == NULL", type, objectIdx, skillUniqueIdx );
					pArray->PopAt( i-1 );
					continue;
				}

				if( pSkillObject->GetUniqueIdx() == skillUniqueIdx )
				{
					SAFE_DELETE( pSkillObject );
					pArray->PopAt( i-1 );
					return true;
				}
			}
		}
		break;
	default:
		return false;
	}

	return false;
}


void cSkillManager::InsertDeleteSkillObject( sObject skillUser, unsigned long skillUniqueIdx ) 
{ 
	sDelSkillInfo info;
	info.skillUser = skillUser;
	info.mSkillIdx = skillUniqueIdx;

	mDeleteSkillAry.PushBack( info ); 
}


unsigned char cSkillManager::AddPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx, unsigned char skillStep, unsigned long cooltime )
{

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( !pPlayer )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("AddPlayerHaveSkill - playerIdx[%d]", playerIdx );
		return SKILL_ADD_ERR_PLAYER; 
	}

	/// ųindex üũ
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( !pSkillInfo )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("AddPlayerHaveSkill - skillIdx[%d]", skillIdx );
		return SKILL_ADD_ERR_SCRIPT; 
	}

	/// ų ܰ  üũ
	if( skillStep < 0 || pSkillInfo->mStepCount <= skillStep )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("AddPlayerHaveSkill - skillStep[%d]", skillStep );
		return SKILL_ADD_ERR_SKILLSTEP; 
	}


	/*--------------- skilllist_pc ---------------*/

	///   SP
	if( pSkillInfo->mJobStep != 0 && pSkillInfo->mJobStep != 9 )
	{
		unsigned long point  = pPlayer->GetJobUsedSkillPoint( pSkillInfo->mJobStep-1 );

		if( point < pSkillInfo->mBeforeReqSP )
			return SKILL_ADD_ERR_JOBSP;
	}

	///   ִ°
	if( pSkillInfo->mRace != 0 ) /// 0 = ALL
	{
		///  üũ
		switch( pPlayer->GetRace() )
		{
		case eRACE_HUMAN:
			if( !( pSkillInfo->mRace == eSKILLRACE_HUMAN || 
				pSkillInfo->mRace == eSKILLRACE_HUMAN_BEAST || 
				pSkillInfo->mRace == eSKILLRACE_HUMAN_ELF ) )	
			{
				return SKILL_ADD_ERR_RACE; 
			}break;
		case eRACE_BEAST:
			if( !( pSkillInfo->mRace == eSKILLRACE_BEAST || 
				pSkillInfo->mRace == eSKILLRACE_HUMAN_BEAST || 
				pSkillInfo->mRace == eSKILLRACE_BEAST_ELF ) )
			{ 
				return SKILL_ADD_ERR_RACE; 
			}break;
		case eRACE_ELF:
			if( !( pSkillInfo->mRace == eSKILLRACE_ELF || 
				pSkillInfo->mRace == eSKILLRACE_HUMAN_ELF || 
				pSkillInfo->mRace == eSKILLRACE_BEAST_ELF ) )	
			{ 
				return SKILL_ADD_ERR_RACE; 
			}break;
		default:
			assert(NULL); 
			return SKILL_ADD_ERR_SCRIPT; 	
		}
	}

	///  ų1 ʿ
	if( pSkillInfo->mLearnSkillIdx1 != 0 )
	{
		///   ų üũ
		cHaveSkillObject* pPlayerHaveSkill = GetPlayerHaveSkill( playerIdx, pSkillInfo->mLearnSkillIdx1 );
		if( !pPlayerHaveSkill )	
			return SKILL_ADD_ERR_LEARNSKILL; 

		///   ų 
		if( pSkillInfo->mLearnSkillStep1 > pPlayerHaveSkill->GetSkillStep() + 1 )	
			return SKILL_ADD_ERR_LEARNSTEP; 
	}

	///  ų2 ʿ
	if( pSkillInfo->mLearnSkillIdx2 != 0 )
	{
		///   ų üũ
		cHaveSkillObject* pPlayerHaveSkill = GetPlayerHaveSkill( playerIdx, pSkillInfo->mLearnSkillIdx2 );
		if( !pPlayerHaveSkill )	
			return SKILL_ADD_ERR_LEARNSKILL; 

		///   ų 
		if( pSkillInfo->mLearnSkillStep2 > pPlayerHaveSkill->GetSkillStep() + 1 )	
			return SKILL_ADD_ERR_LEARNSTEP; 
	}


	///*--------------- skilllist_sub ---------------*/

	///  ִ 
	if( pSkillInfo->mpSetpInfoArray->mJobType != 0 )
	{
		///  üũ
		if( !SKILLSCRIPT->IsPlayerSkillJob( pSkillInfo->mpSetpInfoArray->mJobType, static_cast<unsigned long>(pPlayer->GetJob()) ) )
			return SKILL_ADD_ERR_JOB; 
	}

	/// ĳ ʿ level
	if( pSkillInfo->mpSetpInfoArray->mPlayerLevel > pPlayer->GetLevel() )	
		return SKILL_ADD_ERR_LEVEL; 

	///*---------------------------------------------*/


	/// ߰ ų Ʈ ִ о
	cHaveSkillObject* pPlayerHaveSkill = GetPlayerHaveSkill( playerIdx, skillIdx );

	///   ų üũ
	if( skillStep == SKILL_START_STEP )
	{
		/// ̹ ų  
		if( pPlayerHaveSkill )	
		{ 
			assert(NULL); 
			NETWORK2->PostServerEvent("AddPlayerHaveSkill -alreay have skill skillStep[%d]", skillStep );
			return SKILL_ADD_ERR_SKILLSTEP; 
		}

		/// playeridx ÷̾  ųƮ ͸ 
		cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( playerIdx );
		///  ųƮ 
		if ( !pPlayerHaveSkillMap )
		{
			/// ο ųƮ 
			pPlayerHaveSkillMap = new cPointerHashMap;

			///   ųƮ 
			if( !( mPlayerHaveSkillMap.Insert( playerIdx, pPlayerHaveSkillMap ) ) )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("AddPlayerHaveSkill[%d,%d,%d] - mPlayerHaveSkillMap.Insert error", playerIdx, skillIdx, skillStep );
				SAFE_DELETE( pPlayerHaveSkillMap );
				return SKILL_ADD_ERR_MAPINSERT;
			}
		}

		/// ųƮ  
		cHaveSkillObject* pPlayerHaveSkill = new cHaveSkillObject;
		pPlayerHaveSkill->Init( skillIdx, 0, cooltime );

		if( !(pPlayerHaveSkillMap->Insert( skillIdx, pPlayerHaveSkill ) ) )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("AddPlayerHaveSkill[%d,%d,%d] - mPlayerHaveSkillMap.Insert error", playerIdx, skillIdx, skillStep  );
			SAFE_DELETE( pPlayerHaveSkill );
			return SKILL_ADD_ERR_MAPINSERT;
		}
	}
	else	/// ܰ踦 Ű 
	{
		/// ų  
		if( pPlayerHaveSkill == 0 )	
		{ 
			NETWORK2->PostServerEvent("AddPlayerHaveSkill[%d,%d,%d] - update error not have", playerIdx, skillIdx, skillStep );
			return SKILL_ADD_ERR_SKILLSTEP; 
		}

		/// ܰ    
		if( pPlayerHaveSkill->StepUp( skillStep, cooltime ) == false )	
		{ 
			NETWORK2->PostServerEvent("AddPlayerHaveSkill[%d,%d,%d] - update error", playerIdx, skillIdx, skillStep );
			return SKILL_ADD_ERR_SKILLSTEP; 
		}
	}

	/// нú ϰ  
	if( pSkillInfo->mType == eSKILLTYPE_PASSIVE )
	{
		/// ⺻׸  Ȯ(+,%) ׸ 
		STATUSCALC->CalcPlayerExtensionGlobal( pPlayer->GetObject() );
	}

	/// ų̸  ų 
	if( pSkillInfo->mShotType == eSHOTTYPE_AURA )
		AuraInfluenceOff( playerIdx, skillIdx );

	return SKILL_ADD_ERR_SUCCESS;
}



void cSkillManager::InsertPlayerSkillMap( unsigned long characterIdx, cBaseSkillObject* pSkillObject )
{
	cArray* pSkillArray = (cArray*)mPlayerSkillMap.GetAt( characterIdx );
	if( pSkillArray == NULL )
	{
		pSkillArray = new cArray;
		mPlayerSkillMap.Insert( characterIdx, pSkillArray );
	}

	pSkillArray->PushBack( pSkillObject );
}



void cSkillManager::InsertMonsterSkillMap( unsigned long monsterIdx, cMonsterSkillObject* pSkillObject )
{
	cArray* pSkillArray = (cArray*)mMonsterSkillMap.GetAt( monsterIdx );
	if( pSkillArray == NULL )
	{
		pSkillArray = new cArray;
		mMonsterSkillMap.Insert( monsterIdx, pSkillArray );
	}

	pSkillArray->PushBack( pSkillObject );
}



cHaveSkillObject* cSkillManager::GetPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx )
{
	cPointerHashMap* cPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( playerIdx );
	if ( !cPlayerHaveSkillMap )
	{
		return NULL;
	}

	/// ⺻   LBS߰
	if( skillIdx < NORMAL_ATTACK_SKILL_MAX )
		return (cHaveSkillObject*)cPlayerHaveSkillMap->GetAt( NORMAL_ATTACK_SKILL );

	return (cHaveSkillObject*)cPlayerHaveSkillMap->GetAt( skillIdx );
}



void* cSkillManager::GetPlayerHaveSkill( unsigned long playerIdx )
{
	return mPlayerHaveSkillMap.GetAt( playerIdx );
}



bool cSkillManager::DelPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx )
{
	/// playeridx ÷̾  ųƮ ͸ 
	cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( playerIdx );
	///  ųƮ 
	if ( !pPlayerHaveSkillMap )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cSkillManager::DelPlayerHaveSkill pPlayer[%d]HaveSkillMap == NULL", playerIdx );
		return false;
	}

	if( !(pPlayerHaveSkillMap->Erase( skillIdx ) ) )
	{
		return false;
	}

	return true;
}


void cSkillManager::RollBackPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx )
{
	cHaveSkillObject* pHaveSkillObject = GetPlayerHaveSkill( playerIdx, skillIdx );
	if( !pHaveSkillObject ) 
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::RollBackPlayerHaveSkill pHaveSkillObject[%d,%d] == NULL", playerIdx, skillIdx );
		return; 
	}

	if( pHaveSkillObject->GetSkillStep() == SKILL_START_STEP )
	{
		cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( playerIdx );
		if( !pPlayerHaveSkillMap )	
		{ 
			assert(NULL); 
			NETWORK2->PostServerEvent("cSkillManager::RollBackPlayerHaveSkill pPlayerHaveSkillMap[%d] == NULL", playerIdx );
			return; 
		}

		SAFE_DELETE( pHaveSkillObject );
		pPlayerHaveSkillMap->Erase( skillIdx );
	}
	else
	{
		///  Ѵܰ 
		pHaveSkillObject->StepDown();
	}
}


void cSkillManager::ReleasePlayerHaveSkill()
{
	cPointerHashMap::cIterator startPlayer = mPlayerHaveSkillMap.Begin();
	cPointerHashMap::cIterator endPlayer = mPlayerHaveSkillMap.End();

	for( ; startPlayer != endPlayer ; ++startPlayer )
	{
		cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)(*startPlayer).mSecond;
		if ( !pPlayerHaveSkillMap )		{ continue; }

		cPointerHashMap::cIterator startSkill = pPlayerHaveSkillMap->Begin();
		cPointerHashMap::cIterator endSkill = pPlayerHaveSkillMap->End();

		cHaveSkillObject* p;
		for( ; startSkill != endSkill ; ++startSkill )
		{
			p = (cHaveSkillObject*)(*startSkill).mSecond;
			SAFE_DELETE( p );
		}
		SAFE_DELETE( pPlayerHaveSkillMap );
	}

	mPlayerHaveSkillMap.Clear();
}



void cSkillManager::ReleaseInfluence()
{
	cPointerHashMap::cIterator startInfluence = mInfluenceMap.Begin();
	cPointerHashMap::cIterator endInfluence = mInfluenceMap.End();

	cInfluenceObject* pInfluenceObject;
	for( ; startInfluence != endInfluence ; ++startInfluence )
	{
		pInfluenceObject = (cInfluenceObject*)(*startInfluence).mSecond;
		SAFE_DELETE( pInfluenceObject );
	}

	mInfluenceMap.Clear();
}


bool cSkillManager::SavePlayerInfluence( unsigned long playerIdx, SKILL_INFLUENCE_INSERT* pInfluenceInsert )
{

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( !pPlayer )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SavePlayerInfluence pPlayer[%d] == NULL", playerIdx );
		return false; 
	}

	tHashSet<unsigned long>* pInfluenceAry = pPlayer->GetInfluenceSet();
	if( !pInfluenceAry )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SavePlayerInfluence pInfluenceAry == NULL" );
		return false; 
	}

	cInfluenceObject* pInfluenceObject = NULL;

	tHashSet<unsigned long>::cIterator start = pInfluenceAry->Begin();
	tHashSet<unsigned long>::cIterator end = pInfluenceAry->End();

	// 08/03/11 
	TB_CHARACTER_INFLUENCE* table = pInfluenceInsert->mTable;	// long i = 0;
	for( ; start != end ; ++start )
	{
		pInfluenceObject = GetInfluence( (*start) );
		if( !pInfluenceObject ) 
		{ 
			assert(NULL); 
			NETWORK2->PostServerEvent("cSkillManager::SavePlayerInfluence pInfluenceObject[%d] == NULL", (*start) );
			//-/-//InsertDeleteInfluenceObject( pInfluenceObject );	/// ü  ⿭ ִ´.
			continue;
		}

		if( PVP_DM_LEADER_INFLUENCE == pInfluenceObject->GetInfluenceClassIdx() )
			continue;			
		if( PVP_DM_LEADER_INFLUENCE2 == pInfluenceObject->GetInfluenceClassIdx() )
			continue;			

		/// ȿ,   ȿ  ʴ´.
		if( pInfluenceObject->IsSwitchType() == true )
			continue;

		// 08/03/11 
		pInfluenceObject->SavePlayerInfluence( table );		// pInfluenceObject->SavePlayerInfluence( &pInfluenceInsert->mTable[i] );
		table++;											// i++;

		pInfluenceInsert->mRowCount++;
	}
	// 08/03/11 
	// pInfluenceInsert->mRowCount = i;
	pInfluenceInsert->mCharacterIdx = playerIdx;
	return true;
}



void cSkillManager::RestorePlayerInfluence( unsigned long playerIdx, SKILL_INFLUENCE_SELECT* pInfluenceSelect, unsigned long rowCnt )
{

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( !pPlayer ) 
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::RestorePlayerInfluence pPlayer[%d] == NULL", playerIdx );
		return; 
	}

	const int colNum = 3;

	unsigned long uniqueIdx = 0;
	cInfluenceObject* pInf = NULL;
	for( unsigned long i = 0 ; i < rowCnt ; ++i )
	{
		sInfluence* pInfluence = &pInfluenceSelect->mTable[i];
		if( pInfluence == NULL )
			continue;

		sInfluenceScript* pScript = SKILLSCRIPT->GetInfluenceInfo( pInfluence->mInfluenceClassIdx );
		if( pScript == NULL )
			continue;

		/// ű 
		pInf = new cInfluenceObject;
		uniqueIdx = mInfluenceGen.GeneratIdx();
		if( pInf->RestorePlayerInfluence( playerIdx, uniqueIdx, pInfluence ) == false )
		{
			assert(NULL);
			SAFE_DELETE( pInf );
			continue;
		}

		if( !( mInfluenceMap.Insert( uniqueIdx, pInf ) ) )
		{
			assert(NULL);
			SAFE_DELETE( pInf );
			NETWORK2->PostServerEvent( "cSkillManager::RestorePlayerInfluence mInfluenceMap.Insert Duplicate" );
			continue;
		}

		if( pPlayer->AddInfluence( uniqueIdx, pInf->GetInfluenceClassIdx() ) == false )
		{
			assert(NULL);
			NETWORK2->PostServerEvent( "cSkillManager::RestorePlayer[%d]Influence[%d] pPlayer->AddSkillInfluence[%d] == false", playerIdx, uniqueIdx, pInf->GetInfluenceClassIdx() );
			NETWORK2->PostServerEvent( "cSkillManager::RestorePlayer[%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d]",
			pInfluence->mUniqueIdx,
			pInfluence->mDbIdx,
			pInfluence->mInfluenceClassIdx,
			pInfluence->mAttacker.type,
			pInfluence->mAttacker.index,
			pInfluence->mIsRealTime,
			pInfluence->mRestTime,
			pInfluence->mTime1,
			pInfluence->mTime2,
			pInfluence->mInfluenceValue1,
			pInfluence->mInfluenceValue2,
			pInfluence->mAttriButeType );
			continue;
		}

		long type[colNum] = { pScript->mStatusPlusIdx1, pScript->mStatusPlusIdx2, pScript->mStatusPlusIdx3 };
		long value[colNum] = { pScript->mValue1, pScript->mValue2, pScript->mValue3 };

		for( int i = 0 ; i < colNum ; ++i )
			ApplyInfluence( pPlayer, pPlayer, uniqueIdx, pInfluence->mInfluenceClassIdx, type[i], value[i] );
	}
}


void cSkillManager::ReleasePlayerHaveSkill( unsigned long playerIdx )
{
	/// playeridx ÷̾  ųƮ ͸ 
	cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( playerIdx );
	///  ųƮ 
	if ( !pPlayerHaveSkillMap )	{ return; }

	cPointerHashMap::cIterator startSkill = pPlayerHaveSkillMap->Begin();
	cPointerHashMap::cIterator endSkill = pPlayerHaveSkillMap->End();

	cHaveSkillObject* p = NULL;
	for( ; startSkill != endSkill ; ++startSkill )
	{
		p = (cHaveSkillObject*)(*startSkill).mSecond;
		SAFE_DELETE( p );
	}
	SAFE_DELETE( pPlayerHaveSkillMap );

	mPlayerHaveSkillMap.Erase( playerIdx );
}


bool cSkillManager::AddInfluence( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, bool msgSend )
{
	//////////////////////////////////////////////////////////////////////////
	///  Ÿ ε
	
	/// űȿ ũƮ
	sInfluenceScript* pNewScript = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( pNewScript == NULL ) 	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewScript[%d]==NULL", infClassIdx );
		return false; 
	}
	const int colNum = 3;
	long type[colNum] = { pNewScript->mStatusPlusIdx1, pNewScript->mStatusPlusIdx2, pNewScript->mStatusPlusIdx3 };
	long value[colNum] = { pNewScript->mValue1, pNewScript->mValue2, pNewScript->mValue3 };

	/// , Ÿ 
	cBaseObject* pAttacker = OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL || pAttacker->GetStateDie() == true )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pAttacker[%d,%d]==NULL", attacker.type, attacker.index );
		return false; 
	}
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( !pTarget )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pTarget[%d,%d]==NULL", target.type, target.index );
		return false; 
	}


	//////////////////////////////////////////////////////////////////////////
	/// ߵ Ȯ üũ
	unsigned long skillRate = pNewScript->mActivityPer;
	if( skillRate != 0 )
	{
		/// Ȯ 
		unsigned long checkPer = skillRate;

		/// ڿ Ÿٰ ̻   ؾ ϴ 
		bool isBadInfluence = false;
		for( int i = 0 ; i < colNum ; ++i )
		{
			if( eSTATUSPLUS_DISPEL <= type[i] && type[i] <= eSTATUSPLUS_CONDITIONINDISPOSITION_MAX )
			{
				isBadInfluence = true;
				break;
			}
		}

		///  ̻ Ȯ 
		if( isBadInfluence == true )
		{
			/// ڰ ÷̾  
			if( attacker.type == eOBJECTTYPE_PLAYER )
				checkPer = DAMAGECALC->PlayerConditionOdd( target, attacker, skillRate, skillClassIdx );
			else if( attacker.type == eOBJECTTYPE_MONSTER )
				checkPer = DAMAGECALC->MonsterConditionOdd( target, attacker, skillRate, skillClassIdx );
		}

		/// Ȯ üũ
		unsigned long activityRand = rand() % 100;
		if( checkPer <= activityRand )	
			return false; 
	}


	bool EndVehicle = false;
	//////////////////////////////////////////////////////////////////////////
	/// ȿ ü  üũ
	bool createInfluence = false;
	for( int i = 0 ; i < colNum ; ++i )
	{
		if( eSTATUSPLUS_STR_PLUS <= type[i] && type[i] <= eSTATUSPLUS_BASE_MAX ||
			eSTATUSPLUS_ATK_PLUS <= type[i] && type[i] <= eSTATUSPLUS_BUFF_ETC_MAX ||
			eSTATUSPLUS_DOT_HPCHANGE_PLUS <= type[i] && type[i] <= eSTATUSPLUS_DOT_MAX ||
			eSTATUSPLUS_STOPMOVE <= type[i] && type[i] <= eSTATUSPLUS_CONDITIONINDISPOSITION_MAX ||
			eSTATUSPLUS_CHAR_SIZE == type[i] )
		{
			createInfluence = true;
			break;
		}
		/// ų  -  
		else if( eSTATUSPLUS_INSTANTPERHIT <= type[i] && type[i] <= eSTATUSPLUS_DELETE_TARGETING )
		{
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence type[%d,%d] error", infClassIdx, type[i] );
			continue;
		}
		/// Ż ź¿   Ұ
		else if( type[i] == eSTATUSPLUS_CHANGE_MONSTER )
		{
			if( pTarget->GetObjectType() != eOBJECTTYPE_PLAYER )
				return false;

			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->IsVehicle() == true )
			{
				EndVehicle = true;
			}
		}
	}


	//////////////////////////////////////////////////////////////////////////
	/// ȿ ü 
	unsigned long uniqueIdx = 0;
	if( createInfluence == true )
	{
		cHashSet* pInfluenceSet = pTarget->GetInfluenceSet();

		/// ߺ/׷ üũ
		tHashSet<unsigned long>::cIterator begin = pInfluenceSet->Begin();
		tHashSet<unsigned long>::cIterator end = pInfluenceSet->End();
	
		while( begin != end )
		{
			///  ȿ Ʈ
			cInfluenceObject* pHaveInf = GetInfluence( *begin++ );
			if( !pHaveInf )	
			{ 
				NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceObject==NULL" );
				continue; 
			}
	
			///  ȿ ũƮ 
			sInfluenceScript* pHaveScript = SKILLSCRIPT->GetInfluenceInfo( pHaveInf->GetInfluenceClassIdx() );
			if( !pHaveInf )	
			{ 
				NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceScript==NULL" );
				continue; 
			}
	
			/// ϰ ִ ȿ ű ȿ ߺüũ
			if( pNewScript->mNotOverlapGroupIdx != 0 &&
				pHaveScript->mNotOverlapGroupIdx == pNewScript->mNotOverlapGroupIdx )
			{
				/// ڵ  ȿ 
				if( pHaveInf->GetAttacker().index == attacker.index &&
					pHaveInf->GetAttacker().type == attacker.type )
				{
					DeleteInfluence( target, pHaveInf->GetUniqueIdx() );
					break;
				}
			}
	
			/// ϰ ִ ȿ ű ȿ ȿ±׷ 
			if( pNewScript->mGroupIdx == pHaveScript->mGroupIdx )
			{
				/// ű   ų  ű ()
				if( pNewScript->mGroupOrder >= pHaveScript->mGroupOrder )
				{
					DeleteInfluence( target, pHaveInf->GetUniqueIdx() );
					break;
				}
				else
					return false;
			}
		}

		/// 
		unsigned long plusTime = 0;
		cInfluenceObject* pNewObject = new cInfluenceObject;
		uniqueIdx = mInfluenceGen.GeneratIdx();
		if( !pNewObject->NormalInit( attacker, target, uniqueIdx, infClassIdx, skillClassIdx, &plusTime ) )
		{
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewInfluenceObject->Init err");
			SAFE_DELETE( pNewObject );
			return false;
		}

		if( !( mInfluenceMap.Insert( uniqueIdx, pNewObject ) ) )
		{
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence mInfluenceMap duplicate");
			SAFE_DELETE( pNewObject );
			return false;
		}

		/// Ÿ ȿ Ʈ ߰
		if( pTarget->AddInfluence( uniqueIdx, pNewObject->GetInfluenceClassIdx() ) == false )
		{
			NETWORK2->PostServerEvent( "cSkillManager::AddInfluence pTarget[%d,%d]->AddSkillInfluence[%d,%d] == false", 
				target.type, target.index, uniqueIdx, infClassIdx );
			return false;
		}

		if( msgSend == true )
		{
			MSG_SYN_INFLUENCE_CREATE msg;
			msg.Category = NM_SKILL;
			msg.Protocol = NM_SKILL_INFLUENCE_CREATE_SYN;
			msg.mTarget = target;
			msg.mAttacker = attacker;
			msg.mUniqueIdx = uniqueIdx;
			msg.mInfluenceClassIdx = infClassIdx;
			msg.mAuraSkillClassIdx = 0;
			msg.mDieDelete = pNewObject->GetDieDelete();
			msg.mPlusTime = plusTime;

			NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
		}
	}


	//////////////////////////////////////////////////////////////////////////
	/// 
	bool calcStatus = false;
	for( int i = 0 ; i < colNum ; ++i )
	{
		if( ApplyInfluence( pAttacker, pTarget, uniqueIdx, infClassIdx, type[i], value[i] ) == true )
			calcStatus = true;
	}


	//////////////////////////////////////////////////////////////////////////
	///  
	if( calcStatus == true )
	{
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
			STATUSCALC->CalcPlayerExtensionGlobal( pTarget->GetObject() );
		else if( pTarget->GetObjectType() == eOBJECTTYPE_MONSTER )
			STATUSCALC->CalcMonster( target.index );
		else
			assert(NULL);
	}

	if( EndVehicle == true )
	{
		((cPlayer*)pTarget)->EndVehicleClient( false );
	}

	return true;
}


unsigned long cSkillManager::AddInfSwitch( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, bool msgSend )
{
	//////////////////////////////////////////////////////////////////////////
	///  Ÿ ε

	/// űȿ ũƮ
	sInfluenceScript* pNewScript = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( pNewScript == NULL ) 	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewScript[%d]==NULL", infClassIdx );
		return 0; 
	}
	const int colNum = 3;
	long type[colNum] = { pNewScript->mStatusPlusIdx1, pNewScript->mStatusPlusIdx2, pNewScript->mStatusPlusIdx3 };
	long value[colNum] = { pNewScript->mValue1, pNewScript->mValue2, pNewScript->mValue3 };

	/// , Ÿ 
	cBaseObject* pAttacker = OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL || pAttacker->GetStateDie() == true )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pAttacker[%d,%d]==NULL", attacker.type, attacker.index );
		return 0; 
	}
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( !pTarget )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pTarget[%d,%d]==NULL", target.type, target.index );
		return 0; 
	}


	//////////////////////////////////////////////////////////////////////////
	/// ȿ ü 

	cHashSet* pInfluenceSet = pTarget->GetInfluenceSet();

	tHashSet<unsigned long>::cIterator begin = pInfluenceSet->Begin();
	tHashSet<unsigned long>::cIterator end = pInfluenceSet->End();

	/// ڽ ѵ   üũ
	while( begin != end )
	{
		///  ȿ Ʈ
		cInfluenceObject* pHaveInf = GetInfluence( *begin++ );
		if( !pHaveInf )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceObject==NULL Aura" );
			continue; 
		}

		///  ȿ ũƮ 
		sInfluenceScript* pHaveScript = SKILLSCRIPT->GetInfluenceInfo( pHaveInf->GetInfluenceClassIdx() );
		if( !pHaveScript )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceScript==NULL Aura" );
			continue; 
		}

		/// ϰ ִ ȿ ű ȿ ߺüũ
		if( pHaveScript->mNotOverlapGroupIdx != 0 &&
			pHaveScript->mNotOverlapGroupIdx == pNewScript->mNotOverlapGroupIdx )
		{				
			/// ڵ  ȿ 
			if( pHaveInf->GetAttacker().index == attacker.index &&
				pHaveInf->GetAttacker().type == attacker.type )
			{
				DeleteInfluence( target, pHaveInf->GetUniqueIdx() );
				break;
			}
		}
	}

	begin = pInfluenceSet->Begin();
	end = pInfluenceSet->End();

	while( begin != end )
	{
		///  ȿ Ʈ
		cInfluenceObject* pHaveInf = GetInfluence( *begin++ );
		if( !pHaveInf )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceObject==NULL" );
			continue; 
		}

		///  ȿ ũƮ 
		sInfluenceScript* pHaveScript = SKILLSCRIPT->GetInfluenceInfo( pHaveInf->GetInfluenceClassIdx() );
		if( !pHaveScript )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceScript==NULL" );
			continue; 
		}

		/// ϰ ִ ȿ ű ȿ ȿ±׷ 
		if( pNewScript->mGroupIdx == pHaveScript->mGroupIdx )
		{
			/// ű   ų  ű ()
			if( pNewScript->mGroupOrder >= pHaveScript->mGroupOrder )
			{
				DeleteInfluence( target, pHaveInf->GetUniqueIdx() );
				break;
			}
			else
				return 0;
		}
	}

	cInfluenceObject* pNewObject = new cInfluenceObject;
	unsigned long uniqueIdx = mInfluenceGen.GeneratIdx();
	if( !pNewObject->SwitchParentInit( attacker, target, uniqueIdx, infClassIdx, skillClassIdx ) )
	{
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewInfluenceObject->Init err");
		SAFE_DELETE( pNewObject );
		return 0;
	}

	if( !( mInfluenceMap.Insert( uniqueIdx, pNewObject ) ) )
	{
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence mInfluenceMap duplicate");
		SAFE_DELETE( pNewObject );
		return 0;
	}

	/// Ÿ ȿ Ʈ ߰
	if( pTarget->AddInfluence( uniqueIdx, pNewObject->GetInfluenceClassIdx() ) == false )
	{
		NETWORK2->PostServerEvent( "cSkillManager::AddInfluence pTarget[%d,%d]->AddSkillInfluence[%d,%d] == false", 
			target.type, target.index, uniqueIdx, infClassIdx );
		return 0;
	}

	if( msgSend == true )
	{
		MSG_SYN_INFLUENCE_CREATE msg;
		msg.Category = NM_SKILL;
		msg.Protocol = NM_SKILL_INFLUENCE_CREATE_SYN;
		msg.mTarget = target;
		msg.mAttacker = attacker;
		msg.mUniqueIdx = uniqueIdx;
		msg.mInfluenceClassIdx = infClassIdx;
		msg.mAuraSkillClassIdx = skillClassIdx;
		msg.mDieDelete = pNewObject->GetDieDelete();
		msg.mPlusTime = 0;

		NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
	}


	//////////////////////////////////////////////////////////////////////////
	/// 
	bool calcStatus = false;
	for( int i = 0 ; i < colNum ; ++i )
	{
		if( ApplyInfluence( pAttacker, pTarget, uniqueIdx, infClassIdx, type[i], value[i] ) == true )
			calcStatus = true;
	}


	//////////////////////////////////////////////////////////////////////////
	///  
	if( calcStatus == true )
	{
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
			STATUSCALC->CalcPlayerExtensionGlobal( pTarget->GetObject() );
		else if( pTarget->GetObjectType() == eOBJECTTYPE_MONSTER )
			STATUSCALC->CalcMonster( target.index );
		else
			assert(NULL);
	}

	return uniqueIdx;
}


bool cSkillManager::AddInfChildAura( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, unsigned long parentIdx, bool msgSend )
{
	//////////////////////////////////////////////////////////////////////////
	///  Ÿ ε

	/// űȿ ũƮ
	sInfluenceScript* pNewScript = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( pNewScript == NULL ) 	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewScript[%d]==NULL", infClassIdx );
		return false; 
	}
	const int colNum = 3;
	long type[colNum] = { pNewScript->mStatusPlusIdx1, pNewScript->mStatusPlusIdx2, pNewScript->mStatusPlusIdx3 };
	long value[colNum] = { pNewScript->mValue1, pNewScript->mValue2, pNewScript->mValue3 };

	/// , Ÿ 
	cBaseObject* pAttacker = OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL || pAttacker->GetStateDie() == true )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pAttacker[%d,%d]==NULL", attacker.type, attacker.index );
		return false; 
	}
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( !pTarget )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pTarget[%d,%d]==NULL", target.type, target.index );
		return false; 
	}


	//////////////////////////////////////////////////////////////////////////
	/// ȿ ü 
	cHashSet* pInfluenceSet = pTarget->GetInfluenceSet();

	tHashSet<unsigned long>::cIterator begin = pInfluenceSet->Begin();
	tHashSet<unsigned long>::cIterator end = pInfluenceSet->End();
	while( begin != end )
	{
		///  ȿ Ʈ
		cInfluenceObject* pHaveInf = GetInfluence( *begin++ );
		if( !pHaveInf )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceObject==NULL" );
			continue; 
		}

		///  ȿ ũƮ 
		sInfluenceScript* pHaveScript = SKILLSCRIPT->GetInfluenceInfo( pHaveInf->GetInfluenceClassIdx() );
		if( !pHaveScript )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceScript==NULL" );
			continue; 
		}

		/// ϰ ִ ȿ ű ȿ ȿ±׷ 
		if( pNewScript->mGroupIdx == pHaveScript->mGroupIdx )
		{
			/// ű    ű ()
			if( pNewScript->mGroupOrder > pHaveScript->mGroupOrder )
			{
				DeleteInfluence( target, pHaveInf->GetUniqueIdx() );
				break;
			}
			else
				return false;
		}
	}

	cInfluenceObject* pNewObject = new cInfluenceObject;
	unsigned long uniqueIdx = mInfluenceGen.GeneratIdx();
	if( !pNewObject->SwitchChildAuraInit( attacker, target, uniqueIdx, infClassIdx, skillClassIdx, parentIdx ) )
	{
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewInfluenceObject->Init err");
		SAFE_DELETE( pNewObject );
		return false;
	}

	if( !( mInfluenceMap.Insert( uniqueIdx, pNewObject ) ) )
	{
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence mInfluenceMap duplicate");
		SAFE_DELETE( pNewObject );
		return false;
	}

	/// Ÿ ȿ Ʈ ߰
	if( pTarget->AddInfluence( uniqueIdx, pNewObject->GetInfluenceClassIdx() ) == false )
	{
		NETWORK2->PostServerEvent( "cSkillManager::AddInfluence pTarget[%d,%d]->AddSkillInfluence[%d,%d] == false", 
			target.type, target.index, uniqueIdx, infClassIdx );
		return false;
	}

	if( msgSend == true )
	{
		MSG_SYN_INFLUENCE_CREATE msg;
		msg.Category = NM_SKILL;
		msg.Protocol = NM_SKILL_INFLUENCE_CREATE_SYN;
		msg.mTarget = target;
		msg.mAttacker = attacker;
		msg.mUniqueIdx = uniqueIdx;
		msg.mInfluenceClassIdx = infClassIdx;
		msg.mAuraSkillClassIdx = 0;
		msg.mDieDelete = pNewObject->GetDieDelete();
		msg.mPlusTime = 0;

		NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
	}


	//////////////////////////////////////////////////////////////////////////
	/// 
	bool calcStatus = false;
	for( int i = 0 ; i < colNum ; ++i )
	{
		if( ApplyInfluence( pAttacker, pTarget, uniqueIdx, infClassIdx, type[i], value[i] ) == true )
			calcStatus = true;
	}


	//////////////////////////////////////////////////////////////////////////
	///  
	if( calcStatus == true )
	{
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
			STATUSCALC->CalcPlayerExtensionGlobal( pTarget->GetObject() );
		else if( pTarget->GetObjectType() == eOBJECTTYPE_MONSTER )
			STATUSCALC->CalcMonster( target.index );
		else
			assert(NULL);
	}

	return true;
}


bool cSkillManager::AddInfChildTotem( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, unsigned long parentIdx, bool msgSend )
{
	//////////////////////////////////////////////////////////////////////////
	///  Ÿ ε

	sInfluenceScript* pNewScript = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( pNewScript == NULL ) 	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewScript[%d]==NULL", infClassIdx );
		return false; 
	}
	const int colNum = 3;
	long type[colNum] = { pNewScript->mStatusPlusIdx1, pNewScript->mStatusPlusIdx2, pNewScript->mStatusPlusIdx3 };
	long value[colNum] = { pNewScript->mValue1, pNewScript->mValue2, pNewScript->mValue3 };

	/// , Ÿ 
	cBaseObject* pAttacker = OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pAttacker == NULL || pAttacker->GetStateDie() == true )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pAttacker[%d,%d]==NULL", attacker.type, attacker.index );
		return false; 
	}
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( !pTarget )	
	{ 
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pTarget[%d,%d]==NULL", target.type, target.index );
		return false; 
	}


	//////////////////////////////////////////////////////////////////////////
	/// ȿ ü 
	cHashSet* pInfluenceSet = pTarget->GetInfluenceSet();

	tHashSet<unsigned long>::cIterator begin = pInfluenceSet->Begin();
	tHashSet<unsigned long>::cIterator end = pInfluenceSet->End();
	while( begin != end )
	{
		///  ȿ Ʈ
		cInfluenceObject* pHaveInf = GetInfluence( *begin++ );
		if( !pHaveInf )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceObject==NULL" );
			continue; 
		}

		///  ȿ ũƮ 
		sInfluenceScript* pHaveScript = SKILLSCRIPT->GetInfluenceInfo( pHaveInf->GetInfluenceClassIdx() );
		if( !pHaveScript )	
		{ 
			NETWORK2->PostServerEvent("cSkillManager::AddInfluence pHaveInfluenceScript==NULL" );
			continue; 
		}

		/// ϰ ִ ȿ ű ȿ ȿ±׷ 
		if( pNewScript->mGroupIdx == pHaveScript->mGroupIdx )
		{
			/// ű    ű ()
			if( pNewScript->mGroupOrder > pHaveScript->mGroupOrder )
			{
				DeleteInfluence( target, pHaveInf->GetUniqueIdx() );
				break;
			}
			else
				return false;
		}
	}

	cInfluenceObject* pNewObject = new cInfluenceObject;
	unsigned long uniqueIdx = mInfluenceGen.GeneratIdx();
	if( !pNewObject->SwitchChildTotemInit( attacker, target, uniqueIdx, infClassIdx, skillClassIdx, parentIdx ) )
	{
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence pNewInfluenceObject->Init err");
		SAFE_DELETE( pNewObject );
		return false;
	}

	if( !( mInfluenceMap.Insert( uniqueIdx, pNewObject ) ) )
	{
		NETWORK2->PostServerEvent("cSkillManager::AddInfluence mInfluenceMap duplicate");
		SAFE_DELETE( pNewObject );
		return false;
	}

	/// Ÿ ȿ Ʈ ߰
	if( pTarget->AddInfluence( uniqueIdx, pNewObject->GetInfluenceClassIdx() ) == false )
	{
		NETWORK2->PostServerEvent( "cSkillManager::AddInfluence pTarget[%d,%d]->AddSkillInfluence[%d,%d] == false", 
			target.type, target.index, uniqueIdx, infClassIdx );
		return false;
	}

	if( msgSend == true )
	{
		MSG_SYN_INFLUENCE_CREATE msg;
		msg.Category = NM_SKILL;
		msg.Protocol = NM_SKILL_INFLUENCE_CREATE_SYN;
		msg.mTarget = target;
		msg.mAttacker = attacker;
		msg.mUniqueIdx = uniqueIdx;
		msg.mInfluenceClassIdx = infClassIdx;
		msg.mAuraSkillClassIdx = 0;
		msg.mDieDelete = pNewObject->GetDieDelete();
		msg.mPlusTime = 0;

		NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
	}


	//////////////////////////////////////////////////////////////////////////
	/// 
	bool calcStatus = false;
	for( int i = 0 ; i < colNum ; ++i )
	{
		if( ApplyInfluence( pAttacker, pTarget, uniqueIdx, infClassIdx, type[i], value[i] ) == true )
			calcStatus = true;
	}


	//////////////////////////////////////////////////////////////////////////
	///  
	if( calcStatus == true )
	{
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
			STATUSCALC->CalcPlayerExtensionGlobal( pTarget->GetObject() );
		else if( pTarget->GetObjectType() == eOBJECTTYPE_MONSTER )
			STATUSCALC->CalcMonster( target.index );
		else
			assert(NULL);
	}

	return true;
}


bool cSkillManager::ItemCheckAddInf( cBaseObject* pAttacker, cBaseObject* pTarget, unsigned long infClassIdx )
{

	if( pAttacker == NULL )
		return false;

	if( pTarget == NULL )
		return false;

	if( pAttacker->GetStateDie() == true )
		return false;

	const int colNum = 3;
	sInfluenceScript* pScript = SKILLSCRIPT->GetInfluenceInfo( infClassIdx );
	if( pScript == NULL )
		return false;

	long type[colNum] = { pScript->mStatusPlusIdx1, pScript->mStatusPlusIdx2, pScript->mStatusPlusIdx3 };
	long value[colNum] = { pScript->mValue1, pScript->mValue2, pScript->mValue3 };

	for( int i = 0 ; i < colNum ; ++i )
	{
		/// ׾  ȿ üũ
		if( pTarget->GetStateDie() == true )
		{
			switch( type[i] )
			{
			case eSTATUSPLUS_RESURRECTION_HP_PLUS:
			case eSTATUSPLUS_RESURRECTION_HP_PER:
			case eSTATUSPLUS_RESURRECTION_MP_PLUS:
			case eSTATUSPLUS_RESURRECTION_MP_PER:
				if( pTarget->GetObjectType() != eOBJECTTYPE_PLAYER || value[i] <= 0 )
					return false;
			default:
				return false;
			}
		}

		///  ϶ ȿ üũ
		switch( type[i] )
		{
		case eSTATUSPLUS_BLINK:
			{
				if( pTarget->GetObjectType() != eOBJECTTYPE_PLAYER )
					return false;
					
				cPlayer* pPlayer = (cPlayer*)pTarget;
				if( pPlayer->GetState() != eOBJECT_STATE_ATTACK )
					return false;
			}
			break;
		case eSTATUSPLUS_CHANGE_MONSTER:
			if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
			{
				cPlayer* pPlayer = (cPlayer*)pTarget;
				if( !(pPlayer->GetState() == eOBJECT_STATE_IDLE || pPlayer->GetState() == ePLAYER_STATE_ITEMPICK ) )
					return false;

				/// 
				//if( pPlayer->IsVehicle() == true )
				//{
				//	return false;
				//}
			}
			break;
		}
	}

	return true;
}


bool cSkillManager::ApplyInfluence( cBaseObject* pAttacker, cBaseObject* pTarget, unsigned long infObjectIdx, unsigned long infClassIdx, 
								   unsigned long type, long value )
{

	bool statusCalc = false;

	if( pAttacker == NULL )
		return statusCalc;

	if( pTarget == NULL )
		return statusCalc;

	if( pAttacker->GetStateDie() == true )
		return statusCalc;

	///   ϴ üũϴ κ
	if( ( eSTATUSPLUS_STR_PLUS <= type && type <= eSTATUSPLUS_BASE_MAX ) ||
		( eSTATUSPLUS_ATK_PLUS <= type && type <= eSTATUSPLUS_BUFF_ETC_MAX ) || 
		eSTATUSPLUS_CHAR_SIZE == type || eSTATUSPLUS_CHANGE_MONSTER == type )
	{
		statusCalc = true;
	}

	switch( type )
	{
	case eSTATUSPLUS_DISPEL:
		SKILLMANAGER->DispelInfluence( pAttacker->GetObject(), value );
		break;
	case eSTATUSPLUS_RESURRECTION_HP_PLUS:
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )	/// ÷̾ Ȱ
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetStateDie() == true && value > 0 )
			{
				/// Ȱ hpȸ 
				pPlayer->SkillResurrectionHP( value );

				/// Ŭ̾Ʈ Ȱ û ޼ ߼
				HANDLE handle = NULL;
				MSG_RES_SKILL_RESURRECTION* sendMsg = (MSG_RES_SKILL_RESURRECTION*)NETWORK2->GetMsgRoot( &handle, pPlayer->GetConnectionIdx( ) );
				if ( sendMsg != NULL )
				{
					sendMsg->Category    = NM_SKILL;
					sendMsg->Protocol    = NM_SKILL_RESURRECTION_RES;
					sendMsg->mAttackerIdx = pAttacker->GetObjectID();
					NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_RESURRECTION) );
				}
			}
		}
		break;
	case eSTATUSPLUS_RESURRECTION_HP_PER:
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )	/// ÷̾ üũ
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetStateDie() == true && value > 0 )
			{
				long resurrectionValue = pPlayer->GetMaxHP() * value / 100;

				/// Ȱ hpȸ 
				pPlayer->SkillResurrectionHP( resurrectionValue );

				/// Ŭ̾Ʈ Ȱ û ޼ ߼
				HANDLE handle = NULL;
				MSG_RES_SKILL_RESURRECTION* sendMsg = (MSG_RES_SKILL_RESURRECTION*)NETWORK2->GetMsgRoot( &handle, pPlayer->GetConnectionIdx( ) );
				if ( sendMsg != NULL )
				{
					sendMsg->Category    = NM_SKILL;
					sendMsg->Protocol    = NM_SKILL_RESURRECTION_RES;
					sendMsg->mAttackerIdx = pAttacker->GetObjectID();
					NETWORK2->SendMsgRoot( handle, sizeof(MSG_RES_SKILL_RESURRECTION) );
				}
			}
		}
		break;
	case eSTATUSPLUS_RESURRECTION_MP_PLUS:
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )	/// ÷̾ üũ
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetStateDie() == true )
			{
				/// Ȱ mpȸ 
				///  SkillResurrectionHP  Ȱ츸 õ
				pPlayer->SkillResurrectionMP( value );
			}
		}
		break;
	case eSTATUSPLUS_RESURRECTION_MP_PER:
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )	/// ÷̾ üũ
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetStateDie() == true )
			{
				long resurrectionValue = pPlayer->GetMaxMP() * value / 100;

				/// Ȱ mpȸ 
				///  SkillResurrectionHP  Ȱ츸 õ
				pPlayer->SkillResurrectionMP( resurrectionValue );
			}
		}
		break;
	case eSTATUSPLUS_BLINK:
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
		{
			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( pPlayer->GetState() != eOBJECT_STATE_ATTACK )
				return statusCalc;

			pPlayer->Blink();	
		}
		break;
	case eSTATUSPLUS_DISPEL_ALL:
		SKILLMANAGER->DispelInfluenceAll( pTarget->GetObject() );
		break;
	case eSTATUSPLUS_HP_ABSORB_INS:
		break;
	case eSTATUSPLUS_MP_ABSORB_INS:
		break;
	case eSTATUSPLUS_MONSTER_ESCAPE:
		if( pTarget->GetObjectType() == eOBJECTTYPE_MONSTER )
			((cMonster*)pTarget)->SetEscape();
		break;

	case eSTATUSPLUS_NONSKILL_HPCHANGE_PLUS:
		{
			bool die = false;

			if( value > 0 )
				pTarget->HPHeal( value, false, pAttacker->GetObjectID(), 0, eTAKEDAMAGETYPE_POTION );
			else
			{
				/// ߸ ũƮ
				NETWORK2->PostServerEvent("eSTATUSPLUS_NONSKILL_HPCHANGE_PLUS influenceValue <= 0" );
				pTarget->HPDamage( abs(value), &die, false );
			}

			MSG_SYN_SKILL_NONSKILL_HPCHANGE msg; 
			msg.Category = NM_SKILL;
			msg.Protocol = NM_SKILL_NONSKILL_HPCHANGE_SYN;
			msg.mInfluenceClassIdx = infClassIdx;
			msg.mTarget = pTarget->GetObject();
			msg.mChangeValue = value;
			msg.mObjectHP = pTarget->GetHP();
			msg.mObjectMaxHP = pTarget->GetMaxHP();

			NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
		}
		break;
	case eSTATUSPLUS_NONSKILL_HPCHANGE_PER:
		break;
	case eSTATUSPLUS_NONSKILL_MPCHANGE_PLUS:
		{
			if( value > 0 )
			{
				/// MPȸ
				pTarget->MPHeal( value, false );
			}
			else
			{
				/// ߸ ũƮ
				assert(NULL);
				NETWORK2->PostServerEvent("eSTATUSPLUS_NONSKILL_MPCHANGE_PLUS influenceValue <= 0" );
				pTarget->MPHeal( abs(value), false );
			}

			MSG_SYN_SKILL_NONSKILL_MPCHANGE msg; 
			msg.Category = NM_SKILL;
			msg.Protocol = NM_SKILL_NONSKILL_MPCHANGE_SYN;
			msg.mInfluenceClassIdx = infClassIdx;
			msg.mTarget = pTarget->GetObject();
			msg.mChangeValue = value;
			msg.mObjectMP = pTarget->GetMP();
			msg.mObjectMaxMP = pTarget->GetMaxMP();

			NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
		}
		break;
	case eSTATUSPLUS_NONSKILL_MPCHANGE_PER:
		break;
	case eSTATUSPLUS_CHAR_SIZE:
		break;
	case eSTATUSPLUS_CHANGE_MONSTER:
		{
			if( pTarget->GetObjectType() != eOBJECTTYPE_PLAYER )
				return false;

			cPlayer* pPlayer = (cPlayer*)pTarget;
			if( !(pPlayer->GetState() == eOBJECT_STATE_IDLE || pPlayer->GetState() == ePLAYER_STATE_ITEMPICK ) )
				return statusCalc;

			pPlayer->SetChgMonster( infObjectIdx, value );
		}
		break;
	case eSTATUSPLUS_VEHICLE:
		{
			if( pTarget->GetObjectType() != eOBJECTTYPE_PLAYER )
				return statusCalc;

			cPlayer* pPlayer = (cPlayer*)pTarget;
			pPlayer->SetVehicle( infObjectIdx, value );
		}
		break;
	}

	return statusCalc;
}

void cSkillManager::DispelInfluence( sObject target, unsigned long influenceTypeDetail )
{
	/// Ÿ  Ȯ
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( pTarget == NULL )
		return;

	/// ÷̾  ȿ ؽ о
	tHashSet<unsigned long>* pHashSet = pTarget->GetInfluenceSet();

	tHashSet<unsigned long>::cIterator begin = pHashSet->Begin();
	tHashSet<unsigned long>::cIterator end = pHashSet->End();

	cInfluenceObject* pHaveObejct = NULL;
	sInfluenceScript* pHaveScript = NULL;
	unsigned long uniqueIdx;

	/// ü ˻
	while( begin != end )
	{
		uniqueIdx = *begin++;
		pHaveObejct = SKILLMANAGER->GetInfluence( uniqueIdx );

		if( pHaveObejct == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("pHaveInfluenceObejct err - unique[%d]", uniqueIdx );
			//-/-//InsertDeleteInfluenceObject( pHaveObejct );	/// ü  ⿭ ִ´.
			continue;
		}

		///  ȿ ũƮ  о
		pHaveScript = SKILLSCRIPT->GetInfluenceInfo( pHaveObejct->GetInfluenceClassIdx() );
		if( pHaveScript == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("DispelInfluence InfluenceClassIdx err - [%d]", pHaveObejct->GetInfluenceClassIdx() );
			continue;
		}

		/// Է    ȿ   ȿ 
		if( pHaveScript->mTypeDetail == influenceTypeDetail )
		{
			DeleteInfluence( target, uniqueIdx );
			break;
		}
	}
}


void cSkillManager::DispelInfluenceAll( sObject target )
{
	/// Ÿ  Ȯ
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( pTarget == NULL )
		return;

	/// Ÿ ü  ȿ ؽü о
	tHashSet<unsigned long>* pHashSet = pTarget->GetInfluenceSet();

	tHashSet<unsigned long>::cIterator begin = pHashSet->Begin();
	tHashSet<unsigned long>::cIterator end = pHashSet->End();

	cInfluenceObject* pHaveObejct = NULL;
	sInfluenceScript* pHaveScript = NULL;
	unsigned long uniqueIdx;

	/// ü ˻
	while( begin != end )
	{
		uniqueIdx = *begin++;
		pHaveObejct = SKILLMANAGER->GetInfluence( uniqueIdx );

		if( pHaveObejct == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("pHaveInfluenceObejct err - unique[%d]", uniqueIdx );
			//-/-//InsertDeleteInfluenceObject( pHaveObejct );	/// ü  ⿭ ִ´.
			continue;
		}

		///  ȿ ũƮ  о
		pHaveScript = SKILLSCRIPT->GetInfluenceInfo( pHaveObejct->GetInfluenceClassIdx() );
		if( pHaveScript == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("DispelInfluence InfluenceClassIdx err - [%d]", pHaveObejct->GetInfluenceClassIdx() );
			continue;
		}

		///  ü  Ѵ.
		if( pHaveScript->mType != eINFLUENCETYPE_DEBUF )
			continue;

		SKILLMANAGER->DeleteInfluenceList( uniqueIdx );
	}
}


bool cSkillManager::ClientAuraInfluenceOff( unsigned long playerIdx, unsigned long uniqueIdx, unsigned long skillClassIdx )
{
	cInfluenceObject* pInfluenceObject = (cInfluenceObject*)mInfluenceMap.GetAt( uniqueIdx );
	if( pInfluenceObject == NULL )
		return false;

	/// ų ȣ  Ȯ
	if( pInfluenceObject->GetCopySkillClassIdx() != skillClassIdx )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("ClientAuraInfluenceOff skillClassIdx ERROR [%d,%d,%d]", playerIdx, uniqueIdx, skillClassIdx );
		return false;;
	}

	/// θ ȿ Ȯ
	if( pInfluenceObject->GetSwitchType() != eSWITCHTYPE_PARENT )
		return false;

	/// ȿ  Ȯ
	if( pInfluenceObject->GetTarget().index != playerIdx ||
		pInfluenceObject->GetTarget().type != eOBJECTTYPE_PLAYER )
	{
		/// ۵ ޼
		assert(NULL);
		NETWORK2->PostServerEvent("ClientAuraInfluenceOff Hack? player[%d,%d,%d]", playerIdx, uniqueIdx, skillClassIdx );
		return false;
	}

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer == NULL )
		return false;

	SKILLMANAGER->DeleteInfluence( pPlayer->GetObject(), uniqueIdx );

	return true;
}


void cSkillManager::AuraInfluenceOff( unsigned long playerIdx, unsigned long skillClassIdx )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer != NULL )
	{
		cHashSet* pInfSet = pPlayer->GetInfluenceSet();
		cHashSet::cIterator begin = pInfSet->Begin();
		cHashSet::cIterator end = pInfSet->End();

		unsigned long influenceIdx;
		while( begin != end )
		{
			influenceIdx = *begin++;

			cInfluenceObject* pInf = GetInfluence( influenceIdx );
			if( pInf == NULL )
			{
				NETWORK2->PostServerEvent("cSkillManager::AuraInfluenceOff pInf[%d] == NULL", playerIdx, skillClassIdx );
				//-/-//InsertDeleteInfluenceObject( pInf );	/// ü  ⿭ ִ´.
				continue;
			}

			if( pInf->GetCopySkillClassIdx() != skillClassIdx )
				continue;

			if( pInf->GetSwitchType() != eSWITCHTYPE_PARENT )
				continue;

			if( pInf->GetTarget().index != playerIdx ||
				pInf->GetTarget().type != eOBJECTTYPE_PLAYER )
				continue;

			SKILLMANAGER->DeleteInfluence( pPlayer->GetObject(), influenceIdx );
			return;
		}
	}
}

void cSkillManager::InfluenceOff( unsigned long playerIdx, unsigned long influenceClassIdx )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer != NULL )
	{
		cHashSet* pInfSet = pPlayer->GetInfluenceSet();
		cHashSet::cIterator i = pInfSet->Begin();
		cHashSet::cIterator end = pInfSet->End();

		for( ; i != end; ++i )
		{
			unsigned long uniqueIndex = (unsigned long)(*i);
			cInfluenceObject* pInf = GetInfluence( uniqueIndex );
			if( pInf == NULL )
			{
				NETWORK2->PostServerEvent("cSkillManager::InfluenceOff pInf[%d, %d, %d] == NULL", playerIdx, uniqueIndex, influenceClassIdx );
				continue;
			}

			if( pInf->GetInfluenceClassIdx() != influenceClassIdx )
				continue;

			if( pInf->GetTarget().index != playerIdx ||
				pInf->GetTarget().type != eOBJECTTYPE_PLAYER )
				continue;

			SKILLMANAGER->DeleteInfluence( pPlayer->GetObject(), uniqueIndex );
			return;
		}
	}
}


void cSkillManager::AddAuraChild( auraTemp auraChild )
{
	mAura.PushBack( auraChild );
}


void cSkillManager::DeleteInfluence( sObject target, unsigned long uniqueIdx )
{
	/// Ÿ ü Ͽ ִ ȿ ȣ .
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( pTarget != NULL )
	{
		pTarget->DeleteInfluence( uniqueIdx );
		pTarget->StatusCalc();
	}

	/// ȿ ü .
	cInfluenceObject* pInf = GetInfluence( uniqueIdx );
	if( pInf != NULL )
	{
		/// ۿ   ȿ  θۿ Ͽ 
		if( pInf->IsTotemInf() == true )
			pInf->TotemSetEraseTarget();

		if( pTarget )
		{
			///
			const int maximum = 3;
			sInfluenceScript* pScript = SKILLSCRIPT->GetInfluenceInfo( pInf->GetInfluenceClassIdx() );
			if( pScript != NULL )
			{
				unsigned short idx[maximum] = { pScript->mStatusPlusIdx1, pScript->mStatusPlusIdx2, pScript->mStatusPlusIdx3 };

				for( int i = 0 ; i < maximum ; ++i )
				{
					switch( idx[i] )
					{
					case eSTATUSPLUS_CHANGE_MONSTER:
						{
							if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
								((cPlayer*)pTarget)->EndChgMonster(); 
						}
						break;
					case eSTATUSPLUS_VEHICLE:
						{
							if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
								((cPlayer*)pTarget)->SendEndVehicle(); 
						}
						break;
					}
				}
			}
			else
				NETWORK2->PostServerEvent("cPlayer[%d,%d]::EraseSkillInfluence SKILLSCRIPT->GetInfluenceInfo(%d) == NULL", 
				target.type, target.index, pInf->GetInfluenceClassIdx() );

			///
			if( pInf->IsSendDelMsg() == true )
			{
				MSG_SYN_INFLUENCE_DELETE msg;
				msg.Category = NM_SKILL;
				msg.Protocol = NM_SKILL_INFLUENCE_DELETE_SYN;
				msg.mUniqueIdx = uniqueIdx;

				NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
			}
		}

		/// 
		SAFE_DELETE( pInf );
		mInfluenceMap.Erase( uniqueIdx );
	}

	if( pTarget != NULL )
		pTarget->StatusCalc();
}


void cSkillManager::DeleteInfluenceClassIdx( sObject target, unsigned long classIdx )
{
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( pTarget == NULL )
		return;

	cHashSet* pInfSet = pTarget->GetInfluenceSet();
	if( pInfSet == NULL )
		return;

	cHashSet::cIterator start = pInfSet->Begin();
	cHashSet::cIterator end = pInfSet->End();

	unsigned long infIdx = 0;
	cInfluenceObject* pInfluence = NULL;
	while( start != end )
	{
		infIdx = *start++;
		pInfluence = SKILLMANAGER->GetInfluence( infIdx );
		if( pInfluence == NULL )
		{
			NETWORK2->PostServerEvent("cSkillManager::DeleteInfluenceClassIdx  pInfluence[%d,%d] == NULL", target.type, target.index );
			continue;
		}

		if( pInfluence->GetInfluenceClassIdx() != classIdx )
			continue;        

		SKILLMANAGER->DeleteInfluenceList( infIdx );
	}
}


void cSkillManager::VehicleDeleteInfluence( sObject target, unsigned long uniqueIdx, bool sendSync )
{
	/// Ÿ ü Ͽ ִ ȿ ȣ .
	cBaseObject* pTarget = OBJECTMANAGER->GetObject( target.type, target.index );
	if( pTarget != NULL )
	{
		pTarget->DeleteInfluence( uniqueIdx );
		pTarget->StatusCalc();
	}

	/// ȿ ü .
	cInfluenceObject* pInf = GetInfluence( uniqueIdx );
	if( pInf != NULL )
	{
		if( pTarget )
		{
			///
			const int maximum = 3;
			sInfluenceScript* pScript = SKILLSCRIPT->GetInfluenceInfo( pInf->GetInfluenceClassIdx() );
			if( pScript != NULL )
			{
				unsigned short idx[maximum] = { pScript->mStatusPlusIdx1, pScript->mStatusPlusIdx2, pScript->mStatusPlusIdx3 };

				for( int i = 0 ; i < maximum ; ++i )
				{
					switch( idx[i] )
					{
					case eSTATUSPLUS_CHANGE_MONSTER:
						{
							if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
								((cPlayer*)pTarget)->EndChgMonster(); 
						}
						break;
					case eSTATUSPLUS_VEHICLE:
						{
							if( sendSync )
							{
								if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
									((cPlayer*)pTarget)->SendEndVehicleExcept(); 
							}
						}
						break;
					}
				}
			}
			else
				NETWORK2->PostServerEvent("cPlayer[%d,%d]::EraseSkillInfluence SKILLSCRIPT->GetInfluenceInfo(%d) == NULL", 
				target.type, target.index, pInf->GetInfluenceClassIdx() );

			///
			if( pInf->IsSendDelMsg() == true )
			{
				MSG_SYN_INFLUENCE_DELETE msg;
				msg.Category = NM_SKILL;
				msg.Protocol = NM_SKILL_INFLUENCE_DELETE_SYN;
				msg.mUniqueIdx = uniqueIdx;

				NETWORK2->QuickSend( pTarget, (char*)&msg, sizeof(msg) );
			}
		}

		/// 
		SAFE_DELETE( pInf );
		mInfluenceMap.Erase( uniqueIdx );
	}
}


void cSkillManager::DeleteInfluenceList( unsigned long uniqueIdx )
{
	cInfluenceObject* pInf = GetInfluence( uniqueIdx );
	if( pInf != NULL )
		pInf->DelReady(); 

	mDeleteInfluenceAry.PushBack( uniqueIdx );
}


void cSkillManager::ClientDeleteInfluenceObject( unsigned long playerIdx, unsigned long uniqueIdx )
{

	cInfluenceObject* pInfluenceObject = (cInfluenceObject*)mInfluenceMap.GetAt( uniqueIdx );
	if( pInfluenceObject == NULL )
		return;	/// ޼  ü 

	/// ۵ ޼
	if( pInfluenceObject->GetTarget().index != playerIdx ||
		pInfluenceObject->GetTarget().type != eOBJECTTYPE_PLAYER )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("ClientDeleteInfluenceObject Hack");
		return;
	}

	sInfluenceScript* pInflueneScript = SKILLSCRIPT->GetInfluenceInfo( pInfluenceObject->GetInfluenceClassIdx() );
	if( pInflueneScript == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("ClientDeleteInfluenceObject GetInfluenceInfo[%d]", pInfluenceObject->GetInfluenceClassIdx() );
		return;
	}

	///   û Ұ
	if( pInflueneScript->mType == eINFLUENCETYPE_DEBUF )
		return;

	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( playerIdx );
	if( pPlayer == NULL )
		return;
	
	DeleteInfluence( pPlayer->GetObject(), uniqueIdx );
	return;
}


bool cSkillManager::NeedAddPlayerHaveSkill( unsigned long skillIdx, unsigned char skillStep, unsigned long* money, unsigned short* sp )
{
	/// ÷̾ ųũƮ 
	sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
	if( !pSkillInfo )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::NeedAddPlayerHaveSkill pSkillInfo==NULL" );
		return false; 
	}

	/// ÷̾ ų ũƮ 
	if( skillStep < 0 || pSkillInfo->mStepCount <= skillStep )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::NeedAddPlayerHaveSkill pSkillInfo->mStepCount ERR" );
		return false; 
	}

	sPlayerSkillStepInfo* pSkillStep = &pSkillInfo->mpSetpInfoArray[skillStep];
	if( pSkillStep == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cSkillManager::NeedAddPlayerHaveSkill pSkillStep==NULL" );
		return false;
	}

	*money = pSkillStep->mUseMoney;
	*sp = pSkillStep->mRequireSP;

	return true;

}



void cSkillManager::UpdateSkillCoolTime( sObject attacker, unsigned long skillIdx, unsigned char skillStep, unsigned long /*accumTime*/, float speedFactor )
{
	/// ÷̾  ʹ   ִ
	switch( attacker.type )
	{
	case eOBJECTTYPE_HERO:
	case eOBJECTTYPE_PLAYER:
		{
			/// ÷̾ ųũƮ 
			sPlayerSkillBaseInfo* pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( skillIdx );
			if( !pSkillInfo )	
			{ 
				assert(NULL); 
				NETWORK2->PostServerEvent("cSkillManager::UpdateSkillCoolTime pSkillInfo[%d]==NULL", skillIdx );
				return; 
			}

			/// ÷̾ ų ũƮ 
			if( skillStep < 0 || pSkillInfo->mStepCount <= skillStep )	
			{ 
				assert(NULL); 
				NETWORK2->PostServerEvent("cSkillManager::UpdateSkillCoolTime pSkillInfo->mStepCount[%d] ERR", pSkillInfo->mStepCount );
				return; 
			}
			sPlayerSkillStepInfo* pSkillStep = &pSkillInfo->mpSetpInfoArray[skillStep];

			/// ÷̾ ų Ʈ ȹ
			cPointerHashMap* pHaveSkillMap = (cPointerHashMap*)GetPlayerHaveSkill( attacker.index );
			if( !pHaveSkillMap )	
			{ 
				assert(NULL); 
				NETWORK2->PostServerEvent("cSkillManager::UpdateSkillCoolTime pHaveSkillMap[%d]==NULL", attacker.index );
				return; 
			}

			/// Ÿ, ۷ι Ÿ   þ  
			if( pSkillInfo->mIsGlobalCoolTime == false && pSkillStep->mCoolTime == 0 )	
			{ 
				/// Ÿ µ ׷ ִ  ũƮ
				if( pSkillInfo->mGroupCoolTimeIdx != 0 )	
				{ 
					assert(NULL); 
					NETWORK2->PostServerEvent("pSkillInfo->mIsGlobalCoolTime == false && pSkillInfo->mGroupCoolTimeIdx != 0" );
				}
				return; 
			}

			/// ġ  Ÿ
			unsigned long fixCoolTime = (unsigned long)( pSkillStep->mCoolTime * ( 2.0f - speedFactor ) );
			///   ð
			if( fixCoolTime - SYNC_NORMALATTACK > 0 )
				fixCoolTime = fixCoolTime - SYNC_NORMALATTACK;
			else
			{
				fixCoolTime = 0; 
				assert(NULL);
				NETWORK2->PostServerEvent("cSkillManager::UpdateSkillCoolTime[%d] fixCoolTime == 0", skillIdx );
			}					

			/// ų 
			cHaveSkillObject* pHaveSkill = NULL;
			/// ų ų ⺻
			sPlayerSkillBaseInfo* pHaveSkillInfo = NULL;

			/// ׷   ڽŸ Ÿ 
			if( pSkillInfo->mGroupCoolTimeIdx == 0 )
			{
				pHaveSkill = GetPlayerHaveSkill( attacker.index, skillIdx );
				if( pHaveSkill == NULL ) 
				{ 
					assert(NULL); 
					NETWORK2->PostServerEvent("cSkillManager::UpdateSkillCoolTime GetPlayerHaveSkill[%d,%d]", attacker.index, skillIdx );
					return; 
				}

				pHaveSkill->UpdateCoolTime( fixCoolTime );
			}
			else
			{
				///  ų Ÿ  ׸ Ʈ
				cPointerHashMap::cIterator begin = pHaveSkillMap->Begin();
				cPointerHashMap::cIterator end = pHaveSkillMap->End();

				for( ; begin != end ; ++begin )
				{

					pHaveSkill = (cHaveSkillObject*)(*begin).mSecond;
					if( pHaveSkill == NULL )
					{
						assert(NULL);
						NETWORK2->PostServerEvent("cSkillManager::UpdateSkillCoolTime pHaveSkill==NULL" );
						continue;
					}             

					/// ׷ Ÿ ½ų 
					if( pSkillInfo->mGroupCoolTimeIdx == 0 )
						continue;

					/// ų  ų  ׷ üũ
					pHaveSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( pHaveSkill->GetSkillIdx() );
					if( !pHaveSkillInfo ) 
					{ 
						assert(NULL); 
						NETWORK2->PostServerEvent("cSkillManager::UpdateSkillCoolTime pHaveSkillInfo==NULL" );
						continue; 
					}

					if( pSkillInfo->mGroupCoolTimeIdx == pHaveSkillInfo->mGroupCoolTimeIdx )
					{
						///  ׷ΰ  ų Ÿ 
						pHaveSkill->UpdateCoolTime( fixCoolTime );
					}
				}
			}
		}break;
	}
}


void cSkillManager::AddSkillReset( unsigned long playerIdx, unsigned long skillIdx, unsigned char skillStep )
{
	/// playeridx ÷̾  ųƮ ͸ 
	cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( playerIdx );
	///  ųƮ 
	if ( !pPlayerHaveSkillMap )
	{
		/// ο ųƮ 
		pPlayerHaveSkillMap = new cPointerHashMap;

		///   ųƮ 
		if( !( mPlayerHaveSkillMap.Insert( playerIdx, pPlayerHaveSkillMap ) ) )
		{
			NETWORK2->PostServerEvent("AddSkillReset[%d,%d,%d] - mPlayerHaveSkillMap.Insert error", playerIdx, skillIdx, skillStep );
			SAFE_DELETE( pPlayerHaveSkillMap );
			return;
		}
	}

	/// ųƮ  
	cHaveSkillObject* pPlayerHaveSkill = new cHaveSkillObject;
	pPlayerHaveSkill->Init( skillIdx, skillStep, 0 );

	if( !(pPlayerHaveSkillMap->Insert( skillIdx, pPlayerHaveSkill ) ) )
	{
		NETWORK2->PostServerEvent("AddSkillReset[%d,%d,%d] - mPlayerHaveSkillMap.Insert error", playerIdx, skillIdx, skillStep  );
		SAFE_DELETE( pPlayerHaveSkill );
		return;
	}
}


bool cSkillManager::SaveSkillCoolTime( unsigned long playerIdx, SKILL_COOLTIME* skillCoolTime )
{

	skillCoolTime->mCharacterIdx = playerIdx;
	skillCoolTime->mRetvalue = 0;

	/// ÷̾ ų Ʈ ȹ
	cPointerHashMap* pHaveSkillMap = (cPointerHashMap*)GetPlayerHaveSkill( playerIdx );
	if( !pHaveSkillMap )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SaveSkillCoolTime pHaveSkillMap==NULL" );
		return false; 
	}

	cPointerHashMap::cIterator begin = pHaveSkillMap->Begin();
	cPointerHashMap::cIterator end = pHaveSkillMap->End();

	/// ų 
	cHaveSkillObject* pHaveSkill = NULL;
	long restTime = 0;
	unsigned long row = 0;

	for( ; begin != end ; ++begin )
	{
		pHaveSkill = (cHaveSkillObject*)((*begin).mSecond);
		if( pHaveSkill == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cSkillManager::SaveSkillCoolTime pHaveSkill==NULL" );
			continue;
		}

		/// ⺻  
		if( pHaveSkill->GetSkillIdx() <= NORMAL_ATTACK_SKILL_MAX )
			continue;

		///  Ÿ   
		if( pHaveSkill->DbSaveDataCoolTime() <= NETWORK2->GetAccumTime() )
			continue;

		///  ɽð DB_SAVE_COOLTIME ms ̻ ͵鸸 
		restTime = pHaveSkill->DbSaveDataCoolTime() - NETWORK2->GetAccumTime();
		if( restTime > DB_SAVE_COOLTIME && pHaveSkill->GetSkillIdx() != 0 )
		{
			skillCoolTime->mTable[row].mSkillIdx = pHaveSkill->GetSkillIdx();
			skillCoolTime->mTable[row].mSkillStep = pHaveSkill->GetSkillStep();
			skillCoolTime->mTable[row].mEndCoolTime = restTime;
			++row;
		}
	}

	skillCoolTime->mRowCount = row;

	return true;

}


bool cSkillManager::RestorePlayerSkill( SKILL_SELECT* skillSelect )
{
	///  ü 
	if( skillSelect->mRowCount >= 1 )
		ReleasePlayerHaveSkill( skillSelect->mCharacterIdx );

	/// ⺻(idx:0) ־ 
	SKILLMANAGER->AddPlayerHaveSkill( skillSelect->mCharacterIdx, NORMAL_ATTACK_SKILL, SKILL_START_STEP, 0 );

	long restTime;
	for ( long i = 0; i < skillSelect->mRowCount; i++ )
	{
		restTime = skillSelect->mTable[i].mEndCoolTime;

		///   ð Ȱ
		if( restTime < 0 )	{ restTime = 0; }

		/// playeridx ÷̾  ųƮ ͸ 
		cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( skillSelect->mCharacterIdx );
		///  ųƮ 
		if ( !pPlayerHaveSkillMap )
		{
			/// ο ųƮ 
			pPlayerHaveSkillMap = new cPointerHashMap;

			///   ųƮ 
			if( !( mPlayerHaveSkillMap.Insert( skillSelect->mCharacterIdx, pPlayerHaveSkillMap ) ) )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("cSkillManager::RestorePlayerSkill mPlayerHaveSkillMap.Insert duplicate" );
				SAFE_DELETE( pPlayerHaveSkillMap );
				return false;
			}
		}

		/// ųƮ  
		cHaveSkillObject* pPlayerHaveSkill = new cHaveSkillObject;
		pPlayerHaveSkill->RestoreInit( skillSelect->mTable[i].mSkillIdx, skillSelect->mTable[i].mSkillStep, restTime );

		if( !(pPlayerHaveSkillMap->Insert( skillSelect->mTable[i].mSkillIdx, pPlayerHaveSkill ) ) )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cSkillManager::RestorePlayerSkill pPlayerHaveSkillMap.Insert duplicate" );
			SAFE_DELETE( pPlayerHaveSkill );
			return false;
		}
	}

	return true;
}

void cSkillManager::SendMsgSkillHaveToPlayer( unsigned long connectionIdx, unsigned long characterIdx )
{
	HANDLE              handle  = NULL;
	MSG_RES_SKILL_LIST* sendMsg = (MSG_RES_SKILL_LIST*)NETWORK2->GetMsgRoot( &handle, connectionIdx, NM_SKILL, NM_SKILL_LIST_RES );

	if ( sendMsg != NULL )
	{
		cPointerHashMap* pPlayerHaveSkillMap = (cPointerHashMap*)mPlayerHaveSkillMap.GetAt( characterIdx );

		if( pPlayerHaveSkillMap )
		{
			cHaveSkillObject* pPlayerHaveSkill;

			cPointerHashMap::cIterator start = pPlayerHaveSkillMap->Begin();
			cPointerHashMap::cIterator end = pPlayerHaveSkillMap->End();

			unsigned char& row = (sendMsg->mRowCount = 0);
			for( ; start != end ; ++start )
			{
				pPlayerHaveSkill = (cHaveSkillObject*)(*start).mSecond;

				if( pPlayerHaveSkill == NULL )
				{
					assert(NULL);
					NETWORK2->PostServerEvent("cSkillManager::SendMsgSkillHaveToPlayer pPlayerHaveSkill==NULL" );
					continue;
				}

				if( pPlayerHaveSkill->GetSkillIdx() == 0 )	
					continue; 

				sendMsg->mTable[row].mSkillIdx     = pPlayerHaveSkill->GetSkillIdx();
				sendMsg->mTable[row].mSkillStep    = pPlayerHaveSkill->GetSkillStep();
				sendMsg->mTable[row].mRestCoolTime = pPlayerHaveSkill->GetRestTime();
				++row;
			}
		}

		NETWORK2->SendMsgRoot( handle, sendMsg->GetMsgLength( ) );
	}

	cPlayer* player = OBJECTMANAGER->GetPlayer( characterIdx );
	if( player )
		player->SendSkillPoint();
	else
		assert(0);
}



void cSkillManager::SendMsgInfluenceToPlayer( unsigned long connectionIdx, unsigned long characterIdx )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( characterIdx );
	if( !pPlayer )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SendMsgInfluenceToPlayer pPlayer[%d]==NULL", characterIdx);
		return; 
	}

	tHashSet<unsigned long>* pInfluenceSet = pPlayer->GetInfluenceSet();
	if( !pInfluenceSet )	
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent("cSkillManager::SendMsgInfluenceToPlayer pInfluenceSet==NULL" );
		return; 
	}

	cInfluenceObject* pInfluenceObject = NULL;

	tHashSet<unsigned long>::cIterator start = pInfluenceSet->Begin();
	tHashSet<unsigned long>::cIterator end = pInfluenceSet->End();

	HANDLE                  handle  = NULL;
	MSG_RES_INFLUENCE_LIST* sendMsg = (MSG_RES_INFLUENCE_LIST*)NETWORK2->GetMsgRoot( &handle, connectionIdx, NM_SKILL, NM_SKILL_INFLUENCE_LIST_RES );

	if ( sendMsg != NULL )
	{
		unsigned char& row = (sendMsg->mRowCount = 0);
		for( ; start != end ; ++start )
		{
			pInfluenceObject = GetInfluence( (*start) );
			if( pInfluenceObject == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("cSkillManager::SendMsgInfluenceToPlayer pInfluenceObject[%d]==NULL", (*start) );
				//-/-//InsertDeleteInfluenceObject( pInfluenceObject );	/// ü  ⿭ ִ´.
				continue;
			}

			sendMsg->mTable[row].mUniqueIdx         = pInfluenceObject->GetUniqueIdx();
			sendMsg->mTable[row].mInfluenceClassIdx = pInfluenceObject->GetInfluenceClassIdx();
			sendMsg->mTable[row].mAuraSkillClassIdx = pInfluenceObject->GetCopySkillClassIdx();
			sendMsg->mTable[row].mRestTime          = pInfluenceObject->GetInfluenceRestTime();	
			sendMsg->mTable[row].mDieDelete         = pInfluenceObject->GetDieDelete();
			++row;
		}

		NETWORK2->SendMsgRoot( handle, sendMsg->GetMsgLength( ) );
	}
}



void cSkillManager::SendAddSynMsgInfluenceToPlayer( unsigned long connectionIdx, unsigned long characterIdx )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( characterIdx );
	if( !pPlayer )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SendAddSynMsgInfluenceToPlayer pPlayer[%d]==NULL", characterIdx );
		return; 
	}

	tHashSet<unsigned long>* pInfluenceSet = pPlayer->GetInfluenceSet();
	if( !pInfluenceSet )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SendAddSynMsgInfluenceToPlayer pInfluenceSet==NULL" );
		return; 
	}

	cInfluenceObject* pInfluenceObject = NULL;

	tHashSet<unsigned long>::cIterator start = pInfluenceSet->Begin();
	tHashSet<unsigned long>::cIterator end = pInfluenceSet->End();

	HANDLE                     handle  = NULL;
	MSG_SYN_INFLUENCE_ADDLIST* sendMsg = (MSG_SYN_INFLUENCE_ADDLIST*)NETWORK2->GetMsgRoot( &handle, connectionIdx, NM_SKILL, NM_SKILL_INFLUENCE_ADDLIST_SYN );

	if ( sendMsg != NULL )
	{
		sendMsg->mObject.type  = eOBJECTTYPE_PLAYER;
		sendMsg->mObject.index = characterIdx;

		unsigned char& row = (sendMsg->mRowCount = 0);
		for( ; start != end ; ++start )
		{
			pInfluenceObject = GetInfluence( (*start) );

			if( pInfluenceObject == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("cSkillManager::SendAddSynMsgInfluenceToPlayer pInfluenceObject[%d]==NULL", (*start) );
				//-/-//InsertDeleteInfluenceObject( pInfluenceObject );	/// ü  ⿭ ִ´.
				continue;
			}

			sendMsg->mTable[row].mUniqueIdx         = pInfluenceObject->GetUniqueIdx();
			sendMsg->mTable[row].mInfluenceClassIdx = pInfluenceObject->GetInfluenceClassIdx();
			sendMsg->mTable[row].mDieDelete			= pInfluenceObject->GetDieDelete();
			sendMsg->mTable[row].mRestTime          = pInfluenceObject->GetInfluenceRestTime();
			++row;
		}

		NETWORK2->SendMsgRoot( handle, sendMsg->GetMsgLength( ) );
	}
}



void cSkillManager::SendDelSynMsgInfluenceToPlayer( unsigned long connectionIdx, unsigned long characterIdx )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( characterIdx );
	if( !pPlayer )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SendAddSynMsgInfluenceToPlayer pPlayer[%d]==NULL", characterIdx );
		return; 
	}

	tHashSet<unsigned long>* pInfluenceSet = pPlayer->GetInfluenceSet();
	if( !pInfluenceSet )	
	{ 
		assert(NULL); 
		NETWORK2->PostServerEvent("cSkillManager::SendAddSynMsgInfluenceToPlayer pInfluenceSet==NULL" );
		return; 
	}

	cInfluenceObject* pInfluenceObject = NULL;

	tHashSet<unsigned long>::cIterator start = pInfluenceSet->Begin();
	tHashSet<unsigned long>::cIterator end = pInfluenceSet->End();

	HANDLE                     handle  = NULL;
	MSG_SYN_INFLUENCE_DELLIST* sendMsg = (MSG_SYN_INFLUENCE_DELLIST*)NETWORK2->GetMsgRoot( &handle, connectionIdx, NM_SKILL, NM_SKILL_INFLUENCE_DELLIST_SYN );

	if ( sendMsg != NULL )
	{
		sendMsg->mObject.type  = eOBJECTTYPE_PLAYER;
		sendMsg->mObject.index = characterIdx;

		unsigned char& row = (sendMsg->mRowCount = 0);
		for( ; start != end ; ++start )
		{
			pInfluenceObject = GetInfluence( (*start) );

			if( pInfluenceObject == NULL )
			{
				assert(NULL);
				NETWORK2->PostServerEvent("cSkillManager::SendDelSynMsgInfluenceToPlayer pInfluenceObject[%d]==NULL", (*start) );
				//-/-//InsertDeleteInfluenceObject( pInfluenceObject );	/// ü  ⿭ ִ´.
				continue;
			}

			sendMsg->mUniqueIdx[row] = pInfluenceObject->GetUniqueIdx();
			++row;
		}

		NETWORK2->SendMsgRoot( handle, sendMsg->GetMsgLength( ) );
	}
}
