/* ==========================================================================
*      : SkillManager.h
*      : 
*    : ڰ
*    : 2007-07-06
* ǻ :
*===========================================================================*/
#pragma once

#include "HashMap.h"
#include "PointerHashMap.h"
#include "Pool.h"

#include "../Common/BaseObject_Common.h"

#include "PlayerSkillObject.h"
#include "MonsterSkillObject.h"
#include "PlayerMonSkillObject.h"
#include "InfluenceObject.h"
#include "HaveSkillObject.h"

#include "DramaturgyManager.h"
#include "IndexGenerator.h"

#include "SQLGameStmt.h"
#include "RangeCheck.h"

class cBaseObject;
class cSkillScript;
class cCommunityScript;
class cMakeSkillScript;
class cPlayer;
class cInfluenceObject;

enum eObject;
enum eAURATYPE;

const long DB_SAVE_COOLTIME = 5000;
const long SYNC_NORMALATTACK = 100;

struct sDelSkillInfo
{
	sObject			skillUser;
	unsigned long	mSkillIdx;
};

struct auraTemp
{
	sObject target;
	unsigned long influenceClassIdx;
	sObject attacker;
	unsigned long skillClassIdx;
	bool msgSend;
	unsigned long parentUniqueIdx;
};

class cSkillManager
{
public:

	static cSkillManager* mpSkillManager;

public:

	cSkillManager();
	~cSkillManager();

	bool				Init();
	void				Release();
	void				Process( unsigned long elapsedTime, unsigned long accumTime );


	/*------------------ Ǯ  ݳϱ ------------------ */
	///  ų
	cPlayerSkillObject*	AllocPlayerSkillObject() { return mPlayerSkillObjectPool.Alloc(); }
	void				FreePlayerSkillObject(cPlayerSkillObject* ptr) { mPlayerSkillObjectPool.Free(ptr); }
	cMonsterSkillObject*	AllocMonsterSkillObject() { return mMonsterSkillObjectPool.Alloc(); }
	void				FreeMonsterSkillObject(cMonsterSkillObject* ptr) { mMonsterSkillObjectPool.Free(ptr); }
	cPlayerMonSkillObject*	AllocPlayerMonSkillObject() { return mPlayerMonSkillObjectPool.Alloc(); }
	void				FreePlayerMonSkillObject(cPlayerMonSkillObject* ptr) { mPlayerMonSkillObjectPool.Free(ptr); }
	///  ȿ
	cInfluenceObject*	AllocInfluenceObject() { return mInfluenceObjectPool.Alloc(); }
	void				FreeInfluenceObject(cInfluenceObject* ptr) { mInfluenceObjectPool.Free(ptr); }
	///  ų
	cHaveSkillObject*	AllocHaveSkillObject() { return mPlayerHaveSkillPool.Alloc(); }
	void				FreeHaveSkillObject(cHaveSkillObject* ptr) { mPlayerHaveSkillPool.Free(ptr); }


	/*---------------  ų ó ---------------*/
	/// DB 
	bool				SaveSkillCoolTime( unsigned long playerIdx, SKILL_COOLTIME* skillCoolTime );
	bool				RestorePlayerSkill( SKILL_SELECT* skillSelect );
	/// ų  ˻ ׸ 
	bool				NeedAddPlayerHaveSkill( unsigned long skillIdx, unsigned char skillStep, unsigned long *money, unsigned short *sp );
	/// db н ų ܰ谨
	void				RollBackPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx );
	///  ų ߰
	unsigned char		AddPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx, unsigned char skillStep, unsigned long cooltime );
	cHaveSkillObject*	GetPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx );
	void*				GetPlayerHaveSkill( unsigned long playerIdx );

	///  ų 
	void				ReleasePlayerHaveSkill( unsigned long playerIdx );

	/// ų   ų Ÿ Ʈ
	void				UpdateSkillCoolTime( sObject attacker, unsigned long skillIdx, unsigned char skillStep, unsigned long accumTime, float speedFactor );

	void				AddSkillReset( unsigned long playerIdx, unsigned long skillIdx, unsigned char skillStep );

	/*--------------- ų(+Ϲ)  ó ---------------*/
	/// Ϲ 
	void				PlayerNormalAttackRequest( unsigned long characterIdx, MSG_REQ_SKILL_USED* pMsg );
	/// Ʈ Ÿ ų
	void				PlayerObjectSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_USED* pMsg, bool casting );
	/// ǥ Ÿ ų
	void				PlayerPositionSkillRequest( unsigned long characterIdx, MSG_REQ_POS_USED* pMsg, bool casting );
	///   ų
	void				PlayerMonSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_USED* pMsg, bool casting );
	/// ̵ ų
	void				MapChangeSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_ITEMMAPCHANGE* pMsg );
	/// Ż ų
	void				VehiCleSkillRequest( unsigned long characterIdx, MSG_REQ_SKILL_VEHICLE* pMsg );

	///  
	bool				MonsterAttack( unsigned long monsterIdx, eMONSTERATTACK_TYPE attackType, sObject target );

	/// ų    üũ
	bool				IsUsingSkill( unsigned char type, unsigned long objectIdx );
	unsigned long		SkillLeftEndTime( unsigned char type, unsigned long objectIdx );

	/// ĳ  ų  
	void				CastSkillCancel( sObject attacker );

	///  ų
	bool				DeleteSkillObject( unsigned char type, unsigned long objectIdx, unsigned long skillUniqueIdx );
	void				InsertDeleteSkillObject( sObject skillUser, unsigned long skillUniqueIdx );


	/// ųü Ҹ Ű  Ű ȯ
	void				DelSkillUniqueIdx( unsigned long uniqueIdx ) { mSkillGen.DelIdx( uniqueIdx ); }


	/*--------------- ȿ ó ---------------*/ 
	/// DB 
	bool				SavePlayerInfluence( unsigned long playerIdx, SKILL_INFLUENCE_INSERT* pInfluenceInsert );
	void				RestorePlayerInfluence( unsigned long playerIdx, SKILL_INFLUENCE_SELECT* pInfluenceSelect, unsigned long rowCnt );

	/// ų  ȿ 
	bool				AddInfluence( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, bool msgSend );
	unsigned long		AddInfSwitch( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, bool msgSend );
	bool				AddInfChildAura( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, 
		unsigned long parentIdx, bool msgSend );
	bool				AddInfChildTotem( sObject attacker, sObject target, unsigned long infClassIdx, unsigned long skillClassIdx, 
		unsigned long parentIdx, bool msgSend );
	bool				ItemCheckAddInf( cBaseObject* pAttacker, cBaseObject* pTarget, unsigned long infClassIdx );
	bool				ApplyInfluence( cBaseObject* pAttacker, cBaseObject* pTarget, unsigned long infObjectIdx, unsigned long infClassIdx, 
		unsigned long type, long value );

	void				AddAuraChild( auraTemp auraChild );

	cInfluenceObject*	GetInfluence( unsigned long uniqueIdx )	{ return (cInfluenceObject*)mInfluenceMap.GetAt( uniqueIdx ); }

	///  ȿ 
	void				DeleteInfluence( sObject target, unsigned long uniqueIdx );
	void				DeleteInfluenceClassIdx( sObject target, unsigned long classIdx );
	void				VehicleDeleteInfluence( sObject target, unsigned long uniqueIdx, bool sendSync = true );
	/// Ʈ ( )
	void				DeleteInfluenceList( unsigned long uniqueIdx );

	///  ȿ 
	bool				ClientAuraInfluenceOff( unsigned long playerIdx, unsigned long uniqueIdx, unsigned long skillClassIdx );
	void				AuraInfluenceOff( unsigned long playerIdx, unsigned long skillClassIdx );
	
	void				InfluenceOff( unsigned long playerIdx, unsigned long influenceClassIdx );

	/// Ŭ̾Ʈ ȿ ޼ 
	void				ClientDeleteInfluenceObject( unsigned long playerIdx, unsigned long uniqueIdx );

	/// ȿ 
	void				DispelInfluence( sObject target, unsigned long influenceTypeDetail );
	void				DispelInfluenceAll( sObject target );

	/// ȿü Ҹ Ű  Ű ȯ
	void				DelInfluenceUniqueIdx( unsigned long uniqueIdx ) { mInfluenceGen.DelIdx( uniqueIdx ); }

	/*--------------- ÷̾  ó ---------------*/
	///  ε  ߼
	void				SendMsgSkillHaveToPlayer( unsigned long connectionIdx, unsigned long characterIdx );
	void				SendMsgInfluenceToPlayer( unsigned long connectionIdx, unsigned long characterIdx );
	/// ׸ in/out ũ ޼ ߼
	void				SendAddSynMsgInfluenceToPlayer( unsigned long connectionIdx, unsigned long characterIdx );
	void				SendDelSynMsgInfluenceToPlayer( unsigned long connectionIdx, unsigned long characterIdx );
	/*-----------------------------------------*/


private:

	void				InsertPlayerSkillMap( unsigned long characterIdx, cBaseSkillObject* pSkillObject );
	void				InsertMonsterSkillMap( unsigned long monsterIdx, cMonsterSkillObject* pSkillObject );

	/// ų Ʈ ó
	bool				DelPlayerHaveSkill( unsigned long playerIdx, unsigned long skillIdx );
	void				ReleasePlayerHaveSkill();

	/// ȿ Ʈ ó
	void				ReleaseInfluence();

private:

	/// ÷̾ ų ü  pool
	typedef tPool<cPlayerSkillObject>	cPlayerSkillObjectPool;
	cPlayerSkillObjectPool	mPlayerSkillObjectPool;
	typedef tPool<cMonsterSkillObject>	cMonsterSkillObjectPool;
	cMonsterSkillObjectPool	mMonsterSkillObjectPool;
	typedef tPool<cPlayerMonSkillObject>	cPlayerMonSkillObjectPool;
	cPlayerMonSkillObjectPool	mPlayerMonSkillObjectPool;
	/// ȿ ü  pool
	typedef tPool<cInfluenceObject> cInfluenceObjectPool;
	cInfluenceObjectPool	mInfluenceObjectPool;
	///  ų  pool
	typedef tPool<cHaveSkillObject> cHaveSkillObjectPool;
	cHaveSkillObjectPool	mPlayerHaveSkillPool;

	typedef tArray<void*>	cArray;
	typedef tPointerHashMap<unsigned long, void*> cPointerHashMap;
	typedef tPointerHashMap<unsigned long, cPlayer*> cPlayerMap;
	typedef tHashSet<unsigned long> cHashSet;

	///   ųü  ؽ
	//typedef tPointerHashMap<unsigned long, tArray<cSkillObject*>*> cSkillObjectHashMap;
	cPointerHashMap		mPlayerSkillMap;
	cPointerHashMap		mMonsterSkillMap;

	/// ÷̾  ų Ʈ
	///  playeridx skillidx  ˻ ־ map map ϴ · 
	//typedef tPointerHashMap<unsigned long, cHaveSkillObject*> cPlayerHaveSkillMap;
	//typedef tPointerHashMap<unsigned long, cPlayerHaveSkillMap*> cPlayerSkillPointerHashMap;
	cPointerHashMap		mPlayerHaveSkillMap;

	/// ȿ ü  - Ʈ ڽſ ´ ȿ ͸  ִ.
	//typedef tPointerHashMap<unsigned long, cInfluenceObject*> cInfluenceMap;
	cPointerHashMap		mInfluenceMap;

	/// ׸迭
	tArray<sDelSkillInfo> mDeleteSkillAry;
	tArray<unsigned long> mDeleteInfluenceAry;

	/// ų ũƮ  δ
	cSkillScript*		mpSkillScript;

	/// Ŀ´Ƽ ũƮ  ε
	cCommunityScript*	mpCommuScript;

	/// ų   δ
	cDramaturgyManager	mDramaturgyManager;

	///  
	cMakeSkillScript*	mpMakeSkillScript;

	/// ε 
	cIndexGenerator		mSkillGen;
	cIndexGenerator		mInfluenceGen;

	/// Ÿ üũ
	cRangeCheck			mRangeCheck;

	typedef tArray<auraTemp>	cAura;
	cAura				mAura;
};

#define SKILLMANAGER	cSkillManager::mpSkillManager

