#include "stdafx.h"
#include "statuscalc_Server.h"
#include "GameSrv.h"
#include "Player.h"
#include "Monster.h"
#include "ObjectManager.h"
#include "StatusScript.h"
#include "Skill_Common.h"
#include "HaveSkillObject.h"
#include "InfluenceObject.h"
#include "SkillManager.h"
#include "SkillScript.h"
#include "MonsterScript.h"

cStatusCalc_Server* cStatusCalc_Server::mpStatusCalc = NULL;


cStatusCalc_Server::cStatusCalc_Server(void)
{
	if( !mpStatusCalc )
	{
		mpStatusCalc = this;
	}
}



cStatusCalc_Server::~cStatusCalc_Server(void)
{
}



void cStatusCalc_Server::CalcPlayerStatusItemSkillAddDetail( eSTATUS_PLUS statusType, float value )
{
	unsigned long arrayNum = 0;

	if( eSTATUSPLUS_STR_PLUS <= statusType && statusType < eSTATUSPLUS_BASE_MAX )
	{
		arrayNum = statusType - eSTATUSPLUS_STR_PLUS;
		mBaseStatusPlus[arrayNum] = mBaseStatusPlus[arrayNum] + value;
	}
	else if( eSTATUSPLUS_ATK_PLUS <= statusType && statusType <= eSTATUSPLUS_SKILL_HP_PLUS_PLUS )
	{
		arrayNum = statusType - eSTATUSPLUS_ATK_PLUS;
		mExtStatusPlus[arrayNum] = mExtStatusPlus[arrayNum] + value;
	}
	/// ݷ ü +
	else if( eSTATUSPLUS_ATKTOTAL_PLUS == statusType )
	{
		mExtStatusPlus[ePLAYER_STATUS_EXT_ATK] += value;
		mExtStatusPlus[ePLAYER_STATUS_EXT_RATK] += value;
		mExtStatusPlus[ePLAYER_STATUS_EXT_MATK] += value;			
	}
	///  ü +
	else if( eSTATUSPLUS_DEFTOTAL_PLUS == statusType )
	{
		mExtStatusPlus[ePLAYER_STATUS_EXT_DEF] += value;
		mExtStatusPlus[ePLAYER_STATUS_EXT_MDEF] += value;
	}
	else if( eSTATUSPLUS_ATK_PER <= statusType && statusType <= eSTATUSPLUS_SKILL_HP_PLUS_PER )
	{
		arrayNum = statusType - eSTATUSPLUS_ATK_PER;
		mExtStatusPer[arrayNum] = mExtStatusPer[arrayNum] + value;
	}
	/// ݷ ü %
	else if( eSTATUSPLUS_ATKTOTAL_PER == statusType )
	{
		mExtStatusPer[ePLAYER_STATUS_EXT_ATK] += value;
		mExtStatusPer[ePLAYER_STATUS_EXT_RATK] += value;
		mExtStatusPer[ePLAYER_STATUS_EXT_MATK] += value;			
	}
	///  ü %
	else if( eSTATUSPLUS_DEFTOTAL_PER == statusType )
	{
		mExtStatusPer[ePLAYER_STATUS_EXT_DEF] += value;
		mExtStatusPer[ePLAYER_STATUS_EXT_MDEF] += value;
	}
	else if( eSTATUSPLUS_EXPADDPER <= statusType && statusType < eSTATUSPLUS_BUFF_ETC_MAX )
	{
		arrayNum = statusType - eSTATUSPLUS_EXPADDPER;
		mExtAddStatus[arrayNum] = mExtAddStatus[arrayNum] + value;
	}
	else if( eSTATUSPLUS_CHAR_SIZE <= statusType && statusType < eSTATUSPLUS_TAROT_MAX )
	{
		switch( statusType )
		{
			/// ĳ ũ 
		case eSTATUSPLUS_CHAR_SIZE:		
			mSizePer = mSizePer + (short)FloatToInt(value); 
			break;
		}
	}
	else
	{
		switch( statusType )
		{
		case eSTATUSPLUS_STOPMOVE:	mOddity[eODDITYTYPE_CANTMOVE] += 1; break;
		case eSTATUSPLUS_STOPSKILL:	mOddity[eODDITYTYPE_CANTSKILL] += 1; break;
		case eSTATUSPLUS_SLEEP:		mOddity[eODDITYTYPE_SLEEP] += 1; break;
		case eSTATUSPLUS_STUN:		mOddity[eODDITYTYPE_STUN] += 1; break;
		case eSTATUSPLUS_INVINCIBILITY_PHY:	mOddity[eODDITYTYPE_INVINCIBILITY_PHY] += 1; break;
		case eSTATUSPLUS_INVINCIBILITY_MAG:	mOddity[eODDITYTYPE_INVINCIBILITY_MAG] += 1; break;
		case eSTATUSPLUS_HP_ABSORB_LONG:	mOddity[eODDITYTYPE_HP_ABSORB] += (long)value; break;
		case eSTATUSPLUS_MP_ABSORB_LONG:	mOddity[eODDITYTYPE_MP_ABSORB] += (long)value; break;
		case eSTATUSPLUS_STOPITEM_KIND:		mOddity[eODDITYTYPE_STOPITEM_KIND] += (long)value; break;
		case eSTATUSPLUS_STOPITEM_IDX:		mOddity[eODDITYTYPE_STOPITEM_IDX] += (long)value; break;
		case eSTATUSPLUS_DAMAGE_ABSORB_PHY:	mOddity[eODDITYTYPE_DAMAGE_ABSORB_PHY] += (long)value; break;
		case eSTATUSPLUS_DAMAGE_ABSORB_MAG:	mOddity[eODDITYTYPE_DAMAGE_ABSORB_MAG] += (long)value; break;
		case eSTATUSPLUS_DAMAGE_REFLECT_PHY:	mOddity[eODDITYTYPE_DAMAGE_REFLECTION_PHY] += (long)value; break;
		case eSTATUSPLUS_DAMAGE_REFLECT_MAG:	mOddity[eODDITYTYPE_DAMAGE_REFLECTION_MAG] += (long)value; break;
		}
	}
}



void cStatusCalc_Server::CalcPlayerBaseOnly( cPlayer* pPlayer )
{

	/// ⺻  ʱȭ
	for( unsigned char i = ePLAYER_STATUS_STR ; ePLAYER_STATUS_LEVEL > i ; ++i )
		mBaseStatus[i] = 0.0f;

	/// ũƮ о  ⺻ ݰ 
	CalcPlayerStatus( pPlayer );

	/// ⺻   ÷̾ 
	for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL ; ++i )
		pPlayer->SetStatus1( (ePLAYER_STATUS)i, mBaseStatus[i] );
}



void cStatusCalc_Server::CalcPlayerExtensionOnly( cPlayer* pPlayer )
{

	/// 1 + ʱȭ
	memset( mBaseStatusPlus, 0, sizeof(mBaseStatusPlus) );

	/// 2 + ʱȭ
	memset( mExtStatusPlus, 0, sizeof(mExtStatusPlus) );

	/// 2 % ʱȭ
	memset( mExtStatusPer, 0, sizeof(mExtStatusPer) );

	/// ġ 
	memset( mExtAddStatus, 0, sizeof(mExtAddStatus) );

	/// ̻ 
	memset( mOddity, 0, sizeof(mOddity) );

	///   ׸   ȭ	
	mSizePer = 0;		/// ĳ ũ⺯ȭ

	/// ųȿ, ųнú,  Ÿ о  ġ 
	CalcPlayerStatusSkillInfluenceAdd( pPlayer );
	CalcPlayerStatusSkillPassiveAdd( pPlayer );
	CalcPlayerStatusItemAdd( pPlayer );

	pPlayer->StateOddity( mOddity );

	/// Ȯ  ÷̾ 
	memcpy( pPlayer->GetPointerStatus2Plus(), mExtStatusPlus, sizeof(pPlayer->GetPointerStatus2Plus()) * ePLAYER_STATUS_EXT_MAX );
	memcpy( pPlayer->GetPointerStatus2Per(), mExtStatusPer, sizeof(pPlayer->GetPointerStatus2Per()) * ePLAYER_STATUS_EXT_MAX );

	for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL ; ++i )
		pPlayer->SetStatus1Plus( (ePLAYER_STATUS)i, mBaseStatusPlus[i] );

	for( unsigned char i = ePLAYER_STATUS_EXT_ADD_EXPADDPER ; i < ePLAYER_STATUS_EXT_ADD_MAX ; ++i )
		pPlayer->SetStatusEtc( (ePLAYER_STATUS_EXT_ADD)i, mExtAddStatus[i] );
}



unsigned long cStatusCalc_Server::GetParantJob( unsigned long job, unsigned int jobPos )
{

	unsigned long jobCode;

	///   θ  迭 ޾ƿ´.
	tArray<unsigned long>* pParentJob = NULL;

	///   ڵ带 о
	pParentJob = STATUSSCRIPT->GetParentJob( job );

	/// Ͱ  -   ⺻  ̴.
	if( pParentJob == NULL )
		return NULL;

	///  ũ -    ̴.
	if( jobPos > pParentJob->GetSize() - 1 )
		return NULL;

	///   شϴ  ڵ带 о.
	pParentJob->GetAt( &jobCode, jobPos );

	return jobCode;
}



void cStatusCalc_Server::CalcPlayerStatusSkillInfluenceAdd( cPlayer* pPlayer )
{
	cHashSet::cIterator iter;

	///  ȿ ġ 
	cHashSet* influenceSet = pPlayer->GetInfluenceSet();
	if( influenceSet == NULL )
		return;

	cInfluenceObject* pInfluence = NULL;
	sInfluenceScript* pInfluenceScript = NULL;
	unsigned long infIdx = 0;
	for( iter = influenceSet->Begin() ; iter != influenceSet->End() ; ++iter )
	{
		infIdx = *iter;
		pInfluence = SKILLMANAGER->GetInfluence( infIdx );
		if( pInfluence == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcPlayerStatusSkillInfluenceAdd pInfluence[%d]==NULL", *iter);
			//-/-//SKILLMANAGER->InsertDeleteInfluenceObject( pInfluence );	/// ü  ⿭ ִ´.
			continue;
		}		

		pInfluenceScript = SKILLSCRIPT->GetInfluenceInfo( pInfluence->GetInfluenceClassIdx() );
		/// ()  ȿ ƴѰ츸
		if( pInfluenceScript->mTime1 == 0 )
		{
			if( pInfluenceScript->mStatusPlusIdx1 != 0 )
			{
				CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx1),
					(float)(pInfluenceScript->mValue1) );
			}
		}
		if( pInfluenceScript->mTime2 == 0 )
		{
			if( pInfluenceScript->mStatusPlusIdx2 != 0 )
			{
				CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx2),
					(float)(pInfluenceScript->mValue2) );
			}
		}
		if( pInfluenceScript->mStatusPlusIdx3 != 0 )
		{
			CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx3),
				(float)(pInfluenceScript->mValue3) );
		}
	}
}



void cStatusCalc_Server::CalcPlayerStatusSkillPassiveAdd( cPlayer* pPlayer )
{
	///  ȿ ġ 
	cPointerHashMap::cIterator iter;

	cPointerHashMap* pHaveMap = (cPointerHashMap*)SKILLMANAGER->GetPlayerHaveSkill( pPlayer->GetObjectID() );
	if( pHaveMap == NULL )
		return;

	cHaveSkillObject* pSkillObject = NULL;
	sPlayerSkillBaseInfo* pSkillInfo = NULL;
	sPlayerSkillStepInfo* pSkillStep = NULL;
	for( iter = pHaveMap->Begin() ; iter != pHaveMap->End() ; ++iter )
	{

		pSkillObject = (cHaveSkillObject*)((*iter).mSecond);
		if( pSkillObject == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcPlayerStatusSkillPassiveAdd pSkillObject == NULL");
			continue;
		}

		pSkillInfo = SKILLSCRIPT->GetPlayerSkillInfo( pSkillObject->GetSkillIdx() );
		if( pSkillInfo == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcPlayerStatusSkillPassiveAdd pSkillInfo == NULL");
			continue;
		}

		if( pSkillInfo->mType != eSKILLTYPE_PASSIVE )
			continue;

		pSkillStep = &pSkillInfo->mpSetpInfoArray[pSkillObject->GetSkillStep()];
		if( pSkillStep == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcPlayerStatusSkillPassiveAdd pSkillStep == NULL");
			continue;
		}


		///   ´ üũ
		bool IsEquipment = true;
		if( pSkillInfo->mUseEquipment )
		{
			eWEAPON_STATE weaponState = pPlayer->GetWeaponState();

			///   üũ
			switch( pSkillInfo->mUseEquipment )
			{
			case eEQUIPTYPE_SWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment = false;
				break;
			case eEQUIPTYPE_LONGSWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD:
				if( weaponState != eWEAPON_STATE_SHORTSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_GUN:
				if( weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_STAFF:
				if( weaponState != eWEAPON_STATE_STAFF )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHIELD:
				if( weaponState != eWEAPON_STATE_SHEILD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SWORD_LONGSWORD_DOUBLESWORD:
				if( weaponState != eWEAPON_STATE_SWORD &&
					weaponState != eWEAPON_STATE_SWORD_SHEILD &&
					weaponState != eWEAPON_STATE_LONGSWORD &&
					weaponState != eWEAPON_STATE_DOUBLESWORD )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_SHORTSWORD_GUN:
				if( weaponState != eWEAPON_STATE_SHORTSWORD &&
					weaponState != eWEAPON_STATE_GUN )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_CLOTH:
				if( pPlayer->GetArmorSets() != ARMOR_SETS_ROBES )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_LIGHTARMOR:
				if( pPlayer->GetArmorSets() != ARMOR_SETS_LIGHT_ARMOR )
					IsEquipment =  false;
				break;
			case eEQUIPTYPE_HEAVYARMOR:
				if( pPlayer->GetArmorSets() != ARMOR_SETS_HEAVY_ARMOR )
					IsEquipment =  false;
				break;
			}
		}

		///  ´ 츸 
		if( IsEquipment == true )
		{
			if( pSkillStep->mApplyValueType1 != 0 )
			{
				CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pSkillStep->mApplyValueType1),
					(float)(pSkillStep->mApplyValue1) );
			}
			if( pSkillStep->mApplyValueType2 != 0 )
			{
				CalcPlayerStatusItemSkillAddDetail( (eSTATUS_PLUS)(pSkillStep->mApplyValueType2),
					(float)(pSkillStep->mApplyValue2) );
			}
		}
	}
}



void cStatusCalc_Server::CalcPlayerStatusItemAdd( cPlayer* pPlayer )
{
	sEquipAbility* pEquipAbility = pPlayer->GetEquipAbility();
	if( pEquipAbility == NULL )
		return;

	///     Ǵ ׸ 
	if( pEquipAbility->mOptStr != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_STR_PLUS, (float)pEquipAbility->mOptStr );
	}
	if( pEquipAbility->mOptDex != 0 )	/// :ø
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_DEX_PLUS, (float)pEquipAbility->mOptDex );
	}
	if( pEquipAbility->mOptCon != 0 )	/// :ü
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_CON_PLUS, (float)pEquipAbility->mOptCon );
	}
	if( pEquipAbility->mOptInt != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_INT_PLUS, (float)pEquipAbility->mOptInt );
	}
	if( pEquipAbility->mOptWis != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_WIS_PLUS, (float)pEquipAbility->mOptWis );
	}

	if( pEquipAbility->mOptPlusWei != 0 )	/// :
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_WEIGHT_PLUS, (float)pEquipAbility->mOptPlusWei );
	}
	if( pEquipAbility->mOptPlusMov != 0 )	/// :̵ӵ
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_SPD_PLUS, (float)pEquipAbility->mOptPlusMov );
	}
	if( pEquipAbility->mOptPlusMaxHp != 0 )	/// :ִHP 
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_HP_PLUS, (float)pEquipAbility->mOptPlusMaxHp );
	}
	if( pEquipAbility->mOptPlusMaxMp != 0 )	/// :ִMP 
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_MP_PLUS, (float)pEquipAbility->mOptPlusMaxMp );
	}

	if( pEquipAbility->mOptPercentDrainHp != 0 )	// HP 
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_HP_ABSORB_LONG, (float)pEquipAbility->mOptPercentDrainHp );
	}
	if( pEquipAbility->mOptPercentDrainMp != 0 )	// MP 
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_MP_ABSORB_LONG, (float)pEquipAbility->mOptPercentDrainMp );
	}
	if( pEquipAbility->mOptPercentDamageDec != 0 )	//  /
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_DAMAGE_ABSORB_PHY, (float)pEquipAbility->mOptPercentDamageDec );
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_DAMAGE_ABSORB_MAG, (float)pEquipAbility->mOptPercentDamageDec );
	}
	if( pEquipAbility->mOptPercentDamageRef != 0 )	//  ݻ
	{
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_DAMAGE_REFLECT_PHY, (float)pEquipAbility->mOptPercentDamageRef );
		CalcPlayerStatusItemSkillAddDetail( eSTATUSPLUS_DAMAGE_REFLECT_MAG, (float)pEquipAbility->mOptPercentDamageRef );
	}
}



void cStatusCalc_Server::CalcStatusPlusDetailMonster( unsigned long monsterIdx, eSTATUS_PLUS statusType, float value )
{
	///   
	cMonster* pMonster = OBJECTMANAGER->GetMonster( monsterIdx );
	if( pMonster == NULL ) 
	{ 
		assert(NULL);
		NETWORK2->PostServerEvent("cStatusCalc_Server::CalcStatusPlusDetailMonster pMonster == NULL");
		return; 
	}

	switch( statusType )
	{
	case eSTATUSPLUS_ATK_PLUS:	{ pMonster->GetStatusPlus()->mPhysicAttack += value; }break;
	case eSTATUSPLUS_RATK_PLUS:	{ pMonster->GetStatusPlus()->mPhysicRangeAttack += value; }break;
	case eSTATUSPLUS_DEF_PLUS:	{ pMonster->GetStatusPlus()->mPhysicDefense += value; }break;
	case eSTATUSPLUS_MATK_PLUS:	{ pMonster->GetStatusPlus()->mMagicAttack += value; }break;
	case eSTATUSPLUS_MDEF_PLUS:	{ pMonster->GetStatusPlus()->mMagicDefense += value; }break;
	case eSTATUSPLUS_CRI_PLUS:	{ pMonster->GetStatusPlus()->mPhysicCritical += value; }break;
	case eSTATUSPLUS_MCRI_PLUS:	{ pMonster->GetStatusPlus()->mMagicCritical += value; }break;
	case eSTATUSPLUS_HP_PLUS:	{ pMonster->GetStatusPlus()->mMaxHP += value; } break;
	case eSTATUSPLUS_MP_PLUS:	{ pMonster->GetStatusPlus()->mMaxMP += value; } break;
	case eSTATUSPLUS_HIT_PLUS:	{ pMonster->GetStatusPlus()->mPhysicAttackRate += value; }break;
	case eSTATUSPLUS_MHIT_PLUS:	{ pMonster->GetStatusPlus()->mMagicAttackRate += value; }break;
	case eSTATUSPLUS_AVOID_PLUS:	{ pMonster->GetStatusPlus()->mAvoid += value; }break;
	case eSTATUSPLUS_ASPD_PLUS:	{ pMonster->GetStatusPlus()->mAttackSpeed += value; }break;
	case eSTATUSPLUS_COOLTIME_PLUS:	{ pMonster->GetStatusPlus()->mCooltime += value; }break;
	case eSTATUSPLUS_RANGE_PLUS:	{ pMonster->GetStatusPlus()->mInRange += value; }break;
	case eSTATUSPLUS_RRANGE_PLUS:	{ pMonster->GetStatusPlus()->mOutRange += value; }break;
	case eSTATUSPLUS_SPD_PLUS:	{ pMonster->GetStatusPlus()->mMoveSpeed += value; }break;

	case eSTATUSPLUS_ATK_PER:	{ pMonster->GetStatusPer()->mPhysicAttack += value; }break;
	case eSTATUSPLUS_RATK_PER:	{ pMonster->GetStatusPer()->mPhysicRangeAttack += value; }break;
	case eSTATUSPLUS_DEF_PER:	{ pMonster->GetStatusPer()->mPhysicDefense += value; }break;
	case eSTATUSPLUS_MATK_PER:	{ pMonster->GetStatusPer()->mMagicAttack += value; }break;
	case eSTATUSPLUS_MDEF_PER:	{ pMonster->GetStatusPer()->mMagicDefense += value; }break;
	case eSTATUSPLUS_CRI_PER:	{ pMonster->GetStatusPer()->mPhysicCritical += value; }break;
	case eSTATUSPLUS_MCRI_PER:	{ pMonster->GetStatusPer()->mMagicCritical += value; }break;
	case eSTATUSPLUS_HP_PER:	{ pMonster->GetStatusPer()->mMaxHP += value; } break;
	case eSTATUSPLUS_MP_PER:	{ pMonster->GetStatusPer()->mMaxMP += value; } break;
	case eSTATUSPLUS_HIT_PER:	{ pMonster->GetStatusPer()->mPhysicAttackRate += value; }break;
	case eSTATUSPLUS_MHIT_PER:	{ pMonster->GetStatusPer()->mMagicAttackRate += value; }break;
	case eSTATUSPLUS_AVOID_PER:	{ pMonster->GetStatusPer()->mAvoid += value; }break;
	case eSTATUSPLUS_ASPD_PER:	{ pMonster->GetStatusPer()->mAttackSpeed += value; }break;
	case eSTATUSPLUS_COOLTIME_PER:	{ pMonster->GetStatusPer()->mCooltime += value; }break;
	case eSTATUSPLUS_RANGE_PER:	{ pMonster->GetStatusPer()->mInRange += value; }break;
	case eSTATUSPLUS_RRANGE_PER:	{ pMonster->GetStatusPer()->mOutRange += value; }break;
	case eSTATUSPLUS_SPD_PER:	{ pMonster->GetStatusPer()->mMoveSpeed += value; }break;

	case eSTATUSPLUS_STOPMOVE:	mOddity[eODDITYTYPE_CANTMOVE] += 1; break;
	case eSTATUSPLUS_STOPSKILL:	mOddity[eODDITYTYPE_CANTSKILL] += 1; break;
	case eSTATUSPLUS_SLEEP:		mOddity[eODDITYTYPE_SLEEP] += 1; break;
	case eSTATUSPLUS_STUN:		mOddity[eODDITYTYPE_STUN] += 1; break;
	case eSTATUSPLUS_INVINCIBILITY_PHY:	mOddity[eODDITYTYPE_INVINCIBILITY_PHY] += 1; break;
	case eSTATUSPLUS_INVINCIBILITY_MAG:	mOddity[eODDITYTYPE_INVINCIBILITY_MAG] += 1; break;
	case eSTATUSPLUS_HP_ABSORB_LONG:	mOddity[eODDITYTYPE_HP_ABSORB] += (long)value; break;
	case eSTATUSPLUS_MP_ABSORB_LONG:	mOddity[eODDITYTYPE_MP_ABSORB] += (long)value; break;
	case eSTATUSPLUS_STOPITEM_KIND:		mOddity[eODDITYTYPE_STOPITEM_KIND] += (long)value; break;
	case eSTATUSPLUS_STOPITEM_IDX:		mOddity[eODDITYTYPE_STOPITEM_IDX] += (long)value; break;
	case eSTATUSPLUS_DAMAGE_ABSORB_PHY:	mOddity[eODDITYTYPE_DAMAGE_ABSORB_PHY] += (long)value; break;
	case eSTATUSPLUS_DAMAGE_ABSORB_MAG:	mOddity[eODDITYTYPE_DAMAGE_ABSORB_MAG] += (long)value; break;
	case eSTATUSPLUS_DAMAGE_REFLECT_PHY:	mOddity[eODDITYTYPE_DAMAGE_REFLECTION_PHY] += (long)value; break;
	case eSTATUSPLUS_DAMAGE_REFLECT_MAG:	mOddity[eODDITYTYPE_DAMAGE_REFLECTION_MAG] += (long)value; break;
	}
}



void cStatusCalc_Server::CalcMonster( unsigned long monsterIdx )
{

	cMonster* pMonster = OBJECTMANAGER->GetMonster( monsterIdx );
	if( pMonster == NULL )	
	{ 
		NETWORK2->PostServerEvent("cStatusCalc_Server::CalcMonster pMonster[%d] == NULL", monsterIdx );
		return; 
	}

	mMoveSpeed = pMonster->GetMoveSpeed();

	/// Ϳ ɸ ȿ  о
	cHashSet* influenceSet = pMonster->GetInfluenceSet();
	if( influenceSet == NULL )
		return;

	sMonsterStatus* pStatusPlus = pMonster->GetStatusPlus();
	if( pStatusPlus == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cStatusCalc_Server::CalcMonster pStatusPlus == NULL" );
		return;
	}

	sMonsterStatus* pStatusPer = pMonster->GetStatusPer();
	if( pStatusPer == NULL )
	{
		assert(NULL);
		NETWORK2->PostServerEvent("cStatusCalc_Server::CalcMonster pStatusPer == NULL" );
		return;
	}

	memset( pStatusPlus, 0, sizeof(sMonsterStatus) );
	memset( pStatusPer, 0, sizeof(sMonsterStatus) );
	memset( mOddity, 0, sizeof(mOddity) );

	cInfluenceObject* pInfluence = NULL;
	sInfluenceScript* pInfluenceScript = NULL;

	cHashSet::cIterator iter = influenceSet->Begin();
	cHashSet::cIterator end = influenceSet->End();

	while( iter != end )
	{
		pInfluence = SKILLMANAGER->GetInfluence( *iter++ );
		if( pInfluence == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcMonster pInfluence == NULL" );
			//-/-//SKILLMANAGER->InsertDeleteInfluenceObject( pInfluence );	/// ü  ⿭ ִ´.
			continue;
		}		

		pInfluenceScript = SKILLSCRIPT->GetInfluenceInfo( pInfluence->GetInfluenceClassIdx() );
		/// ()  ȿ ƴѰ츸
		if( pInfluenceScript->mTime1 == 0 )
		{
			if( pInfluenceScript->mStatusPlusIdx1 != 0 )
			{
				CalcStatusPlusDetailMonster( monsterIdx, (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx1),
					(float)(pInfluenceScript->mValue1) );
			}
		}
		if( pInfluenceScript->mStatusPlusIdx2 != 0 )
		{
			CalcStatusPlusDetailMonster( monsterIdx, (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx2),
				(float)(pInfluenceScript->mValue2) );
		}
		if( pInfluenceScript->mStatusPlusIdx3 != 0 )
		{
			CalcStatusPlusDetailMonster( monsterIdx, (eSTATUS_PLUS)(pInfluenceScript->mStatusPlusIdx3),
				(float)(pInfluenceScript->mValue3) );
		}
	}

	pMonster->StateOddity( mOddity );

	/// ̵ ӵ Ѱ Ŭ̾Ʈ 
	if( pMonster->GetMoveSpeed() != mMoveSpeed )
	{
		pMonster->SendMoveSpeed();
	}
}


void cStatusCalc_Server::CalcPlayerStatus( cPlayer* pPlayer )
{
	unsigned char level = pPlayer->GetLevel();
	ePLAYER_JOB job = pPlayer->GetJob();

	/// Ŭ1   
	unsigned char class1 = 30;
	/// Ŭ2  
	unsigned char class2 = 70;

	sStatusBaseScript* pStatusBase = NULL;

	/// ڱ ڽſ شϴ  statusbase  
	pStatusBase = STATUSSCRIPT->GetStatusBaseInfo( job );

	/// ڽſ شϴ     оͼ óѴ.
	if( pStatusBase == NULL )
	{
		///   迭 о´.
		tArray<unsigned long>* playerJobParent = STATUSSCRIPT->GetParentJob( job );
		if( playerJobParent == NULL )
		{
			/// ڽ  µ θ   
			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcPlayerStatus parantJob[%d] == NULL", job );
			return; 
		}
		else
		{

			///    
			for( int i = playerJobParent->GetSize() - 1 ; 0 <= i  ; --i )
			{
				///  ڵ ũƮ  о
				pStatusBase = STATUSSCRIPT->GetStatusBaseInfo( (*playerJobParent)[i] );
				if( pStatusBase != NULL )
				{
					break;
				}
			}

			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcPlayerStatus playerJobParentAry == NULL" );
		}
	}

	/// Է  ⺻  ġ  
	for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL ; ++i )
	{
		mBaseStatus[i] = pStatusBase->mBaseStatus[i];
	}

	///       ޾ƾ ڵ
	unsigned long fixjob = job;

	sStatusMultiplScript* pStatusMultipl;

	///   1   ( 0 ⺻ 1 ġ )
	for( unsigned char j = 1 ; j <= level ; ++j )
	{

		/// 1 1(30) ⺻ ڵ  
		if( ( 1 <= j ) && ( j < class1 ) )
		{
			///   Ʈ 1  
			fixjob = GetParantJob( job, 0 );
			///     ⺻ ̶ θ  
			if( fixjob == NULL )
			{
				///      ڵ 
				fixjob = job;
			}
		}

		/// 1(30) 2(70) 1
		else if( ( class1 <= j ) && ( j < class2 ) )
		{
			///   Ʈ 1  
			fixjob = GetParantJob( job, 1 );
			///     1 
			if( fixjob == NULL )
			{
				fixjob = job;
			}
		}

		/// 2(30)  Ѱ 
		else if( class2 <= j )
		{
			///   Ʈ 2  
			fixjob = GetParantJob( job, 2 );
			///     2 
			if( fixjob == NULL )
			{
				fixjob = job;
			}
		}

		///   ´  ڵ  ġ 
		pStatusMultipl = STATUSSCRIPT->GetStatusMultiplInfo( fixjob );
		if( pStatusMultipl == NULL )
		{
			assert(NULL);
			NETWORK2->PostServerEvent("cStatusCalc_Server::CalcPlayerStatus pStatusMultipl[%d] == NULL", fixjob);
			return;
		}

		for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL ; ++i )
		{
			/// Ŭؿ  ġ ŭ 
			mBaseStatus[i] = mBaseStatus[i] + pStatusMultipl->mBaseStatus[i];
		}
	}
}



void cStatusCalc_Server::CalcPlayerExtStatus( cPlayer* pPlayer, ePLAYER_STATUS_EXT statusExt )
{
	ePLAYER_JOB job = pPlayer->GetJob();

	/// ÷̾ 1  о + 
	float baseStatus[ePLAYER_STATUS_LEVEL_MAX];
	unsigned char i = ePLAYER_STATUS_STR;
	for( ; i < ePLAYER_STATUS_LEVEL ; ++i )
	{
		baseStatus[i] = mBaseStatus[i] + mBaseStatusPlus[i];
		if( baseStatus[i] < 0.0f )
			baseStatus[i] = 0.0f;
	}
	baseStatus[i] = pPlayer->GetLevel(); 

	///    
	float			statusValue = 0.0f;

	/// ڿȸHP/MP ⺻ [ĳͽȸġ]  ʰ ڿȸ Ѵ.
	if( statusExt == ePLAYER_STATUS_EXT_RECOVHP || statusExt == ePLAYER_STATUS_EXT_RECOVMP )
	{
		statusValue = 0.0f;
	}
	else
	{
		/// ڽ   ̶   ִ üũ
		statusValue = STATUSSCRIPT->GetStatusExtBaseInfo( statusExt, job );
		//if( FloatToInt(statusValue) == 0 )
		//{
		//	if( playerJobParent != 0 )
		//	{
		//		///    
		//		for( int i = playerJobParent->GetSize() - 1 ; 0 <= i  ; --i )
		//		{
		//			///  ڵ ũƮ  о
		//			statusValue = STATUSSCRIPT->GetStatusExtBaseInfo( statusExt, (*playerJobParent)[i] );

		//			if( FloatToInt(statusValue) != 0 )
		//			{
		//				break;
		//			}
		//		}
		//	}
		//	else
		//	{
		//		statusValue = 0.0f;
		//	}
		//}
	}


	/// ÷̾ ֻ(1)  
	tArray<unsigned long>* playerJobParent = STATUSSCRIPT->GetParentJob( job );
	unsigned long firstJob = job;
	if( playerJobParent != NULL )
		firstJob = (*playerJobParent)[0];

	/// 1   ݷ  ġ о ׸ 
	unsigned long plusStatus = 0;
	switch( firstJob )
	{		
	case ePLAYER_FIGHTER:	/// 
	case ePLAYER_WARRIOR:	/// 
		plusStatus = 0;
		break;
	case ePLAYER_RANGER:	/// 
	case ePLAYER_ROGUE:		/// α
		plusStatus = 1;
		break;
	case ePLAYER_MAGE:		/// 
	case ePLAYER_SHAMAN:	/// 
		plusStatus = 2;
		break;
	}

	float importance = 0.0f;
	for( unsigned char i = ePLAYER_STATUS_STR ; i < ePLAYER_STATUS_LEVEL_MAX ; ++i )
	{
        eEXT_MULTIPL chgStatusExt = eEXT_MULTIPL_MAX;
		switch( statusExt )
		{
		case ePLAYER_STATUS_EXT_ATK:
            chgStatusExt = (eEXT_MULTIPL)( eEXT_MULTIPL_ATK_FIGHTER + plusStatus );	/// ٰŸ, Ÿ,    ݷ ׸ 
			break;
		case ePLAYER_STATUS_EXT_RATK:
			chgStatusExt = (eEXT_MULTIPL)( eEXT_MULTIPL_RATK_FIGHTER + plusStatus );
			break;
		case ePLAYER_STATUS_EXT_MATK:
			chgStatusExt = (eEXT_MULTIPL)( eEXT_MULTIPL_MATK_FIGHTER + plusStatus );
			break;
		case ePLAYER_STATUS_EXT_DEF:		chgStatusExt = eEXT_MULTIPL_DEF;		break;	///  
		case ePLAYER_STATUS_EXT_MDEF:		chgStatusExt = eEXT_MULTIPL_MDEF;		break;	///  
		case ePLAYER_STATUS_EXT_CRI:		chgStatusExt = eEXT_MULTIPL_CRI;		break;	///  ũƼ ġ
		case ePLAYER_STATUS_EXT_MCRI:		chgStatusExt = eEXT_MULTIPL_MCRI;		break;	///  ũƼ ġ
		case ePLAYER_STATUS_EXT_MAXHP:		chgStatusExt = eEXT_MULTIPL_MAXHP;		break;	/// HP 
		case ePLAYER_STATUS_EXT_MAXMP:		chgStatusExt = eEXT_MULTIPL_MAXMP;		break;	/// MP
		case ePLAYER_STATUS_EXT_RECOVHP:	chgStatusExt = eEXT_MULTIPL_RECOVHP;	break;	/// HP ȸ ӵ
		case ePLAYER_STATUS_EXT_RECOVMP:	chgStatusExt = eEXT_MULTIPL_RECOVMP;	break;	/// MP ȸ ӵ
		case ePLAYER_STATUS_EXT_HIT:		chgStatusExt = eEXT_MULTIPL_HIT;		break;	///  ġ
		case ePLAYER_STATUS_EXT_MHIT:		chgStatusExt = eEXT_MULTIPL_MHIT;		break;	///  
		case ePLAYER_STATUS_EXT_AVOID:		chgStatusExt = eEXT_MULTIPL_AVOID;		break;	/// ȸ ġ
		case ePLAYER_STATUS_EXT_WEIGHT:		chgStatusExt = eEXT_MULTIPL_WEIGHT;		break;	///  
		case ePLAYER_STATUS_EXT_RANGE:		chgStatusExt = eEXT_MULTIPL_RANGE;		break;	/// Ÿ
		case ePLAYER_STATUS_EXT_RRANGE:		chgStatusExt = eEXT_MULTIPL_RRANGE;		break;	/// Ÿ
		case ePLAYER_STATUS_EXT_COOLTIME:	chgStatusExt = eEXT_MULTIPL_COOLTIME;	break;	/// Ÿ
		case ePLAYER_STATUS_EXT_SPD:		chgStatusExt = eEXT_MULTIPL_SPD;		break;	/// ̵ӵ
		case ePLAYER_STATUS_EXT_ASPD:		chgStatusExt = eEXT_MULTIPL_ASPD;		break;	///  ӵ	
		}

		/// ̽  ߰ Ѵ.
		importance = STATUSSCRIPT->GetStatusExtMultiplInfo( chgStatusExt, (ePLAYER_STATUS)i );
		statusValue += baseStatus[i] * importance;
	}

	///  ̵ ӵ ̹ ִ (ͺ) ó
	if( statusExt == ePLAYER_STATUS_EXT_SPD && pPlayer->GetMoveSpeed() != 0 )
		mExtStatus[statusExt] = (float)pPlayer->GetMoveSpeed();
	else	///   
		mExtStatus[statusExt] = mExtStatus[statusExt] + statusValue;

	if( mExtStatus[statusExt] < 0.0f ) 
		mExtStatus[statusExt] = 0.0f;
}



void cStatusCalc_Server::CalcPlayerInit( sObject object )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( object.index );
	if( pPlayer != NULL )
	{
		mMoveSpeed = pPlayer->GetMoveSpeed();
		mAttackSpeed = pPlayer->GetStatus2()->mAttackSpeed;
		mSizePer = pPlayer->GetFixedObjectSizePer();
		mMaxHP = pPlayer->GetMaxHP();
		mMaxMP = pPlayer->GetMaxMP();

		pPlayer->InitStatus2();

		CalcPlayerBaseOnly( pPlayer );
		CalcPlayerExtensionOnly( pPlayer );
		CalcPlayerGlobal( pPlayer );
	}
}



void cStatusCalc_Server::CalcPlayerBaseGlobal( sObject object )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( object.index );
	if( pPlayer != NULL )
	{
		mMoveSpeed = pPlayer->GetMoveSpeed();
		mAttackSpeed = pPlayer->GetStatus2()->mAttackSpeed;
		mSizePer = pPlayer->GetFixedObjectSizePer();
		mMaxHP = pPlayer->GetMaxHP();
		mMaxMP = pPlayer->GetMaxMP();

		pPlayer->InitStatus2();

		mBaseStatusPlus[ePLAYER_STATUS_STR] = (float)pPlayer->GetStatus1Plus()->mStr;
		mBaseStatusPlus[ePLAYER_STATUS_DEX] = (float)pPlayer->GetStatus1Plus()->mDex;
		mBaseStatusPlus[ePLAYER_STATUS_CON] = (float)pPlayer->GetStatus1Plus()->mCon;
		mBaseStatusPlus[ePLAYER_STATUS_INT] = (float)pPlayer->GetStatus1Plus()->mInt;
		mBaseStatusPlus[ePLAYER_STATUS_WIS] = (float)pPlayer->GetStatus1Plus()->mWis;

		memcpy( mExtStatusPlus, pPlayer->GetPointerStatus2Plus(), sizeof(mExtStatusPlus) );
		memcpy( mExtStatusPer, pPlayer->GetPointerStatus2Per(), sizeof(mExtStatusPer) );

		mExtAddStatus[ePLAYER_STATUS_EXT_ADD_EXPADDPER] = (float)pPlayer->GetStatusEtc()->mExpAddPer;
		mExtAddStatus[ePLAYER_STATUS_EXT_ADD_EXPADDPLUS] = (float)pPlayer->GetStatusEtc()->mExpAddPlus; 
		mExtAddStatus[ePLAYER_STATUS_EXT_ADD_SXPADDPER] = (float)pPlayer->GetStatusEtc()->mSxpAddPer;
		mExtAddStatus[ePLAYER_STATUS_EXT_ADD_SXPADDPLUS] = (float)pPlayer->GetStatusEtc()->mSxpAddPlus;

		CalcPlayerBaseOnly( pPlayer );
		CalcPlayerGlobal( pPlayer );
	}
}



void cStatusCalc_Server::CalcPlayerExtensionGlobal( sObject object )
{
	cPlayer* pPlayer = OBJECTMANAGER->GetPlayer( object.index );
	if( pPlayer != NULL )
	{
		mMoveSpeed = pPlayer->GetMoveSpeed();
		mAttackSpeed = pPlayer->GetStatus2()->mAttackSpeed;
		mSizePer = pPlayer->GetFixedObjectSizePer();
		mMaxHP = pPlayer->GetMaxHP();
		mMaxMP = pPlayer->GetMaxMP();
		
		pPlayer->InitStatus2();

		mBaseStatus[ePLAYER_STATUS_STR] = (float)pPlayer->GetStatus1()->mStr;
		mBaseStatus[ePLAYER_STATUS_DEX] = (float)pPlayer->GetStatus1()->mDex;
		mBaseStatus[ePLAYER_STATUS_CON] = (float)pPlayer->GetStatus1()->mCon;
		mBaseStatus[ePLAYER_STATUS_INT] = (float)pPlayer->GetStatus1()->mInt;
		mBaseStatus[ePLAYER_STATUS_WIS] = (float)pPlayer->GetStatus1()->mWis;

		CalcPlayerExtensionOnly( pPlayer );
		CalcPlayerGlobal( pPlayer );
	}
}



void  cStatusCalc_Server::CalcPlayerGlobal( cPlayer* pPlayer )
{

	/// 2 ̽ ʱȭ
	for( int i = ePLAYER_STATUS_EXT_ATK ; ePLAYER_STATUS_EXT_MAX > i ; ++i )
	{
		mExtStatus[i] = 0;
	}

	/// 2 
	for( int i = ePLAYER_STATUS_EXT_ATK ; ePLAYER_STATUS_EXT_MAX > i ; ++i )
	{
		mExtStatusLast[i] = 0;
	}

	float num1, num2, num3, num4;
	float valueA, valueB, valueC;

	sEquipAbility* pItem = pPlayer->GetEquipAbility();

	for( unsigned char i = ePLAYER_STATUS_EXT_ATK ; i < ePLAYER_STATUS_EXT_MAX ; ++i )
	{
		/// ũƮ о  2  
		CalcPlayerExtStatus( pPlayer , (ePLAYER_STATUS_EXT)i );

		///      ׸ 
		switch( (ePLAYER_STATUS_EXT)i )
		{
			/// ٰŸ  
		case ePLAYER_STATUS_EXT_ATK:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 301 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 302 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 303 );

				/// A =	ĳ  ٰŸ ݷ
				/// B =	  ݷ + ( [ĳ] Lv * {num301} )
				/// C =	(({num302} + (  ٰŸ ݷ[%] + ۿɼǰ[%] ) / {num303})
				///	((A + B ) * C) + (  ٰŸ ݷ[+-] + ۿɼǰ[+-] )
				valueA = mExtStatus[i];
				valueB = pItem->mPhysicMinAttack + ( pPlayer->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_ATKMin, mExtStatusLast[i] );

				valueB = pItem->mPhysicMaxAttack + ( pPlayer->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;
					
				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_ATKMax, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			/// Ÿ  
		case ePLAYER_STATUS_EXT_RATK:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 331 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 332 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 333 );

				/// A =	ĳ  Ÿ ݷ
				/// B =	  ݷ + ( [ĳ] Lv * {num331} )
				/// C =	(({num332} + (  ٰŸ ݷ[%] + ۿɼǰ[%] ) / {num333})
				///	((A + B ) * C) + (  ٰŸ ݷ[+-] + ۿɼǰ[+-] )
				valueA = mExtStatus[i];
				valueB = pItem->mPhysicMinAttack + ( pPlayer->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_RATKMin, mExtStatusLast[i] );

				valueB = pItem->mPhysicMaxAttack + ( pPlayer->GetLevel() * num1 );
				valueC = ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentPhysicAttack ) / num3 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_RATKMax, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			///  
		case ePLAYER_STATUS_EXT_DEF:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 401 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 402 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 403 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 404 );

				// A =	ĳ ȹ 
				// B =	  
				// C =	(( {num401} + (   [%] + ۿɼ[%] ) ) / {num402} )
				// D =	((A /{num403}  + B /{num404}) * C) + (   [+-] + ۿɼ[+-] )
				valueA = mExtStatus[i];
				valueB = pItem->mPhysicDefense;
				valueC = ( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentPhysicDefense ) ) / num2 );
				mExtStatusLast[i] = ( ( valueA / num3 + valueB / num4 ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicDefense;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			///  
		case ePLAYER_STATUS_EXT_MATK:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 361 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 362 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 363 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 364 );

				/// A =	ĳ   ݷ / {num361}
				/// B =	  ݷ + ( [ĳ] Lv * {num362} )
				/// C =	(({num363} + (   ݷ[%] + ۿɼ[%] ) ) / {num364})
				///	((A + B ) * C) + (   ݷ[+-] + ۿɼ[+-] )
				valueA = mExtStatus[i] / num1;
				valueB = pItem->mMagicMinAttack + ( pPlayer->GetLevel() * num2 );
				valueC = ( ( num3 + ( mExtStatusPer[i] + pItem->mOptPercentMagicAttack ) ) / num4 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusMagicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_MATKMin, mExtStatusLast[i] );

				valueB = pItem->mMagicMaxAttack + ( pPlayer->GetLevel() * num2 );
				valueC = ( ( num3 + ( mExtStatusPer[i] + pItem->mOptPercentMagicAttack ) ) / num4 );
				mExtStatusLast[i] = ( ( valueA + valueB ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusMagicAttack;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_MATKMax, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			///  
		case ePLAYER_STATUS_EXT_MDEF:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 431 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 432 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 433 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 434 );

				// A =	ĳ ȸ 
				// B =	  
				// C =	(( {num431} + (   [%] + ۿɼ[%] ) ) / {num432} )
				// D =	((A /{num433}  + B /{num434}) * C) + (   [+-] + ۿɼ[+-] )
				valueA = mExtStatus[i];
				valueB = pItem->mMagicDefense;
				valueC = ( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentMagicDefense ) ) / num2 );
				mExtStatusLast[i] = ( ( valueA / num3 + valueB / num4 ) * valueC ) + mExtStatusPlus[i] + pItem->mOptPlusMagicDefense;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			///   ũ
		case ePLAYER_STATUS_EXT_CRI:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 201 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 202 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 203 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 204 );

				/// A =	[] ĳ   ũƼ ġ +   ũƼ ġ
				///	( A * {num201} ) * (({num202} + (   ũƼ [%] + ۿɼ[%] ) ) /
				///	{num203}) + (   ũƼ ġ[+-] + ۿɼ[+-] ) * {num204} )
				valueA = mExtStatus[i] + pItem->mPhysicCritical;
				mExtStatusLast[i] = ( valueA * num1 ) * ( ( num2 + ( mExtStatusPer[i] + pItem->mOptPercentPhysicCritical ) ) / num3 ) +
					( ( mExtStatusPlus[i] + pItem->mOptPlusPhysicCritical ) * num4 );

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}break;
			///	  ũ
		case ePLAYER_STATUS_EXT_MCRI:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 231 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 232 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 233 );
				num4 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 234 );

				/// A =	[] ĳ   ũƼ ġ +   ũƼ ġ
				///	( A * {num231} ) * (({num232} + (   ũƼ [%] + ۿɼ[%] ) ) / 
				/// {num233}) + ( (   ũƼ ġ[+-] + ۿɼ[+-] ) * {num234} )
				valueA = mExtStatus[i] + pItem->mMagicCritical;
				mExtStatusLast[i] = ( valueA * num1 ) * ( ( num2 + ( mExtStatusPer[i] + pItem->mOptPercentMagicCritical ) ) / num3 ) + 
					( ( mExtStatusPlus[i] + pItem->mOptPlusMagicCritical ) * num4 );

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}break;
			/// ִ HP
		case ePLAYER_STATUS_EXT_MAXHP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 20 );

				/// ⺻ hp + (  * num1 )
				mExtStatus[i] = mExtStatus[i] + ( pPlayer->GetLevel() * num1 );                
				mExtStatusLast[i] = mExtStatus[i] * ( ( 100 + ( mExtStatusPer[i] + pItem->mOptPercentMaxHp ) ) / 100 )
					+ mExtStatusPlus[i] + pItem->mOptPlusMaxHp;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// ִ MP
		case ePLAYER_STATUS_EXT_MAXMP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 20 );

				mExtStatusLast[i] = mExtStatus[i] * ( ( 100 + ( mExtStatusPer[i] + pItem->mOptPercentMaxMp ) ) / 100 ) + 
					mExtStatusPlus[i] + pItem->mOptPlusMaxMp;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// HP ڿ ȸ
		case ePLAYER_STATUS_EXT_RECOVHP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1001 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1002 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1003 );

				float defaultValueHP = STATUSSCRIPT->GetStatusExtBaseInfo( (ePLAYER_STATUS_EXT)i, pPlayer->GetJob() );

				/// A =	Ŭ ⺻
				///	B =	( ĳ  ȸ ġ * {num1001} ) * (( {num1002} +  HPȸ [%] + ۿɼ[%] ) / {num1003} ) + ۿ  HP ȸ ġ 
				///	A + B +  HPȸ [+-]
				valueA = defaultValueHP;
				valueB = ( mExtStatus[i] * num1 ) * ( ( num2 + ( mExtStatusPer[i] + pItem->mOptPercentHp ) ) / num3 ) + pItem->mOptPlusHp;
				mExtStatusLast[i] = valueA + valueB + mExtStatusPlus[i];

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// MP ڿ ȸ
		case ePLAYER_STATUS_EXT_RECOVMP:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1101 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1102 );
				num3 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1103 );

				float defaultValueMP = STATUSSCRIPT->GetStatusExtBaseInfo( (ePLAYER_STATUS_EXT)i, pPlayer->GetJob() );

				/// A =	Ŭ ⺻
				///	B =	( ĳ  ȸ ġ * {num1101} ) * (( {num1102} + (  MPȸ [%] + ۿɼ[%] ) ) / {num1103} ) + ۿ  MP ȸ ġ 
				///	A + B +  MPȸ [+-]
				valueA = defaultValueMP;
				valueB = ( mExtStatus[i] * num1 ) * ( ( num2 + mExtStatusPer[i] + pItem->mOptPercentMp ) / num3 ) + pItem->mOptPlusMp;
				mExtStatusLast[i] = valueA + valueB + mExtStatusPlus[i];

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			///   
		case ePLAYER_STATUS_EXT_HIT:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 101 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 102 );

				/// ( [] ĳ   ġ +   ġ ) * (({num101} + (   ġ[%] + + ۿɼ[%] ) ) / {num102}) + 
				///   ġ[+-] + ۿɼ[+-] 
				mExtStatusLast[i] = ( mExtStatus[i] + pItem->mPhysicAttackRate ) * 
					( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentPhysicAttackRate ) ) / num2 ) + mExtStatusPlus[i] + pItem->mOptPlusPhysicAttackRate;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			///   
		case ePLAYER_STATUS_EXT_MHIT:
			{
				///  ݻ 
				mExtStatusLast[i] = 0.0f;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// ȸ
		case  ePLAYER_STATUS_EXT_AVOID:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 105 );
				num2 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 106 );

				///	( [] ĳ  ȸ ġ +  ȸ ġ ) * (({num105} + (  ȸ ġ[%] + ۿɼ[%] ) ) / {num106}) + 
				///  ȸ ġ[+-] + ۿɼ[+-] )
				mExtStatusLast[i] = ( mExtStatus[i] + pItem->mOptPlusDod ) *
					( ( num1 + ( mExtStatusPer[i] + pItem->mOptPercentDod ) ) / num2 ) + mExtStatusPlus[i] + pItem->mOptPlusDod;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
			/// Ϲݰ ӵ
		case ePLAYER_STATUS_EXT_ASPD:
			{
				mExtStatusLast[i] = ( 100 + pItem->mAttackSpeed + mExtStatusPer[i] ) / 100;

				if( mExtStatusLast[i] < 0.1f )
					mExtStatusLast[i] = 0.1f;

				if( mExtStatusLast[i] > 2.0f )
					mExtStatusLast[i] = 2.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );                
			}break;
			/// ̵ ӵ 
		case ePLAYER_STATUS_EXT_SPD:
			{
				///    ̵ӵ ⺻ Ϳ о´.
				if( pPlayer->GetChgMonsterIdx() != 0 )
				{
					sMonsterScript* pMScript = MONSTERSCRIPT->GetMonsterListInfo( pPlayer->GetChgMonsterIdx() );
					if( pMScript != NULL )
						mExtStatus[i] = (float)pMScript->mActionRunSpd;

					mExtStatusLast[i] = mExtStatus[i] * ( ( 100 + mExtStatusPer[i] + pItem->mOptPercentMov ) / 100 ) + 
						mExtStatusPlus[i] + pItem->mOptPlusMov;

					if( mExtStatusLast[i] < 0.0f )
						mExtStatusLast[i] = 0.0f;

					pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
				}
				else
				{
					mExtStatusLast[i] = mExtStatus[i] * ( ( 100 + mExtStatusPer[i] + pItem->mOptPercentMov  ) / 100 ) + 
						mExtStatusPlus[i] + pItem->mOptPlusMov;

					if( mExtStatusLast[i] < 0.0f )
						mExtStatusLast[i] = 0.0f;

					pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
				}

			}
			break;
			///  ȸ
		case ePLAYER_STATUS_EXT_HEAL:
			{
				num1 = STATUSSCRIPT->GetDamageCalcNumericalInfo( 1203 );

				///	( ĳ   ݷ * 0.5 ) + ۿ  ųȸ  ġ 
				mExtStatusLast[i] = pPlayer->GetStatus2()->mMagicMinAttack * num1;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_HEALMin, mExtStatusLast[i] );

				mExtStatusLast[i] = pPlayer->GetStatus2()->mMagicMaxAttack * num1;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( ePLAYER_STATUS_EXT_HEALMax, mExtStatusLast[i] );

				mExtStatusLast[i] = 0.0f;
			}
			break;
			/// 
		case ePLAYER_STATUS_EXT_WEIGHT:
			{
				mExtStatusLast[i] = mExtStatus[i] * ( ( 100.0f + ( mExtStatusPer[i] + pItem->mOptPercentWei ) ) / 100.0f ) + 
					mExtStatusPlus[i] + pItem->mOptPlusWei;

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
		default:
			{
				mExtStatusLast[i] = mExtStatus[i] * ( ( 100.0f + mExtStatusPer[i] ) / 100.0f ) + mExtStatusPlus[i];

				if( mExtStatusLast[i] < 0.0f )
					mExtStatusLast[i] = 0.0f;

				pPlayer->SetStatus2( (ePLAYER_STATUS_EXT)i, mExtStatusLast[i] );
			}
			break;
		}
	}

	if( pPlayer->GetGameIn() == true )
	{

		/// hpġ hpִġ Ѿ ʰ 
		if( pPlayer->GetHP() > pPlayer->GetStatus2()->mMaxHP )
			pPlayer->HPHeal( 0, true, 0, 0, eTAKEDAMAGETYPE_NONE );
		
		/// mpġ mpִġ Ѿ ʰ 
		if( pPlayer->GetMP() > pPlayer->GetStatus2()->mMaxMP )
			pPlayer->MPHeal( 0, true );

		if( pPlayer->GetStateDie() != true )
		{
			if( mMaxHP != pPlayer->GetStatus2()->mMaxHP )
				pPlayer->SendHPHeal();

			if( mMaxMP != pPlayer->GetStatus2()->mMaxMP )
				pPlayer->SendMPHeal();
		}
		else
		{
			if( mMaxHP != pPlayer->GetStatus2()->mMaxHP )
				pPlayer->SendMaxHP();

			if( mMaxMP != pPlayer->GetStatus2()->mMaxMP )
				pPlayer->SendMaxMP();
		}

		/// ġƮ ̵ӵ 
		pPlayer->CalcCheatSpeedUp();

		/// ݼӵ  ߼
		if( pPlayer->GetStatus2()->mAttackSpeed != mAttackSpeed )
			pPlayer->SendAttackSpeed();

		/// ̵ ӵ Ѱ Ŭ̾Ʈ 
		if( pPlayer->GetMoveSpeed() != mMoveSpeed )
			pPlayer->SendMoveSpeed();

		/// ĳ ũⰡ Ѱ
		if( pPlayer->GetFixedObjectSizePer() != mSizePer )
		{
			pPlayer->SetFixedObjectSizePer( (short)mSizePer );
			pPlayer->SendPlayerSize();
		}
	}
}
