/* ==========================================================================
*      : TitleManager.h
*      : 
*    : 谡
*    : 2008-03-07
* ǻ :
*===========================================================================*/
#pragma once

class cTitleDefine
{
public:
	cTitleDefine();

public:
	/// ŸƲ
	LPCTSTR mName;

	/// ŸƲ
	LPCTSTR mDescription;

	/// ȿ ε
	long mInfluenceIndex;

	/// ŸƲ 
	unsigned long mColor;
};

inline
cTitleDefine::cTitleDefine()
: mName(0)
, mDescription(0)
, mInfluenceIndex(0)
, mColor(0)
{
}

class cTitleManager
{
public: 
	cTitleManager();
	~cTitleManager();

	bool Init();
	void Release();

	cTitleDefine* GetTitleDefine( unsigned long index );

	///
	tPointerHashMap<unsigned int, void*>* GetTitleDefineMap() { return &mTitleDefineMap; }

public:
	static cTitleManager* mpSingleton;
	static cTitleManager* GetSingleton();

protected:
	bool Load( const cString& pathname );

private:
	typedef tPointerHashMap<unsigned int, void*> cTitleDefineMap;
	cTitleDefineMap	mTitleDefineMap;
};

inline cTitleManager* cTitleManager::GetSingleton()
{
	return mpSingleton;
}

#define TITLEMAN cTitleManager::GetSingleton()
