#include "gamesrv.h"
#include "stdafx.h"
#include "Totem.h"
#include "Totem_Common.h"
#include "TotemScript.h"

cTotem::cTotem( void ) : cBaseObject( eOBJECTTYPE_TOTEM )
, mpInfScript(NULL)
{
}


cTotem::~cTotem( void )
{
}			


void* cTotem::operator new( size_t n )
{
	if( n != sizeof(cTotem) ) 
	{
		assert(0);
		return NULL;
	}

	return OBJECTMANAGER->AllocTotem();
}


void cTotem::operator delete( void* ptr, size_t n )
{
	/// NULL  ˻
	if( ptr == 0 )
	{
		assert(0);
		return;
	}

	if( n != sizeof(cTotem) ) 
	{
		assert(0);
		return;
	}

	OBJECTMANAGER->FreeTotem( static_cast<cTotem*>(ptr) );

	return;
}


bool cTotem::TotemInit( sObject attacker, unsigned long objectIdx, unsigned long classIdx, unsigned long partyIdx, 
					   NiPoint2 pos, eAPPLYTYPE applyType, eATTRIBUTETYPE attributeType )
{
	///  ũƮ
	mpTotemScript = TOTEMSCRIPT->GetTotemInfo( classIdx );
	if( mpTotemScript == NULL )
		return false;

	///  ȿ ũƮ
	mpInfScript = SKILLSCRIPT->GetInfluenceInfo( mpTotemScript->mInfluenceIdx );
	if( mpInfScript == NULL )
	{
        NETWORK2->PostServerEvent("cTotem::TotemInit mpInfScript[%d] != NULL", mpTotemScript->mInfluenceIdx );
		return false;
	}

	if( AIMANAGER->IsPassible( GetMapNumber(), pos.x, pos.y, GetObject() ) == false )
		return false;

	cBaseObject* pObject = OBJECTMANAGER->GetObject( attacker.type, attacker.index );
	if( pObject == NULL )
		return false;

	mMapNumber = pObject->GetMapNumber();
	mTeamType = ePVPDM_TEAMTYPE_MAX;
	mObjectPos = pos;
	mObject.index = objectIdx;
	mAttacker = attacker;
	mApplytype = applyType;
	mAttriButeType = attributeType;
	mNextCheckTime = NETWORK2->GetAccumTime() + mpTotemScript->mApplyTime;
	mEndTime = NETWORK2->GetAccumTime() + mpTotemScript->mContinuanceTime;
	mPartyIdx = partyIdx;

	return true;
}


bool cTotem::PvPTotemInit( ePVPDM_TEAM_TYPE teamType, unsigned long objectIdx, unsigned long classIdx,
					   unsigned short pvpIdx, NiPoint2 pos, eAPPLYTYPE applyType, eATTRIBUTETYPE attributeType )
{
	///  ũƮ
	mpTotemScript = TOTEMSCRIPT->GetTotemInfo( classIdx );
	if( mpTotemScript == NULL )
		return false;

	///  ȿ ũƮ
	mpInfScript = SKILLSCRIPT->GetInfluenceInfo( mpTotemScript->mInfluenceIdx );
	if( mpInfScript == NULL )
	{
		NETWORK2->PostServerEvent("cTotem::PvPTotemInit mpInfScript[%d] != NULL", mpTotemScript->mInfluenceIdx );
		return false;
	}

	mMapNumber = pvpIdx;		/// pvp ȣ
	mTeamType = teamType;
	mObjectPos = pos;
	mObject.index = objectIdx;
	mAttacker = mObject;
	mApplytype = applyType;
	mAttriButeType = attributeType;
	mNextCheckTime = NETWORK2->GetAccumTime() + mpTotemScript->mApplyTime;
	mEndTime = NETWORK2->GetAccumTime() + PVP_DM_TEAM_MINCNT_TIME + PVP_DM_FIGHT_TIME;
	mPartyIdx = 0;

	return true;
}


void cTotem::TotemProcess( unsigned long /*elapsedTime*/, unsigned long accumTime )
{
	/// üũð Ȯ
	if( mNextCheckTime > accumTime )
		return;

	///  üũ ð 
	mNextCheckTime = mNextCheckTime + mpTotemScript->mApplyTime;

	/// ü  üũ
	if( CheckTotem( accumTime ) == true )
	{
		///  Ÿ   ʱȭ
		mTargetCnt = 0;

		switch( mTeamType )
		{
		case ePVPDM_TEAMTYPE_A:
			ATeamSelectTarget();
			break;
		case ePVPDM_TEAMTYPE_B:
			BTeamSelectTarget();
			break;
		case ePVPDM_TEAMTYPE_MAX:	/// ÷̾/Ͱ  Ϲ 
			{
				/// ȿ  Ÿ Ͽ ߰
				if( mAttacker.type == eOBJECTTYPE_PLAYER )
					PlayerSelectTarget();
				else if( mAttacker.type == eOBJECTTYPE_MONSTER )
					MonsterSelectTarget();
			}
			break;
		}
	}
}


void cTotem::PlayerSelectTarget()
{
	///  Ÿ üũ
	bool addInfAura = false;
	if( mpInfScript != NULL && mpInfScript->mTypeDetail == eINFLUENCETYPEDETAIL_AURA )
		addInfAura = true;

	///  ó
	switch( mApplytype )
	{
	case eAPPLYTYPE_SELF:
	case eAPPLYTYPE_BUDDY:
	case eAPPLYTYPE_PARTY:
		{
			/// ڰ  Ͽ ̹  ִ üũ
			if( mPlayerTargetSet.Find( mAttacker.index ) != mPlayerTargetSet.End() )
				break;;

			if( addInfAura == true )
			{
				cPlayer* pAttacker = OBJECTMANAGER->GetPlayer( mAttacker.index );
				if( pAttacker != NULL )
					CopyTotemInfluence( pAttacker );	///  Ÿ ȿ 
			}
			else
				SKILLMANAGER->AddInfChildTotem( mAttacker, mAttacker, mpTotemScript->mInfluenceIdx, 0, mObject.index, true );
		}
		break;
	}

	///  ó
	switch( mApplytype )
	{
	case eAPPLYTYPE_ENEMY:
		{
			///  Ÿ
			cBaseObject* pMonsterTarget = GRIDMANAGER->FindFirstMonster( this );
			while( pMonsterTarget != NULL )
			{
				if( pMonsterTarget->GetObjectID() == mAttacker.index )
				{
					pMonsterTarget = GRIDMANAGER->FindNextMonster();
					continue;		/// ڽ 
				}

				/// Ÿ  Ͽ ̹  ִ üũ
				if( mMonsterTargetSet.Find( pMonsterTarget->GetObjectID() ) != mMonsterTargetSet.End() )
				{
					pMonsterTarget = GRIDMANAGER->FindNextMonster();
					continue;
				}

				if( addInfAura == true )
				{
					///  Ÿ ȿ 
					if( CopyTotemInfluence( pMonsterTarget ) == true )
						++mTargetCnt;
				}
				else
				{
					/// Ϲ ȿ 
					if( SKILLMANAGER->AddInfluence( mAttacker, pMonsterTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, true ) == true )
						++mTargetCnt;
				}

				/// Ÿ   
				if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
					return;

				///   ˻
				pMonsterTarget = GRIDMANAGER->FindNextMonster();
			}


			/// ÷̾ Ÿ
			cPlayer* pPlayerTarget = GRIDMANAGER->FindFirstPlayer( this );
			while( pPlayerTarget != NULL )
			{
				if( pPlayerTarget->GetObjectID() == mAttacker.index )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;		/// ڽ 
				}

				/// Ÿ  Ͽ ̹  ִ üũ
				if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				/// 1:1 ݴ üũ
				if( DUELMANAGER->IsAttack( pPlayerTarget->GetDuelIdx(), mAttacker.index, pPlayerTarget->GetObjectID() ) == false )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				if( addInfAura == true )
				{
					///  Ÿ ȿ 
					if( CopyTotemInfluence( pPlayerTarget ) == true )
						++mTargetCnt;
				}
				else
				{
					/// ȿ 
					if( SKILLMANAGER->AddInfluence( mAttacker, pPlayerTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, true ) == true )
						++mTargetCnt;
				}

				/// Ÿ   
				if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
					return;

				pPlayerTarget = GRIDMANAGER->FindNextPlayer();
			}
		}

		break;
	case eAPPLYTYPE_BUDDY:
		{
			/// ÷̾ Ÿ
			cPlayer* pPlayerTarget = GRIDMANAGER->FindFirstPlayer( this );
			while( pPlayerTarget != NULL )
			{
				if( pPlayerTarget->GetObjectID() == mAttacker.index )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;		/// ڽ 
				}

				/// Ÿ  Ͽ ̹  ִ üũ
				if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				/// 1:1 ݴ üũ
				if( DUELMANAGER->IsAttack( pPlayerTarget->GetDuelIdx(), mAttacker.index, pPlayerTarget->GetObjectID() ) == true )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				if( addInfAura == true )
				{
					///  Ÿ ȿ 
					if( CopyTotemInfluence( pPlayerTarget ) == true )
						++mTargetCnt;
				}
				else
				{
					/// ȿ 
					if( SKILLMANAGER->AddInfSwitch( mAttacker, pPlayerTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, true ) != 0 )
						++mTargetCnt;
				}

				/// Ÿ   
				if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
					return;

				pPlayerTarget = GRIDMANAGER->FindNextPlayer();
			}
		}
		break;
	case eAPPLYTYPE_DIEBUDDY:
		{
			/// ÷̾ Ÿ
			cPlayer* pPlayerTarget = GRIDMANAGER->FindFirstPlayer( this );
			while( pPlayerTarget != NULL )
			{
				if( pPlayerTarget->GetObjectID() == mAttacker.index )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;		/// ڽ 
				}

				/// Ÿ  Ͽ ̹  ִ üũ
				if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				///    
				if( pPlayerTarget->GetStateDie() == false )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				/// 1:1 ݴ üũ
				if( DUELMANAGER->IsAttack( pPlayerTarget->GetDuelIdx(), mAttacker.index, pPlayerTarget->GetObjectID() ) == true )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				if( addInfAura == true )
				{
					///  Ÿ ȿ 
					if( CopyTotemInfluence( pPlayerTarget ) == true )
						++mTargetCnt;
				}
				else
				{
					/// ȿ 
					if( SKILLMANAGER->AddInfSwitch( mAttacker, pPlayerTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, true ) != 0 )
						++mTargetCnt;
				}

				/// Ÿ   
				if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
					return;

				pPlayerTarget = GRIDMANAGER->FindNextPlayer();
			}
		}
		break;
	case eAPPLYTYPE_PARTY:
		{
			/// Ƽ  ڿԸ 
			cParty* pParty = PARTYMAN->GetParty( mPartyIdx );
			if( pParty == NULL )
				return;

			/// Ƽ  
			unsigned long* userArr = pParty->GetUserArr();
			unsigned int partyCount = pParty->GetCount();

			for( unsigned int i = 0 ; i < partyCount ; ++i )
			{
				cPlayer* pPlayerTarget = GRIDMANAGER->GetPlayer( userArr[i] );
				if( pPlayerTarget != NULL )
				{
					if( pPlayerTarget->GetObjectID() == mAttacker.index )
					{
						pPlayerTarget = GRIDMANAGER->FindNextPlayer();
						continue;		/// ڽ 
					}

					/// Ÿ  Ͽ ̹  ִ üũ
					if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
					{
						pPlayerTarget = GRIDMANAGER->FindNextPlayer();
						continue;
					}

					if( addInfAura == true )
					{
						///  Ÿ ȿ 
						if( CopyTotemInfluence( pPlayerTarget ) == true )
							++mTargetCnt;
					}
					else
					{
						/// ȿ 
						if( SKILLMANAGER->AddInfSwitch( mAttacker, pPlayerTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, true ) != 0 )
							++mTargetCnt;
					}
				}
			}
		}
		break;
	}
}


void cTotem::MonsterSelectTarget()
{
	///  Ÿ üũ
	bool addInfAura = false;
	if( mpInfScript != NULL && mpInfScript->mTypeDetail == eINFLUENCETYPEDETAIL_AURA )
		addInfAura = true;

	///  ó
	switch( mApplytype )
	{
	case eAPPLYTYPE_SELF:
	case eAPPLYTYPE_BUDDY:
	case eAPPLYTYPE_PARTY:
		{
			/// ڰ  Ͽ ̹  ִ üũ
			if( mMonsterTargetSet.Find( mAttacker.index ) == mMonsterTargetSet.End() )
				return;

			if( addInfAura == true )
			{
				cMonster* pAttacker = OBJECTMANAGER->GetMonster( mAttacker.index );
				if( pAttacker != NULL )
					CopyTotemInfluence( pAttacker );	///  Ÿ ȿ 
			}
			else
				SKILLMANAGER->AddInfSwitch( mAttacker, mAttacker, mpTotemScript->mInfluenceIdx, 0, true );
		}
		break;
	}

	///  ó
	switch( mApplytype )
	{
	case eAPPLYTYPE_BUDDY:
		{
			///  Ÿ
			cBaseObject* pMonsterTarget = GRIDMANAGER->FindFirstMonster( this );
			while( pMonsterTarget != NULL )
			{
				if( pMonsterTarget->GetObjectID() == mAttacker.index )
				{
					pMonsterTarget = GRIDMANAGER->FindNextMonster();
					continue;		/// ڽ 
				}

				/// Ÿ  Ͽ ̹  ִ üũ
				if( mMonsterTargetSet.Find( pMonsterTarget->GetObjectID() ) != mMonsterTargetSet.End() )
				{
					pMonsterTarget = GRIDMANAGER->FindNextMonster();
					continue;
				}

				if( addInfAura == true )
				{
					///  Ÿ ȿ 
					if( CopyTotemInfluence( pMonsterTarget ) == true )
						++mTargetCnt;
				}
				else
				{
					/// Ϲ ȿ 
					if( SKILLMANAGER->AddInfluence( mAttacker, pMonsterTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, true ) == true )
						++mTargetCnt;
				}

				/// Ÿ   
				if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
					return;

				///   ˻
				pMonsterTarget = GRIDMANAGER->FindNextMonster();
			}
		}
		break;
	case eAPPLYTYPE_ENEMY:
		{
			cBaseObject* pPlayerTarget = GRIDMANAGER->FindFirstPlayer( this );
			while( pPlayerTarget != NULL )
			{
				/// Ÿ  Ͽ ̹  ִ üũ
				if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectType() ) != mPlayerTargetSet.End() )
				{
					pPlayerTarget = GRIDMANAGER->FindNextPlayer();
					continue;
				}

				if( addInfAura == true )
				{
					/// ȿ 
					if( CopyTotemInfluence( pPlayerTarget ) == true )
						++mTargetCnt;
				}
				else
				{
					/// ȿ 
					if( SKILLMANAGER->AddInfluence( mAttacker, pPlayerTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, true ) == true )
						++mTargetCnt;
				}

				/// Ÿ   
				if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
					return;

				pPlayerTarget = GRIDMANAGER->FindNextPlayer();
			}
		}
		break;
	}
}


void cTotem::ATeamSelectTarget()
{
	switch( mApplytype )
	{
	case eAPPLYTYPE_BUDDY:
		{
			cDeathMatchObject* pDM = PVPMANAGER->GetPvPDMObject( mMapNumber );
			if( pDM != NULL )
			{
				unsigned char teamCnt = pDM->TeamCnt( ePVPDM_TEAMTYPE_A );
				sPvPDMMemberInfo* pMember = pDM->TeamMember( ePVPDM_TEAMTYPE_A );
				if( pMember == NULL )
					return;

				for( unsigned char i = 0 ; i < teamCnt ; ++i )
				{
					cPlayer* pPlayerTarget = GRIDMANAGER->GetPlayer( pMember[i].mPlayerIdx );
					if( pPlayerTarget != NULL )
					{
						/// Ÿ  Ͽ ̹  ִ üũ
						if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
							continue;

						///  Ÿ ȿ 
						if( CopyTotemInfluence( pPlayerTarget ) == true )
							++mTargetCnt;

						/// Ÿ   
						if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
							return;
					}
				}
			}
		}
		break;
	case eAPPLYTYPE_ENEMY:
		{
			cDeathMatchObject* pDM = PVPMANAGER->GetPvPDMObject( mMapNumber );
			if( pDM != NULL )
			{
				unsigned char teamCnt = pDM->TeamCnt( ePVPDM_TEAMTYPE_B );
				sPvPDMMemberInfo* pMember = pDM->TeamMember( ePVPDM_TEAMTYPE_B );
				if( pMember == NULL )
					return;

				for( unsigned char i = 0 ; i < teamCnt ; ++i )
				{
					cPlayer* pPlayerTarget = GRIDMANAGER->GetPlayer( pMember[i].mPlayerIdx );
					if( pPlayerTarget != NULL )
					{
						/// Ÿ  Ͽ ̹  ִ üũ
						if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
							continue;

						///  Ÿ ȿ 
						if( CopyTotemInfluence( pPlayerTarget ) == true )
							++mTargetCnt;

						/// Ÿ   
						if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
							return;
					}
				}
			}
		}
		break;	
	}
}


void cTotem::BTeamSelectTarget()
{
	switch( mApplytype )
	{
	case eAPPLYTYPE_BUDDY:
		{
			cDeathMatchObject* pDM = PVPMANAGER->GetPvPDMObject( mMapNumber );
			if( pDM != NULL )
			{
				unsigned char teamCnt = pDM->TeamCnt( ePVPDM_TEAMTYPE_B );
				sPvPDMMemberInfo* pMember = pDM->TeamMember( ePVPDM_TEAMTYPE_B );
				if( pMember == NULL )
					return;

				for( unsigned char i = 0 ; i < teamCnt ; ++i )
				{
					cPlayer* pPlayerTarget = GRIDMANAGER->GetPlayer( pMember[i].mPlayerIdx );
					if( pPlayerTarget != NULL )
					{
						/// Ÿ  Ͽ ̹  ִ üũ
						if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
							continue;

						///  Ÿ ȿ 
						if( CopyTotemInfluence( pPlayerTarget ) == true )
							++mTargetCnt;

						/// Ÿ   
						if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
							return;
					}
				}
			}
		}
		break;
	case eAPPLYTYPE_ENEMY:
		{
			cDeathMatchObject* pDM = PVPMANAGER->GetPvPDMObject( mMapNumber );
			if( pDM != NULL )
			{
				unsigned char teamCnt = pDM->TeamCnt( ePVPDM_TEAMTYPE_A );
				sPvPDMMemberInfo* pMember = pDM->TeamMember( ePVPDM_TEAMTYPE_A );
				if( pMember == NULL )
					return;

				for( unsigned char i = 0 ; i < teamCnt ; ++i )
				{
					cPlayer* pPlayerTarget = GRIDMANAGER->GetPlayer( pMember[i].mPlayerIdx );
					if( pPlayerTarget != NULL )
					{
						/// Ÿ  Ͽ ̹  ִ üũ
						if( mPlayerTargetSet.Find( pPlayerTarget->GetObjectID() ) != mPlayerTargetSet.End() )
							continue;

						///  Ÿ ȿ 
						if( CopyTotemInfluence( pPlayerTarget ) == true )
							++mTargetCnt;

						/// Ÿ   
						if( mTargetCnt == TOTEM_APPLY_LIST_MAX )
							return;
					}
				}
			}
		}
		break;	
	}
}


bool cTotem::CheckTotem( unsigned long accumTime )
{
	/// ð Ȯ
	if( mEndTime <= accumTime )
	{
		OBJECTMANAGER->InsertDeleteTotem( mObject.index );
		return false;
	}

	/// ڿ   ó
	cBaseObject* pAttacker = NULL;
	if( mpTotemScript->mDependent == true )
	{
		///    ڰ  
		pAttacker = OBJECTMANAGER->GetObject( mAttacker.type, mAttacker.index );
		if( pAttacker == NULL || pAttacker->GetStateDie() == true )
		{
			OBJECTMANAGER->InsertDeleteTotem( mObject.index );
			return false;
		}

		/// Ÿ    
        mRangeCheck.SetRadius( mpTotemScript->mAttackerRange );
		if( mRangeCheck.IsNotRange( pAttacker->GetPos(), mObjectPos ) == true )
		{
			OBJECTMANAGER->InsertDeleteTotem( mObject.index );
			return false;
		}
	}

	return true;
}


// SendSightIn Method
bool cTotem::SendSightIn(char category, char protocol, unsigned long connectionIdx)
{
	HANDLE          handle  = NULL;
	MSG_TOTEM_INFO* sendMsg = (MSG_TOTEM_INFO*)NETWORK2->GetMsgRoot( &handle, connectionIdx );
	if ( sendMsg != NULL )
	{
		sendMsg->Category = category;
		sendMsg->Protocol = protocol;

		sendMsg->mObjectIdx         = mObject.index;
		sendMsg->mPosX              = mObjectPos.x;
		sendMsg->mPosY              = mObjectPos.y;
		sendMsg->mCreateInfClassIdx = GetClassIdx();

		return NETWORK2->SendMsgRoot( handle, sizeof(MSG_TOTEM_INFO) );
	}
	return false;
}

// SendSightOut Method
bool cTotem::SendSightOut(char category, char protocol, unsigned long connectionIdx)
{
	HANDLE            handle  = NULL;
	MSG_TOTEMIDX* sendMsg = (MSG_TOTEMIDX*)NETWORK2->GetMsgRoot( &handle, connectionIdx );
	if ( sendMsg != NULL )
	{
		sendMsg->Category   = category;
		sendMsg->Protocol   = protocol;
		sendMsg->mObjectIdx = mObject.index;
		return NETWORK2->SendMsgRoot( handle, sizeof(MSG_TOTEMIDX) );
	}
	return false;
}


bool cTotem::CopyTotemInfluence( cBaseObject* pTarget )
{
	if( mpTotemScript == NULL )
		return false;

	///  ȿ Ÿ  ȵȴ.
	if( mpTotemScript->mApplyRange == 0.0f )
	{
		NETWORK2->PostServerEvent("cSkillManager::CopyAuraInfluence auraRange == 0.0f" );
		return false;
	}

	if( pTarget == NULL )
		return false;

	/// Ÿ üũ
	NiPoint3 childPos( pTarget->GetXPos(), pTarget->GetYPos(), pTarget->Height() );
	NiPoint3 parentPos( mObjectPos.x, mObjectPos.y, Height() );
	mRangeCheck.SetRadius( mpTotemScript->mApplyRange );
	if( mRangeCheck.IsNotRange( mObjectPos, pTarget->GetPos() ) == true )
		return false;

	/// ȿ 
	if( SKILLMANAGER->AddInfChildTotem( mAttacker, pTarget->GetObject(), mpTotemScript->mInfluenceIdx, 0, mObject.index, true ) == true )
	{
		if( pTarget->GetObjectType() == eOBJECTTYPE_PLAYER )
			mPlayerTargetSet.Insert( pTarget->GetObjectID() );
		else if( pTarget->GetObjectType() == eOBJECTTYPE_MONSTER )
			mMonsterTargetSet.Insert( pTarget->GetObjectID() );
	}

	return true;
}


void cTotem::EraseTarget( sObject target )
{
	if( target.type == eOBJECTTYPE_MONSTER )
		mMonsterTargetSet.Erase( target.index );
	else if( target.type == eOBJECTTYPE_PLAYER )
		mPlayerTargetSet.Erase( target.index );
}
