#include "stdafx.h"
#include "gamesrv.h"
#include "TriggerManager.h"
#include "ObjectManager.h"

cTriggerManager* cTriggerManager::mpSingleton = 0;

/////
cTrigger::cTrigger()
: mQuestIndex(0)
, mLowLevel(0)
, mHighLevel(0)
{
	mRace[0] = -1;
	mRace[1] = -1;

	for( unsigned int i = 0; i < QUEST_ITEM_MAX; ++i )
	{
		mHaveItem[i].itemIndex = 0;
		mHaveItem[i].count = 0;
	}

	::memset( mSkillArray, 0, sizeof(mSkillArray) );
}

////////////////
cTriggerManager::cTriggerManager()
{
	assert( mpSingleton == 0 && "bad singleton!" );
	mpSingleton = this;
}

cTriggerManager::~cTriggerManager()
{
	Clear();
}

bool cTriggerManager::Init()
{
	Clear();
	return true;
}

void cTriggerManager::Clear()
{
	cTriggerMap::cIterator i = mTriggerMap.Begin();
	cTriggerMap::cIterator end = mTriggerMap.End();

	for( ; i != end; ++i )
	{
		cTrigger* trigger = (cTrigger*)(i->mSecond);
		SAFE_DELETE( trigger );
	}
	mTriggerMap.Clear();
}

/// Ʈ 
bool cTriggerManager::AddTrigger( unsigned long questIdx, cTrigger* trigger )
{
	if( !trigger )
		return false;

	if( mTriggerMap.Insert( questIdx, trigger ) == false )
	{
		assert( 0 && "failed to add trigger" );
		return false;
	}
	return true;
}

/// ƮŻ
void cTriggerManager::DeleteTrigger( unsigned long questIdx )
{
	cTrigger* trigger = (cTrigger*)mTriggerMap.GetAt( questIdx );
	if( trigger )
	{
		mTriggerMap.Erase( questIdx );
		SAFE_DELETE( trigger );
	}
}

cTrigger* cTriggerManager::GetTrigger( unsigned long questIdx )
{
	return (cTrigger*)mTriggerMap.GetAt( questIdx );
}

/// Ʈ  üũ
bool cTriggerManager::CheckTrigger( unsigned long playerIdx, unsigned long questIdx )
{
	/// ߻  ׳ true
	cTrigger* trigger = GetTrigger( questIdx );
	if( !trigger )
		return true;

	cPlayer* player = OBJECTMANAGER->GetPlayer( playerIdx );
	if( !player )
		return false;

	///   üũ
	int level = player->GetLevel();
	if( trigger->mLowLevel > 0 && trigger->mLowLevel > level )
		return false;

	if( trigger->mHighLevel > 0 && trigger->mHighLevel < level )
		return false;

	///  üũ
	char race = player->GetRace();
	if( trigger->mRace[0] != -1 && (trigger->mRace[0] != race && trigger->mRace[1] != race)  )
		return false;

	///  üũ
	unsigned long jobIdx = player->GetJob();
	if( !trigger->mJobSet.IsEmpty() && trigger->mJobSet.Find( jobIdx ) == trigger->mJobSet.End() )
		return false;

	///   üũ
	sQuestItem* item = trigger->mHaveItem;
	for( unsigned int i = 0; i < QUEST_ITEM_MAX; i++, item++ )
	{
		int			  remainCount = item->count;
		TB_INVENTORY* inven = player->SelectInventory( INVENTORY_CHARACTER_BEGIN );

		/// κ丮 +  ʿ䰹 ˻
		for( int i = INVENTORY_CHARACTER_BEGIN; i <= INVENTORY_CHARACTER_END; i++, inven++ )
		{
			if( player->IsInventory( inven ) == true )
			{
				if( (long)item->itemIndex == inven->itemDefineIndex )
				{
					///  üũ  ̱
					remainCount -= inven->count;

					if( remainCount <= 0 )
						break;
				}
			}
		}
		///  ϸ  
		if( remainCount > 0 )
			return false;
	}

	///  Ʈ üũ
	typedef tArray<unsigned long> cLinkQuestArr;
	cLinkQuestArr& linkQuest = trigger->mLinkQuestArr;

	for( unsigned int i = 0; i < linkQuest.GetSize(); ++i )
	{
		/// ʿ Ʈ  ϷǾ ˻
		unsigned long linkIdx = (unsigned long)linkQuest[i];

		if( player->IsCompleteQuest( linkIdx ) == false )
			return false;
	}

	/// ų Ʈ ˻
	typedef tHashSet<unsigned long> cSkillInfluenceSet;

	for( unsigned int i = 0; i < QUEST_BUFF_MAX; ++i )
	{
		unsigned long skillIndex = trigger->mSkillArray[i];
		if( skillIndex > 0 )
		{
			cSkillInfluenceSet* influenceSet = player->GetInfluenceSet();
			if( !influenceSet )
			{
				assert(0);
				return false;
			}

			/// ش ȿų  
			cSkillInfluenceSet::cIterator iter = influenceSet->Find( skillIndex );
			if( iter == influenceSet->End() )
				return false;
		}
	}
	return true;
}
