#include "stdafx.h"
#include "gamesrv.h"
#include "NoteManager.h"
#include "Player.h"

cNoteManager* cNoteManager::mpSingleton = NULL;

cNoteManager::cNoteManager()
{
	mpSingleton = this;
}

cNoteManager::~cNoteManager()
{
	Release();
}

void cNoteManager::Release()
{
	cNoteHashMap::cIterator i = mNoteHashMap.Begin();
	cNoteHashMap::cIterator end = mNoteHashMap.End();
	for( ; i != end; ++i )
	{
		cPlayerNoteMap* noteMap = (cPlayerNoteMap*)(i->mSecond);
		cPlayerNoteMap::cIterator ni = noteMap->Begin();
		cPlayerNoteMap::cIterator nend = noteMap->End();
		for( ; ni != nend; ++ni )
		{
			TB_NOTE* p = (TB_NOTE*)(ni->mSecond);
			SAFE_DELETE(p);
		}
		noteMap->Clear();
	}
	mNoteHashMap.Clear();
}

///  
bool cNoteManager::AddNote( unsigned long idx, TB_NOTE* note )
{
	cPlayerNoteMap* noteMap = (cPlayerNoteMap*)mNoteHashMap.GetAt( idx );
	if( noteMap )
	{
		TB_NOTE* p = new TB_NOTE;
		*p = *note;

		///  ð
		p->startTime = NETWORK2->GetAccumTime();

		if( noteMap->Insert( note->idx, p ) == false )
		{
			NETWORK2->PostServerEvent("cNoteManager::AddNote - exist note map [%d]", p->idx );
			SAFE_DELETE( p );
			return false;
		}
	}
	else
	{
		assert(0);
		NETWORK2->PostServerEvent("cNoteManager::AddNote - User Note Map EMPTY [%d]", idx );
		return false;
	}
	return true;
}

///  
bool cNoteManager::DeleteNote( unsigned long idx, unsigned long noteIdx )
{
	cPlayerNoteMap* noteMap = (cPlayerNoteMap*)mNoteHashMap.GetAt( idx );
	if( noteMap )
	{
        TB_NOTE* p = (TB_NOTE*)noteMap->GetAt( noteIdx );
		noteMap->Erase( noteIdx );
		SAFE_DELETE( p );
		return true;
	}
	return false;
}

///  Ʈ 
bool cNoteManager::SendNoteList( cPlayer* player )
{
	if( player )
	{
		cPlayerNoteMap* noteMap = (cPlayerNoteMap*)mNoteHashMap.GetAt( player->GetObjectID() );
		if( noteMap )
		{
			if( noteMap->GetSize() == 0 )
				return true;

			HANDLE             handle  = NULL;
			MSG_RES_NOTE_RECV* sendMsg = (MSG_RES_NOTE_RECV*)NETWORK2->GetMsgRoot( &handle, player->GetConnectionIdx(), NM_CHAT, NM_CHAT_NOTE_RECV_RES );
			sNoteList*		   noteList = sendMsg->table;
			unsigned long	   length  = sizeof(MSG_RES_NOTE_RECV) - sizeof(sendMsg->table);

			sendMsg->RowCount = 0;

			///     ó Ѵ ( ó)

			cPlayerNoteMap::cIterator i = noteMap->Begin();
			cPlayerNoteMap::cIterator end = noteMap->End();
			for( ; i != end; ++i )
			{
				TB_NOTE* p = (TB_NOTE*)(i->mSecond);

				/// ð 
				long accumTime = NETWORK2->GetAccumTime();
				if( accumTime - p->startTime > p->remainTime )
					continue;	

				noteList->Idx    = p->idx;
				noteList->Year   = p->registerDate.year;
				noteList->Month  = p->registerDate.month;
				noteList->Day    = p->registerDate.day;
				noteList->Hour   = p->registerDate.hour;
				noteList->Minute = p->registerDate.minute;
				wcscpy( noteList->CharacterName, p->characterName );
				wcscpy( noteList->Message, p->message );
				noteList->RemainTime = p->remainTime - (accumTime - p->startTime);

				noteList++;
				sendMsg->RowCount++;
			}

			length += (sendMsg->RowCount * sizeof(sendMsg->table));
			return NETWORK2->SendMsgRoot( handle, length );
		}
	}
	else
	{
		NETWORK2->PostServerEvent("cNoteManager::SendNoteList - not exist player");
		return false;
	}
	return true;
}

bool cNoteManager::AddPlayerNoteMap( unsigned long idx )
{
	cPlayerNoteMap* noteMap = new cPlayerNoteMap;
	if( mNoteHashMap.Insert( idx, noteMap ) == false )
	{
		assert(0);
		return false;
	}
	return true;
}

void cNoteManager::DeletePlayerNoteMap( unsigned long idx )
{
	cPlayerNoteMap* noteMap = (cPlayerNoteMap*)mNoteHashMap.GetAt( idx );
	if( noteMap )
	{
		cPlayerNoteMap::cIterator ni = noteMap->Begin();
		cPlayerNoteMap::cIterator nend = noteMap->End();
		for( ; ni != nend; ++ni )
		{
			TB_NOTE* p = (TB_NOTE*)(ni->mSecond);
			SAFE_DELETE(p);
		}
		noteMap->Clear();

		mNoteHashMap.Erase( idx );
	}
}