// Include
#include "gamesrv.h"
#include "logprotocol.h"

#include <stdlib.h>
#include <time.h>

// Local definitions
#pragma warning( disable: 4244 )
#pragma warning( disable: 4127 )

// Global data
cRandomTable* cRandomTable::mpRandomTable = NULL;

// cRandomTable Constructor
cRandomTable::cRandomTable(void)
{
	mpRandomTable = this;

	table  = NULL;
	offset = 0;
	length = 0;
}

// ~cRandomTable Destructor
cRandomTable::~cRandomTable(void)
{
	Shutdown( );

	mpRandomTable = NULL;
}

// Initialize Method - ̺  ִũ ˻ ʿ.
bool cRandomTable::Initialize( )
{
	FILE*  stream   = fopen( "./Script/Resource/randomtable.", "rb" );
	size_t numread  = 0;
	bool   retvalue = false;

	// rand function õ尪 ʱȭ.
	srand( (unsigned)time( NULL ) );

	if ( stream != NULL )
	{
		WORD type;

		//  Ȯ
		fread( &type, sizeof(type), 1, stream );

		if ( type == ((WORD) ('T' << 8) | 'R') )
		{
			// ̺ NULL  ƴҰ   ʱȭ.
			if ( table != NULL )
			{
				GlobalFree( table );
				table = NULL;
			}
			// ̺  ʱȭ.
			offset = 0;
			// ̺ ִ ũ .
			fread( &length, sizeof(length), 1, stream );

			// ̺ ޸ .
			table = (double*)GlobalAlloc( GPTR, sizeof(double)*length );

			if ( table != NULL )
			{
				// ̺  & ִ ũ .
				numread = fread( table, sizeof(double), length, stream );
				if ( numread != length )
				{
					GlobalFree( table );
					table = NULL;
				}
				else
				{
					// ̺  .
					offset   = rand( ) % length;
					retvalue = true;
				}
			}
		}

		fclose( stream );
	}

	return retvalue;
}

// Shutdown Method
void cRandomTable::Shutdown( )
{
	if ( table != NULL )
	{
		GlobalFree( table );
		table = NULL;
	}
	length = 0;
	offset = 0;
}

// GetSeed Method
DWORD cRandomTable::GetSeed( )
{
	return rand( );
}

// Get Method
double cRandomTable::Get( )
{
	double value = 0;
	if ( table != NULL && offset < length )
	{
		value = *(table + offset);

		if ( ++offset >= length )
			offset = 0;
	}
	return value;
}

// Get Method
double cRandomTable::Get(DWORD& seed)
{
	double value = 0;
	if ( table != NULL )
	{
		// ִ  ũų .
		if ( seed >= length ) seed %= length;

		value = *(table + seed);
		seed += 1;

		// ִ  Ŀ..
		if ( seed >= length ) seed = 0;
	}
	return value;
}
