/* ====================================================================
 *      :	sqlAccount.h
 *      :	
 *    :	ö
 *    :	07/01/12
 * ǻ :	
 * =================================================================== */
#ifndef __SQL_ACCOUNT_H__
#define __SQL_ACCOUNT_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "sqlpool.h"
#include "sqlaccountstmt.h"
#include "iocontextpool.h"

#ifndef __SQL_REQUEST_ACCOUNT_TYPE__
#define __SQL_REQUEST_ACCOUNT_TYPE__

enum SQL_REQUEST_ACCOUNT_TYPE
{
	// DEFAULT_SQL_ACCOUNT
	SQL_REQUEST_ACCOUNT_TEST = 0x1000,	// DEFAULT_SQL_ACCOUNT(0x1000) - defined gamesrv.h file
	SQL_REQUEST_ACCOUNT_SHUTDOWN,		// Shutdown Account Database

	SQL_GAME_PROCESS_CHANNEL_CHECK,
	SQL_GAME_PROCESS_MEMBER_CHECK,
	SQL_GAME_PROCESS_MEMBER_LOGOUT,
	SQL_GAME_PROCESS_COMEIN_GAME,
	SQL_GAME_PROCESS_GAMEIN_COMPLETE,
	SQL_GAME_PROCESS_GAMEOUT_COMPLETE,
	SQL_GAME_PROCESS_GOTO_INSTANT_DUNGEON,
	SQL_GAME_PROCESS_RETURN_TO_MAP,

	// 
	SQL_GAME_PROCESS_WHISPER_MEMBER_SELECT,
	SQL_GAME_PROCESS_NOTE_MEMBER_SELECT,

	// MAX
	MAX_SQL_ACCOUNT
};

#endif // __SQL_REQUEST_ACCOUNT_TYPE__


class cSQLAccount :
	public cSQLPool
{
private:
	cIoContextPool*   mIoContextPool;

protected:
// Page Pool  ޼ҵ.
	PerSQLConnection* AllocSQLConnection ( void );

private:
// LOG  ޼ҵ.
	bool              PostServerEvent    ( LPCTSTR format, ... );

public:
// Ŭ    ޼ҵ.
	cSQLAccount(void);

	bool              Initialize         ( char* dsn, char* uid, char* pwd, unsigned int numWorkerThreads=2, unsigned int bufferLength=65535 );
	void              Shutdown           ( void );

	void              GetIoContextPool   ( SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize );

	PerIoContext*     Get                ( );
	void              Release            ( PerIoContext* perIoContext );

	DWORD             WorkerThread       ( void );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSQLAccount(void);
};

#endif // __SQL_ACCOUNT_H__