// Include
#include "sqlaccountstmt.h"

// Local definitions

// Global data

// cSQLAccountStmt Constructor.
cSQLAccountStmt::cSQLAccountStmt(void)
{
}

// ~cSQLAccountStmt Destructor.
cSQLAccountStmt::~cSQLAccountStmt(void)
{
}

// Shutdown Method.
// GP_SERVERDOWN.SQL .
SQLRETURN cSQLAccountStmt::Shutdown(SHUTDOWN_ACCOUNT* shutdownAccount)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SERVERDOWN(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &shutdownAccount->serverNum,  0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &shutdownAccount->channelNum, 0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// ChannelCheck Method.
// GP_CHANNEL_CHECK.SQL .
SQLRETURN cSQLAccountStmt::ChannelCheck(CHANNEL_CHECK* channelCheck)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHANNEL_CHECK(?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       serverNameLen = (long)sizeof( channelCheck->serverName );
	long       cbServerName  = SQL_NTS;

	long       serverDescLen = (long)sizeof( channelCheck->serverDesc );
	long       cbServerDesc  = SQL_NTS;

	long       inetnumLen = (long)sizeof( channelCheck->inetnum );
	long       cbInetnum  = SQL_NTS;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,        SQL_C_SLONG,  SQL_INTEGER,  0,   0, &channelCheck->serverNum,  0,             &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_OUTPUT,       SQL_C_WCHAR,  SQL_WVARCHAR, 50,  0, channelCheck->serverName,  serverNameLen, &cbServerName    );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_OUTPUT,       SQL_C_CHAR,   SQL_VARCHAR,  200, 0, channelCheck->serverDesc,  serverDescLen, &cbServerDesc    );
		retcode = SQLBindParameter( mHstmt, 0x4, SQL_PARAM_INPUT_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0,   0, &channelCheck->channelNum, 0,             &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x5, SQL_PARAM_INPUT,        SQL_C_CHAR,   SQL_VARCHAR,  20,  0, channelCheck->inetnum,     inetnumLen,    &cbInetnum       );
		retcode = SQLBindParameter( mHstmt, 0x6, SQL_PARAM_INPUT,        SQL_C_SLONG,  SQL_INTEGER,  0,   0, &channelCheck->ipv4,       0,             &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x7, SQL_PARAM_INPUT,        SQL_C_SHORT,  SQL_SMALLINT, 0,   0, &channelCheck->port,       0,             &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x8, SQL_PARAM_OUTPUT,       SQL_C_SLONG,  SQL_INTEGER,  0,   0, &channelCheck->retvalue,   0,             &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// MemberCheck Method.
SQLRETURN cSQLAccountStmt::MemberCheck(MEMBER_CHECK* memberCheck)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_MEMBER_CHECK(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &memberCheck->loginIdx,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &memberCheck->memberIdx,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &memberCheck->serverNum,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x4, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &memberCheck->channelNum,     0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x5, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &memberCheck->lastChannel,    0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x6, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &memberCheck->characterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x7, SQL_PARAM_OUTPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &memberCheck->instantDungeon, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x8, SQL_PARAM_OUTPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &memberCheck->slevel,         0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x9, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &memberCheck->retvalue,       0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// MemberLogout Method.
SQLRETURN cSQLAccountStmt::MemberLogout(MEMBER_LOGOUT* memberLogout)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_MEMBER_LOGOUT(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &memberLogout->loginIdx,  0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &memberLogout->memberIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &memberLogout->retvalue,  0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// ComeinGame Method.
// GP_COMEIN_GAME.SQL .
SQLRETURN cSQLAccountStmt::ComeinGame(COMEIN_GAME* comeinGame)
{
	SQLCHAR*     statement = (SQLCHAR*)"{call GP_COMEIN_GAME(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER   strLenOrInd;
	SQLRETURN    retcode;
	SQLUSMALLINT param;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &comeinGame->loginIdx,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &comeinGame->serverNum,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &comeinGame->channelNum,     0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &comeinGame->lastChannel,    0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &comeinGame->characterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &comeinGame->instantDungeon, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &comeinGame->ipv4,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SSHORT,  SQL_SMALLINT, 0,  0, &comeinGame->port,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &comeinGame->retvalue,       0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// GameinComplete Method.
SQLRETURN cSQLAccountStmt::GameinComplete(GAMEIN_COMPLETE* gameinComplete)
{
	SQLCHAR*     statement = (SQLCHAR*)"{call GP_GAMEIN_COMPLETE(?, ?)}";
	SQLINTEGER   strLenOrInd;
	SQLRETURN    retcode;
	SQLUSMALLINT param;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		long nameSize = sizeof(gameinComplete->characterName);
		long cbName   = wcslen(gameinComplete->characterName) ? SQL_NTS : SQL_NULL_DATA;

		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER,  0,  0, &gameinComplete->loginIdx,     0,        &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_WCHAR, SQL_WVARCHAR, 16, 0, gameinComplete->characterName, nameSize, &cbName          );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// GameoutComplete Method.
SQLRETURN cSQLAccountStmt::GameoutComplete(GAMEOUT_COMPLETE* gameoutComplete)
{
	SQLCHAR*     statement = (SQLCHAR*)"{call GP_GAMEOUT_COMPLETE(?)}";
	SQLINTEGER   strLenOrInd;
	SQLRETURN    retcode;
	SQLUSMALLINT param;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &gameoutComplete->loginIdx, 0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
};

// GotoInstantDungeon Method.
SQLRETURN cSQLAccountStmt::GotoInstantDungeon(GOTO_INSTANT_DUNGEON* gotoInstantDungeon)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_COMEIN_GAME(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->loginIdx,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->memberIdx,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->serverNum,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x4, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->channelNum,     0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x5, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->lastChannel,    0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x6, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->characterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x7, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &gotoInstantDungeon->instantDungeon, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x8, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->ipv4,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x9, SQL_PARAM_OUTPUT, SQL_C_SSHORT,  SQL_SMALLINT, 0,  0, &gotoInstantDungeon->port,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0xa, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &gotoInstantDungeon->retvalue,       0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// ReturnToMap Method.
SQLRETURN cSQLAccountStmt::ReturnToMap(RETURN_TO_MAP* returnToMap)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_COMEIN_GAME(?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->loginIdx,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->memberIdx,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->serverNum,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x4, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->channelNum,     0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x5, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->lastChannel,    0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x6, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->characterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x7, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &returnToMap->instantDungeon, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x8, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->ipv4,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x9, SQL_PARAM_OUTPUT, SQL_C_SSHORT,  SQL_SMALLINT, 0,  0, &returnToMap->port,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0xa, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &returnToMap->retvalue,       0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

SQLRETURN cSQLAccountStmt::WhsiperMemberSelect( WHISPERMEMBER_SELECT* memberSelect )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_MEMBER_SELECT(?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	long       nameSize = sizeof(memberSelect->recvName);
	long       cbName   = wcslen(memberSelect->recvName) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 16, 0, memberSelect->recvName,		nameSize, &cbName          );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0,  0, &memberSelect->channelNum,	0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLAccountStmt::NoteMemberSelect( NOTEMEMBER_SELECT* memberSelect )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_MEMBER_SELECT(?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	long       nameSize = sizeof(memberSelect->recvName);
	long       cbName   = wcslen(memberSelect->recvName) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 16, 0, memberSelect->recvName,		nameSize, &cbName          );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0,  0, &memberSelect->channelNum,	0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}