/* ====================================================================
 *      :	sqlAccountStmt.h
 *      :	
 *    :	ö
 *    :	07/01/12/
 * ǻ :	
 * =================================================================== */
#ifndef __SQL_ACCOUNT_STATEMENT_H__
#define __SQL_ACCOUNT_STATEMENT_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "odbcsql.h"
#include "Guild_Common.h"

struct SHUTDOWN_ACCOUNT
{
	long serverNum;
	long channelNum;
};

struct CHANNEL_CHECK
{
	long    serverNum;
	wchar_t serverName[51];
	char    serverDesc[201];
	long    channelNum;
	char    inetnum[21];
	long    ipv4;
	short   port;
	long    retvalue;
};

struct MEMBER_CHECK
{
	long loginIdx;
	long memberIdx;
	int  serverNum;
	int  channelNum;
	int  lastChannel;
	long characterIdx;
	BYTE instantDungeon;
	BYTE slevel;
	long retvalue;
};

struct MEMBER_LOGOUT
{
	long loginIdx;
	long memberIdx;
	long retvalue;
};

struct COMEIN_GAME
{
	long  loginIdx;
	long  serverNum;
	long  channelNum;
	long  lastChannel;
	long  characterIdx;
	BYTE  instantDungeon;
	long  ipv4;
	short port;
	long  retvalue;
};

struct GAMEIN_COMPLETE
{
	long    loginIdx;
	wchar_t characterName[17];
};

struct GAMEOUT_COMPLETE
{
	long loginIdx;
};

struct GOTO_INSTANT_DUNGEON
{
	long  loginIdx;
	long  memberIdx;
	long  serverNum;
	long  channelNum;
	long  lastChannel;
	long  characterIdx;
	BYTE  instantDungeon;
	long  ipv4;
	short port;
	long  retvalue;
};

struct RETURN_TO_MAP
{
	long  loginIdx;
	long  memberIdx;
	long  serverNum;
	long  channelNum;
	long  lastChannel;
	long  characterIdx;
	BYTE  instantDungeon;
	long  ipv4;
	short port;
	long  retvalue;
};

//   
struct WHISPERMEMBER_SELECT
{
	wchar_t recvName[17];				// [In]  ĳ ̸
	long    channelNum;					// [Out]  äιȣ

	/// ׿
	wchar_t message[128];
	short	slotIndex;			
};

struct NOTEMEMBER_SELECT
{
	wchar_t        recvName[17];			//  ĳ̸
	long		   channelNum;				// [Out]  äιȣ

	/// ׿
	tbNOTE		   table;
	
	//long           Idx;                                     // ȣ
	//short          Year;									// 
	//unsigned short Month;									// 
	//unsigned short Day;										// 
	//unsigned short Hour;									// ð
	//unsigned short Minute;									// 
	//wchar_t        CharacterName[17];						//  ĳ̸
	//wchar_t        Message[101];							// ޽
	//unsigned long  RemainTime;								// (ms)
};

class cSQLAccountStmt :
	public cSQLStatement
{
public:
// Ŭ    ޼ҵ.
	cSQLAccountStmt(void);

	SQLRETURN Shutdown           ( SHUTDOWN_ACCOUNT* shutdownAccount );
	SQLRETURN ChannelCheck       ( CHANNEL_CHECK* channelCheck );

	SQLRETURN MemberCheck        ( MEMBER_CHECK* memberCheck );
	SQLRETURN MemberLogout       ( MEMBER_LOGOUT* memberLogout );

	SQLRETURN ComeinGame         ( COMEIN_GAME* comeinGame );
	SQLRETURN GameinComplete     ( GAMEIN_COMPLETE* gameinComplete );
	SQLRETURN GameoutComplete    ( GAMEOUT_COMPLETE* gameoutComplete );

	SQLRETURN GotoInstantDungeon ( GOTO_INSTANT_DUNGEON* gotoInstantDungeon );
	SQLRETURN ReturnToMap        ( RETURN_TO_MAP* returnToMap );

	/// ӼӸ -  
	SQLRETURN WhsiperMemberSelect	( WHISPERMEMBER_SELECT* memberSelect );
	SQLRETURN NoteMemberSelect		( NOTEMEMBER_SELECT* memberSelect );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSQLAccountStmt(void);
};

#endif // __SQL_ACCOUNT_STATEMENT_H__
