/* ====================================================================
 *      :	sqlGame.h
 *      :	
 *    :	ö
 *    :	07/01/12
 * ǻ :	
 * =================================================================== */
#ifndef __SQL_GAME_H__
#define __SQL_GAME_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "stdafx.h"

#include "sqlpool.h"
#include "sqlgamestmt.h"
#include "iocontextpool.h"

#include "DramaturgyManager.h"
#include "Skillscript.h"
#include "QuestManager.h"
#include "TriggerManager.h"
#include "TitleManager.h"


#ifndef __SQL_REQUEST_GAME_TYPE__
#define __SQL_REQUEST_GAME_TYPE__

enum SQL_REQUEST_GAME_TYPE
{
	// DEFAULT_SQL_GAME
	SQL_REQUEST_GAME_TEST = 0x2000,				// DEFAULT_SQL_GAME(0x2000) - defined gamesrv.h file
	SQL_REQUEST_GAME_INIT,						// Init Game Database
	SQL_REQUEST_GAME_SHUTDOWN,					// Shutdown Game Database

	// Item Table Data
	SQL_GAME_PROCESS_VERIFY_ITEM_DEFINE,		//  ̺ ˻ - 
	SQL_GAME_PROCESS_VERIFY_ITEM_ABILITY,		// "      ̺ ˻ - Ӽ
	SQL_GAME_PROCESS_VERIFY_ITEM_COOLTIME2,		// "      ̺ ˻ - Ÿ
	SQL_GAME_PROCESS_VERIFY_ITEM_LIMIT,			// "      ̺ ˻ - 
	SQL_GAME_PROCESS_VERIFY_ITEM_CARD,			// "      ̺ ˻ - ī
	SQL_GAME_PROCESS_VERIFY_ITEM_CARD_SLOT,		// "      ̺ ˻ - ī彽
	SQL_GAME_PROCESS_VERIFY_ITEM_TAROT,			// "      ̺ ˻ - Ÿ
	SQL_GAME_PROCESS_VERIFY_ITEM_ENHANCED,		// "      ̺ ˻ - ȭ
	SQL_GAME_PROCESS_VERIFY_ITEM_ENHANCEDRATE,	// "      ̺ ˻ - Ȯ(ȭ)
	SQL_GAME_PROCESS_VERIFY_ITEM_DISJOINT,		// "      ̺ ˻ - 
	SQL_GAME_PROCESS_VERIFY_ITEM_CHANGE,		// "      ̺ ˻ - ȯ

	SQL_GAME_PROCESS_ITEM_DEFINE,				//  ̺ ˻ - 
	SQL_GAME_PROCESS_ITEM_ABILITY,				//  ̺ ˻ - Ӽ
	SQL_GAME_PROCESS_ITEM_COOLTIME2,			//  ̺ ˻ - Ÿ
	SQL_GAME_PROCESS_ITEM_LIMIT,				//  ̺ ˻ - 
	SQL_GAME_PROCESS_ITEM_CARD,					//  ̺ ˻ - ī
	SQL_GAME_PROCESS_ITEM_CARD_SLOT,			//  ̺ ˻ - ī彽
	SQL_GAME_PROCESS_ITEM_TAROT,				//  ̺ ˻ - Ÿ
	SQL_GAME_PROCESS_ITEM_ENHANCED,				//  ̺ ˻ - ȭ
	SQL_GAME_PROCESS_ITEM_ENHANCEDRATE,			//  ̺ ˻ - Ȯ(ȭ)
	SQL_GAME_PROCESS_ITEM_DISJOINT,				//  ̺ ˻ - 
	SQL_GAME_PROCESS_ITEM_CHANGE,				//  ̺ ˻ - ȯ

	SQL_GAME_PROCESS_VERIFY_DEFAULT_ITEMS,		// ⺻  ̺ ˻.

	// Character Table Data
	SQL_GAME_PROCESS_CHARACTER_LIST,			// ĳ ϰ˻
	SQL_GAME_PROCESS_CHARACTER_NAME,			// ĳ ̸
	SQL_GAME_PROCESS_CHARACTER_INSERT,			// ĳ ߰
	SQL_GAME_PROCESS_CHARACTER_DELETE,			// ĳ 
	SQL_GAME_PROCESS_CHARACTER_UPDATE,			// ĳ 
	SQL_GAME_PROCESS_CHARACTER_SELECT,			// ĳ 
	SQL_GAME_PROCESS_CHARACTER_EQUIP,			// ĳ ()
	SQL_GAME_PROCESS_CHARACTER_MONEY,			// ĳ ݾ
	SQL_GAME_PROCESS_CHARACTER_DEPOSIT,			// ĳ ġݾ
	SQL_GAME_PROCESS_CHARACTER_TAROT_POINT,		// ĳ ŸƮ
	SQL_GAME_PROCESS_CHARACTER_PVP_POINT,		// ĳ Ʈ
	SQL_GAME_PROCESS_CHARACTER_LEVEL,			// ĳ 
	SQL_GAME_PROCESS_CHARACTER_SKILLLEVEL,		// ĳ ų 
	SQL_GAME_PROCESS_CHARACTER_ACTIVE_WEPON,	// ĳ Ȱ 
	SQL_GAME_PROCESS_CHARACTER_OPTION,			// ĳ ɼ
	SQL_GAME_PROCESS_CHARACTER_FORCETYPE,		// ĳ  Ÿ
	SQL_GAME_PROCESS_CHARACTER_SKILLRESET,		// ĳ ų ʱȭ
	SQL_GAME_PROCESS_CHARACTER_BLOCK_SELECT,	// ĳ (ä) ˻
	SQL_GAME_PROCESS_CHARACTER_BLOCK_INSERT,	// ĳ (ä) ߰

	// Inventory & Item Table Data
	SQL_GAME_PROCESS_INVENTORY_INSERT,			// κ丮 ߰
	SQL_GAME_PROCESS_INVENTORY_SELECT,			// κ丮 ˻
	SQL_GAME_PROCESS_INVENTORY_DELETE,			// κ丮 
	SQL_GAME_PROCESS_INVENTORY_COOLTIME_SELECT,	// κ丮 Ÿ(˻)
	SQL_GAME_PROCESS_INVENTORY_COOLTIME_INSERT,	// κ丮 Ÿ
	SQL_GAME_PROCESS_INVENTORY_REMOVE,			// κ丮 
	SQL_GAME_PROCESS_INVENTORY_USE,				// κ丮 
	SQL_GAME_PROCESS_INVENTORY_SWAP,			// ̺丮 ȯ
	SQL_GAME_PROCESS_INVENTORY_MOVE,			// κ丮 ̵
	SQL_GAME_PROCESS_INVENTORY_EXCEPT,			// κ丮 ( ̵ó)
	SQL_GAME_PROCESS_INVENTORY_MERGE,			// κ丮 ( ̵ó)
	SQL_GAME_PROCESS_INVENTORY_DIVIDE,			// κ丮 
	SQL_GAME_PROCESS_INVENTORY_MOVE2,			// κ丮 ̵(â )
	SQL_GAME_PROCESS_INVENTORY_ENHANCED,		// κ丮 ȭ
	SQL_GAME_PROCESS_INVENTORY_DISJOINT,		// κ丮 
	SQL_GAME_PROCESS_INVENTORY_PUT_CARD,		// κ丮 ī
	SQL_GAME_PROCESS_INVENTORY_CHANGE,			// κ丮 ü
	SQL_GAME_PROCESS_ITEM_SELL,					//  Ǹ
	SQL_GAME_PROCESS_ITEM_BUY,					//  
	SQL_GAME_PROCESS_ITEM_COLLECT,				//  (÷Ǻ)
	SQL_GAME_PROCESS_ITEM_GET,					//  (ݱ)
	SQL_GAME_PROCESS_ITEM_GET_QUEST,			//  (Ʈ)
	SQL_GAME_PROCESS_ITEM_USE,					//  (κ丮 )
	SQL_GAME_PROCESS_ITEM_EXCHANGE,				//  ŷ
	SQL_GAME_PROCESS_ITEM_MIX,					//  

	// Note Table Data
	SQL_GAME_PROCESS_NOTE_SELECT,				// (Ʈ) ˻
	SQL_GAME_PROCESS_NOTE_INSERT,				// (Ʈ) ߰
	SQL_GAME_PROCESS_NOTE_DELETE,				// (Ʈ) 

	SQL_GAME_PROCESS_GUILDNOTE_INSERT,			//  (Ʈ) ߰

	// Friend Table Data
	SQL_GAME_PROCESS_FRIEND_SELECT,				// ģ ˻
	SQL_GAME_PROCESS_FRIEND_INSERT,				// ģ ߰
	SQL_GAME_PROCESS_FRIEND_UPDATE,				// ģ 
	SQL_GAME_PROCESS_FRIEND_DELETE,				// ģ 

	// Item Table Data
	SQL_GAME_PROCESS_ITEM_SPREAD_VALUE,			//    ȯ
	SQL_GAME_PROCESS_ITEM_TAROT_RESULT,			//  Ÿȿ  ȯ

	// Skill Table Data
	SQL_GAME_PROCESS_SKILL_SELECT,				// ų Ʈ
	SQL_GAME_PROCESS_SKILL_INSERT,				// ų ߰
	SQL_GAME_PROCESS_SKILL_UPDATE,				// ų ܰ
	SQL_GAME_PROCESS_SKILL_COOLTIME,			// ų ŸӺ

	// Skill Influence Data
	SQL_GAME_PROCESS_INFLUENCE_SELECT,			// ȿ Ʈ 
	SQL_GAME_PROCESS_INFLUENCE_INSERT,			// ȿ ߰
	SQL_GAME_PROCESS_INFLUENCE_DELETE,			// ȿ 

	// Stall Sell Table Data
	SQL_GAME_PROCESS_STALL_SELL_SEARCH,			// Ǹ Ʈ ˻
	SQL_GAME_PROCESS_STALL_SELL_INSERT,			// Ǹ Ʈ 
	SQL_GAME_PROCESS_STALL_SELL_REMOVE,			// Ǹ Ʈ 
	SQL_GAME_PROCESS_STALL_SELL_CLEAR,			// Ǹ Ʈ 
	SQL_GAME_PROCESS_STALL_SELL_GET,			// Ǹ  

	// Stall Buy Table Data
	SQL_GAME_PROCESS_STALL_BUY_SEARCH,			//  Ʈ ˻
	SQL_GAME_PROCESS_STALL_BUY_INSERT,			//  Ʈ 
	SQL_GAME_PROCESS_STALL_BUYL_DELETE,			//  Ʈ 

	// Shortcut Table Data
	SQL_GAME_PROCESS_SHORTCUT_SELECT,			// ţ ˻
	SQL_GAME_PROCESS_SHORTCUT_UPDATE,			// ţ 

	// Quest Table Data
	SQL_GAME_PROCESS_QUEST_INSERT,				// Ʈ ű 
	SQL_GAME_PROCESS_QUEST_INSERTBYITEM,		// Ʈ ű  - Ƿھ
	SQL_GAME_PROCESS_QUEST_SELECT,				// Ʈ Ʈ ޱ
	SQL_GAME_PROCESS_QUEST_UPDATE,				// Ʈ  Ʈ
	SQL_GAME_PROCESS_QUEST_DELETE,				// Ʈ  
	SQL_GAME_PROCESS_QUEST_DELETEAUTO,			// Ʈ  ڵ 
	SQL_GAME_PROCESS_QUEST_COMPLETE,			// Ʈ Ϸ û
	SQL_GAME_PROCESS_QUEST_REWARD,				// Ʈ  û
	SQL_GAME_PROCESS_QUEST_ENDLISTSELECT,		// Ʈ Ϸ  ޱ
	SQL_GAME_PROCESS_QUEST_REMOVE,				// Ʈ 
	
	// Title Data
	SQL_GAME_PROCESS_TITLE_INSERT,				// ȣĪ ߰
	SQL_GAME_PROCESS_TITLE_SELECT,				// ȣĪ Ʈ ޱ

	// Guild Data
	SQL_GAME_PROCESS_VERIFY_GUILD,				//  Ʈ ˻
	SQL_GAME_PROCESS_GUILDUSER_SELECT,			//   Ʈ ˻
	
	SQL_GAME_PROCESS_GUILD_SELECT,				//   Ʈ ˻
	SQL_GAME_PROCESS_GUILD_CREATE,				//  
	SQL_GAME_PROCESS_GUILD_DELETE,				//  ü
	SQL_GAME_PROCESS_GUILD_UPDATE,				//  
	SQL_GAME_PROCESS_GUILDUSER_ADD,				//   ߰
	SQL_GAME_PROCESS_GUILDUSER_OUT,				//   Ż
	SQL_GAME_PROCESS_GUILDUSER_CUT,				//   ߹
	SQL_GAME_PROCESS_GUILDUSER_GIVEPOSITION,	//   
	SQL_GAME_PROCESS_GUILDMARK_UPDATE,			//  ũ 

	// ų
	SQL_GAME_PROCESS_MAKESKILL_INSERT,
	SQL_GAME_PROCESS_MAKESKILL_SELECT,
	SQL_GAME_PROCESS_MAKESKILL_DELETE,

	SQL_GAME_PROCESS_RECIPE_INSERT,
	SQL_GAME_PROCESS_RECIPE_GROUP_INSERT,
	SQL_GAME_PROCESS_RECIPE_COOLTIME,

	//  Ӽ
	SQL_GAME_PROCESS_FORTUNE_SELECT,
	SQL_GAME_PROCESS_FORTUNE_UPDATE,

	// MAX
	MAX_SQL_GAME
};

#endif // __SQL_REQUEST_GAME_TYPE__


class cSQLGame :
	public cSQLPool
{
private:
	cIoContextPool*   mIoContextPool;

protected:
// Page Pool  ޼ҵ.
	PerSQLConnection* AllocSQLConnection ( void );

private:
// LOG  ޼ҵ.
	bool              PostServerEvent        ( LPCTSTR format, ... );

public:
// Item Insert ޼ҵ(Script).
	bool              InsertItemDefine       ( char* dsn, char* uid, char* pwd );
	bool              InsertItemAbility      ( char* dsn, char* uid, char* pwd );
	bool              InsertItemLimit        ( char* dsn, char* uid, char* pwd );
	bool              InsertItemCard         ( char* dsn, char* uid, char* pwd );
	bool              InsertItemCardSlot     ( char* dsn, char* uid, char* pwd );
	bool              InsertItemTarot        ( char* dsn, char* uid, char* pwd );
	bool              InsertItemTarotResult  ( char* dsn, char* uid, char* pwd );
	bool              InsertItemSpread       ( char* dsn, char* uid, char* pwd );
	bool              InsertItemDisjoint     ( char* dsn, char* uid, char* pwd );
	bool              InsertItemEnhanced     ( char* dsn, char* uid, char* pwd );
	bool              InsertItemEnhancedRate ( char* dsn, char* uid, char* pwd );
	bool              InsertItemChange       ( char* dsn, char* uid, char* pwd );
	bool              InsertDefaultItems     ( char* dsn, char* uid, char* pwd );

	bool              ConsoleInsertInit      ( );
	void              ConsoleInsertRelease   ( );

	// Skill Insert ޼ҵ(Script)
	bool              InsertSkillPC          ( char* dsn, char* uid, char* pwd );
	//  ⺻ų Ʈ
	bool              InsertDefaultSkill     ( char* dsn, char* uid, char* pwd );
	
	/// Ʈ ε
	bool			  InsertQuestData        ( char* dsn, char* uid, char* pwd );

public:
// Ŭ    ޼ҵ.
	cSQLGame(void);

	bool              Initialize             ( char* dsn, char* uid, char* pwd, unsigned int numWorkerThreads=2, unsigned int bufferLength=65535 );
	void              Shutdown               ( void );

	void              GetIoContextPool       ( SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize );

	PerIoContext*     Get                    ( );
	void              Release                ( PerIoContext* perIoContext );

	DWORD             WorkerThread           ( void );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSQLGame(void);

private:
	cSkillScript*		mpSkillScript;
	cQuestManager*		mpQuestManager;
	cTriggerManager*	mpTriggerManager;
	cTitleManager*		mpTitleManager;
};

#endif // __SQL_GAME_H__
