// Include
#include "stdafx.h"
#include "sqlgamestmt.h"
#include "QuestDefine.h"
// Local definitions

// Global data

// cSQLGameStmt Constructor.
cSQLGameStmt::cSQLGameStmt(void)
{
}

// ~cSQLGameStmt Destructor.
cSQLGameStmt::~cSQLGameStmt(void)
{
}

// Init Method
SQLRETURN cSQLGameStmt::Init(INIT_GAME* initGame)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_INIT(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &initGame->channelNum,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &initGame->removeCoolTimeCount,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &initGame->removeSTallSellCount, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// Shutdown Method
SQLRETURN cSQLGameStmt::Shutdown(SHUTDOWN_GAME* shutdownGame)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SHUTDOWN(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &shutdownGame->channelNum,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &shutdownGame->removeCoolTimeCount,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &shutdownGame->removeSTallSellCount, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// TruncateItemDefine Method
SQLRETURN cSQLGameStmt::TruncateItemDefine(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_DEFINE", SQL_NTS ), mHstmt );
}

// TruncateItemAbility Method
SQLRETURN cSQLGameStmt::TruncateItemAbility(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_ABILITY", SQL_NTS ), mHstmt );
}

// TruncateItemLimit Method
SQLRETURN cSQLGameStmt::TruncateItemLimit(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_LIMIT", SQL_NTS ), mHstmt );
}

// TruncateItemCard Method
SQLRETURN cSQLGameStmt::TruncateItemCard(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_CARD", SQL_NTS ), mHstmt );
}

// TruncateItemCardSlot Method
SQLRETURN cSQLGameStmt::TruncateItemCardSlot(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_CARD_SLOT", SQL_NTS ), mHstmt );
}

// TruncateItemTarot Method
SQLRETURN cSQLGameStmt::TruncateItemTarot(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_TAROT", SQL_NTS ), mHstmt );
}

// TruncateItemTarotResult Method
SQLRETURN cSQLGameStmt::TruncateItemTarotResult(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_TAROT_RESULT", SQL_NTS ), mHstmt );
}

// TruncateItemSpread Method
SQLRETURN cSQLGameStmt::TruncateItemSpread(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_SPREAD", SQL_NTS ), mHstmt );
}

// TruncateItemDisjoint Method
SQLRETURN cSQLGameStmt::TruncateItemDisjoint(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_DISJOINT", SQL_NTS ), mHstmt );
}

// TruncateItemEnhanced Method
SQLRETURN cSQLGameStmt::TruncateItemEnhanced(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_ENHANCED", SQL_NTS ), mHstmt );
}

// TruncateItemEnhancedRate Method
SQLRETURN cSQLGameStmt::TruncateItemEnhancedRate(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_ENHANCED_RATE", SQL_NTS ), mHstmt );
}

// TruncateItemChange Method
SQLRETURN cSQLGameStmt::TruncateItemChange(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_ITEM_CHANGE", SQL_NTS ), mHstmt );
}

// TruncateDefaultItems Method
SQLRETURN cSQLGameStmt::TruncateDefaultItems(void)
{
	return SQLClose( SQLExecDirect( mHstmt, (SQLCHAR*)"TRUNCATE TABLE TB_DEFAULT_ITEMS", SQL_NTS ), mHstmt );
}

// InsertItemDefine Method
SQLRETURN cSQLGameStmt::InsertItemDefine(TB_ITEM_DEFINE* tbItemDefine, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_DEFINE_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	long       nameSize = sizeof(tbItemDefine->name);
	long       cbName   = wcslen(tbItemDefine->name) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->index,             0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_WCHAR,   SQL_WVARCHAR, 50, 0, tbItemDefine->name,               nameSize, &cbName          );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &tbItemDefine->type,              0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &tbItemDefine->subType,           0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0,  0, &tbItemDefine->weight,            0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0,  0, &tbItemDefine->capacity,          0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->sellType,          0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->sellPrice,         0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->buyType,           0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->buyPrice,          0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->maxPresent,        0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &tbItemDefine->exchange,          0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->maxInventory,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->abilityIndex,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->limitIndex,        0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->cardIndex,         0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->cardSlotIndex,     0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->tarotIndex,        0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->spreadIndex,       0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->enhancedIndex,     0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->enhancedRateIndex, 0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->disjointIndex,     0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->changeIndex,       0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &tbItemDefine->titleIndex,        0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &retvalue,                        0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemAbility Method
SQLRETURN cSQLGameStmt::InsertItemAbility(TB_ITEM_ABILITY* tbItemAbility, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_ABILITY_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &tbItemAbility->index,         0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->def_class,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0, 0, &tbItemAbility->range_type,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0, 0, &tbItemAbility->target_type,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->use_range,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->p_def,         0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->m_def,         0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->atk_range,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->atk_spd,       0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &tbItemAbility->cool_time1,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &tbItemAbility->cool_time2,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->min_p_atk,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->max_p_atk,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->min_m_atk,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->max_m_atk,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt01_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt01_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt02_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt02_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt03_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt03_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt04_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt04_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt05_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt05_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt06_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt06_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt07_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt07_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt08_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt08_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt09_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt09_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt10_index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemAbility->opt10_value,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &tbItemAbility->influence_idx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &retvalue,                     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemLimit Method
SQLRETURN cSQLGameStmt::InsertItemLimit(TB_ITEM_LIMIT* tbItemLimit, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_LIMIT_INSERT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemLimit->index,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemLimit->charRace,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemLimit->charGender, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemLimit->charJob,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemLimit->charLevel,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemLimit->pvpOnly,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &retvalue,                0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemCard Method
SQLRETURN cSQLGameStmt::InsertItemCard(TB_ITEM_CARD* tbItemCard, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_CARD_INSERT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemCard->index,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemCard->episode, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemCard->number,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCard->level,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCard->type,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCard->subType, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &retvalue,            0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemCardSlot Method
SQLRETURN cSQLGameStmt::InsertItemCardSlot(TB_ITEM_CARD_SLOT* tbItemCardSlot, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_CARD_SLOT_INSERT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemCardSlot->index, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCardSlot->slot1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCardSlot->slot2, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCardSlot->slot3, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCardSlot->slot4, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemCardSlot->slot5, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &retvalue,              0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemCard Method
SQLRETURN cSQLGameStmt::InsertItemTarot(TB_ITEM_TAROT* tbItemTarot, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_TAROT_INSERT(?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemTarot->index,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemTarot->number,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &tbItemTarot->level,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemTarot->strValue, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemTarot->invValue, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemTarot->prop,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &tbItemTarot->episode,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &retvalue,              0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemTarotResult Method
SQLRETURN cSQLGameStmt::InsertItemTarotResult(TB_ITEM_TAROT_RESULT* tbItemTarotResult, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_TAROT_RESULT_INSERT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &tbItemTarotResult->index,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &tbItemTarotResult->min_value,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &tbItemTarotResult->max_value,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &tbItemTarotResult->influence_idx1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &tbItemTarotResult->influence_idx2, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &tbItemTarotResult->influence_idx3, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &retvalue,                          0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemSpread Method
SQLRETURN cSQLGameStmt::InsertItemSpread(TB_ITEM_SPREAD* tbItemSpread, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_SPREAD_INSERT(?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	long       calcSize = sizeof(tbItemSpread->calc);
	long       cbCalc   = strlen(tbItemSpread->calc) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &tbItemSpread->index,     0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0, 0, &tbItemSpread->axisArray, 0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemSpread->xPos,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemSpread->yPos,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0, 0, &tbItemSpread->dir,       0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_CHAR,     2, 0, &tbItemSpread->calc,      calcSize, &cbCalc          );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &tbItemSpread->value,     0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &retvalue,                0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemDisjoint Method
SQLRETURN cSQLGameStmt::InsertItemDisjoint(TB_ITEM_DISJOINT* tbItemDisjoint, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_DISJOINT_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->index,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->price,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->itemDefineIndex1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbItemDisjoint->inventoryCount1,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->itemDefineIndex2, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbItemDisjoint->inventoryCount2,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->itemDefineIndex3, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbItemDisjoint->inventoryCount3,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->itemDefineIndex4, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbItemDisjoint->inventoryCount4,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->itemDefineIndex5, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbItemDisjoint->inventoryCount5,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbItemDisjoint->itemDefineIndex6, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbItemDisjoint->inventoryCount6,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &retvalue,                         0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemEnhanced Method
SQLRETURN cSQLGameStmt::InsertItemEnhanced(TB_ITEM_ENHANCED* tbItemEnhanced, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_ENHANCED_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	long plusSize = sizeof(tbItemEnhanced->strPlus);
	long cbPlus   = strlen(tbItemEnhanced->strPlus) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0,   0, &tbItemEnhanced->index,     0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0,   0, &tbItemEnhanced->enhanced1, 0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0,   0, &tbItemEnhanced->enhanced2, 0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_VARCHAR, 260, 0, tbItemEnhanced->strPlus,    plusSize, &cbPlus          );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,   0, &retvalue,                  0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemEnhancedRate Method
SQLRETURN cSQLGameStmt::InsertItemEnhancedRate(TB_ITEM_ENHANCED_RATE* tbItemEnhancedRate, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_ENHANCED_RATE_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	long successSize = sizeof(tbItemEnhancedRate->str.success);
	long cbSuccess   = strlen(tbItemEnhancedRate->str.success) ? SQL_NTS : SQL_NULL_DATA;

	long downSize     = sizeof(tbItemEnhancedRate->str.down);
	long cbDown       = strlen(tbItemEnhancedRate->str.down) ? SQL_NTS : SQL_NULL_DATA;

	long destructSize = sizeof(tbItemEnhancedRate->str.destruct);
	long cbDestruct   = strlen(tbItemEnhancedRate->str.destruct) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0,   0, &tbItemEnhancedRate->index,       0,            &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_VARCHAR, 260, 0, tbItemEnhancedRate->str.success,  successSize,  &cbSuccess       );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_VARCHAR, 260, 0, tbItemEnhancedRate->str.down,     downSize,     &cbDown          );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_VARCHAR, 260, 0, tbItemEnhancedRate->str.destruct, destructSize, &cbDestruct      );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,   0, &retvalue,                        0,            &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertItemChange Method
SQLRETURN cSQLGameStmt::InsertItemChange(TB_ITEM_CHANGE* tbItemChange, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_CHANGE_INSERT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	long rateSize  = sizeof(tbItemChange->str.rate);
	long cbRate    = strlen(tbItemChange->str.rate) ? SQL_NTS : SQL_NULL_DATA;

	long indexSize = sizeof(tbItemChange->str.index);
	long cbIndex   = strlen(tbItemChange->str.index) ? SQL_NTS : SQL_NULL_DATA;

	long countSize = sizeof(tbItemChange->str.count);
	long cbCount   = strlen(tbItemChange->str.count) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0,   0, &tbItemChange->index,     0,         &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0,   0, &tbItemChange->minMoney,  0,         &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0,   0, &tbItemChange->maxMoney,  0,         &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,  SQL_VARCHAR, 400, 0, tbItemChange->str.rate,   rateSize,  &cbRate          );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,  SQL_VARCHAR, 400, 0, tbItemChange->str.index,  indexSize, &cbIndex         );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,  SQL_VARCHAR, 400, 0, tbItemChange->str.count,  countSize, &cbCount         );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0,   0, &retvalue,                0,         &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InsertDefaultItems Method
SQLRETURN cSQLGameStmt::InsertDefaultItems(TB_DEFAULT_ITEMS* tbDefaultItems, long& retvalue)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_DEFAULT_ITEMS_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbDefaultItems->characterJob,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &tbDefaultItems->itemDefineIndex, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbDefaultItems->inventoryNumber, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &tbDefaultItems->inventoryCount,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &retvalue,                        0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemDefine Method
SQLRETURN cSQLGameStmt::VerifyItemDefine(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_DEFINE(?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemAbility Method
SQLRETURN cSQLGameStmt::VerifyItemAbility(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_ABILITY(?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemCooltime2 Method
SQLRETURN cSQLGameStmt::VerifyItemCooltime2(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_COOLTIME2(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemLimit Method
SQLRETURN cSQLGameStmt::VerifyItemLimit(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_LIMIT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemCard Method
SQLRETURN cSQLGameStmt::VerifyItemCard(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_CARD(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemCardSlot Method
SQLRETURN cSQLGameStmt::VerifyItemCardSlot(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_CARD_SLOT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemTarot Method
SQLRETURN cSQLGameStmt::VerifyItemTarot(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_TAROT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemEnhanced Method
SQLRETURN cSQLGameStmt::VerifyItemEnhanced(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_ENHANCED(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemEnhancedRate Method
SQLRETURN cSQLGameStmt::VerifyItemEnhancedRate(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_ENHANCED_RATE(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemDisjoint Method
SQLRETURN cSQLGameStmt::VerifyItemDisjoint(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_DISJOINT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// VerifyItemChange Method
SQLRETURN cSQLGameStmt::VerifyItemChange(VERIFY_ITEM_TABLE* verifyItemTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_ITEM_CHANGE(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->count,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyItemTable->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// ItemDefine Method
// GP_ITEM_DEFINE_SELECT .
//   @IDX [int] --ε
SQLRETURN cSQLGameStmt::ItemDefine(ITEM_DEFINE_TABLE* itemDefineTable)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_DEFINE_SELECT(?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemDefineTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_DEFINE* table    = itemDefineTable->table;
		SQLINTEGER      nameSize = sizeof(itemDefineTable->table->name);

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, param=1, SQL_C_SLONG,   &table->idx,               0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxAbility,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxLimit,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxCard,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxCardSlot,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxTarot,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxEnhanced,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxEnhancedRate,   0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxDisjoint,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->idxChange,         0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->index,             0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_WCHAR,   table->name,               nameSize, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_TINYINT, &table->type,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_TINYINT, &table->subType,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SSHORT,  &table->weight,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SSHORT,  &table->capacity,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->sellType,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->sellPrice,         0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->buyType,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->buyPrice,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->present,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->maxPresent,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_TINYINT, &table->exchange,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->maxInventory,      0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->abilityIndex,      0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->limitIndex,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->cardIndex,         0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->cardSlotIndex,     0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->tarotIndex,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->spreadIndex,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->enhancedIndex,     0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->enhancedRateIndex, 0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->disjointIndex,     0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->changeIndex,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->titleIndex,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_TINYINT, &table->apply,             0,        &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemAbility Method
// GP_ITEM_ABILITY_SELECT .
SQLRETURN cSQLGameStmt::ItemAbility(ITEM_ABILITY_TABLE* itemAbilityTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_ABILITY_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemAbilityTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_ABILITY* table = itemAbilityTable->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1,  SQL_C_SLONG,   &table->idx,           0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2,  SQL_C_SLONG,   &table->index,         0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3,  SQL_C_SSHORT,  &table->def_class,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4,  SQL_C_TINYINT, &table->range_type,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5,  SQL_C_TINYINT, &table->target_type,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6,  SQL_C_SSHORT,  &table->use_range,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7,  SQL_C_SSHORT,  &table->p_def,         0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 8,  SQL_C_SSHORT,  &table->m_def,         0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 9,  SQL_C_SSHORT,  &table->atk_range,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 10, SQL_C_SSHORT,  &table->atk_spd,       0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 11, SQL_C_SLONG,   &table->cool_time1,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 12, SQL_C_SLONG,   &table->cool_time2,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 13, SQL_C_SSHORT,  &table->min_p_atk,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 14, SQL_C_SSHORT,  &table->max_p_atk,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 15, SQL_C_SSHORT,  &table->min_m_atk,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 16, SQL_C_SSHORT,  &table->max_m_atk,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 17, SQL_C_SSHORT,  &table->opt01_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 18, SQL_C_SSHORT,  &table->opt01_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 19, SQL_C_SSHORT,  &table->opt02_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 20, SQL_C_SSHORT,  &table->opt02_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 21, SQL_C_SSHORT,  &table->opt03_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 22, SQL_C_SSHORT,  &table->opt03_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 23, SQL_C_SSHORT,  &table->opt04_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 24, SQL_C_SSHORT,  &table->opt04_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 25, SQL_C_SSHORT,  &table->opt05_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 26, SQL_C_SSHORT,  &table->opt05_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 27, SQL_C_SSHORT,  &table->opt06_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 28, SQL_C_SSHORT,  &table->opt06_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 29, SQL_C_SSHORT,  &table->opt07_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 30, SQL_C_SSHORT,  &table->opt07_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 31, SQL_C_SSHORT,  &table->opt08_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 32, SQL_C_SSHORT,  &table->opt08_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 33, SQL_C_SSHORT,  &table->opt09_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 34, SQL_C_SSHORT,  &table->opt09_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 35, SQL_C_SSHORT,  &table->opt10_index,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 36, SQL_C_SSHORT,  &table->opt10_value,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 37, SQL_C_SLONG,   &table->influence_idx, 0, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemCooltime2 Method
// GP_ITEM_COOLTIME2_SELECT .
SQLRETURN cSQLGameStmt::ItemCooltime2(ITEM_COOLTIME2_TABLE* itemCooltime2Table, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_COOLTIME2_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemCooltime2Table->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		u_long     tableSize = sizeof(itemCooltime2Table->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, &itemCooltime2Table->table[ i ].itemDefineIdx,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG, &itemCooltime2Table->table[ i ].itemDefineIndex, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SLONG, &itemCooltime2Table->table[ i ].cooltime,        0, &(strLenOrInd=0) );
			itemCooltime2Table->rowCount++;
		}
		cbLength += (itemCooltime2Table->rowCount * tableSize);

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemLimit Method
// GP_ITEM_LIMIT_SELECT .
SQLRETURN cSQLGameStmt::ItemLimit(ITEM_LIMIT_TABLE* itemLimitTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_LIMIT_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemLimitTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_LIMIT* table = itemLimitTable->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &table->idx,        0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &table->index,      0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_TINYINT, &table->charRace,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_TINYINT, &table->charGender, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_SLONG,   &table->charJob,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6, SQL_C_TINYINT, &table->charLevel,  0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7, SQL_C_TINYINT, &table->pvpOnly,    0, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemCard Method
// GP_ITEM_CARD_SELECT .
SQLRETURN cSQLGameStmt::ItemCard(ITEM_CARD_TABLE* itemCardTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_CARD_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemCardTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_CARD* table = itemCardTable->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, &table->idx,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG, &table->index, 0, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemCardSlot Method
// GP_ITEM_CARD_SLOT_SELECT .
SQLRETURN cSQLGameStmt::ItemCardSlot(ITEM_CARD_SLOT_TABLE* itemCardSlotTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_CARD_SLOT_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemCardSlotTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_CARD_SLOT* table = itemCardSlotTable->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &table->idx,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &table->index, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_TINYINT, &table->slot1, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_TINYINT, &table->slot2, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_TINYINT, &table->slot3, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6, SQL_C_TINYINT, &table->slot4, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7, SQL_C_TINYINT, &table->slot5, 0, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemTarot Method
// GP_ITEM_TAROT_SELECT .
SQLRETURN cSQLGameStmt::ItemTarot(ITEM_TAROT_TABLE* itemTarotTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_TAROT_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemTarotTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_TAROT* table = itemTarotTable->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &table->idx,      0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &table->index,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SLONG,   &table->number,   0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_TINYINT, &table->level,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_SLONG,   &table->strValue, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6, SQL_C_SLONG,   &table->invValue, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7, SQL_C_SLONG,   &table->prop,     0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 8, SQL_C_SLONG,   &table->episode,  0, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemEnhanced Method
SQLRETURN cSQLGameStmt::ItemEnhanced(ITEM_ENHANCED_TABLE* itemEnhancedTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_ENHANCED_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemEnhancedTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_ENHANCED* table       = itemEnhancedTable->table;
		SQLINTEGER        strPlusSize = sizeof(table->strPlus);

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &table->idx,       0,           &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &table->index,     0,           &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_TINYINT, &table->enhanced1, 0,           &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_TINYINT, &table->enhanced2, 0,           &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_CHAR,    table->strPlus,    strPlusSize, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemEnhancedRate Method
SQLRETURN cSQLGameStmt::ItemEnhancedRate(ITEM_ENHANCED_RATE_TABLE* itemEnhancedRateTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_ENHANCED_RATE_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemEnhancedRateTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_ENHANCED_RATE* table        = itemEnhancedRateTable->table;
		SQLINTEGER             successSize  = sizeof(table->str.success);
		SQLINTEGER             downSize     = sizeof(table->str.down);
		SQLINTEGER             destructSize = sizeof(table->str.destruct);

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, &table->idx,         0,            &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG, &table->index,       0,            &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_CHAR,  table->str.success,  successSize,  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_CHAR,  table->str.down,     downSize,     &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_CHAR,  table->str.destruct, destructSize, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemDisjoint Method
SQLRETURN cSQLGameStmt::ItemDisjoint(ITEM_DISJOINT_TABLE* itemDisjointTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_DISJOINT_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemDisjointTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_DISJOINT* table        = itemDisjointTable->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1,  SQL_C_SLONG, &table->idx,         0,            &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2,  SQL_C_SLONG, &table->index,       0,            &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3,  SQL_C_SLONG, &table->price,       0,            &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4,  SQL_C_SLONG, &table->itemDefineIndex1, 0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5,  SQL_C_SHORT, &table->inventoryCount1,  0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6,  SQL_C_SLONG, &table->itemDefineIndex2, 0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7,  SQL_C_SHORT, &table->inventoryCount2,  0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 8,  SQL_C_SLONG, &table->itemDefineIndex3, 0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 9,  SQL_C_SHORT, &table->inventoryCount3,  0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 10, SQL_C_SLONG, &table->itemDefineIndex4, 0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 11, SQL_C_SHORT, &table->inventoryCount4,  0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 12, SQL_C_SLONG, &table->itemDefineIndex5, 0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 13, SQL_C_SHORT, &table->inventoryCount5,  0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 14, SQL_C_SLONG, &table->itemDefineIndex6, 0,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 15, SQL_C_SHORT, &table->inventoryCount6,  0,       &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemChange Method
SQLRETURN cSQLGameStmt::ItemChange(ITEM_CHANGE_TABLE* itemChangeTable)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_CHANGE_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemChangeTable->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_ITEM_CHANGE* table = itemChangeTable->table;
		SQLINTEGER      rateSize  = sizeof(table->str.rate);
		SQLINTEGER      indexSize = sizeof(table->str.index);
		SQLINTEGER      countSize = sizeof(table->str.count);

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, &table->idx,      0,         &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG, &table->index,    0,         &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SLONG, &table->minMoney, 0,         &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_SLONG, &table->maxMoney, 0,         &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_CHAR,  table->str.rate,  rateSize,  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6, SQL_C_CHAR,  table->str.index, indexSize, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7, SQL_C_CHAR,  table->str.count, countSize, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// VerifyDefaultItems Method
SQLRETURN cSQLGameStmt::VerifyDefaultItems(VERIFY_DEFAULT_ITEMS* verifyDefaultItems)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_VERIFY_DEFAULT_ITEMS(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyDefaultItems->rowCount, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyDefaultItems->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterList Method
// GP_CHARACTER_LIST .
//   @USER_IDX [int]
SQLRETURN cSQLGameStmt::CharacterList(CHARACTER_LIST* characterList, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_LIST(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterList->userIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		u_long     tableSize = sizeof(characterList->table);
		SQLINTEGER nameSize  = sizeof(characterList->table->name);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt,  1, SQL_C_SLONG,   &characterList->table[ i ].idx,               0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt,  2, SQL_C_WCHAR,   characterList->table[ i ].name,               nameSize, &(strLenOrInd=0) );
			SQLGetData( mHstmt,  3, SQL_C_TINYINT, &characterList->table[ i ].level ,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt,  4, SQL_C_TINYINT, &characterList->table[ i ].race,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt,  5, SQL_C_TINYINT, &characterList->table[ i ].gender,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt,  6, SQL_C_SLONG,   &characterList->table[ i ].job,               0,        &(strLenOrInd=0) );

			SQLGetData( mHstmt,  7, SQL_C_SLONG,   &characterList->table[ i ].hair,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt,  8, SQL_C_SLONG,   &characterList->table[ i ].face,              0,        &(strLenOrInd=0) );

			SQLGetData( mHstmt,  9, SQL_C_SLONG,   &characterList->table[ i ].hat,               0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 10, SQL_C_SLONG,   &characterList->table[ i ].body1,             0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 11, SQL_C_SLONG,   &characterList->table[ i ].body2,             0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 12, SQL_C_SLONG,   &characterList->table[ i ].hand,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 13, SQL_C_SLONG,   &characterList->table[ i ].foot,              0,        &(strLenOrInd=0) );

			SQLGetData( mHstmt, 14, SQL_C_SLONG,   &characterList->table[ i ].earring,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 15, SQL_C_SLONG,   &characterList->table[ i ].necklace,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 16, SQL_C_SLONG,   &characterList->table[ i ].brooch,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 17, SQL_C_SLONG,   &characterList->table[ i ].bracelet,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 18, SQL_C_SLONG,   &characterList->table[ i ].ring,              0,        &(strLenOrInd=0) );

			SQLGetData( mHstmt, 19, SQL_C_SLONG,   &characterList->table[ i ].leftHand,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 20, SQL_C_TINYINT, &characterList->table[ i ].leftHandEnhanced,  0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 21, SQL_C_SLONG,   &characterList->table[ i ].rightHand,         0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 22, SQL_C_TINYINT, &characterList->table[ i ].rightHandEnhanced, 0,        &(strLenOrInd=0) );

			SQLGetData( mHstmt, 23, SQL_C_SSHORT,  &characterList->table[ i ].mapNum,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 24, SQL_C_TINYINT, &characterList->table[ i ].standIdx,          0,        &(strLenOrInd=0) );

			characterList->rowCount++;
		}

		cbLength += (characterList->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// CharacterName Method
SQLRETURN cSQLGameStmt::CharacterName(CHARACTER_NAME* characterName)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_NAME(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       nameSize = sizeof(characterName->name);
	long       cbName   = wcslen(characterName->name) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 16, 0, characterName->name,      nameSize, &cbName          );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0,  0, &characterName->retvalue, 0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterInsert Method
// GP_CHARACTER_INSERT .
SQLRETURN cSQLGameStmt::CharacterInsert(CHARACTER_INSERT* characterInsert, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       nameSize = sizeof(characterInsert->name);
	long       cbName   = wcslen(characterInsert->name) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1,  SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->idx,       0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2,  SQL_PARAM_INPUT,  SQL_C_WCHAR,   SQL_WVARCHAR, 16, 0, characterInsert->name,       nameSize, &cbName          );
	retcode = SQLBindParameter( mHstmt, 3,  SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &characterInsert->race,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4,  SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &characterInsert->gender,    0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5,  SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->job,       0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6,  SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->hair,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 7,  SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->face,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 8,  SQL_PARAM_INPUT,  SQL_C_FLOAT,   SQL_REAL,     0,  0, &characterInsert->xPos,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 9,  SQL_PARAM_INPUT,  SQL_C_FLOAT,   SQL_REAL,     0,  0, &characterInsert->yPos,      0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 10, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->hp,        0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 11, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->mp,        0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 12, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0,  0, &characterInsert->standIdx,  0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 13, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->userIdx,   0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 14, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0,  0, &characterInsert->retvalue,  0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_INVENTORY* table     = characterInsert->table;
		u_long        tableSize = sizeof(characterInsert->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++, table++ )
		{
			SQLGetFullInv( mHstmt, table );
			characterInsert->rowCount++;
		}

		cbLength += (characterInsert->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// CharacterDelete Method
// GP_CHARACTER_DELETE .
SQLRETURN cSQLGameStmt::CharacterDelete(CHARACTER_DELETE* characterDelete)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_DELETE(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterDelete->idx,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterDelete->userIdx,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterDelete->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterUpdate Method
// GP_CHARACTER_UPDATE .
SQLRETURN cSQLGameStmt::CharacterUpdate(CHARACTER_UPDATE* characterUpdate)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_CHARACTER_UPDATE(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->idx,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &characterUpdate->mapNumber,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_FLOAT,   SQL_REAL,     0, 0, &characterUpdate->xPos,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_FLOAT,   SQL_REAL,     0, 0, &characterUpdate->yPos,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->exp,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->skillExp,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->hp,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->mp,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->tarotPoint,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->titleIndex,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->guildIndex,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0, 0, &characterUpdate->guildPosition, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &characterUpdate->retvalue,      0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterSelect Method
// GP_CHARACTER_SELECT .
SQLRETURN cSQLGameStmt::CharacterSelect(CHARACTER_SELECT* characterSelect)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_SELECT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	TB_CHARACTER* character = &characterSelect->character;
	SQLINTEGER    nameSize  = sizeof(character->name);
	SQLSMALLINT n = 0;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterSelect->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterSelect->userIdx,      0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->idx,               0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_WCHAR,   &character->name[0],           nameSize, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->level,             0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->race,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->gender,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->job,               0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->hair,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->face,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->hat,               0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->body1,             0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->body2,             0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->hand,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->foot,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->earring,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->necklace,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->brooch,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->bracelet,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->ring,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->leftHand,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->leftHandEnhanced,  0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->rightHand,         0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->rightHandEnhanced, 0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->activeWeapon,      0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SSHORT,  &character->mapNum,            0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_FLOAT,   &character->xPos,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_FLOAT,   &character->yPos,              0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->exp,               0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->HP,                0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->MP,                0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->skillLevel,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->skillPointRemain,  0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->skillPointTotal,   0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->skillExp,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->tarotPoint,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SBIGINT, &character->money,             0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SBIGINT, &character->deposit,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG,   &character->option1,           0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_UTINYINT,&character->mForceType,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mPvPPoint,         0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mFirePoint,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mFireFriendly,     0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mWaterPoint,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mWaterFriendly,    0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mWindPoint,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mWindFriendly,     0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mEarthPoint,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mEarthFriendly,    0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mTitleIndex,	   0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG,   &character->mGuildIndex,	   0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TINYINT, &character->mGuildPosition,	   0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_UTINYINT, &character->mMakeSkill1,	   0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_UTINYINT, &character->mMakeSkill2,	   0,        &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// CharacterEquip Method
// GP_CHARACTER_EQUIP .
SQLRETURN cSQLGameStmt::CharacterEquip(CHARACTER_EQUIP* characterEquip)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_CHARACTER_EQUIP(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->idx,               0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->hat,               0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->body1,             0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->body2,             0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->hand,              0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->foot,              0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->earring,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->necklace,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->brooch,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->bracelet,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->ring,              0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->leftHand,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &characterEquip->leftHandEnhanced,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &characterEquip->rightHand,         0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &characterEquip->rightHandEnhanced, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterMoney Method
// GP_CHARACTER_MONEY .
SQLRETURN cSQLGameStmt::CharacterMoney(CHARACTER_MONEY* characterMoney)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_MONEY(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterMoney->idx,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterMoney->money,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterMoney->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterDeposit Method
// GP_CHARACTER_DEPOSIT .
SQLRETURN cSQLGameStmt::CharacterDeposit(CHARACTER_DEPOSIT* characterDeposit)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_DEPOSIT(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterDeposit->idx,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterDeposit->money,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterDeposit->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterTarotPoint Method
SQLRETURN cSQLGameStmt::CharacterTarotPoint(CHARACTER_TAROT_POINT* characterTarotPoint)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_TAROT_POINT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterTarotPoint->idx,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterTarotPoint->point, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterPvpPoint Method
SQLRETURN cSQLGameStmt::CharacterPvpPoint(CHARACTER_PVP_POINT* characterPvpPoint)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_PVP_POINT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterPvpPoint->idx,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterPvpPoint->point, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

SQLRETURN cSQLGameStmt::CharacterLevel( CHARACTER_LEVEL* characterLevel )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_LEVEL(?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &characterLevel->idx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &characterLevel->level, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &characterLevel->levelUpPoint, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterLevel->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::CharacterSkillLevel( CHARACTER_SKILLLEVEL* characterSkillLevel )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_SKILLLEVEL(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;
	unsigned char n = 0;

	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &characterSkillLevel->idx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &characterSkillLevel->skillLevel, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &characterSkillLevel->levelUpPoint, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &characterSkillLevel->skillPoint, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &characterSkillLevel->skillTotal, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterSkillLevel->skillUpPoint, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterSkillLevel->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

// CharacterActiveWeapon Method
// GP_CHARACTER_ACTIVE_WEAPON .
SQLRETURN cSQLGameStmt::CharacterActiveWeapon(CHARACTER_ACTIVE_WEAPON* characterActiveWeapon)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_ACTIVE_WEAPON(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_ULONG,   SQL_INTEGER, 0, 0, &characterActiveWeapon->idx,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &characterActiveWeapon->activeWeapon, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_ULONG,   SQL_INTEGER, 0, 0, &characterActiveWeapon->retvalue,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// CharacterOption Method
// GP_CHARACTER_OPTION .
SQLRETURN cSQLGameStmt::CharacterOption(CHARACTER_OPTION* characterOption)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_OPTION(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterOption->idx,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterOption->option1,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterOption->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}


SQLRETURN cSQLGameStmt::CharacterForce( CHARACTER_FORCE* characterForce )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_FORCE(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &characterForce->mIdx,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_INTEGER, 0, 0, &characterForce->mForceType,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterForce->mRetValue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


SQLRETURN cSQLGameStmt::CharacterSkillReset( CHARACTER_SKILL_RESET* reset, u_long& cbLength )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_SKILL_RESET( ?, ?, ?, ?, ? )}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &reset->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &reset->mRace, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &reset->mJobStep, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &reset->mInventoryIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &reset->mRetvalue, 0, &(strLenOrInd=0) );
//	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLExecute( mHstmt );

		u_long     tableSize = sizeof( reset->mTable );
		SQLUSMALLINT n;

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			n = 0;
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &reset->mTable[ i ].mSkillIdx, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_UTINYINT, &reset->mTable[ i ].mSkillStep, 0, &(strLenOrInd=0) );
			
			reset->mTable[ i ].mEndCoolTime = 0;

			reset->mRowCount++;
		}
		cbLength += ( reset->mRowCount * tableSize );

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

// CharacterBlockSelect Method
SQLRETURN cSQLGameStmt::CharacterBlockSelect(CHARACTER_BLOCK_SELECT* characterBlockSelect)
{
	SQLCHAR*     statement = (SQLCHAR*)"{call GP_CHARACTER_BLOCK_SELECT(?, ?)}";
	SQLINTEGER   strLenOrInd;
	SQLRETURN    retcode;
	SQLUSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterBlockSelect->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterBlockSelect->rowCount,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, &characterBlockSelect->validTrue, 0, &(strLenOrInd=0) );
		}
		SQLClose( mHstmt );
	}
	return retcode;
}

// CharacterBlockInsert Method
SQLRETURN cSQLGameStmt::CharacterBlockInsert(CHARACTER_BLOCK_INSERT* characterBlockInsert)
{
	SQLCHAR*     statement = (SQLCHAR*)"{call GP_CHARACTER_BLOCK_INSERT(?, ?, ?)}";
	SQLINTEGER   strLenOrInd;
	SQLRETURN    retcode;
	SQLUSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterBlockInsert->blockCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterBlockInsert->adminCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterBlockInsert->validTrue,         0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InventoryInsert Method
// GP_INVENTORY_INSERT .
SQLRETURN cSQLGameStmt::InventoryInsert(INVENTORY_INSERT* inventoryInsert)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  itemDefineIndex;
	SQLSMALLINT inventoryNumner;
	SQLSMALLINT inventoryCount;
	SQLCHAR     inventoryEnhanced;
	SQLINTEGER  inventoryCardSlot1;
	SQLINTEGER  inventoryCardSlot2;
	SQLINTEGER  inventoryCardSlot3;
	SQLINTEGER  inventoryCardSlot4;
	SQLINTEGER  inventoryCardSlot5;
	SQLCHAR     inventorySeal; 

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryInsert->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &itemDefineIndex,               0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &inventoryNumner,               0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &inventoryCount,                0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT,  0, 0, &inventoryEnhanced,             0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryCardSlot1,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryCardSlot2,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryCardSlot3,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryCardSlot4,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryCardSlot5,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT,  0, 0, &inventorySeal,                 0, &(strLenOrInd=0) );

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_INVENTORY* table = inventoryInsert->table;
		for ( long i = 0; i < inventoryInsert->rowCount; i++, table++ )
		{
			itemDefineIndex    = table->itemDefineIndex;
			inventoryNumner    = table->number;
			inventoryCount     = table->count;
			inventoryEnhanced  = table->enhanced;
			inventoryCardSlot1 = table->cardSlot1;
			inventoryCardSlot2 = table->cardSlot2;
			inventoryCardSlot3 = table->cardSlot3;
			inventoryCardSlot4 = table->cardSlot4;
			inventoryCardSlot5 = table->cardSlot5;
			inventorySeal      = table->seal;
			retcode            = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetFullInv( mHstmt, table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventorySelect Method
// GP_INVENTORY_SELECT .
//   @CHARACTER_IDX [int] --ĳ ȣ
SQLRETURN cSQLGameStmt::InventorySelect(INVENTORY_SELECT* inventorySelect, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_INVENTORY_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventorySelect->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_INVENTORY* table     = inventorySelect->table;
		u_long        tableSize = sizeof(inventorySelect->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++, table++ )
		{
			SQLGetFullInv( mHstmt, table );
			inventorySelect->rowCount++;
		}

		cbLength += (inventorySelect->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryDelete Method
SQLRETURN cSQLGameStmt::InventoryDelete(INVENTORY_DELETE* inventoryDelete)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_DELETE(?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryDelete->inventoryIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryDelete->retvalue,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_INVENTORY* table = &inventoryDelete->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetBaseInv( mHstmt, table );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryCooltimeSelect Method
SQLRETURN cSQLGameStmt::InventoryCooltimeSelect(INVENTORY_COOLTIME_SELECT* inventoryCooltimeSelect, u_long& cbLength)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_COOLTIME_SELECT(?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryCooltimeSelect->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_INVENTORY_COOLTIME* table     = inventoryCooltimeSelect->table;
		u_long                 tableSize = sizeof(inventoryCooltimeSelect->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++, table++ )
		{
			SQLGetData( mHstmt, param=1, SQL_C_SLONG, &table->itemDefineIndex, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG, &table->cooltime2,       0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG, &table->cooltime,        0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG, &table->cooltime1,       0, &(strLenOrInd=0) );

			inventoryCooltimeSelect->rowCount++;
		}

		cbLength += (inventoryCooltimeSelect->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryCooltimeSelect Method
SQLRETURN cSQLGameStmt::InventoryCooltimeInsert(INVENTORY_COOLTIME_INSERT* inventoryCooltimeInsert)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_COOLTIME_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	TB_INVENTORY_COOLTIME* table = inventoryCooltimeInsert->table;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryCooltimeInsert->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &table->itemDefineIndex,                0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &table->cooltime1,                      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &table->cooltime2,                      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &table->cooltime,                       0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// InventoryRemove Method
// GP_INVENTORY_REMOVE
//   @CHARACTER_IDX    [int]       --ĳ ȣ
//   @RETVALUE         [int]OUTPUT --ȯ
SQLRETURN cSQLGameStmt::InventoryRemove(INVENTORY_REMOVE* inventoryRemove)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_REMOVE(?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryRemove->idx,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryRemove->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetBaseInv( mHstmt, &inventoryRemove->table );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryUse Method
// GP_INVENTORY_USE
SQLRETURN cSQLGameStmt::InventoryUse(INVENTORY_USE* inventoryUse)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_USE(?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryUse->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetBaseInv( mHstmt, inventoryUse->table );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventorySwap Method.
// GP_INVENTORY_SWAP .
//   @IDX1    [int]      --ȣ1
//   @IDX2    [int]      --ȣ2
SQLRETURN cSQLGameStmt::InventorySwap(INVENTORY_SWAP* inventorySwap)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_SWAP(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,  0, 0, &inventorySwap->idx1,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SHORT, SQL_SMALLINT, 0, 0, &inventorySwap->number1,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,  0, 0, &inventorySwap->idx2,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SHORT, SQL_SMALLINT, 0, 0, &inventorySwap->number2,  0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0, 0, &inventorySwap->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_INVENTORY* table = inventorySwap->table;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetBaseInv( mHstmt, table );

		if ( SQLMoreResults( mHstmt ) == SQL_SUCCESS )
			table++;

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetBaseInv( mHstmt, table );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryMove Method.
// GP_INVENTORY_MOVE .
//   @CHARACTER_IDX [int]      --ĳ ȣ
//   @IDX           [int]      --ȣ
//   @NUMBER        [smallint] --ȣ
SQLRETURN cSQLGameStmt::InventoryMove(INVENTORY_MOVE* inventoryMove)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_MOVE(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryMove->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryMove->idx,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryMove->number,       0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetBaseInv( mHstmt, &inventoryMove->table );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryExcept Method.
// GP_INVENTORY_EXCEPT .
//   @CHARACTER_IDX [int]      --ĳ ȣ
//   @IDX           [int]      --ȣ
//   @NUMBER        [smallint] --ȣ
SQLRETURN cSQLGameStmt::InventoryExcept(INVENTORY_EXCEPT* inventoryExcept)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_EXCEPT(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryExcept->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryExcept->idx,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryExcept->number,       0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetBaseInv( mHstmt, &inventoryExcept->table );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryMerge Method.
// GP_INVENTORY_MERGE .
SQLRETURN cSQLGameStmt::InventoryMerge(INVENTORY_MERGE* inventoryMerge, u_long& cbLength)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_MERGE(?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryMerge->idx1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryMerge->idx2, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_INVENTORY* table     = inventoryMerge->table;
		u_long        tableSize = sizeof(inventoryMerge->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++, table++ )
		{
			SQLGetBaseInv( mHstmt, table );
			inventoryMerge->rowCount++;
		}

		cbLength += (inventoryMerge->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// NoteSelect Method.
// GP_INVENTORY_DIVIDE .
SQLRETURN cSQLGameStmt::InventoryDivide(INVENTORY_DIVIDE* divide)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_DIVIDE(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  inventoryIdx;
	SQLINTEGER  itemDefineIndex;
	SQLSMALLINT inventoryCount;
	SQLSMALLINT inventoryNumner;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &divide->characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,         0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,      0, &(strLenOrInd=0) );

		TB_INVENTORY* table = divide->table;
		for ( long i = 0; i < divide->rowCount; i++, table++ )
		{
			inventoryIdx    = table->idx;
			itemDefineIndex = table->itemDefineIndex;
			inventoryCount  = table->count;
			inventoryNumner = table->number;
			retcode         = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetBaseInv( mHstmt, table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemSell Method.
// GP_ITEM_SELL .
SQLRETURN cSQLGameStmt::ItemSell(ITEM_SELL* itemSell)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_SELL(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  inventoryIdx;
	SQLINTEGER  itemDefineIndex;
	SQLSMALLINT inventoryCount;
	SQLSMALLINT inventoryNumner;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemSell->characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,        0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,         0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,        0, &(strLenOrInd=0) );

		TB_INVENTORY* table = itemSell->table;
		for ( long i = 0; i < itemSell->rowCount; i++, table++ )
		{
			inventoryIdx    = table->idx; 
			itemDefineIndex = table->itemDefineIndex;
			inventoryCount  = table->count;
			inventoryNumner = table->number;
			retcode         = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetFullInv( mHstmt, table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemBuy Method.
// GP_ITEM_BUY .
SQLRETURN cSQLGameStmt::ItemBuy(ITEM_BUY* itemBuy)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_BUY(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  inventoryIdx;
	SQLINTEGER  itemDefineIndex;
	SQLSMALLINT inventoryCount;
	SQLSMALLINT inventoryNumner;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemBuy->characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,          0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,        0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,       0, &(strLenOrInd=0) );

		TB_INVENTORY* table = itemBuy->table;
		for ( long i = 0; i < itemBuy->rowCount; i++, table++ )
		{
			inventoryIdx    = table->idx; 
			itemDefineIndex = table->itemDefineIndex;
			inventoryCount  = table->count;
			inventoryNumner = table->number;
			retcode         = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetFullInv( mHstmt, table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemCollect Method.
// GP_ITEM_COLLECT .
SQLRETURN cSQLGameStmt::ItemCollect(ITEM_COLLECT* itemCollect)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_COLLECT(?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemCollect->update.inventoryIdx,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &itemCollect->inventoryNumber2,        0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemCollect->remove.inventoryIdx,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemCollect->retvalue,                0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetFullInv( mHstmt, &itemCollect->update.table );

		if ( SQLMoreResults( mHstmt ) == SQL_SUCCESS )
		{
			if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
				SQLGetFullInv( mHstmt, &itemCollect->remove.table );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemGet Method.
// GP_ITEM_GET .
SQLRETURN cSQLGameStmt::ItemGet(ITEM_GET* itemGet)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_GET(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  itemDefineIndex;
	SQLSMALLINT inventoryNumber;
	SQLSMALLINT count;
	SQLINTEGER  retvalue;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &itemGet->characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &itemDefineIndex,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &inventoryNumber,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &count,                 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &retvalue,              0, &(strLenOrInd=0) );

		for ( long i = 0; i < itemGet->rowCount; i++ )
		{
			itemDefineIndex = itemGet->table[ i ].itemDefineIndex;
			inventoryNumber = itemGet->table[ i ].inventoryNumber;
			count           = itemGet->table[ i ].count;
			retvalue        = itemGet->table[ i ].retvalue;
			retcode         = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				itemGet->table[ i ].retvalue = retvalue;

				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetFullInv( mHstmt, &itemGet->table[ i ].table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemGetQuest Method.
SQLRETURN cSQLGameStmt::ItemGetQuest(ITEM_GET_QUEST* itemGetQuest)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_GET_QUEST(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &itemGetQuest->characterIdx,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &itemGetQuest->itemDefineIndex, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &itemGetQuest->inventoryNumber, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &itemGetQuest->count,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &itemGetQuest->retvalue,        0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetFullInv( mHstmt, &itemGetQuest->table );

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemUse Method.
SQLRETURN cSQLGameStmt::ItemUse(ITEM_USE* itemUse)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_USE(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  inventoryIdx;
	SQLSMALLINT count;
	SQLINTEGER  retvalue;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &count,        0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &retvalue,     0, &(strLenOrInd=0) );

		for ( long i = 0; i < itemUse->rowCount; i++ )
		{
			inventoryIdx = itemUse->table[ i ].inventoryIdx;
			count        = itemUse->table[ i ].count;
			retvalue     = itemUse->table[ i ].retvalue;
			retcode      = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				itemUse->table[ i ].retvalue = retvalue;

				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetFullInv( mHstmt, &itemUse->table[ i ].table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemExchange Method.
SQLRETURN cSQLGameStmt::ItemExchange(ITEM_EXCHANGE* itemExchange)
{
	SQLINTEGER  strLenOrInd = 0;
	SQLRETURN   retcode     = SQL_SUCCESS;
	SQLSMALLINT	param;

	for ( int i0 = 0; i0 < itemExchange->rowCount; i0++ )
	{
		if ( itemExchange->table[ i0 ].characterMoney != 0 )
		{
			SQLCHAR* statement = (SQLCHAR*)"{call GP_CHARACTER_MONEY(?, ?, ?)}";

			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemExchange->table[ i0 ].characterIdx,   0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemExchange->table[ i0 ].characterMoney, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemExchange->table[ i0 ].retvalue,       0, &(strLenOrInd=0) );
			retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

			if ( !(SQL_SUCCEEDED( retcode )) )
				return retcode;

			SQLClose( mHstmt );
		}

		if ( itemExchange->table[ i0 ].retvalue == 0 && itemExchange->table[ i0 ].rowCount > 0 )
		{
			SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_EXCHANGE(?, ?, ?, ?)}";

			SQLINTEGER  inventoryIdx;
			SQLSMALLINT inventoryNumber;
			SQLINTEGER  retvalue;

			TB_INVENTORY* table;

			retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
			if ( !(SQL_SUCCEEDED( retcode )) )
				return retcode;

			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &itemExchange->table[ i0 ].characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryIdx,                           0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &inventoryNumber,                        0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &retvalue,                               0, &(strLenOrInd=0) );

			table = itemExchange->table[ i0 ].table;
			for ( long i1 = 0; i1 < itemExchange->table[ i0 ].rowCount; i1++, table++ )
			{
				inventoryIdx    = table->idx;
				inventoryNumber = table->number;
				retvalue        = itemExchange->table[ i0 ].retvalue;
				retcode         = SQLExecute( mHstmt );

				if ( SQL_SUCCEEDED( retcode ) )
				{
					if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
						SQLGetFullInv( mHstmt, table );

					itemExchange->table[ i0 ].retvalue = retvalue;

					// ν  .
					while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
				}
				else
					return retcode;
			}

			SQLClose( mHstmt );
		}
	}

	return retcode;
}

// ItemMix Method.
SQLRETURN cSQLGameStmt::ItemMix(ITEM_MIX* itemMix)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_ITEM_MIX(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  inventoryIdx;
	SQLINTEGER  itemDefineIndex;
	SQLSMALLINT inventoryCount;
	SQLSMALLINT inventoryNumner;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemMix->characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,          0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,        0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,       0, &(strLenOrInd=0) );

		TB_INVENTORY* table = itemMix->table;
		for ( long i = 0; i < itemMix->rowCount; i++, table++ )
		{
			inventoryIdx    = table->idx; 
			itemDefineIndex = table->itemDefineIndex;
			inventoryCount  = table->count;
			inventoryNumner = table->number;
			retcode         = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetBaseInv( mHstmt, table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}


// InventoryMove2 Method.
// GP_INVENTORY_MOVE2 .
SQLRETURN cSQLGameStmt::InventoryMove2(INVENTORY_MOVE2* move2)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_MOVE2(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	SQLINTEGER  inventoryIdx;
	SQLINTEGER  itemDefineIndex;
	SQLSMALLINT inventoryCount;
	SQLSMALLINT inventoryNumner;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &move2->characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,         0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,      0, &(strLenOrInd=0) );

		TB_INVENTORY* table = move2->table;
		for ( long i = 0; i < move2->rowCount; i++, table++ )
		{
			inventoryIdx    = table->idx;
			itemDefineIndex = table->itemDefineIndex;
			inventoryCount  = table->count;
			inventoryNumner = table->number;
			retcode         = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetBaseInv( mHstmt, table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryEnhanced Method.
SQLRETURN cSQLGameStmt::InventoryEnhanced(INVENTORY_ENHANCED* inventoryEnhanced)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_ENHANCED(?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryEnhanced->idx1,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryEnhanced->idx2,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT,  0, 0, &inventoryEnhanced->result,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryEnhanced->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ȭ
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetFullInv( mHstmt, &inventoryEnhanced->table[ 0 ] );

		SQLMoreResults( mHstmt );

		// ȭī
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetFullInv( mHstmt, &inventoryEnhanced->table[ 1 ] );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryDisjoint Method.
SQLRETURN cSQLGameStmt::InventoryDisjoint(INVENTORY_DISJOINT* inventoryDisjoint)
{
	SQLINTEGER  strLenOrInd = 0;
	SQLRETURN   retcode     = 0;
	SQLSMALLINT	param;

	if ( inventoryDisjoint->characterMoney != 0 )
	{
		SQLCHAR* statement = (SQLCHAR*)"{call GP_CHARACTER_MONEY(?, ?, ?)}";

		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryDisjoint->characterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryDisjoint->characterMoney, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryDisjoint->retvalue,       0, &(strLenOrInd=0) );
		retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

		if ( !(SQL_SUCCEEDED( retcode )) )
			return retcode;

		SQLClose( mHstmt );
	}

	if ( inventoryDisjoint->retvalue == 0 && inventoryDisjoint->rowCount > 0 )
	{
		SQLCHAR*      statement = (SQLCHAR*)"{call GP_INVENTORY_DISJOINT(?, ?, ?, ?, ?, ?)}";
		TB_INVENTORY* table     = inventoryDisjoint->table;

		for ( long i = 0; i < inventoryDisjoint->rowCount && inventoryDisjoint->retvalue == 0; i++, table++ )
		{
			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryDisjoint->characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &table->idx,                      0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &table->itemDefineIndex,          0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &table->number,                   0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &table->count,                    0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &inventoryDisjoint->retvalue,     0, &(strLenOrInd=0) );
			retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
					SQLGetFullInv( mHstmt, table );

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryPutCard Method.
SQLRETURN cSQLGameStmt::InventoryPutCard(INVENTORY_PUT_CARD* inventoryPutCard)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_PUT_CARD(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &inventoryPutCard->idx1,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &inventoryPutCard->cardSlot,        0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &inventoryPutCard->idx2,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &inventoryPutCard->itemDefineIndex, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &inventoryPutCard->retvalue,        0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// 
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetFullInv( mHstmt, &inventoryPutCard->table[ 0 ] );

		SQLMoreResults( mHstmt );

		// ī
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			SQLGetFullInv( mHstmt, &inventoryPutCard->table[ 1 ] );

		SQLClose( mHstmt );
	}
	return retcode;
}

// InventoryChange Method.
SQLRETURN cSQLGameStmt::InventoryChange(INVENTORY_CHANGE* inventoryChange)
{
	SQLINTEGER  strLenOrInd = 0;
	SQLRETURN   retcode     = 0;
	SQLSMALLINT	param;

	if ( inventoryChange->characterMoney != 0 )
	{
		SQLCHAR* statement = (SQLCHAR*)"{call GP_CHARACTER_MONEY(?, ?, ?)}";

		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryChange->characterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryChange->characterMoney, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryChange->retvalue,       0, &(strLenOrInd=0) );
		retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

		if ( !(SQL_SUCCEEDED( retcode )) )
			return retcode;

		SQLClose( mHstmt );
	}

	if ( SQL_SUCCEEDED( retcode ) && inventoryChange->retvalue == 0 && inventoryChange->rowCount > 0 )
	{
		SQLCHAR*    statement = (SQLCHAR*)"{call GP_INVENTORY_CHANGE(?, ?, ?, ?, ?)}";

		SQLINTEGER  inventoryIdx;
		SQLINTEGER  itemDefineIndex;
		SQLSMALLINT inventoryCount;
		SQLSMALLINT inventoryNumner;

		retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
		if ( SQL_SUCCEEDED( retcode ) )
		{
			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryChange->characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,                  0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,               0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,               0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,                0, &(strLenOrInd=0) );

			TB_INVENTORY* table = inventoryChange->table;
			for ( long i = 0; i < inventoryChange->rowCount; i++, table++ )
			{
				inventoryIdx    = table->idx; 
				itemDefineIndex = table->itemDefineIndex;
				inventoryCount  = table->count;
				inventoryNumner = table->number;
				retcode         = SQLExecute( mHstmt );

				if ( SQL_SUCCEEDED( retcode ) )
				{
					if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
						SQLGetBaseInv( mHstmt, table );

					// ν  .
					while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
				}
				else
					return retcode;
			}
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// NoteSelect Method.
// GP_NOTE_SELECT .
SQLRETURN cSQLGameStmt::NoteSelect(NOTE_SELECT* noteSelect, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_NOTE_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &noteSelect->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		SQLINTEGER nameSize    = sizeof(noteSelect->table->characterName);
		SQLINTEGER messageSize = sizeof(noteSelect->table->message);
		u_long     tableSize   = sizeof(noteSelect->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,          &noteSelect->table[ i ].idx,          0,                 &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_TYPE_TIMESTAMP, &noteSelect->table[ i ].registerDate, SQL_TIMESTAMP_LEN, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_WCHAR,          noteSelect->table[ i ].characterName, nameSize,          &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_WCHAR,          noteSelect->table[ i ].message,       messageSize,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_SLONG,          &noteSelect->table[ i ].remainTime,    0,                 &(strLenOrInd=0) );

			noteSelect->rowCount++;
		}
		cbLength += (noteSelect->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// NoteInsert Method.
// GP_NOTE_INSERT .
SQLRETURN cSQLGameStmt::NoteInsert(NOTE_INSERT* noteInsert)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_NOTE_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       name2Size   = sizeof(noteInsert->characterName2);
	long       cbName2     = wcslen(noteInsert->characterName2) ? SQL_NTS : SQL_NULL_DATA;
	long       messageSize = sizeof(noteInsert->message);
	long       cbMessage   = wcslen(noteInsert->message) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,  0,   0, &noteInsert->characterIdx1, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0,   0, &noteInsert->characterIdx2, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 16,  0, noteInsert->characterName2, name2Size,   &cbName2         );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 200, 0, noteInsert->message,        messageSize, &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0,   0, &noteInsert->retvalue,      0,           &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		SQLINTEGER nameSize    = sizeof(noteInsert->table.characterName);
		SQLINTEGER messageSize = sizeof(noteInsert->table.message);

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,          &noteInsert->table.idx,          0,                 &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_TYPE_TIMESTAMP, &noteInsert->table.registerDate, SQL_TIMESTAMP_LEN, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_WCHAR,          noteInsert->table.characterName, nameSize,          &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_WCHAR,          noteInsert->table.message,       messageSize,       &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_SLONG,          &noteInsert->table.remainTime,    0,                 &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}

	return SQLClose( retcode, mHstmt );
}

// NoteDelete Method
// GP_NOTE_DELETE .
SQLRETURN cSQLGameStmt::NoteDelete(NOTE_DELETE* noteDelete)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_NOTE_DELETE(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER idx;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &noteDelete->characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &idx,                      0, &(strLenOrInd=0) );

		for ( long i = 0; i < noteDelete->rowCount; i++ )
		{
			idx     = noteDelete->idx[ i ];
			retcode = SQLExecute( mHstmt );
			if ( SQL_SUCCEEDED( retcode ) )
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::GuildNoteInsert( GUILDNOTE_INSERT* guildNoteInsert )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_GUILDNOTE_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER characterIdx2 = 0;
	SQLINTEGER idx = 0;
	SQLINTEGER retValue = 0;

	long       messageSize = sizeof(guildNoteInsert->message);
	long       cbMessage   = wcslen(guildNoteInsert->message) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0,		0,	&guildNoteInsert->characterIdx1,	0,			 &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0,		0,	&characterIdx2,                     0,			 &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 200,	0,  guildNoteInsert->message,			messageSize, &cbMessage       );
		retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0,		0,	&idx,								0,			 &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0,		0,	&retValue,							0,			 &(strLenOrInd=0) );

		for ( long i = 0; i < guildNoteInsert->rowCount; i++ )
		{
			characterIdx2		= guildNoteInsert->characterIdx2[ i ];
			retcode				= SQLExecute( mHstmt );

			if ( retcode == SQL_SUCCESS )
			{
				SQLINTEGER nameSize = sizeof(guildNoteInsert->table[i].characterName);
				SQLINTEGER msgSize	= sizeof(guildNoteInsert->table[i].message);

				if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
				{
					SQLGetData( mHstmt, 1, SQL_C_SLONG,          &guildNoteInsert->table[i].idx,          0,                 &(strLenOrInd=0) );
					SQLGetData( mHstmt, 2, SQL_C_TYPE_TIMESTAMP, &guildNoteInsert->table[i].registerDate, SQL_TIMESTAMP_LEN, &(strLenOrInd=0) );
					SQLGetData( mHstmt, 3, SQL_C_WCHAR,          guildNoteInsert->table[i].characterName, nameSize,          &(strLenOrInd=0) );
					SQLGetData( mHstmt, 4, SQL_C_WCHAR,          guildNoteInsert->table[i].message,       msgSize,			  &(strLenOrInd=0) );
					SQLGetData( mHstmt, 5, SQL_C_SLONG,          &guildNoteInsert->table[i].remainTime,    0,                &(strLenOrInd=0) );
				}

				guildNoteInsert->table[i].idx		= idx;
				guildNoteInsert->table[i].retValue  = retValue;

				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;

		}

		SQLClose( mHstmt );
	}
	return retcode;
}


// FriendSelectr Method.
SQLRETURN cSQLGameStmt::FriendSelect(FRIEND_SELECT* friendSelect, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_FRIEND_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &friendSelect->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		SQLINTEGER nameSize  = sizeof(friendSelect->table->characterName);
		u_long     tableSize = sizeof(friendSelect->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &friendSelect->table[ i ].idx,          0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &friendSelect->table[ i ].characterIdx, 0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_WCHAR,   friendSelect->table[ i ].characterName, nameSize, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_TINYINT, &friendSelect->table[ i ].race,         0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_TINYINT, &friendSelect->table[ i ].gender,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6, SQL_C_TINYINT, &friendSelect->table[ i ].status,       0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7, SQL_C_TINYINT, &friendSelect->table[ i ].block,        0,        &(strLenOrInd=0) );

			friendSelect->rowCount++;
		}

		cbLength += (friendSelect->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// FriendInsert Method.
SQLRETURN cSQLGameStmt::FriendInsert(FRIEND_INSERT* friendInsert)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_FRIEND_INSERT(?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       nameSize = sizeof(friendInsert->characterName);
	long       cbName   = wcslen(friendInsert->characterName) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,  0,  0, &friendInsert->characterIdx1, 0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0,  0, &friendInsert->characterIdx2, 0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 16, 0, friendInsert->characterName,  nameSize, &cbName          );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,  0,  0, &friendInsert->retvalue,      0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// FriendUpdate Method.
SQLRETURN cSQLGameStmt::FriendUpdate(FRIEND_UPDATE* friendUpdate)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_FRIEND_UPDATE(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &friendUpdate->idx,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &friendUpdate->characterIdx1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &friendUpdate->characterIdx2, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// FriendDelete Method.
SQLRETURN cSQLGameStmt::FriendDelete(FRIEND_DELETE* friendDelete)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_FRIEND_DELETE(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &friendDelete->idx,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &friendDelete->characterIdx1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &friendDelete->characterIdx2, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// ItemSpreadValue Method
// GP_ITEM_SPREAD_VALUE .
SQLRETURN cSQLGameStmt::ItemSpreadValue(ITEM_SPREAD_VALUE* itemSpreadValue)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_SPREAD_VALUE(?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER array = 1;
	SQLCHAR    dir   = 0;
	SQLINTEGER value = 0;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,        SQL_C_SLONG,    SQL_INTEGER, 0, 0, &itemSpreadValue->spreadIndex, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,        SQL_C_SLONG,    SQL_INTEGER, 0, 0, &array,                        0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,        SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &dir,                          0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT_OUTPUT, SQL_C_SLONG,    SQL_INTEGER, 0, 0, &value,                        0, &(strLenOrInd=0) );

		for ( long i = 0; i < 10; i++, array++ )
		{
			dir     = itemSpreadValue->values[ i ].dir;
			value   = itemSpreadValue->values[ i ].tarot;
			retcode = SQLExecute( mHstmt );

			if ( retcode == SQL_SUCCESS )
			{
				itemSpreadValue->spreadValue += value;
				itemSpreadValue->values[ i ].spread = value;
			}
			else
				return retcode;
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// ItemTarotResult Method.
SQLRETURN cSQLGameStmt::ItemTarotResult(ITEM_TAROT_RESULT* itemTarotResult)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_ITEM_TAROT_RESULT(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemTarotResult->itemDefineIndex, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &itemTarotResult->value,           0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, &itemTarotResult->influence_idx1, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG, &itemTarotResult->influence_idx2, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SLONG, &itemTarotResult->influence_idx3, 0, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

// SkillSelect Method.
SQLRETURN cSQLGameStmt::SkillSelect( SKILL_SELECT* skillSelect, u_long& cbLength )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_SKILL_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &skillSelect->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		u_long     tableSize = sizeof( skillSelect->mTable );
		SQLUSMALLINT n;

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			n = 0;
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &skillSelect->mTable[ i ].mSkillIdx, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_UTINYINT, &skillSelect->mTable[ i ].mSkillStep, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_LONG, &skillSelect->mTable[ i ].mEndCoolTime, 0, &(strLenOrInd=0) );

			if( skillSelect->mTable[ i ].mEndCoolTime < 0 )
				skillSelect->mTable[ i ].mEndCoolTime = 0;
			else
				skillSelect->mTable[ i ].mEndCoolTime = skillSelect->mTable[ i ].mEndCoolTime * SECOND_THOUSAND;

			skillSelect->mRowCount++;
		}
		cbLength += ( skillSelect->mRowCount * tableSize );

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


// SkillInsert Method.
SQLRETURN cSQLGameStmt::SkillInsert( SKILL_INSERT* skillInsert )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_SKILL_INSERT(?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;
	SQLSMALLINT n = 0;

	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mSkillClassIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_USHORT, SQL_SMALLINT, 0, 0, &skillInsert->mSP, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &skillInsert->skillLevel, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->skillPoint, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &skillInsert->mRetvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


// SkillUpdate Method.
SQLRETURN cSQLGameStmt::SkillUpdate( SKILL_UPDATE* skillUpdate )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_SKILL_UPDATE(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;
	SQLSMALLINT n = 0;

	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillUpdate->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillUpdate->mSkillClassIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &skillUpdate->mSkillStep, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_USHORT, SQL_SMALLINT, 0, 0, &skillUpdate->mSP, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &skillUpdate->skillLevel, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillUpdate->skillPoint, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &skillUpdate->mRetvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	else
		assert(NULL);

	return retcode;
}

// SkillCoolTime Method.
SQLRETURN cSQLGameStmt::SkillCoolTime( SKILL_COOLTIME* skillCoolTime )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_SKILL_COOLTIME(?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER characterIdx;
	SQLINTEGER skillIdx;
	SQLINTEGER endCoolTime;
	SQLINTEGER retValue;

	SQLSMALLINT n;

	skillCoolTime->mRetvalue = 0;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		n = 0;

		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &skillIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &endCoolTime, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &retValue, 0, &(strLenOrInd=0) );

		for ( long i = 0; i < skillCoolTime->mRowCount; ++i )
		{
			characterIdx = skillCoolTime->mCharacterIdx;
			skillIdx = skillCoolTime->mTable[i].mSkillIdx;
			endCoolTime = (unsigned long)(skillCoolTime->mTable[i].mEndCoolTime / SECOND_THOUSAND);
			
			retcode = SQLExecute( mHstmt );

			if ( (SQL_SUCCEEDED( retcode )) )
			{
				if( retValue != 0 )
					skillCoolTime->mRetvalue = retValue;
			}
			else
			{
				assert(NULL);
				return retcode;
			}
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	else
		assert(NULL);

	return retcode;
}


// SkillInfluenceSelect Method.
SQLRETURN cSQLGameStmt::SkillInfluenceSelect( SKILL_INFLUENCE_SELECT* influenceSelect, u_long& cbLength )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_INFLUENCE_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &influenceSelect->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		u_long     tableSize = sizeof( influenceSelect->mTable );
		SQLUSMALLINT n;

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			n = 0; // ÷ ȣ
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mDbIdx, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mInfluenceClassIdx, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mAttacker.index, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mAttacker.type, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_BIT, &influenceSelect->mTable[i].mIsRealTime, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mRestTime, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TYPE_TIMESTAMP, &influenceSelect->mTable[ i ].mStartDate, SQL_TIMESTAMP_LEN, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_TYPE_TIMESTAMP, &influenceSelect->mTable[ i ].mEndDate, SQL_TIMESTAMP_LEN, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mTime1, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mTime2, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG, &influenceSelect->mTable[i].mInfluenceValue1, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_SLONG, &influenceSelect->mTable[i].mInfluenceValue2, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &influenceSelect->mTable[i].mAttriButeType, 0, &(strLenOrInd=0) );

			influenceSelect->mRowCount++;
		}
		cbLength += ( influenceSelect->mRowCount * tableSize );

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


// SkillInfluenceDelete Method.
SQLRETURN cSQLGameStmt::SkillInfluenceDelete( SKILL_INFLUENCE_DELETE* influenceDelete )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_INFLUENCE_DELETE(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &influenceDelete->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &influenceDelete->mRetvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


// SkillInfluenceInsert Method.
SQLRETURN cSQLGameStmt::SkillInfluenceInsert( SKILL_INFLUENCE_INSERT* influenceInsert )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_INFLUENCE_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER influenceIdx;
	SQLINTEGER dbIdx = 0;
	SQLINTEGER attackerIdx;
	SQLINTEGER attackerType;
	SQLCHAR isRealTime;
	SQLINTEGER restTime;
	SQL_TIMESTAMP_STRUCT startDate;
	SQL_TIMESTAMP_STRUCT endDate;

	SQLINTEGER time1;
	SQLINTEGER time2;

	SQLINTEGER influenceValue1;
	SQLINTEGER influenceValue2;

	SQLINTEGER attriButeType;

	SQLINTEGER retValue = 0;
	SQLSMALLINT n;

	influenceInsert->mRetvalue = 0;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		n = 0;
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &influenceInsert->mCharacterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &influenceIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &attackerIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &attackerType, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_BIT, SQL_BIT, 0, 0, &isRealTime, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &restTime, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &startDate, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &endDate, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &time1, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &time2, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &influenceValue1, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &influenceValue2, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &attriButeType, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &retValue, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &dbIdx, 0, &(strLenOrInd=0) );

		for ( long i = 0; i < influenceInsert->mRowCount; ++i )
		{
			influenceIdx = influenceInsert->mTable[i].mInfluenceClassIdx;
			attackerIdx = influenceInsert->mTable[i].mAttacker.index;
			attackerType = influenceInsert->mTable[i].mAttacker.type;
			isRealTime = influenceInsert->mTable[i].mIsRealTime;
			restTime = influenceInsert->mTable[i].mRestTime;
			startDate = influenceInsert->mTable[i].mStartDate;
			endDate = influenceInsert->mTable[i].mEndDate;
			time1 = influenceInsert->mTable[i].mTime1;
			time2 = influenceInsert->mTable[i].mTime2;
			influenceValue1 = influenceInsert->mTable[i].mInfluenceValue1;
			influenceValue2 = influenceInsert->mTable[i].mInfluenceValue2;
			attriButeType = influenceInsert->mTable[i].mAttriButeType;

			retcode = SQLExecute( mHstmt );

			if ( SQL_SUCCEEDED( retcode ) )
			{
				influenceInsert->mRetvalue = retValue;
				influenceInsert->mTable[i].mDbIdx = dbIdx;
				if( retValue != 0 )
					influenceInsert->mRetvalue = retValue;
			}
			else
			{
				assert(NULL);
				return retcode;
			}
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	else
		assert(NULL);

	return retcode;
}


// TruncateItemDefine Method
SQLRETURN cSQLGameStmt::TruncateSkillListPc(void)
{
	SQLCHAR*  statement = (SQLCHAR*)"TRUNCATE TABLE TB_SKILLLIST_PC";
	SQLRETURN retcode   = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

// SkillListPcInsert Method.
SQLRETURN cSQLGameStmt::SkillListPcInsert( void* pPlayerSkillBaseInfo )
{
	sPlayerSkillBaseInfo* skillInsert = (sPlayerSkillBaseInfo*)pPlayerSkillBaseInfo;

	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SKILLLIST_PC_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;
	SQLINTEGER output = 0;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mSkillIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mNameIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mIconIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &skillInsert->mRace, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mLearnSkillIdx1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &skillInsert->mLearnSkillStep1, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mLearnSkillIdx2, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 8, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &skillInsert->mLearnSkillStep2, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 9, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &skillInsert->mUseEquipment, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 10, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &skillInsert->mUseState, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 11, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mUseItem, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 12, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mType, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 13, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mAttributeType, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 14, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mShotType, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 15, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mBoundType, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 16, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mApplyType, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 17, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mRangeType, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 18, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &skillInsert->mIsGlobalCoolTime, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 19, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mGroupCoolTimeIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 20, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillInsert->mStepCount, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 21, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &output, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	if ( output != 0 )
	{
		assert(NULL);
		return (SQLRETURN)output;
	}

	return retcode;
}

// TruncateItemDefine Method
SQLRETURN cSQLGameStmt::TruncateDefalultSkill(void)
{
	SQLCHAR*  statement = (SQLCHAR*)"TRUNCATE TABLE TB_DEFAULT_SKILL";
	SQLRETURN retcode   = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


// SkillListPcInsert Method.
SQLRETURN cSQLGameStmt::DefalultSkillInsert( unsigned long jobStep, unsigned long skillIdx, unsigned char race )
{

	SQLCHAR*   statement = (SQLCHAR*)"{call GP_DEFAULT_SKILL_INSERT(?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;
	SQLINTEGER output = 0;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &jobStep, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &skillIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &race, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &output, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	if ( output != 0 )
	{
		assert(NULL);
		return (SQLRETURN)output;
	}

	return retcode;
}

// TruncateQuest Method
SQLRETURN cSQLGameStmt::TruncateQuestDefine( void )
{
	SQLCHAR*  statement = (SQLCHAR*)"TRUNCATE TABLE TB_QUEST_DEFINE";
	SQLRETURN retcode   = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::TruncateQuestProgress( void )
{
	SQLCHAR*  statement = (SQLCHAR*)"TRUNCATE TABLE TB_QUEST_PROGRESS";
	SQLRETURN retcode   = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::InsertQuestDefine( void* questDefine )
{
	cQuestDefine* define = (cQuestDefine*)questDefine;

	SQLCHAR*	statement = (SQLCHAR*)"{call GP_QUEST_DEFINE_INSERT(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	retcode = SQLBindParameter( mHstmt, 1,   SQL_PARAM_INPUT, SQL_C_SLONG,	SQL_INTEGER,	0, 0, &define->mIndex,			0,	&(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2,   SQL_PARAM_INPUT, SQL_C_SLONG,	SQL_INTEGER,	0, 0, &define->mTitleIndex,		0,  &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3,   SQL_PARAM_INPUT, SQL_C_TINYINT,SQL_TINYINT,	0, 0, &define->mType,			0,  &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4,   SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT,	0, 0, &define->mGroup,			0,  &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5,   SQL_PARAM_INPUT, SQL_C_SLONG,	SQL_INTEGER,	0, 0, &define->mGiveNpcIndex,	0,  &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6,   SQL_PARAM_INPUT, SQL_C_SLONG,	SQL_INTEGER,	0, 0, &define->mTakeNpcIndex,	0,  &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 7,   SQL_PARAM_INPUT, SQL_C_TINYINT,SQL_TINYINT,	0, 0, &define->mRepeatType,		0,  &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 8,   SQL_PARAM_INPUT, SQL_C_SSHORT,	SQL_SMALLINT,	0, 0, &define->mSelectCount,	0,  &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 9,   SQL_PARAM_INPUT, SQL_C_SBIGINT,SQL_BIGINT,		0, 0, &define->mComplete,		0,  &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		/// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		/// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	
	return retcode;
}

SQLRETURN cSQLGameStmt::QuestInsert(QUEST_INSERT* questInsert)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_QUEST_INSERT(?, ?, ?, ?, ?, ?)}";

	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->questIdx,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SBIGINT, SQL_BIGINT,  0, 0, &questInsert->check,        0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &questInsert->timeType,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->restTime,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->retvalue,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			TB_QUEST_PROGRESS* table = &questInsert->quest;
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &table->idx,		0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &table->questIdx,	0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SBIGINT, &table->check,	0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_SLONG,	  &table->restTime,	0, &(strLenOrInd=0) );
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	if ( SQL_SUCCEEDED( retcode ) && questInsert->retvalue == 0 && questInsert->rowCount > 0 )
	{
		SQLCHAR* statement = (SQLCHAR*)"{call GP_INVENTORY_UPDATE(?, ?, ?, ?, ?)}";

		SQLINTEGER  inventoryIdx;
		SQLINTEGER  itemDefineIndex;
		SQLSMALLINT inventoryCount;
		SQLSMALLINT inventoryNumner;

		retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
		if ( SQL_SUCCEEDED( retcode ) )
		{
			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &questInsert->characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,              0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,           0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,            0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,           0, &(strLenOrInd=0) );

			TB_INVENTORY* table = questInsert->inventory;
			for ( long i = 0; i < questInsert->rowCount; i++, table++ )
			{
				inventoryIdx    = table->idx; 
				itemDefineIndex = table->itemDefineIndex;
				inventoryCount  = table->count;
				inventoryNumner = table->number;
				retcode         = SQLExecute( mHstmt );

				if ( SQL_SUCCEEDED( retcode ) )
				{
					if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
						SQLGetBaseInv( mHstmt, table );

					// ν  .
					while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
				}
				else
					return retcode;
			}

			SQLClose( mHstmt );
		}
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::QuestInsertByItem(QUEST_INSERTBYITEM* questInsert)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_QUEST_INSERT_BY_ITEM(?, ?, ?, ?, ?, ?)}";

	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->questIdx,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SBIGINT, SQL_BIGINT,  0, 0, &questInsert->check,        0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &questInsert->timeType,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->restTime,     0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questInsert->retvalue,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			TB_QUEST_PROGRESS* table = &questInsert->quest;
			SQLGetData( mHstmt, param=1, SQL_C_SLONG,   &table->idx,      0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->questIdx, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SBIGINT, &table->check,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_SLONG,   &table->restTime, 0, &(strLenOrInd=0) );
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	if ( SQL_SUCCEEDED( retcode ) && questInsert->retvalue == 0 && questInsert->rowCount > 0 )
	{
		SQLCHAR* statement = (SQLCHAR*)"{call GP_INVENTORY_UPDATE(?, ?, ?, ?, ?)}";

		SQLINTEGER  inventoryIdx;
		SQLINTEGER  itemDefineIndex;
		SQLSMALLINT inventoryCount;
		SQLSMALLINT inventoryNumner;

		retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
		if ( SQL_SUCCEEDED( retcode ) )
		{
			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &questInsert->characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,              0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,           0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,            0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,           0, &(strLenOrInd=0) );

			TB_INVENTORY* table = questInsert->inventory;
			for ( long i = 0; i < questInsert->rowCount; i++, table++ )
			{
				inventoryIdx    = table->idx; 
				itemDefineIndex = table->itemDefineIndex;
				inventoryCount  = table->count;
				inventoryNumner = table->number;
				retcode         = SQLExecute( mHstmt );

				if ( SQL_SUCCEEDED( retcode ) )
				{
					if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
						SQLGetBaseInv( mHstmt, table );

					// ν  .
					while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
				}
				else
					return retcode;
			}

			SQLClose( mHstmt );
		}
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::QuestSelect( QUEST_SELECT* questSelect, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_QUEST_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,   0, &questSelect->characterIdx,  0,    &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if( SQL_SUCCEEDED( retcode ) )
	{
		u_long tableSize = sizeof(questSelect->table);
		
		for( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &questSelect->table[i].idx,			0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &questSelect->table[i].questIdx,		0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SBIGINT, &questSelect->table[i].check,			0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_SLONG,	  &questSelect->table[i].restTime,		0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_TINYINT, &questSelect->table[i].status,		0, &(strLenOrInd=0) );

			questSelect->rowCount++;
		}
		cbLength += (questSelect->rowCount * tableSize);

		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::QuestRemove( QUEST_REMOVE* questRemove )
{
	SQLINTEGER strLenOrInd;
	SQLRETURN retcode;

	/// Ʈ 
	SQLCHAR* statement = (SQLCHAR*)"{call GP_QUEST_REMOVE(?)}";

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &questRemove->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::QuestDelete( QUEST_DELETE* questDelete)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_QUEST_DELETE(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &questDelete->idx,          0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &questDelete->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &questDelete->retvalue,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	if ( SQL_SUCCEEDED( retcode ) && questDelete->retvalue == 0 && questDelete->rowCount > 0 )
	{
		SQLCHAR* statement = (SQLCHAR*)"{call GP_INVENTORY_UPDATE(?, ?, ?, ?, ?)}";

		SQLINTEGER  inventoryIdx;
		SQLINTEGER  itemDefineIndex;
		SQLSMALLINT inventoryCount;
		SQLSMALLINT inventoryNumner;

		retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
		if ( SQL_SUCCEEDED( retcode ) )
		{
			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &questDelete->characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,              0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,           0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,            0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,           0, &(strLenOrInd=0) );

			TB_INVENTORY* table = questDelete->table;
			for ( long i = 0; i < questDelete->rowCount; i++, table++ )
			{
				inventoryIdx    = table->idx; 
				itemDefineIndex = table->itemDefineIndex;
				inventoryCount  = table->count;
				inventoryNumner = table->number;
				retcode         = SQLExecute( mHstmt );

				if ( SQL_SUCCEEDED( retcode ) )
				{
					if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
						SQLGetBaseInv( mHstmt, table );

					// ν  .
					while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
				}
				else
					return retcode;
			}

			SQLClose( mHstmt );
		}
	}

	return retcode;
}

// QuestComplete Method
SQLRETURN cSQLGameStmt::QuestComplete(QUEST_COMPLETE* questComplete)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_QUEST_COMPLETE(?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0,   0, &questComplete->idx,          0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0,   0, &questComplete->characterIdx, 0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0,   0, &questComplete->repeatType,   0,        &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,   0, &questComplete->retvalue,     0,        &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, param=1, SQL_C_SLONG,   &questComplete->idx,    0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++param, SQL_C_TINYINT, &questComplete->status, 0, &(strLenOrInd=0) );
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	if ( SQL_SUCCEEDED( retcode ) && questComplete->retvalue == 0 && questComplete->rowCount > 0 )
	{
		SQLCHAR* statement = (SQLCHAR*)"{call GP_INVENTORY_UPDATE(?, ?, ?, ?, ?)}";

		SQLINTEGER  inventoryIdx;
		SQLINTEGER  itemDefineIndex;
		SQLSMALLINT inventoryCount;
		SQLSMALLINT inventoryNumner;

		retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
		if ( SQL_SUCCEEDED( retcode ) )
		{
			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &questComplete->characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,                0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,             0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,              0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,             0, &(strLenOrInd=0) );

			TB_INVENTORY* table = questComplete->table;
			for ( long i = 0; i < questComplete->rowCount; i++, table++ )
			{
				inventoryIdx    = table->idx; 
				itemDefineIndex = table->itemDefineIndex;
				inventoryCount  = table->count;
				inventoryNumner = table->number;
				retcode         = SQLExecute( mHstmt );

				if ( SQL_SUCCEEDED( retcode ) )
				{
					if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
						SQLGetBaseInv( mHstmt, table );

					// ν  .
					while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
				}
				else
					return retcode;
			}

			SQLClose( mHstmt );
		}
	}

	return retcode;
}

// QuestReward Method
SQLRETURN cSQLGameStmt::QuestReward(QUEST_REWARD* questReward, u_long& cbLength)
{
	SQLCHAR* statement = (SQLCHAR*)"{call GP_QUEST_REWARD(?, ?, ?, ?, ?, ?, ?, ?)}";

	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT	param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questReward->idx,            0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questReward->characterIdx,   0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questReward->characterMoney, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questReward->jobIdx,         0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &questReward->race,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &questReward->forceType,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &questReward->titleIdx,       0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_ULONG,   SQL_INTEGER, 0, 0, &questReward->skillPoint,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	/// select   2
	if ( SQL_SUCCEEDED( retcode ) )
	{
		///  ų  
		unsigned long* table = questReward->skillClassIdx;
		while ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, table, 0, &(strLenOrInd=0) );

			++questReward->skillRowCount;
			++table;
		}

		cbLength += (questReward->skillRowCount * sizeof(questReward->skillClassIdx));

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	if ( SQL_SUCCEEDED( retcode ) && questReward->itemRowCount > 0 )
	{
		SQLCHAR* statement = (SQLCHAR*)"{call GP_INVENTORY_UPDATE(?, ?, ?, ?, ?)}";

		SQLINTEGER  inventoryIdx;
		SQLINTEGER  itemDefineIndex;
		SQLSMALLINT inventoryCount;
		SQLSMALLINT inventoryNumner;

		retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
		if ( SQL_SUCCEEDED( retcode ) )
		{
			retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &questReward->characterIdx, 0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &inventoryIdx,              0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER,  0, 0, &itemDefineIndex,           0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryCount,            0, &(strLenOrInd=0) );
			retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SSHORT, SQL_SMALLINT, 0, 0, &inventoryNumner,           0, &(strLenOrInd=0) );

			TB_INVENTORY* table = questReward->table;
			for ( long i = 0; i < questReward->itemRowCount; i++, table++ )
			{
				inventoryIdx    = table->idx; 
				itemDefineIndex = table->itemDefineIndex;
				inventoryCount  = table->count;
				inventoryNumner = table->number;
				retcode         = SQLExecute( mHstmt );

				if ( SQL_SUCCEEDED( retcode ) )
				{
					if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
						SQLGetBaseInv( mHstmt, table );

					// ν  .
					while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
				}
				else
					return retcode;
			}

			SQLClose( mHstmt );
		}
	}

	return retcode;
}


SQLRETURN cSQLGameStmt::QuestUpdate( QUEST_UPDATE* questUpdate )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_QUEST_UPDATE(?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER idx;
	SQLBIGINT check;
	SQLCHAR timetype;
	SQLINTEGER resttime;
	SQLINTEGER  retvalue;
	
	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,   0, &idx,			0,    &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SBIGINT,SQL_BIGINT,	 0,   0, &check,		0,    &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_TINYINT,SQL_TINYINT,	 0,   0, &timetype,		0,    &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,	 0,   0, &resttime,		0,    &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0,   0, &retvalue,		0,    &(strLenOrInd=0) );

		for( long i = 0; i < questUpdate->rowCount; ++i )
		{
			idx			= questUpdate->table[i].idx;
			check		= questUpdate->table[i].check;
			timetype	= questUpdate->titmeType;
			resttime	= questUpdate->table[i].restTime;
			retvalue	= questUpdate->table[i].retvalue;
			retcode     = SQLExecute( mHstmt );

			if( SQL_SUCCEEDED( retcode ) )
			{
				questUpdate->table[i].retvalue = retvalue;

				// ν  .
				while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
			}
			else
				return retcode;
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::QuestEndListSelect( QUEST_ENDLIST* questEndList, u_long& cbLength )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_QUEST_ENDLISTSELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,   0, &questEndList->characterIdx,  0,    &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if( SQL_SUCCEEDED( retcode ) )
	{
		u_long tableSize = sizeof(questEndList->questIdx);

		for( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &questEndList->questIdx[i],			0, &(strLenOrInd=0) );
		
			questEndList->rowCount++;
		}
		cbLength += (questEndList->rowCount * tableSize);

		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

// StallSellSearch Method
SQLRETURN cSQLGameStmt::StallSellSearch(STALL_SELL_SEARCH* stallSellSearch, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_STALL_SELL_SELECT(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellSearch->channelNum,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellSearch->itemDefineIndex, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &stallSellSearch->enhanced,        0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		u_long tableSize = sizeof(stallSellSearch->table);

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG, &stallSellSearch->table[ i ].idx,          0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG, &stallSellSearch->table[ i ].characterIdx, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SLONG, &stallSellSearch->table[ i ].price,        0, &(strLenOrInd=0) );

			stallSellSearch->rowCount++;
		}

		cbLength += (stallSellSearch->rowCount * tableSize);
		SQLClose( mHstmt );
	}
	return retcode;
}

// StallSellInsert Method
SQLRETURN cSQLGameStmt::StallSellInsert(STALL_SELL_INSERT* stallSellInsert)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_STALL_SELL_INSERT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellInsert->channelNum,      0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellInsert->inventoryIdx,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellInsert->characterIdx,    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellInsert->itemDefineIndex, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &stallSellInsert->enhanced,        0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellInsert->price,           0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &stallSellInsert->retvalue,        0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// StallSellRemove Method
SQLRETURN cSQLGameStmt::StallSellRemove(STALL_SELL_REMOVE* stallSellRemove)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_STALL_SELL_REMOVE(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellRemove->inventoryIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellRemove->retvalue,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// StallSellClear Method
SQLRETURN cSQLGameStmt::StallSellClear(STALL_SELL_CLEAR* stallSellClear)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_STALL_SELL_CLEAR(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellClear->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellClear->retvalue,     0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

// StallSellGet Method
SQLRETURN cSQLGameStmt::StallSellGet(STALL_SELL_GET* stallSellGet)
{
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	//  Ǹ ݾ Ա
	{
		SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_MONEY(?, ?, ?)}";

		retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellGet->fCharacterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellGet->fCharacterMoney, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellGet->retvalue,        0, &(strLenOrInd=0) );
		retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

		if ( !(SQL_SUCCEEDED( retcode )) )
			return retcode;

		SQLClose( mHstmt );
	}
	//   ݾ 
	{
		SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_MONEY(?, ?, ?)}";

		retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellGet->tCharacterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellGet->tCharacterMoney, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &stallSellGet->retvalue,        0, &(strLenOrInd=0) );
		retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

		if ( !(SQL_SUCCEEDED( retcode )) )
			return retcode;

		SQLClose( mHstmt );
	}

	//  Ǹ&.
	{
		SQLCHAR*   statement = (SQLCHAR*)"{call GP_STALL_SELL_GET(?, ?, ?, ?, ?)}";
		SQLINTEGER strLenOrInd;
		SQLRETURN  retcode;

		retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &stallSellGet->fInventoryIdx,    0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER,  0, 0, &stallSellGet->tCharacterIdx,    0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &stallSellGet->tInventoryNumber, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT,  SQL_C_SSHORT,  SQL_SMALLINT, 0, 0, &stallSellGet->tInventoryCount,  0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER,  0, 0, &stallSellGet->retvalue,         0, &(strLenOrInd=0) );
		retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			{
				TB_INVENTORY* table = &stallSellGet->fInventory;

				SQLGetData( mHstmt, 1,  SQL_C_SLONG,   &table->idx,             0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 2,  SQL_C_SLONG,   &table->itemDefineIdx,   0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 3,  SQL_C_SLONG,   &table->itemDefineIndex, 0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 4,  SQL_C_SSHORT,  &table->number,          0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 5,  SQL_C_SSHORT,  &table->count,           0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 6,  SQL_C_TINYINT, &table->enhanced,        0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 7,  SQL_C_SLONG,   &table->cardSlot1,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 8,  SQL_C_SLONG,   &table->cardSlot2,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 9,  SQL_C_SLONG,   &table->cardSlot3,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 10, SQL_C_SLONG,   &table->cardSlot4,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 11, SQL_C_SLONG,   &table->cardSlot5,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 12, SQL_C_TINYINT, &table->seal,            0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 13, SQL_C_TINYINT, &table->apply,           0, &(strLenOrInd=0) );
			}
			SQLMoreResults( mHstmt );

			if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
			{
				TB_INVENTORY* table = &stallSellGet->tInventory;

				SQLGetData( mHstmt, 1,  SQL_C_SLONG,   &table->idx,             0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 2,  SQL_C_SLONG,   &table->itemDefineIdx,   0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 3,  SQL_C_SLONG,   &table->itemDefineIndex, 0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 4,  SQL_C_SSHORT,  &table->number,          0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 5,  SQL_C_SSHORT,  &table->count,           0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 6,  SQL_C_TINYINT, &table->enhanced,        0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 7,  SQL_C_SLONG,   &table->cardSlot1,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 8,  SQL_C_SLONG,   &table->cardSlot2,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 9,  SQL_C_SLONG,   &table->cardSlot3,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 10, SQL_C_SLONG,   &table->cardSlot4,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 11, SQL_C_SLONG,   &table->cardSlot5,       0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 12, SQL_C_TINYINT, &table->seal,            0, &(strLenOrInd=0) );
				SQLGetData( mHstmt, 13, SQL_C_TINYINT, &table->apply,           0, &(strLenOrInd=0) );
			}

			SQLClose( mHstmt );
		}
	}
	return retcode;
}

// ShortcutSelect Method
SQLRETURN cSQLGameStmt::ShortcutSelect(SHORTCUT_SELECT* shortcutSelect)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SHORTCUT_SELECT(?,?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       dataLen   = sizeof(shortcutSelect->table.binary);

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &shortcutSelect->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &shortcutSelect->rowCount,    0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_BINARY, shortcutSelect->table.binary, dataLen, &(strLenOrInd=0) );
		}

		SQLClose( mHstmt );
	}

	return retcode;
}

// ShortcutUpdate Method
SQLRETURN cSQLGameStmt::ShortcutUpdate(SHORTCUT_UPDATE* shortcutUpdate)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SHORTCUT_UPDATE(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       dataLen   = sizeof(shortcutUpdate->table.binary);
	long       cbData    = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch   = sizeof(shortcutUpdate->table.binary);

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER, 0,       0, &shortcutUpdate->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_BINARY, SQL_BINARY,  dataLen, 0, (VOID*)1,                      0, &cbData          );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, shortcutUpdate->table.binary, cbBatch );
				dataLen -= cbBatch;
			} while ( dataLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, shortcutUpdate->table.binary, dataLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}

		SQLClose( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::TitleInsert(TITLE_INSERT* titleInsert)
{
	SQLCHAR*    statement = (SQLCHAR*)"{call GP_TITLE_INSERT(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;
	SQLSMALLINT param;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &titleInsert->characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &titleInsert->titleIdx,	    0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT, SQL_C_TINYINT, SQL_TINYINT, 0, 0, &titleInsert->retvalue,	    0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );
}

SQLRETURN cSQLGameStmt::TitleSelect( TITLE_SELECT* titleSelect, u_long& cbLength )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_TITLE_SELECT(?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	retcode = SQLBindParameter( mHstmt, 1,   SQL_PARAM_INPUT, SQL_C_SLONG,	SQL_INTEGER,	0, 0, &titleSelect->characterIdx,0,	&(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if( SQL_SUCCEEDED( retcode ) )
	{
		u_long tableSize = sizeof(titleSelect->table);

		for( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,   &titleSelect->table[i].idx,			0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_SLONG,   &titleSelect->table[i].titleIdx,		0, &(strLenOrInd=0) );

			titleSelect->rowCount++;
		}
		cbLength += (titleSelect->rowCount * tableSize);

		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::VerifyGuild( VERIFY_GUILD* verifyGuild )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_VERIFY_GUILD(?, ?, ?)}";
	SQLRETURN	retcode;
	SQLINTEGER	strLenOrInd;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyGuild->count, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyGuild->total, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &verifyGuild->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if( SQL_SUCCEEDED( retcode ) )
	{
		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::GuildSelect( GUILD_SELECT* guildSelect )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILD_SELECT(?)}";
	SQLRETURN	retcode;
	SQLINTEGER	strLenOrInd;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &guildSelect->idx,		0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if( SQL_SUCCEEDED( retcode ) )
	{
		TB_GUILD* guild = guildSelect->table;
		SQLINTEGER nameSize = sizeof(guild->name);
		SQLINTEGER masterSize = sizeof(guild->masterName);
		SQLINTEGER noticeSize = sizeof(guild->notice);
		long       dataLen   = sizeof(guild->mark);

		if( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,  &guild->idx,			0,			&(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_WCHAR,  &guild->name,			nameSize,	&(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_SLONG,  &guild->masterIndex,	0,			&(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_WCHAR,  &guild->masterName,	masterSize,	&(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_WCHAR,  &guild->notice,		noticeSize,	&(strLenOrInd=0) );
			SQLGetData( mHstmt, 6, SQL_C_SLONG,  &guild->markIdx,		0,			&(strLenOrInd=0) );
			SQLGetData( mHstmt, 7, SQL_C_BINARY, &guild->mark,			dataLen,	&(strLenOrInd=0) );
			SQLGetData( mHstmt, 8, SQL_C_SSHORT, &guild->apply,			0,			&(strLenOrInd=0) );
		}

		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::GuildUserSelect( GUILDUSER_SELECT* guildUserSelect, u_long& cbLength )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILDUSER_SELECT(?)}";
	SQLRETURN	retcode;
	SQLINTEGER	strLenOrInd;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &guildUserSelect->idx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if( SQL_SUCCEEDED( retcode ) )
	{
		u_long tableSize = sizeof(guildUserSelect->table);
		SQLINTEGER nameSize = sizeof(guildUserSelect->table->name);

		for( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			SQLGetData( mHstmt, 1, SQL_C_SLONG,		&guildUserSelect->table[i].characterIdx,	0,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_WCHAR,		&guildUserSelect->table[i].name,			nameSize, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_TINYINT,	&guildUserSelect->table[i].level,			0,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_SLONG,		&guildUserSelect->table[i].job,				0,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_SSHORT,	&guildUserSelect->table[i].mapnum,			0,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 6, SQL_C_TINYINT,	&guildUserSelect->table[i].position,		0,		  &(strLenOrInd=0) );

			guildUserSelect->rowCount++;
		}
		cbLength += (guildUserSelect->rowCount * tableSize);

		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::GuildCreate( GUILD_CREATE* guildCreate )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILD_CREATE(?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	long       nameSize = sizeof(guildCreate->name);
	long       masterSize = sizeof(guildCreate->masterName);
	long       cbName		= wcslen(guildCreate->name) ? SQL_NTS : SQL_NULL_DATA;
	long       cbMasterName = wcslen(guildCreate->masterName) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildCreate->idx,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR,	50, 0, &guildCreate->name,			nameSize, &cbName );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildCreate->characterIdx,	0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR,	50, 0, &guildCreate->masterName,		masterSize, &cbMasterName );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildCreate->money,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildCreate->retvalue,		0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::GuildUpdate( GUILD_UPDATE* guildUpdate )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILD_UPDATE(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	long		noticeSize = sizeof(guildUpdate->notice);
	long		cbNotice   = wcslen(guildUpdate->notice) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUpdate->idx,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR,	40, 0, &guildUpdate->notice,		noticeSize, &cbNotice );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUpdate->retvalue,		0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::GuildDelete( GUILD_DELETE* guildDelete )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILD_DELETE(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildDelete->idx,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildDelete->charaterIdx,	0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildDelete->retvalue,		0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::GuildUserAdd( GUILDUSER_ADD* guildUserAdd )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILDUSER_ADD(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUserAdd->idx,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUserAdd->charaterIdx,	0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUserAdd->retvalue,		0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::GuildUserOut( GUILDUSER_OUT* guildUserOut )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILDUSER_OUT(?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUserOut->idx,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUserOut->charaterIdx,	0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,	0, 0, &guildUserOut->retvalue,		0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::GuildUserGivePosition( GUILDUSER_GIVEPOSITION* guildUserGivePosition )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILDUSER_GIVEPOSITION(?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,	SQL_INTEGER,	0, 0, &guildUserGivePosition->idx,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG,	SQL_INTEGER,	0, 0, &guildUserGivePosition->characterIdx,	0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_TINYINT,	SQL_TINYINT,	0, 0, &guildUserGivePosition->position,		0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_OUTPUT, SQL_C_SLONG,	SQL_INTEGER,	0, 0, &guildUserGivePosition->retvalue,		0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::GuildMarkUpdate( GUILDMARK_UPDATE* guildMarkUpdate )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILDMARK_UPDATE(?, ?, ?, ?)}";
	SQLINTEGER	strLenOrInd;
	SQLRETURN	retcode;

	/*long		dataLen = sizeof(guildMarkUpdate->mark.binary);
	long		cbData = SQL_NO_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,   0,       0, &guildMarkUpdate->idx,		 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,   0,       0, &guildMarkUpdate->markIdx,	 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_BINARY, SQL_VARBINARY, dataLen, 0, &guildMarkUpdate->mark.binary, 0, &cbData );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,   0,       0, &guildMarkUpdate->retvalue,	 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	return SQLClose( retcode, mHstmt );*/

	long       dataLen   = sizeof(guildMarkUpdate->mark.binary);
	long       cbData    = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch   = sizeof(guildMarkUpdate->mark.binary);

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER, 0,       0, &guildMarkUpdate->idx,			0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_SLONG,  SQL_INTEGER, 0,       0, &guildMarkUpdate->markIdx,		0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_BINARY, SQL_BINARY,  dataLen,	0, (VOID*)1,						0, &cbData );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0,       0, &guildMarkUpdate->retvalue,		0, &(strLenOrInd=0) );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, guildMarkUpdate->mark.binary, cbBatch );
				dataLen -= cbBatch;
			} while ( dataLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, guildMarkUpdate->mark.binary, dataLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}

		SQLClose( mHstmt );
	}
	return SQLClose( retcode, mHstmt );
}


SQLRETURN cSQLGameStmt::MakeSkillInsert( MAKESKILL_INSERT* pInsert )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_CHARACTER_MAKESKILL_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	SQLUSMALLINT n = 0;
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &pInsert->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &pInsert->mIsFirstSkill, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &pInsert->mMakeSkillIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &pInsert->mInventoryIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &pInsert->mRetvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			TB_INVENTORY* table = &pInsert->mInventory;

			if( SQLFetch( mHstmt ) == SQL_SUCCESS )
				SQLGetFullInv( mHstmt, table );
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


/// RecipeCoolTime Method.
SQLRETURN cSQLGameStmt::RecipeCoolTime( RECIPE_COOLTIME* recipeCoolTime )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_RECIPE_COOLTIME(?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER characterIdx;
	SQLINTEGER makeSkill;
	SQLINTEGER recipeIdx;
	SQLINTEGER coolTime;
	SQLINTEGER retValue;

	recipeCoolTime->mRetvalue = 0;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		SQLSMALLINT n = 0;

		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &characterIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &makeSkill, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &recipeIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &coolTime, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &retValue, 0, &(strLenOrInd=0) );

		for ( long i = 0; i < recipeCoolTime->mRowCount; ++i )
		{
			characterIdx = recipeCoolTime->mCharacterIdx;
			makeSkill = recipeCoolTime->mTable[i].mMakeSkill;
			recipeIdx = recipeCoolTime->mTable[i].mRecipeIdx;
			coolTime = (unsigned long)(recipeCoolTime->mTable[i].mLeftCoolTime / SECOND_THOUSAND);

			retcode = SQLExecute( mHstmt );

			if ( (SQL_SUCCEEDED( retcode )) )
			{
				if( retValue != 0 )
					recipeCoolTime->mRetvalue = retValue;
			}
			else
			{
				assert(NULL);
				return retcode;
			}
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	else
		assert(NULL);

	return retcode;
}

// MakeSkillSelect Method.
SQLRETURN cSQLGameStmt::MakeSkillSelect( MAKESKILL_SELECT* pSelect, u_long& cbLength )
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_MAKESKILL_SELECT(?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_ULONG, SQL_INTEGER, 0, 0, &pSelect->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		u_long tableSize = sizeof( pSelect->mTable );
		SQLUSMALLINT n;

		for ( int i = 0; SQLFetch( mHstmt ) == SQL_SUCCESS; i++ )
		{
			n = 0;
			SQLGetData( mHstmt, ++n, SQL_C_UTINYINT, &pSelect->mTable[ i ].mMakeSkill, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &pSelect->mTable[ i ].mRecipeIdx, 0, &(strLenOrInd=0) );
			SQLGetData( mHstmt, ++n, SQL_C_ULONG, &pSelect->mTable[ i ].mCoolTime, 0, &(strLenOrInd=0) );

			pSelect->mRowCount++;
		}
		cbLength += ( pSelect->mRowCount * tableSize );

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


SQLRETURN cSQLGameStmt::MakeSkillDelete( MAKESKILL_DELETE* pDelete )
{
	SQLCHAR* statement = (SQLCHAR*)"{call GP_CHARACTER_MAKESKILL_DELETE(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN retcode;
	SQLUSMALLINT n = 0;	

	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &pDelete->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &pDelete->mMakeSkillIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &pDelete->mRetvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return retcode;
}

SQLRETURN cSQLGameStmt::RecipeInsert( RECIPE_INSERT* pInsert )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_CHARACTER_RECIPE_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	SQLUSMALLINT n = 0;
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &pInsert->mCharacterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &pInsert->mMakeSkillIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &pInsert->mRecipeIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &pInsert->mInventoryIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &pInsert->retvalue, 0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			TB_INVENTORY* table = &pInsert->mInventory;

			if( SQLFetch( mHstmt ) == SQL_SUCCESS )
				SQLGetFullInv( mHstmt, table );
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}


/// RecipeCoolTime Method.
SQLRETURN cSQLGameStmt::RecipeGroupInsert( RECIPE_GROUP_INSERT* pRecipeGroup )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_CHARACTER_RECIPE_INSERT(?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLINTEGER characterIdx;
	SQLINTEGER makeSkill;
	SQLINTEGER recipeIdx;
	SQLINTEGER inventoryIdx;
	SQLINTEGER retValue = 0;
	pRecipeGroup->mRetvalue = 0;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( !SQL_SUCCEEDED( retcode ) )
		return retcode;

	SQLSMALLINT n = 0;

	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &characterIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_UTINYINT, SQL_TINYINT, 0, 0, &makeSkill, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_ULONG, SQL_INTEGER, 0, 0, &recipeIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &inventoryIdx, 0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++n, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &retValue, 0, &(strLenOrInd=0) );

	for ( unsigned long i = 0; i < pRecipeGroup->mRowCnt; ++i )
	{
		characterIdx = pRecipeGroup->mCharacterIdx;
		makeSkill = pRecipeGroup->mRecipeGroup[i].mMakeSkill;
		recipeIdx = pRecipeGroup->mRecipeGroup[i].mRecipeIdx;
		if( pRecipeGroup->mRowCnt == i+1 )
			inventoryIdx = pRecipeGroup->mInventoryIdx;
		else
			inventoryIdx = 0;

		retcode = SQLExecute( mHstmt );

		if ( (SQL_SUCCEEDED( retcode )) )
		{
			if( retValue == 0 )
			{				
				if ( SQLFetch( mHstmt ) == SQL_SUCCESS && inventoryIdx != 0 )
				{
					TB_INVENTORY* table = &pRecipeGroup->mInventory;
					if( table->idx != 0 )
						SQLGetFullInv( mHstmt, table );
				}
			}
			else
				pRecipeGroup->mRetvalue = retValue;
		}
		else
			return retcode;

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );
	}

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

SQLRETURN cSQLGameStmt::FortuneSelect( FORTUNE_SELECT* fortuneSelect )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_FORTUNE_SELECT(?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER,	0, 0, &fortuneSelect->characterIdx,			0, &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		SQLINTEGER wordSize = sizeof(fortuneSelect->word);

		if ( SQLFetch( mHstmt ) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 1, SQL_C_TYPE_TIMESTAMP,		&fortuneSelect->thru[0],	SQL_TIMESTAMP_LEN,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 2, SQL_C_TYPE_TIMESTAMP,		&fortuneSelect->thru[1],	SQL_TIMESTAMP_LEN,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 3, SQL_C_TYPE_TIMESTAMP,		&fortuneSelect->thru[2],	SQL_TIMESTAMP_LEN,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 4, SQL_C_TYPE_TIMESTAMP,		&fortuneSelect->thru[3],	SQL_TIMESTAMP_LEN,		  &(strLenOrInd=0) );
			SQLGetData( mHstmt, 5, SQL_C_TYPE_TIMESTAMP,		&fortuneSelect->thru[4],	SQL_TIMESTAMP_LEN,		  &(strLenOrInd=0) );

			SQLGetData( mHstmt, 6, SQL_C_WCHAR,		&fortuneSelect->word,	wordSize, &(strLenOrInd=0) );
			SQLGetData( mHstmt, 7, SQL_C_SLONG,		&fortuneSelect->color,	0,		  &(strLenOrInd=0) );
		}

		while( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

SQLRETURN cSQLGameStmt::FortuneUpdate( FORTUNE_UPDATE* fortuneUpdate )
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_FORTUNE_UPDATE(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN	retcode;

	long       wordSize = sizeof(fortuneUpdate->word);
	long       cbWord= wcslen(fortuneUpdate->word) ? SQL_NTS : SQL_NULL_DATA;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT,  SQL_C_SLONG,		   SQL_INTEGER,	       0,                 0, &fortuneUpdate->characterIdx,	0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT,  SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &fortuneUpdate->thru[0],		0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT,  SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &fortuneUpdate->thru[1],		0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT,  SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &fortuneUpdate->thru[2],		0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT,  SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &fortuneUpdate->thru[3],		0, &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT,  SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &fortuneUpdate->thru[4],		0, &(strLenOrInd=0) );

	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT,  SQL_C_WCHAR, SQL_WVARCHAR, 50, 0, &fortuneUpdate->word,	wordSize,	&cbWord );
	retcode = SQLBindParameter( mHstmt, 8, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER,   0, 0, &fortuneUpdate->color,	0,			&(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 9, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER,	 0, 0, &fortuneUpdate->retvalue,0,			&(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}
