 /* ====================================================================
 *<
 *      :	sqlGameStmt.h
 *      :	
 *    :	ö
 *    :	07/01/12
 * ǻ :	
 * =================================================================== */
#ifndef __SQL_GAME_STATEMENT_H__
#define __SQL_GAME_STATEMENT_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once
#include "odbcsql.h"
#include "gamesrvdefines.h"
#include "MakeSkill_Common.h"

struct INIT_GAME
{
	long channelNum;
	long removeCoolTimeCount;
	long removeSTallSellCount;
};

struct SHUTDOWN_GAME
{
	long channelNum;
	long removeCoolTimeCount;
	long removeSTallSellCount;
};

struct VERIFY_ITEM_TABLE
{
	long count;
	long retvalue;
};
struct ITEM_DEFINE_TABLE
{
	long           idx;
	TB_ITEM_DEFINE table[1];
};

struct ITEM_ABILITY_TABLE
{
	long            idx;
	TB_ITEM_ABILITY table[1];
};

struct ITEM_COOLTIME2_TABLE
{
	long              idx;
	long              rowCount;
	TB_ITEM_COOLTIME1 table[1];
};

struct ITEM_LIMIT_TABLE
{
	long          idx;
	TB_ITEM_LIMIT table[1];
};

struct ITEM_CARD_TABLE
{
	long         idx;
	TB_ITEM_CARD table[1];
};

struct ITEM_CARD_SLOT_TABLE
{
	long              idx;
	TB_ITEM_CARD_SLOT table[1];
};

struct ITEM_TAROT_TABLE
{
	long          idx;
	TB_ITEM_TAROT table[1];
};

struct ITEM_ENHANCED_TABLE
{
	long             idx;
	TB_ITEM_ENHANCED table[1];
};

struct ITEM_ENHANCED_RATE_TABLE
{
	long                  idx;
	TB_ITEM_ENHANCED_RATE table[1];
};

struct ITEM_DISJOINT_TABLE
{
	long             idx;
	TB_ITEM_DISJOINT table[1];
};

struct ITEM_CHANGE_TABLE
{
	long           idx;
	TB_ITEM_CHANGE table[1];
};

struct VERIFY_DEFAULT_ITEMS
{
	long rowCount;
	long retvalue;
};

struct CHARACTER_LIST
{
	long         userIdx;				// [In]   ε
	long         rowCount;				// [Out]   
	TB_CHARACTER table[1];				// [Out] ĳ ̺
};

struct CHARACTER_SELECT
{
	long         characterIdx;			// [In]  ĳ ε
	long         userIdx;				// [In]   ε
	TB_CHARACTER character;				// [Out] ĳ ̺
};

struct CHARACTER_NAME
{
	wchar_t name[17];					// [In]  ĳ ̸
	long    retvalue;					// [Out] 
};

struct CHARACTER_INSERT
{
	long    idx;						// [Out] ĳ ȣ
	wchar_t name[17];					// [In]  ĳ ̸
	char    race;						// [In]  ĳ 
	char    gender;						// [In]  ĳ 
	long    job;						// [In]  ĳ 
							
	long    hair;						// [In]  ĳ 
	long    face;						// [In]  ĳ 
							
	float   xPos;						// [In]  ĳ Xġ
	float   yPos;						// [In]  ĳ Yġ
							
	long    hp;							// [In]  HP ⺻
	long    mp;							// [In]  MP ⺻
							
	char    standIdx;					// [In]  ġ
	long    userIdx;					// [In]   ȣ
	long    retvalue;					// [Out] 
							
	long         rowCount;				// [Out]   
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

struct CHARACTER_DELETE
{
	long  idx;							// [In]  ĳ ȣ
	long  userIdx;						// [In]   ȣ
	long  retvalue;						// [Out] 
};

struct CHARACTER_UPDATE
{
	long  idx;							// [In]  ĳ ȣ
	short mapNumber;					// [In]   ȣ
	float xPos;							// [In]  Xġ (Ҽ )
	float yPos;							// [In]  Yġ "
	long  exp;							// [In]  ġ
	long  skillExp;						// [In]  ų ġ
	long  hp;							// [In]  HP
	long  mp;							// [In]  MP
	long  tarotPoint;					// [In]  Ÿ Ʈ
	long  titleIndex;					// [In]  ȣĪ ε
	long  guildIndex;					// [In]   ε
	char  guildPosition;				// [In]   
	long  retvalue;						// [Out] 
};

struct CHARACTER_EQUIP
{
	long idx;							// [In]  ĳ ȣ
	long hat;							// [In]    -   
	long body1;							// [In]  "               -   
	long body2;							// [In]  "               -   
	long hand;							// [In]  "               -   
	long foot;							// [In]  "               -   
	long earring;						// [In]  "               - Ͱ
	long necklace;						// [In]  "               - 
	long brooch;						// [In]  "               - ġ
	long bracelet;						// [In]  "               -   
	long ring;							// [In]  "               -   
	long leftHand;						// [In]  "               -   
	char leftHandEnhanced;				// [In]  "               -    ȭ
	long rightHand;						// [In]  "               - 
	char rightHandEnhanced;				// [In]  "               -  ȭ
};

struct CHARACTER_LEVEL
{
	unsigned long	idx;				// [In] ĳ ȣ
	unsigned char	level;				// [In] ĳ 
	unsigned char	levelUpPoint;		// [In] ĳ  
	long			retvalue;			// [Out] ȯ
};

struct CHARACTER_SKILLLEVEL
{
	unsigned long	idx;				// [In] ĳ ȣ
	unsigned char	skillLevel;			// [In] ĳ ų 
	unsigned char	levelUpPoint;		// [In] ĳ ų  
	unsigned long	skillPoint;			// [In] ĳ ų Ʈ
	unsigned long	skillTotal;			// [In] ĳ ų Ʈ  ȹ淮
	long			skillUpPoint;		// [In] ĳ ų Ʈ 
	long			retvalue;			// [Out] ȯ
};

struct CHARACTER_SKILL_RESET
{
	unsigned long	mCharacterIdx;		// [In] ĳ ȣ
	char			mRace;				// [In]	
	unsigned char	mJobStep;			// [In] ܰ
	long			mInventoryIdx;		// [In] κ丮 ȣ
	long			mRetvalue;			// [Out] ȯ

	long				mRowCount;		// [Out]	  
	TB_CHARACTER_SKILL	mTable[1];		// [Out] TB_CHARACTER_SKILL
};

struct CHARACTER_MONEY
{
	// DB ó  .
	long          idx;					// [In]  ĳ ȣ
	__int64       money;				// [In]  ݾ (ȣ)

	// LOG ó  .
	long          objectType;			// [In]  Object      - ó
	long          objectIndex;			// [In]  Object    - ó
	long          objectRaceGender;     // [In]  Object Detail   - ó
	unsigned long befor;				// [In]  
	unsigned long after;				// [In]  

	// DB ó  .
	long          retvalue;				// [Out] ȯ
};

struct CHARACTER_DEPOSIT
{
	// DB ó  .
	long          idx;					// [In]  ĳ ȣ
	__int64       money;				// [In]  ݾ (ȣ)

	// LOG ó  .
	long          objectType;			// [In]  Object      - ó
	long          objectIndex;			// [In]  Object    - ó
	long          objectRaceGender;     // [In]  Object Detail   - ó
	unsigned long befor;				// [In]  
	unsigned long after;				// [In]  

	// DB ó  .
	long          retvalue;				// [Out] ȯ
};

struct CHARACTER_TAROT_POINT
{
	long idx;							// [In]  ĳ ȣ
	long point;							// [In]  Ʈ (ȣ)
};

struct CHARACTER_PVP_POINT
{
	long idx;							// [In]  ĳ ȣ
	long point;							// [In]  Ʈ (ȣ)
};

struct CHARACTER_ACTIVE_WEAPON
{
	long idx;							// [In]  ĳ ȣ
	char activeWeapon;					// [In]  ĳ Ȱ  (0 Front, 1Back)
	long retvalue;						// [Out] ȯ
};

struct CHARACTER_OPTION
{
	long idx;							// [In]  ĳ ȣ
	long option1;						// [In]  ĳ ɼ1
	long retvalue;						// [Out] ȯ
};

struct CHARACTER_FORCE
{
	unsigned long		mIdx;			// [In]  ĳ ȣ
	unsigned char		mForceType;		// [In]  
	long				mRetValue;		// [Out] ȯ
};

struct CHARACTER_BLOCK_SELECT
{
	long characterIdx;					// [In]  ĳ ȣ
	int  rowCount;						// [In]  (뿩)
	long validTrue;						// [In]  ȿ( )
};

struct CHARACTER_BLOCK_INSERT
{
	long blockCharacterIdx;				// [In]   ĳ ȣ
	long adminCharacterIdx;	            // [In]   ĳ ȣ
	long validTrue;						// [In]  ȿ( )
};

/*--  / κ丮
*/
enum INVENTORY_WARNING
{
	IW_ERROR_DUPLICATE_NUMBER = 0,		// κ丮 ȣ() ߺ
	IW_ERROR_ITEM_DEFINE_INDEX,			//   ε 
	IW_ERROR_UNDER_COUNT,				// κ丮  
};
struct INVENTORY_INSERT
{
	long         characterIdx;			// [In]     ĳ ȣ
	long         rowCount;				// [In]    
	TB_INVENTORY table[1];				// [In/Out] TB_INVENTORY ڵ
};

struct INVENTORY_SELECT
{
	long         characterIdx;			// [In]  ĳ ȣ
	long         rowCount;				// [In]    
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_DELETE
{
	INVENTORY_WARNING	 warning;		// [In]  
	long				 characterIdx;	// [In]  ĳ ȣ
	long				 inventoryIdx;	// [In]  ȣ
	TB_INVENTORY		 table;			// [Out] TB_INVENTORY ڵ
	long				 retvalue;		// [Out] 
};

struct INVENTORY_COOLTIME_SELECT
{
	long                  characterIdx;	// [In]  ĳ ȣ
	long                  rowCount;		// [In]    
	TB_INVENTORY_COOLTIME table[1];		// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_COOLTIME_INSERT
{
	long                  characterIdx;	// [In]  ĳ ȣ
	TB_INVENTORY_COOLTIME table[1];		// [In]  TB_INVENTORY ڵ
};

struct INVENTORY_USE
{
	long          idx;					// [In]  ȣ
	TB_INVENTORY  table[1];				// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_REMOVE
{
	long  idx;							// [In]  ȣ
	short number;						// [In]  ȣ
	long  retvalue;						// [Out] 

	TB_INVENTORY table;					// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_SWAP
{
	long  idx1;							// [In]  ȣ
	short number1;						// [In]  ȣ

	long  idx2;							// [In]  ȣ
	short number2;						// [In]  ȣ

	TB_INVENTORY table[2];				// [In/Out] TB_INVENTORY ڵ
	long         retvalue;				// [Out] 
};

struct INVENTORY_MOVE
{
	long         characterIdx;			// [In]  ĳ ȣ
	long         idx;					// [In]  ȣ
	short        number;				// [In]  ̵ ȣ
	TB_INVENTORY table;					// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_EXCEPT
{
	long         characterIdx;			// [In]  ĳ ȣ
	long         idx;					// [In]  ȣ
	short        number;				// [In]  ̵ ȣ
	TB_INVENTORY table;					// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_MERGE
{
	long         idx1;					// [In]  ȣ1
	long         idx2;					// [In]  ȣ2

	long         rowCount;				// [Out]   
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_DIVIDE
{
	long         characterIdx;			// [In]  ĳ ȣ
	long         rowCount;				// [In]    
	TB_INVENTORY table[2];				// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_MOVE2
{
	long         characterIdx;			// [In]  ĳ ȣ
	long         rowCount;				// [In]    
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

#define RESULT_INVENTORY_ENHANCED_SUCCESS	0	// 
#define RESULT_INVENTORY_ENHANCED_DOWN		1	// 
#define RESULT_INVENTORY_ENHANCED_DESTRUCT	2	// ı
#define RESULT_INVENTORY_ENHANCED_FAIL		3	// 

struct INVENTORY_ENHANCED
{
	long         idx1;					// [In]  ȣ (ȭ)
	long         idx2;					// [In]  ȣ (ȭī)
	char         result;				// [In]  (0/1/2ı/3)
	long         retvalue;				// [Out] ȯ
	TB_INVENTORY table[2];				// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_DISJOINT
{
	// ؾ
	long characterIdx;					// [In]  ĳ ȣ
	long characterMoney;				// [In]  ĳ ݾ (ȣ)
	long retvalue;						// [In]  [Out] 

	long         rowCount;				// [Out]   
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_PUT_CARD
{
	long         idx1;					// [In]  ȣ1()
	BYTE         cardSlot;              // [In]  ī彽 ȣ(1~5)
	long         idx2;					// [In]  ȣ2(ī)
	long         itemDefineIndex;		// [In]   ε(TB_ITEM_DEFINE::INDEX [ȹ:зȣ])
	long         retvalue;				// [Out] ȯ
	TB_INVENTORY table[2];				// [Out] TB_INVENTORY ڵ
};

struct INVENTORY_CHANGE
{
	// ȯ
	long characterIdx;					// [In]  ĳ ȣ
	long characterMoney;				// [In]  ĳ ݾ (ȣ)
	long retvalue;						// [In]  [Out] 

	long         rowCount;				// [Out]   
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

struct ITEM_SELL
{
	long         characterIdx;			// [In]  ĳ ȣ
	long         npcIdx;				// [In]  NPC    ȣ
	long         sellType;				// [In]  ǸŹ
	long         sellPrice;				// [In]  ǸŰ

	long         rowCount;				//  
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

struct ITEM_BUY
{
	long         characterIdx;			// [In]  ĳ   ȣ
	long         npcIdx;				// [In]  NPC      ȣ
	long         buyType;				// [In]  Թ
	long         buyPrice;				// [In]  ԰

	long         rowCount;				// [In]    
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

struct ITEM_COLLECT
{
	struct {
		long         inventoryIdx;		// [In]  κ丮 ȣ
		TB_INVENTORY table;				// [Out] TB_INVENTORY ڵ
	} update;

	struct {
		long         inventoryIdx;		// [In]  κ丮 ȣ
		TB_INVENTORY table;				// [Out] TB_INVENTORY ڵ
	} remove;
	short inventoryNumber1;				// [In]  κ丮 ȣ
	short inventoryNumber2;				// [In]  κ丮 ȣ
	long retvalue;						// [Out] 
};

struct ITEM_GET
{
	long             characterIdx;		// [In]  ĳ   ȣ

	long             rowCount;			// [In]    
	struct {
		bool         newOrUpdate;		// [In]   Ǵ (0 new, 1 update)
		long         itemDefineIndex;	// [In]    ε
		short        inventoryNumber;	// [In]  κ丮 ȣ
		short        count;				// [In]  

		long         retvalue;			// [Out] ȯ
		TB_INVENTORY table;				// [Out] TB_INVENTORY ڵ
	} table[ 1 ];
};

struct ITEM_GET_QUEST
{
	long         characterIdx;			// [In]  ĳ   ȣ
	bool         newOrUpdate;			// [In]   Ǵ (0 new, 1 update)
	long         itemDefineIndex;		// [In]    ε
	short        inventoryNumber;		// [In]  κ丮 ȣ
	short        count;					// [In]  

	long         retvalue;				// [Out] ȯ
	TB_INVENTORY table;					// [Out] TB_INVENTORY ڵ
};

struct ITEM_USE
{
	long             characterIdx;		// [In]  ĳ   ȣ
	long             rowCount;			// [In]    
	struct {
		long         inventoryIdx;		// [In]  κ丮 ȣ
		short        count;				// [In]  

		long         retvalue;			// [Out] ȯ
		TB_INVENTORY table;				// [Out] TB_INVENTORY ڵ
	} table[ 1 ];
};


/*-- ŷ
*/
struct ITEM_EXCHANGE
{
	long rowCount;
	struct {
		long         characterIdx;		// [In]     ĳ ȣ
		long         characterMoney;	// [In]     ݾ(ȣ)
		long         characterFrom;		// [In]     ĳ ȣ()
		long         characterBefor;	// [In]     ĳ  ݾ
		long         characterAfter;	// [In]     ĳ  ݾ
		long         retvalue;			// [Out]    ȯ

		long         rowCount;						// [In]       
		TB_INVENTORY table[ MAX_ITEM_EXCHANGE ];	// [In&Out] TB_INVENTORY ڵ
	} table[ 2 ];
};

/*--  
*/
struct ITEM_MIX
{
	long         characterIdx;			// [In]  ĳ   ȣ
	long         rowCount;				// [In]    
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};


/*-- 
*/
struct NOTE_SELECT
{
	long    characterIdx;				// [In] ĳ ȣ
	long    rowCount;					// [Out]   
	TB_NOTE table[1];					// TB_NOTE ڵ
};

struct NOTE_INSERT
{
	long    characterIdx1;				// [In]   ĳ(ȣ)
	long    characterIdx2;				// [Out] ޴ ĳ(ȣ)
	wchar_t characterName2[ 17 ];		// [In]  ޴ ĳ(̸)
	wchar_t message[ 200 ];				// [In]  ޽
	long    retvalue;					// [Out] 

	TB_NOTE	table;						// [Out]  
};

struct GUILDNOTE_INSERT
{
	long    characterIdx1;				// [In]   ĳ(ȣ)

	wchar_t message[ 200 ];				// [In]  ޽
	long    characterIdx2[50];			// [In] ޴ ĳ(ȣ)

	long    rowCount;					// [In]    
	TB_NOTE	table[1];					// [Out]  
};

struct NOTE_DELETE
{
	long    characterIdx;				// [In]  ĳ ȣ
	long    rowCount;					// [In]    
	long    idx[ 1 ];					// [In]  ȣ
};

struct FRIEND_SELECT
{
	long      characterIdx;				// [In]  ĳ ȣ
	long      rowCount;					// [Out]   
	TB_FRIEND table[1];					// [Out] TB_FRIEND ڵ
};

struct FRIEND_INSERT
{
	long    characterIdx1;				// [In]  ĳ(ȣ)
	long    characterIdx2;				// [Out] ĳ(ȣ)
	wchar_t characterName[ 17 ];		// [In]  ĳ ̸(ģ)
	long    retvalue;					// [Out] 
};

struct FRIEND_UPDATE
{
	long    idx;						// [In]  ȣ
	long    characterIdx1;				// [In]  ĳ ȣ
	long    characterIdx2;				// [Out] ĳ(ȣ)
};

struct FRIEND_DELETE
{
	long    idx;						// [In]  ȣ
	long    characterIdx1;				// [In]  ĳ ȣ
	long    characterIdx2;				// [Out] ĳ(ȣ)
};

/*-- Etc
*/
struct ITEM_SPREAD_VALUE
{
	long  itemDefineIndex;              // [In]  TB_ITEM_DEFINE::Index-   ε
	long  spreadIndex;					// [In]  TB_ITEM_SPREAD::Index- ε
	long  spreadValue;					// [Out] Ʈ  Ÿī 
	struct
	{
		long  itemDefineIndex;			// [In]  Ÿī ε
		BYTE  dir;						// [In]  Ÿī 
		long  tarot;					// [In]  Ÿī 
		long  spread;					// [In]   
	} values[ 10 ];

};

struct ITEM_TAROT_RESULT
{
	long itemDefineIndex;				// [In]  TB_ITEM_DEFINE::Index  ε
	long value;							// [In]  Է°(Ÿΰ)

	long influence_idx1;				// [Out] ųȿ[ųε]
	long influence_idx2;				// [Out] ųȿ[ųε]
	long influence_idx3;				// [Out] ųȿ[ųε]
};

// ų
struct SKILL_SELECT
{
	long				mCharacterIdx;	// [In]	ĳ ȣ
	long				mRowCount;		// [Out]	  
	TB_CHARACTER_SKILL	mTable[1];		// [Out]	TB_CHARACTER_SKILL
};

struct SKILL_INSERT
{
	unsigned long		mCharacterIdx;	// [In]	ĳ ȣ
	unsigned long		mSkillClassIdx;	// [In]	ų ȣ
	unsigned long		mMoney;			// [In]	Ҹݾ
	unsigned short		mSP;			// [In]	ҸSP
	unsigned char		skillLevel;		// [In] ų 
	unsigned long		skillPoint;		// [In] ų Ʈ
	long				mRetvalue;		// [Out]	
};

struct SKILL_UPDATE
{
	unsigned long		mCharacterIdx;	// [In]	ĳ ȣ
	unsigned long		mSkillClassIdx;	// [In]	ų ȣ
	unsigned char		mSkillStep;		// [In]	ų ܰ
	unsigned long		mMoney;			// [In]	Ҹݾ
	unsigned short		mSP;			// [In]	ҸSP
	unsigned char		skillLevel;		// [In] ų 
	unsigned long		skillPoint;		// [In] ų Ʈ
	long				mRetvalue;		// [Out]	
};

struct SKILL_COOLTIME
{
	unsigned long		mCharacterIdx;	// [In]	ĳ ȣ
	long				mRowCount;		// [Out]	Է  
	long				mRetvalue;		// [Out]	
	TB_CHARACTER_SKILL	mTable[1];		// [Out]	TB_CHARACTER_SKILL
};


// ȿ
struct SKILL_INFLUENCE_SELECT
{
	long				mCharacterIdx;	// [In]	ĳ ȣ
	long				mRowCount;		// [Out]	  
	TB_CHARACTER_INFLUENCE	mTable[1];	// [Out]	TB_CHARACTER_INFLUENCE
};

struct SKILL_INFLUENCE_DELETE
{
	unsigned long		mCharacterIdx;	// [In]	ĳ ȣ
	long				mRetvalue;		// [Out]	
};

struct SKILL_INFLUENCE_INSERT
{
	unsigned long		mCharacterIdx;	// [In]	ĳ ȣ
	long				mRowCount;		// [Out]	Է  
	long				mRetvalue;		// [Out]	
	TB_CHARACTER_INFLUENCE	mTable[1];	// [In]	TB_CHARACTER_INFLUENCE
};

struct RECIPE_COOLTIME
{
	unsigned long		mCharacterIdx;	// [In]	ĳ ȣ
	long				mRowCount;		// [Out]	Է  
	long				mRetvalue;		// [Out]	
	TB_RECIPE_COOLTIME	mTable[1];		// [Out]	TB_CHARACTER_SKILL
};

struct STALL_SELL_SEARCH
{
	long          channelNum;			// [In]  ä ȣ
	long          itemDefineIndex;		// [In]    ε
	BYTE          enhanced;				// [In]  ȭܰ
	long          rowCount;				// [Out]   
	TB_STALL_SELL table[ 1 ];			// [Out] TB_STALL_SELL ڵ
};

struct STALL_SELL_INSERT
{
	long channelNum;					// [In]  äιȣ
	long characterIdx;					// [In]  ĳ ȣ
	long inventoryIdx;					// [In]  κ丮 ȣ
	long itemDefineIndex;				// [In]    ε
	BYTE enhanced;						// [In]  ȭܰ
	long price;							// [In]  
	long retvalue;						// [Out] ȯ
};

struct STALL_SELL_REMOVE
{
	long inventoryIdx;					// [In]  ĳ ȣ
	long retvalue;						// [Out] ȯ
};

struct STALL_SELL_CLEAR
{
	long characterIdx;					// [In]  ĳ ȣ
	long retvalue;						// [Out] ȯ
};

struct STALL_SELL_GET
{
	long         fCharacterIdx;		// [In]  ĳ   ȣ
	sObject      fObject;           // [In]  ĳ   Ʈ 
	long         fCharacterMoney;	// [In]  ĳ   ݾ (ȣ)
	long         fInventoryIdx;		// [In]  κ丮 ȣ
	TB_INVENTORY fInventory;		// [Out] TB_INVENTORY ڵ

	long         tCharacterIdx;		// [In]  ĳ   ȣ
	long         tCharacterMoney;	// [In]  ĳ   ݾ (ȣ)
	short        tInventoryNumber;	// [In]  κ丮 ȣ()
	short        tInventoryCount;	// [In]  κ丮 
	TB_INVENTORY tInventory;		// [Out] TB_INVENTORY ڵ

	long         retvalue;				// [Out] ȯ
};

/*-- ţ
*/
struct SHORTCUT_SELECT
{
	long        characterIdx;			// [In]  ĳ ȣ
	long		rowCount;				// [Out] select īƮ
	TB_SHORTCUT table;					// [In]  TB_SHORTCUT
};

struct SHORTCUT_UPDATE
{
	long        characterIdx;			// [In]  ĳ ȣ
	TB_SHORTCUT table;					// [In]  TB_SHORTCUT
};

/*-- Ʈ
*/
struct QUEST_INSERT
{
	long    characterIdx;				// [In]  ĳ ȣ
	long	questIdx;					//
	__int64 check;						// [In]   
	char	timeType;					// [In]  Ʈ ð Ÿ
	long	restTime;					// [In]  Ʈ ð
	long	retvalue;					// [Out] 

	TB_QUEST_PROGRESS quest;			// [Out] TB_QUEST_PROGRESS ڵ

	long         rowCount;				// [In/Out]   
	TB_INVENTORY inventory[1];			// [In/Out] TB_INVENTORY ڵ
};

struct QUEST_INSERTBYITEM
{
	long    characterIdx;				// [In]  ĳ ȣ
	long	questIdx;					//
	__int64 check;						// [In]   
	char	timeType;					// [In]  Ʈ ð Ÿ
	long	restTime;					// [In]  Ʈ ð
	long	retvalue;					// [Out] 

	TB_QUEST_PROGRESS quest;			// [Out] TB_QUEST_PROGRESS ڵ

	long         rowCount;				// [In]       
	TB_INVENTORY inventory[1];			// [In/Out] TB_INVENTORY ڵ
};

struct QUEST_UPDATE
{
	long	characterIdx;				// [In]  ĳ ȣ
	long	rowCount;
	char	titmeType;					// [In]  ð Ÿ
	TB_QUEST_PROGRESS table[1];			// [In]  TB_QUEST_PROGRESS ڵ
};

struct QUEST_SELECT
{
	long	characterIdx;				// [In]  ĳ ȣ
	long	rowCount;
	TB_QUEST_PROGRESS table[1];
};

struct QUEST_DELETE
{
	long    idx;						// [In]  db ε
	int		arrIdx;						// [In]  迭ε
	long	characterIdx;				// [In]  ĳ ȣ
	long	retvalue;					// [Out] 

	// ȸ []
	long         rowCount;				// [In]       
	TB_INVENTORY table[1];				// [In/Out] TB_INVENTORY ڵ
};

// Ʈ  Ϸ û
struct QUEST_COMPLETE
{
	long idx;							// [In]  db ε
	int  arrIdx;						// [In]  迭ε
	long characterIdx;					// [In]  ĳ ȣ
	char repeatType;					// [In]  ݺŸ
	char status;						// [Out] °
	long retvalue;						// [Out] 

	/// Ʈ 
	__int64 check;						// [In]   

	// ȸ []
	long         rowCount;				// [Out]   
	TB_INVENTORY table[1];				// [Out] TB_INVENTORY ڵ
};

//   Ϸ û
struct QUEST_REWARD
{
	long idx;							// [In&out] db ε
	int  arrIdx;						// [In]     迭ε
	long characterIdx;					// [In]     ĳ ȣ

	//  [  ]
	long bufRowCount;					// [In]       
	long bufIndex[ 3 ];					// [In]     ε

	//  [  ]
	long characterMoney;				// [In]     ĳ ݾ (ȣ)

	//  [  ]
	long jobIdx;						// [In]     ε
	char race;							// [In]		
    
	//  ų
	unsigned int skillPoint;			// [In]		ų Ʈ

	//  [  ]
	unsigned char forceType;			// [In]      Ÿ

	//  [ȣ  Ī]
	long titleIdx;						// [In]		ȣĪ ε

	//  []
	long         itemRowCount;			// [In/Out]   
	TB_INVENTORY table[5];				// [In/Out] TB_INVENTORY ڵ
	
	char skillRowCount;					// [Out]   
	unsigned long skillClassIdx[1];		// [Out]  ڵ ų
};

//   Ʈ Ϲޱ
struct QUEST_ENDLIST
{
	long	characterIdx;				// [In]  ĳ ȣ
	long	rowCount;
	long	questIdx[1];				// [Out] 	
};

// Ʈ 
struct QUEST_REMOVE
{
	long idx;							// [In]  ȣ
};

/// ȣĪ 
struct TITLE_INSERT
{
	long	characterIdx;				// [In] ĳ ε
	long	titleIdx;					// [In] ȣĪ ε
	long	retvalue;					// [Out] 
};

/// ȣĪ Ʈ ޱ
struct TITLE_SELECT
{
	long	characterIdx;				// [In] ĳ ε
	long	rowCount;					// [Out]   
	TB_TITLE	table[1];				// [Out] TB_TITLE ڵ
};

struct VERIFY_GUILD
{
	long		 count;					//  ϴ 
	long		 total;					// ü 
	long         retvalue;			
};

///  select
struct GUILD_SELECT
{
	long		 idx;					// [In] ȣ ( ε)
	TB_GUILD	 table[1];				// [Out]  ̺
};

//   
struct GUILDUSER_SELECT
{
	long			idx;				// [In]  ȣ ( ε)
	long			rowCount;			// [Out]   
	TB_GUILD_USER	table[1];			// [Out]   
};

//  
struct GUILD_CREATE
{
	long	idx;						// [Out] ȣ ( ε)
	long	characterIdx;				// [In] ĳ ε
	wchar_t name[13];					// [In] 
	wchar_t masterName[17];				// [In]  
	long	money;						// [In]  ݾ
	long	retvalue;					// [Out] 	
};

//  ߰
struct GUILDUSER_ADD
{
	long	idx;						// [In] ȣ ( ε)
	long	charaterIdx;				// [In] ĳ ε
	long	retvalue;					// [Out] 	
};

//  
struct GUILDUSER_OUT
{
	long	idx;						// [In] ȣ ( ε)
	long	charaterIdx;				// [In] ĳ ε
	long	retvalue;					// [Out] 	
};

//  ü
struct GUILD_DELETE
{
	long	idx;						// [In] ȣ ( ε)
	long	charaterIdx;				// [In] ĳ ε
	long	retvalue;					// [Out] 	
};

//  
struct GUILD_UPDATE
{
	long	idx;						// [In] ȣ ( ε)
	wchar_t notice[41];					// [In]  
	long	retvalue;					// [Out] 	
};

//   ο
struct GUILDUSER_GIVEPOSITION
{
	long	idx;						// [In] ȣ ( ε)	
	long	characterIdx;				// [In] ĳ ε
	char	position;					// [In]  
	long	retvalue;					// [Out] 	
};

// 帶ũ 
struct GUILDMARK_UPDATE
{
	long			idx;						// [In] ε
	long			markIdx;					// [In] 帶ũ ε
	TB_GUILDMARK	mark;						// [In] 帶ũ 24 * 24 * (32/8)
	long			retvalue;					// [Out] 
};

// ų
struct MAKESKILL_INSERT
{
	unsigned long	mCharacterIdx;		// [In] ĳ ȣ
	bool			mIsFirstSkill;		// [In] 2  1,2 ġ
	unsigned char	mMakeSkillIdx;		// [In]   ų idx	
	long			mInventoryIdx;		// [In] κ丮 ȣ
	long			mRetvalue;			// [Out] 
	TB_INVENTORY	mInventory;			// [Out] TB_INVENTORY ڵ
};

struct MAKESKILL_SELECT
{
	unsigned long	mCharacterIdx;		// [In]		ĳ ȣ
	long			mRowCount;			// [Out]	  
	TB_MAKESKILL	mTable[1];			// [Out]	TB_MAKESKILL
};

struct MAKESKILL_DELETE
{
	unsigned long	mCharacterIdx;		// [In]		ĳ ȣ
	unsigned char	mMakeSkillIdx;		// [In]		
	long			mRetvalue;			// [Out]		
};

struct RECIPE_INSERT
{
	unsigned long	mCharacterIdx;		// [In] ĳ ȣ
	unsigned char	mMakeSkillIdx;		// [In]   ų idx	
	unsigned long	mRecipeIdx;			// [In]  idx
	long			mInventoryIdx;		// [In] κ丮 ȣ
	long			retvalue;			// [Out] 
	TB_INVENTORY	mInventory;			// [Out] TB_INVENTORY ڵ
};

struct RECIPE_GROUP_INSERT
{
	unsigned long	mCharacterIdx;		// [In] ĳ ȣ
	unsigned char	mMakeSkillIdx;		// [In]   ų idx	
	long			mInventoryIdx;		// [In] κ丮 ȣ
	TB_INVENTORY	mInventory;			// [Out] TB_INVENTORY ڵ
	long			mRetvalue;			// [Out] 
	unsigned long	mRowCnt;			// [in]  Է 
	sRecipeGroupInfo mRecipeGroup[1];	// [In]  idx

	unsigned long GetMsgLength() { return sizeof(RECIPE_GROUP_INSERT) - sizeof(mRecipeGroup) + (mRowCnt * sizeof(sRecipeGroupInfo));} 
};

///  Ӽ
struct FORTUNE_SELECT
{
	long				characterIdx;				// [In] ĳ ε
	TIMESTAMP_STRUCT	thru[5];					// [Out] 	
	wchar_t				word[13];					// [Out]  Ѹ
	unsigned long		color;						// [Out]  Ѹ ÷
};

struct FORTUNE_UPDATE
{
	long				characterIdx;				// [In] ĳ ε
	TIMESTAMP_STRUCT	thru[5];					// [In] ð	
	wchar_t				word[13];					// [In]  Ѹ
	unsigned long		color;						// [In]  Ѹ ÷
	long				retvalue;					// [Out] 
};

class cSQLGameStmt :
	public cSQLStatement
{
private:
	SQLRETURN SQLClose                 ( SQLRETURN sqlReturn, SQLHSTMT sqlHStmt );
	void      SQLClose                 ( SQLHSTMT sqlHStmt );

	void      SQLGetFullInv            ( SQLHSTMT sqlHStmt, TB_INVENTORY* table );
	void      SQLGetBaseInv            ( SQLHSTMT sqlHStmt, TB_INVENTORY* table );

public:
// Ŭ    ޼ҵ.
	cSQLGameStmt(void);

	// Init Game Database
	SQLRETURN Init                     ( INIT_GAME* initGame );

	// Shutdown Game Database
	SQLRETURN Shutdown                 ( SHUTDOWN_GAME* shutdownGame );

	// Item
	SQLRETURN TruncateItemDefine       ( void );
	SQLRETURN TruncateItemAbility      ( void );
	SQLRETURN TruncateItemLimit        ( void );
	SQLRETURN TruncateItemCard         ( void );
	SQLRETURN TruncateItemCardSlot     ( void );
	SQLRETURN TruncateItemTarot        ( void );
	SQLRETURN TruncateItemTarotResult  ( void );
	SQLRETURN TruncateItemSpread       ( void );
	SQLRETURN TruncateItemDisjoint     ( void );
	SQLRETURN TruncateItemEnhanced     ( void );
	SQLRETURN TruncateItemEnhancedRate ( void );
	SQLRETURN TruncateItemChange       ( void );
	SQLRETURN TruncateDefaultItems     ( void );

	SQLRETURN InsertItemDefine         ( TB_ITEM_DEFINE* tbItemDefine, long& retvalue );
	SQLRETURN InsertItemAbility        ( TB_ITEM_ABILITY* tbItemAbility, long& retvalue );
	SQLRETURN InsertItemLimit          ( TB_ITEM_LIMIT* tbItemLimit, long& retvalue );
	SQLRETURN InsertItemCard           ( TB_ITEM_CARD* tbItemCard, long& retvalue );
	SQLRETURN InsertItemCardSlot       ( TB_ITEM_CARD_SLOT* tbItemCardSlot, long& retvalue );
	SQLRETURN InsertItemTarot          ( TB_ITEM_TAROT* tbItemTarot, long& retvalue );
	SQLRETURN InsertItemTarotResult    ( TB_ITEM_TAROT_RESULT* tbItemTarotResult, long& retvalue );
	SQLRETURN InsertItemSpread         ( TB_ITEM_SPREAD* tbItemSpread, long& retvalue );
	SQLRETURN InsertItemDisjoint       ( TB_ITEM_DISJOINT* tbItemDisjoint, long& retvalue );
	SQLRETURN InsertItemEnhanced       ( TB_ITEM_ENHANCED* tbItemEnhanced, long& retvalue );
	SQLRETURN InsertItemEnhancedRate   ( TB_ITEM_ENHANCED_RATE* tbItemEnhancedRate, long& retvalue );
	SQLRETURN InsertItemChange         ( TB_ITEM_CHANGE* tbItemChange, long& retvalue );
	SQLRETURN InsertDefaultItems       ( TB_DEFAULT_ITEMS* tbDefaultItems, long& retvalue );

	SQLRETURN VerifyItemDefine         ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemAbility        ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemCooltime2      ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemLimit          ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemCard           ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemCardSlot       ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemTarot          ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemEnhanced       ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemEnhancedRate   ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemDisjoint       ( VERIFY_ITEM_TABLE* verifyItemTable );
	SQLRETURN VerifyItemChange         ( VERIFY_ITEM_TABLE* verifyItemTable );

	SQLRETURN ItemDefine               ( ITEM_DEFINE_TABLE* itemDefineTable );
	SQLRETURN ItemAbility              ( ITEM_ABILITY_TABLE* itemAbilityTable );
	SQLRETURN ItemCooltime2            ( ITEM_COOLTIME2_TABLE* itemCooltime2Table, u_long& cbLength );
	SQLRETURN ItemLimit                ( ITEM_LIMIT_TABLE* itemLimitTable );
	SQLRETURN ItemCard                 ( ITEM_CARD_TABLE* itemCardTable );
	SQLRETURN ItemCardSlot             ( ITEM_CARD_SLOT_TABLE* itemCardSlotTable );
	SQLRETURN ItemTarot                ( ITEM_TAROT_TABLE* itemTarotTable );
	SQLRETURN ItemEnhanced             ( ITEM_ENHANCED_TABLE* itemEnhancedTable );
	SQLRETURN ItemEnhancedRate         ( ITEM_ENHANCED_RATE_TABLE* itemEnhancedRateTable );
	SQLRETURN ItemDisjoint             ( ITEM_DISJOINT_TABLE* itemDisjointTable );
	SQLRETURN ItemChange               ( ITEM_CHANGE_TABLE* itemChangeTable );

	SQLRETURN VerifyDefaultItems       ( VERIFY_DEFAULT_ITEMS* verifyDefaultItems );

	// Character
	SQLRETURN CharacterList            ( CHARACTER_LIST* characterList, u_long& cbLength );
	SQLRETURN CharacterName            ( CHARACTER_NAME* characterName );
	SQLRETURN CharacterInsert          ( CHARACTER_INSERT* characterInsert, u_long& cbLength );
	SQLRETURN CharacterDelete          ( CHARACTER_DELETE* characterDelete );
	SQLRETURN CharacterUpdate          ( CHARACTER_UPDATE* characterUpdate );
	SQLRETURN CharacterSelect          ( CHARACTER_SELECT* characterSelect );
	SQLRETURN CharacterEquip           ( CHARACTER_EQUIP* characterEquip );
	SQLRETURN CharacterMoney           ( CHARACTER_MONEY* characterMoney );
	SQLRETURN CharacterDeposit         ( CHARACTER_DEPOSIT* characterDeposit );
	SQLRETURN CharacterTarotPoint      ( CHARACTER_TAROT_POINT* characterTarotPoint );
	SQLRETURN CharacterPvpPoint        ( CHARACTER_PVP_POINT* characterPvpPoint );
	SQLRETURN CharacterLevel           ( CHARACTER_LEVEL* characterLevel );
	SQLRETURN CharacterSkillLevel      ( CHARACTER_SKILLLEVEL* characterSkillLevel );
	SQLRETURN CharacterActiveWeapon    ( CHARACTER_ACTIVE_WEAPON* characterActiveWeapon );
	SQLRETURN CharacterOption          ( CHARACTER_OPTION* characterOption );
	SQLRETURN CharacterForce           ( CHARACTER_FORCE* characterForce );
	SQLRETURN CharacterSkillReset      ( CHARACTER_SKILL_RESET* reset, u_long& cbLength );
	SQLRETURN CharacterBlockSelect     ( CHARACTER_BLOCK_SELECT* characterBlockSelect );
	SQLRETURN CharacterBlockInsert     ( CHARACTER_BLOCK_INSERT* characterBlockInsert );

	// Inventory&Item
	SQLRETURN InventoryInsert          ( INVENTORY_INSERT* inventoryInsert );
	SQLRETURN InventorySelect          ( INVENTORY_SELECT* inventorySelect, u_long& cbLength );
	SQLRETURN InventoryDelete          ( INVENTORY_DELETE* inventoryDelete );
	SQLRETURN InventoryCooltimeSelect  ( INVENTORY_COOLTIME_SELECT* inventoryCooltimeSelect, u_long& cbLength );
	SQLRETURN InventoryCooltimeInsert  ( INVENTORY_COOLTIME_INSERT* inventoryCooltimeInsert );
	SQLRETURN InventoryRemove          ( INVENTORY_REMOVE* inventoryRemove );
	SQLRETURN InventoryUse             ( INVENTORY_USE* inventoryUse );
	SQLRETURN InventorySwap            ( INVENTORY_SWAP* inventorySwap );
	SQLRETURN InventoryMove            ( INVENTORY_MOVE* inventoryMove );
	SQLRETURN InventoryExcept          ( INVENTORY_EXCEPT* inventoryExcept );
	SQLRETURN InventoryMerge           ( INVENTORY_MERGE* inventoryMerge, u_long& cbLength );
	SQLRETURN InventoryDivide          ( INVENTORY_DIVIDE* inventoryDivide );
	SQLRETURN InventoryMove2           ( INVENTORY_MOVE2* inventoryMove2 );
	SQLRETURN InventoryEnhanced        ( INVENTORY_ENHANCED* inventoryEnhanced );
	SQLRETURN InventoryDisjoint        ( INVENTORY_DISJOINT* inventoryDisjoint );
	SQLRETURN InventoryPutCard         ( INVENTORY_PUT_CARD* inventoryPutCard );
	SQLRETURN InventoryChange          ( INVENTORY_CHANGE* inventoryChange );
	SQLRETURN ItemSell                 ( ITEM_SELL* itemSell );
	SQLRETURN ItemBuy                  ( ITEM_BUY* itemBuy );
	SQLRETURN ItemCollect              ( ITEM_COLLECT* itemCollect );
	SQLRETURN ItemGet                  ( ITEM_GET* itemGet );
	SQLRETURN ItemGetQuest             ( ITEM_GET_QUEST* itemGetQuest );
	SQLRETURN ItemUse                  ( ITEM_USE* itemUse );
	SQLRETURN ItemExchange             ( ITEM_EXCHANGE* itemExchange );
	SQLRETURN ItemMix                  ( ITEM_MIX* itemMix );

	// Note
	SQLRETURN NoteSelect               ( NOTE_SELECT* noteSelect, u_long& cbLength );
	SQLRETURN NoteInsert               ( NOTE_INSERT* noteInsert );
	SQLRETURN NoteDelete               ( NOTE_DELETE* noteDelete );
	SQLRETURN GuildNoteInsert          ( GUILDNOTE_INSERT* guildNoteInsert );

	// Friend
	SQLRETURN FriendSelect             ( FRIEND_SELECT* friendSelect, u_long& cbLength );
	SQLRETURN FriendInsert             ( FRIEND_INSERT* friendInsert );
	SQLRETURN FriendUpdate             ( FRIEND_UPDATE* friendUpdate );
	SQLRETURN FriendDelete             ( FRIEND_DELETE* friendDelete );
	
	// ĳ SKILL
	SQLRETURN SkillSelect              ( SKILL_SELECT* skillSelect, u_long& cbLength );
	SQLRETURN SkillInsert              ( SKILL_INSERT* skillInsert );
	SQLRETURN SkillUpdate              ( SKILL_UPDATE* skillUpdate );
	SQLRETURN SkillCoolTime            ( SKILL_COOLTIME* skillCoolTime );

	// ĳ ų ȿ
	SQLRETURN SkillInfluenceSelect     ( SKILL_INFLUENCE_SELECT* influenceSelect, u_long& cbLength );
	SQLRETURN SkillInfluenceDelete     ( SKILL_INFLUENCE_DELETE* influenceDelete );
	SQLRETURN SkillInfluenceInsert     ( SKILL_INFLUENCE_INSERT* influenceInsert );
	// Skill ũƮ
	SQLRETURN TruncateSkillListPc      ( void );
	SQLRETURN SkillListPcInsert        ( void* pPlayerSkillBaseInfo );
	//  ⺻ų ũƮ
	SQLRETURN TruncateDefalultSkill    ( void );
	SQLRETURN DefalultSkillInsert      ( unsigned long jobStep, unsigned long skillIdx, unsigned char race );

	/// Ʈ 
	SQLRETURN TruncateQuestDefine      ( void );
	SQLRETURN TruncateQuestProgress    ( void );

	SQLRETURN InsertQuestDefine        ( void* questDefine );
	
	SQLRETURN QuestInsert              ( QUEST_INSERT* questInsert );
	SQLRETURN QuestInsertByItem        ( QUEST_INSERTBYITEM* questInsert );
	SQLRETURN QuestSelect              ( QUEST_SELECT* questSelect, u_long& cbLength );
	SQLRETURN QuestDelete              ( QUEST_DELETE* questDelete );
	SQLRETURN QuestComplete            ( QUEST_COMPLETE* questComplete );
	SQLRETURN QuestReward              ( QUEST_REWARD* questReward, u_long& cbLength );
	SQLRETURN QuestUpdate              ( QUEST_UPDATE* questUpdate );
	SQLRETURN QuestEndListSelect       ( QUEST_ENDLIST* questEndList, u_long& cbLength );
	SQLRETURN QuestRemove              ( QUEST_REMOVE* questRemove );
	
	// Etc
	SQLRETURN ItemSpreadValue          ( ITEM_SPREAD_VALUE* itemSpreadValue );
	SQLRETURN ItemTarotResult          ( ITEM_TAROT_RESULT* itemTarotResult );

	//  [Ǹ / ]
	SQLRETURN StallSellSearch          ( STALL_SELL_SEARCH* stallSellSearch, u_long& cbLength );
	SQLRETURN StallSellInsert          ( STALL_SELL_INSERT* stallSellInsert );
	SQLRETURN StallSellRemove          ( STALL_SELL_REMOVE* stallSellRemove );
	SQLRETURN StallSellClear           ( STALL_SELL_CLEAR* stallSellClear );
	SQLRETURN StallSellGet             ( STALL_SELL_GET* stallSellGet );

	// ţ
	SQLRETURN ShortcutSelect           ( SHORTCUT_SELECT* shortcutSelect );
	SQLRETURN ShortcutUpdate           ( SHORTCUT_UPDATE* shortcutUpdate );

	/// ȣĪ
	SQLRETURN TitleInsert			   ( TITLE_INSERT* titleInsert );
	SQLRETURN TitleSelect			   ( TITLE_SELECT* titleSelect, u_long& cbLength );

	/// 
	SQLRETURN VerifyGuild			   ( VERIFY_GUILD* verifyGuild );
	SQLRETURN GuildSelect			   ( GUILD_SELECT* guildSelect );
	SQLRETURN GuildUserSelect		   ( GUILDUSER_SELECT* guildUserSelect, u_long& cbLength );

	SQLRETURN GuildCreate			   ( GUILD_CREATE* guildCreate );
	SQLRETURN GuildDelete			   ( GUILD_DELETE* guildDelete );
	SQLRETURN GuildUpdate			   ( GUILD_UPDATE* guildUpdate );
	SQLRETURN GuildUserAdd			   ( GUILDUSER_ADD* guildUserAdd );
	SQLRETURN GuildUserOut			   ( GUILDUSER_OUT* guildUserOut );
	SQLRETURN GuildUserGivePosition	   ( GUILDUSER_GIVEPOSITION* guildUserGivePosition );
	SQLRETURN GuildMarkUpdate		   ( GUILDMARK_UPDATE* guildMarkUpdate );

	/// 
	SQLRETURN MakeSkillInsert          ( MAKESKILL_INSERT* pInsert );
	SQLRETURN MakeSkillSelect          ( MAKESKILL_SELECT* pSelect, u_long& cbLength );
	SQLRETURN MakeSkillDelete          ( MAKESKILL_DELETE* pDelete );
	SQLRETURN RecipeInsert             ( RECIPE_INSERT* pInsert );
	SQLRETURN RecipeGroupInsert        ( RECIPE_GROUP_INSERT* pRecipeGroup );
	SQLRETURN RecipeCoolTime           ( RECIPE_COOLTIME* recipeCoolTime );

	/// NPC  
	SQLRETURN FortuneSelect			   ( FORTUNE_SELECT* fortuneSelect );
	SQLRETURN FortuneUpdate			   ( FORTUNE_UPDATE* fortuneUpdate );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSQLGameStmt(void);
};

inline SQLRETURN cSQLGameStmt::SQLClose(SQLRETURN sqlReturn, SQLHSTMT sqlHStmt)
{
	if ( SQL_SUCCEEDED( sqlReturn ) )
	{
		while ( SQLMoreResults( sqlHStmt ) == SQL_SUCCESS );	// ν  .
		SQLCloseCursor( sqlHStmt );								// ִ  ݱ.
	}
	return sqlReturn;
}
inline void cSQLGameStmt::SQLClose(SQLHSTMT sqlHStmt)
{
	while ( SQLMoreResults( sqlHStmt ) == SQL_SUCCESS );		// ν  .
	SQLCloseCursor( sqlHStmt );									// ִ  ݱ.
}

// SQLGetFullInv Method
inline void cSQLGameStmt::SQLGetFullInv(SQLHSTMT sqlHStmt, TB_INVENTORY* table)
{
	SQLINTEGER  strLenOrInd;
	SQLSMALLINT param;

	SQLGetData( sqlHStmt, param=1, SQL_C_SLONG,   &table->idx,             0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->itemDefineIdx,   0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->itemDefineIndex, 0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SSHORT,  &table->number,          0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SSHORT,  &table->count,           0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_TINYINT, &table->enhanced,        0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot1,       0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot2,       0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot3,       0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot4,       0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot5,       0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_TINYINT, &table->seal,            0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_TINYINT, &table->apply,           0, &(strLenOrInd=0) );
}

// SQLGetBaseInv Method
inline void cSQLGameStmt::SQLGetBaseInv(SQLHSTMT sqlHStmt, TB_INVENTORY* table)
{
	SQLINTEGER  strLenOrInd;
	SQLSMALLINT param;

	SQLGetData( sqlHStmt, param=1, SQL_C_SLONG,   &table->idx,             0, &(strLenOrInd=0) );
//	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->itemDefineIdx,   0, &(strLenOrInd=0) ); SKIP
	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->itemDefineIndex, 0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SSHORT,  &table->number,          0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_SSHORT,  &table->count,           0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_TINYINT, &table->enhanced,        0, &(strLenOrInd=0) );
//	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot1,       0, &(strLenOrInd=0) ); SKIP
//	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot2,       0, &(strLenOrInd=0) ); SKIP
//	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot3,       0, &(strLenOrInd=0) ); SKIP
//	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot4,       0, &(strLenOrInd=0) ); SKIP
//	SQLGetData( sqlHStmt, ++param, SQL_C_SLONG,   &table->cardSlot5,       0, &(strLenOrInd=0) ); SKIP
	SQLGetData( sqlHStmt, ++param, SQL_C_TINYINT, &table->seal,            0, &(strLenOrInd=0) );
	SQLGetData( sqlHStmt, ++param, SQL_C_TINYINT, &table->apply,           0, &(strLenOrInd=0) );
}

#endif // __SQL_GAME_STATEMENT_H__
