/* ====================================================================
 *      :	Sender.h
 *      :	
 *    :	ö
 *    :	Created 02/13/07
 * ǻ :	
 * =================================================================== */
#ifndef __SENDER_H__
#define __SENDER_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "iocpudpsend.h"

#include "packet.h"
#include "serverProtocol.h"
#include "logprotocol.h"

class cSender :
	public cIocpUdpSend
{
private:
	SOCKADDR_IN mLogin;
	SOCKADDR_IN mGame;
	SOCKADDR_IN mLog;

public:
// Ŭ    ޼ҵ.
	cSender(void);

	bool    Initialize         ( char* addr, unsigned short numWorkerThreads=2 );
	void    Shutdown           ( DWORD maxWait=INFINITE );

	MSGBUF* GetPacket          ( void** handle, char tos, char protocol, SOCKADDR_IN addr );
	bool    SendPacket         ( void* handle, unsigned long length );
	void    GetRegisterDate    ( TIMESTAMP_STRUCT* ts );

public:
// Log  ޼ҵ.
	bool    PostServerEvent    ( char* message );
	bool    PostMemberEvent    ( char type, char category, long memberIdx, char* message );
	bool    PostCharacterEvent ( char category, long memberIdx, long serverIdx, long characterIdx, char* message );
	bool    PostMoneyEvent     ( long serverIdx, long characterIdx, long before, long after, char* message );
	bool    PostDepositEvent   ( long serverIdx, long characterIdx, long before, long after, char* message );
	bool    PostInventoryEvent ( long serverIdx, char category, long inventoryIdx, long characterIdx, long itemDefineIndex, short number, short count, BYTE enhanced, BYTE seal, char* message );
	bool    PostQuestEvent     ( long serverIdx, char category, long characterIdx, long questIdx, char* message );
	bool	PostGuildEvent	   ( long serverIdx, long characterIdx, long guildIdx, char guildPosition, char* message );

public:
// Login  ޼ҵ.
	bool    PostChStatus       ( long cid, BYTE status );

public:
// Game  ޼ҵ.
	bool    PostServerNotice   ( long cid, wchar_t* message );
	bool    PostChatShout      ( long cid, unsigned short numOfMap, long characterIdx, wchar_t* name, wchar_t* message );
	bool    PostPVPStatus      ( long cid, BYTE status );
	bool    PostPVPNotice      ( long cid, unsigned char leftMinute );
	bool    PostGuildSync      ( long cid, char* msg, int len );
	bool    PostGuildConnectSync ( long cid );
	bool	PostMonsterSync    ( long cid, char* msg, int len );
	bool	PostChatSync	   ( long cid, char* msg, int len );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSender(void);
};

#endif // __SENDER_H__
