#include "StdAfx.h"
#include "ShortcutScript.h"
#include "Tokenizer.h"

cShortCutScript* cShortCutScript::mpSingleton = 0;

cShortCutScript::cShortCutScript()
{
	mpSingleton = this;

	memset( mShortCut, 0, sizeof(mShortCut) );
}

cShortCutScript::~cShortCutScript()
{
}

bool cShortCutScript::Init()
{
	if( LoadShortCutScript( "./Script/Resource/Default_QuickSlot.txt" ) == false )
	{
		assert( 0 && "failed to load default shortcut script" );
		return false;
	}
	return true;
}

bool cShortCutScript::LoadShortCutScript( const cString& pathName )
{
	cFileLoader loader;

	if( loader.Open( pathName, true ) == false )
	{
		assert( 0 && "failed to load LoadShortCutScript" );
		return false;
	}

	cTokenizer tokenizer( loader.GetBufferPtr(), loader.GetSize(), " \t\r\n", pathName.Cstr() );
	cString str;

	while( tokenizer.IsEnd() == false )
	{
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long idx = (unsigned long)str.ToInt();

		/// Ű
		if( tokenizer.GetNext( &str ) == false )
			return false;

		///  Ÿ
		if( tokenizer.GetNext( &str ) == false )
			return false;

		char type = (char)str.ToInt();

		/// ųε
		if( tokenizer.GetNext( &str ) == false )
			return false;

		unsigned long skillIdx = (unsigned long)str.ToInt();
	
		char shortcutType = eSHORTCUT_NONE;
		switch( type )
		{
		case 1: shortcutType = eSHORTCUT_COMMU;	break; /// Ŀ´Ƽų
		case 2: shortcutType = eSHORTCUT_SKILL;	break; /// Ϲ ų
		default: assert(0);						break;
		}

		mShortCut[idx].mType  = shortcutType;
		mShortCut[idx].mIndex = skillIdx;
		mShortCut[idx].mInventoryIdx = 0;
	}
	return true;
}