/*-- Include
*/
#include "httpdownloader.h"

/*-- Global data
*/
extern HINSTANCE g_instance;
Loader           g_classDesc;

/*-- Prototype
*/
ClassDesc* GetClassDesc( ) { return &g_classDesc; }

/*-- Loader Constructor
*/
Loader::Loader(void)
: m_internet( NULL ),
m_session( NULL ),
m_port( 80 )
{
}

/*-- Loader Destructor
*/
Loader::~Loader(void)
{
	Close( );
}

/*-- Open Method - ͳ  - HTTP 
*/
DWORD Loader::Open(char* url, unsigned int port)
{
	Close( );

	try {
		m_internet = InternetOpen( NULL, INTERNET_OPEN_TYPE_DIRECT, NULL, 0, INTERNET_FLAG_NO_CACHE_WRITE );
		if ( m_internet == NULL )
			throw GetLastError( );
		if( port != 0)
			m_session = InternetConnect( m_internet, url, port, NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0 );
		else
			m_session = InternetConnect( m_internet, url, INTERNET_DEFAULT_HTTP_PORT, NULL, NULL, INTERNET_SERVICE_HTTP, 0, 0 );

		if ( m_session == NULL )
			throw GetLastError( );

		strcpy( m_url, url );
		m_port = (port == 0) ? 80 : port ;
		return 0;
	} catch ( DWORD error ) {
		Close( );
		return error;
	}
}

/*-- Close Method
*/
void Loader::Close( )
{
	if ( m_session != NULL )
	{
		InternetCloseHandle( m_session );
		m_session = NULL;
	}
	if ( m_internet != NULL )
	{
		InternetCloseHandle( m_internet );
		m_internet = NULL;
	}
}

/*-- Get Method
*/
DWORD Loader::Get(char* url, LOADER_PROGRESS_ROUTINE routine, DWORD* exitCode, void* data, char** buffer, DWORD* bufferLen)
{
	HINTERNET request = NULL;
	DWORD     retcode = 0;

	Open( m_url, m_port );

	try {
		// HTTP  Request ڵ  - URL .
		request = HttpOpenRequest( m_session, "GET", url, HTTP_VERSION, NULL, NULL, INTERNET_FLAG_KEEP_CONNECTION | INTERNET_FLAG_NEED_FILE, 0 );
		if ( request == NULL )
			throw GetLastError( );

		// HTTP  û .
		if ( HttpSendRequest( request, "", 0, 0, 0 ) == FALSE )
			throw GetLastError( );

		char  query[ 32 ];
		memset( query, 0, sizeof(query) );
		DWORD cbLengthQuery = sizeof(query);

		// HTTP   ũ ޱ.
		if ( HttpQueryInfo( request, HTTP_QUERY_CONTENT_LENGTH, query, &cbLengthQuery, NULL ) == FALSE )
			throw GetLastError( );

		// ޸ Ҵ   ʱȭ.
		DWORD offset = 0;

		(*bufferLen) = (DWORD)atol( query );
		(*buffer)    = (char*)GlobalAlloc( GPTR, (*bufferLen)+1 );

		if ( (*buffer) == NULL )
			throw GetLastError( );

		DWORD numOfByteAvaiable   = 0;
		DWORD cbNumOfByteAvaiable = 0;
		char* ptr                 = (*buffer);

		(*exitCode) = LPR_CONTINUE;
		do {
			//   غ  ũ.`
			if ( InternetQueryDataAvailable( request, &numOfByteAvaiable, 0, 0 ) == FALSE )
				throw GetLastError( );

			//   ޱ.
			if ( InternetReadFile( request, ptr, numOfByteAvaiable, &cbNumOfByteAvaiable ) == FALSE )
				throw GetLastError( );

			//    .
			offset += cbNumOfByteAvaiable;
			ptr    += cbNumOfByteAvaiable;

			if ( routine != NULL && (*exitCode) == LPR_CONTINUE )
				(*exitCode) = (*routine)( (*bufferLen), offset, data );

		} while ( offset < (*bufferLen) && (*exitCode) == LPR_CONTINUE );
	} catch ( DWORD error ) {
		retcode = error;
	}

	if ( request != NULL )
	{
		InternetCloseHandle( request );
		request = NULL;
	}

	Close();

	return retcode;
}
