/**********************************************************************
 *<
	FILE: launcher.h

	DESCRIPTION:
		HINTERNET
		Header:  Declared in wininet.h
		Library: Use wininet.lib

	CREATED BY: Kwak CJ

	HISTORY: Created 08/11/14

 *>	Copyright (c) 2008, All Rights Reserved.
 **********************************************************************/
#ifndef __LAUNCHER_H__
#define __LAUNCHER_H__

#ifndef WINVER
#define WINVER          0x0500
#endif

#ifndef _WIN32_WINNT
#define _WIN32_WINNT    0x0500
#endif

#ifndef _WIN32_IE
#define _WIN32_IE		0x0600
#endif

#pragma once

#include <windows.h>        //  
#include <commctrl.h>

#include "zlib.h"
#include "httpdownloader.h"
#include "resource.h"

struct Packfile
{
	char directory[ 1024 ];			// 丮
};

struct Packlist
{
	Packfile* pack;
	ULONG     offset;				// 
	ULONG     length;				// ü
};

struct Patchfile
{
	char     fileName[ 1024 ];		// ̸
	DWORD    sizeHigh;				// ũ
	DWORD    sizeLow;				// ũ
	FILETIME writeTime;				// ϳ¥
};

struct Patchlist
{
	Patchfile* file;				// Ʈ  ü
	ULONG      offset;				// 
	ULONG      length;				// ü
};

class Launcher
{
private:
	HWND       m_wnd;
	HICON      m_icon;
	TCHAR*     m_windowName;
	bool       m_endApp;
	bool       m_endIO;
	bool       m_runApp;
	char       m_currentDirectory[ MAX_PATH ];

	ClassDesc* m_libClassDesc;

	Packlist   m_packlist;
	Patchlist  m_patchlist;

	HANDLE     m_workerThread;

private:
	void        FileTimeToUTC  ( FILETIME* filetime );
	void        FileTimeToDOS  ( FILETIME* filetime );

	bool        MakeList       ( char* buffer );
	bool        VerifyFile     ( Patchfile* patchfile );
	bool        UpdateFile     ( Patchfile* patchfile, char* buffer, DWORD bufferLen );
	bool        UnpackPatchList( char** buffer, DWORD *bufferLen );

public:
	Launcher(void);

	int        Run            ( HINSTANCE instance, HINSTANCE prevInstance, LPSTR cmdLine, int cmdShow );
	LRESULT    MsgProc        ( HWND wnd, UINT msg, WPARAM wParam, LPARAM lParam );

	HWND       GetHwnd        ( ) { return m_wnd; }
	TCHAR*     GetWindowName  ( ) { return m_windowName; }

	BOOL       SetStatus      ( HWND wnd, char* msg );

	DWORD      LoaderProgress ( DWORD totalFileSize, DWORD totalBytesTransferred, void* data );
	DWORD      WorkerThread   ( );

private:
	LRESULT    Destroy        ( HWND wnd, WPARAM wParam, LPARAM lParam );
	LRESULT    InitDialog     ( HWND wnd, WPARAM wParam, LPARAM lParam );
	LRESULT    Command        ( HWND wnd, WPARAM wParam, LPARAM lParam );
	LRESULT    UpdateMsg      ( HWND wnd, WPARAM wParam, LPARAM lParam );

public:
	virtual ~Launcher(void);

public:
	static DWORD WINAPI LoaderProgressRoutine( DWORD totalFileSize, DWORD totalBytesTransferred, void* data );
};

#endif // __LAUNCHER_H__
