// Include
#include "logdemon.h"

// Local definitions
// memory ϰ 
#define SafeDelete(P) if (P!=NULL) { delete(P); (P)=NULL; }

// Global data

// cSQLLog Constructor.
cSQLLog::cSQLLog(void)
{
}

// ~cSQLLog Destructor.
cSQLLog::~cSQLLog(void)
{
}

// Initialize Method
bool cSQLLog::Initialize(char* dsn, char* uid, char* pwd, int numWorkerThreads)
{
	return cSQLPool::Initialize( dsn, uid, pwd, numWorkerThreads );
}

// AllocSQLConnection Method
PerSQLConnection* cSQLLog::AllocSQLConnection(void)
{
	PerSQLConnection* perSQLConnection = (PerSQLConnection*)GlobalAlloc( GPTR, sizeof(PerSQLConnection) );

	if ( perSQLConnection != NULL )
	{
		// PerSQLConnection - ʱȭ.
		perSQLConnection->sqlConnection = new cSQLConnection( );  // 1. SQLConnection .
		perSQLConnection->sqlStatement  = new cSQLLogStmt( );     // 2. cSQLLogStmt   .
		perSQLConnection->prev          = NULL;                   // Ʈ  - .
		perSQLConnection->next          = NULL;                   // Ʈ  - .

		// Ŭ  Ȯ.
		if ( perSQLConnection->sqlConnection != NULL && perSQLConnection->sqlStatement != NULL )
		{
			// SQLEnvironment Ŭ Ͽ ڵ .
			if ( perSQLConnection->sqlConnection->AllocDbc( mSqlEnv ) == true )
			{
				// DBC .
				if ( perSQLConnection->sqlConnection->Connect( (SQLCHAR*)mDsn, (SQLCHAR*)mUid, (SQLCHAR*)mPwd ) == true )
				{
					// SQLConnectionŬ Ͽ ڵ .
					if ( perSQLConnection->sqlStatement->AllocStmt( perSQLConnection->sqlConnection ) == true )
					{
						// mWorkingSetSize .
						mWorkingSetSize++;
						return perSQLConnection;
					}
				}
			}
		}
	}

	FreeSQLConnection( &perSQLConnection );
	return perSQLConnection;
}

// WorkerThread Method
DWORD cSQLLog::WorkerThread(void)
{
	PerSQLConnection* perSQLConnection = NULL;
	cSQLLogStmt*      sqlLogStmt       = NULL;
	SQLRETURN         sqlReturn;

	PerIoContext*     perIoContext     = NULL;
	BOOL              retValue;

	DWORD             bytesTransfered;
	ULONG_PTR         completionKey;
	OVERLAPPED*       overlapped;

	while ( true )
	{
		//  I/O .
		retValue = GetQueuedCompletionStatus( mRequestQueue, &bytesTransfered, &completionKey, &overlapped, INFINITE );

		// Shutdown.
		if ( overlapped == POOL_SHUTDOWN )
			break;

		// Error - .
		if ( retValue == FALSE || bytesTransfered == 0 ) 
			continue;

		// SQLConnection - .
		perSQLConnection = GetPool( );

		// SQLConnection - Ȯ.
		if ( perSQLConnection == NULL )
		{
			// 1( ), ð 50/1000(s) - CPU ȭ  .
			Sleep( 50 );

			// 2( ),   Ǿ , ٽ õ.
			QueueRequest( completionKey, overlapped, bytesTransfered );
			continue;
		}

		// cSQLLogStmt SQLAccountStmt ĳ.
		sqlLogStmt = (cSQLLogStmt*)perSQLConnection->sqlStatement;

		// OVERLAPPED PerIoContext ɽ.
		perIoContext = (PerIoContext*)overlapped;

		// 1. SQL 
		switch ( perIoContext->iParam )
		{
		case SQL_LOG_SERVER_EVENT:
			sqlReturn = sqlLogStmt->ServerEvent( (SERVER_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_MEMBER_EVENT:
			sqlReturn = sqlLogStmt->MemberEvent( (MEMBER_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_CHARACTER_EVENT:
			sqlReturn = sqlLogStmt->CharacterEvent( (CHARACTER_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_MONEY_EVENT:
			sqlReturn = sqlLogStmt->MoneyEvent( (MONEY_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_DEPOSIT_EVENT:
			sqlReturn = sqlLogStmt->DepositEvent( (DEPOSIT_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_INVENTORY_EVENT:
			sqlReturn = sqlLogStmt->InventoryEvent( (INVENTORY_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_CONCURRENT_EVENT:
			sqlReturn = sqlLogStmt->ConcurrentEvent( (CONCURRENT_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_QUEST_EVENT:
			sqlReturn = sqlLogStmt->QuestEvent( (QUEST_EVENT*)perIoContext->buffer );
			break;
		case SQL_LOG_GUILD_EVENT:
			sqlReturn = sqlLogStmt->GuildEvent( (GUILD_EVENT*)perIoContext->buffer );
			break;
		}

		// 2. ̺Ʈ -  .
		if ( !SQL_SUCCEEDED( sqlReturn ) )
		{
			SQLCHAR     sqlstate[ SQL_SQLSTATE_SIZE + 1 ]     = "\0";
			SQLINTEGER  nativeErrorPtr                        = 0;
			SQLCHAR     messageText[ SQL_MAX_MESSAGE_LENGTH ] = "\0";
			SQLSMALLINT bufferLength                          = SQL_MAX_MESSAGE_LENGTH;
			SQLSMALLINT textLength                            = 0;
			SQLRETURN   result;

			result = SQLGetDiagRec( SQL_HANDLE_STMT,
									sqlLogStmt->GetSqlStmt( ),
									1,					// [IN ] Status records are numbered from 1.
									sqlstate,			// [OUT] SQL Error State string
									&nativeErrorPtr,	// [OUT] Native Error code
									messageText,		// [OUT] SQL Error Text string
									bufferLength,		// [IN ] Length of the *MessageText buffer in characters.
									&textLength );

			// ϱ.
			SYSTEMTIME st;
			char       buf[MAX_PATH];

			GetLocalTime( &st );
			sprintf( buf, "L%04d%02d%02d.log", st.wYear, st.wMonth, st.wDay );

			FILE* stream = fopen( buf, "at" );
			if ( stream != NULL )
			{
				fprintf( stream,
						 "%04d-%02d-%02d %02d:%02d:%02d cSQLLog::lParam[%d]:Returns[%d] - SQL Error State string[%s] - Native Error code[%d] - SQL Error Text string[%s]",
						 st.wYear,
						 st.wMonth,
						 st.wDay,
						 st.wHour,
						 st.wMinute,
						 st.wSecond,
						 perIoContext->iParam,
						 sqlReturn,
						 sqlstate,
						 nativeErrorPtr,
						 messageText );
				fclose( stream );
			}
		}

		// 3. PerIoContext Ϸ -  ݹ ǵش.
		// perIoContext->requestType   = IOCP_REQUEST_CALLBACK;
		// perIoContext->requestResult = IOCP_REQUEST_SUCCESS;
		cLogRecver* logRecver = g_logDemon->GetLogRecver( );
		if ( logRecver != NULL )
		{
			perIoContext->requestResult = (sqlReturn == SQL_SUCCESS ? IOCP_REQUEST_SUCCESS : IOCP_REQUEST_ERROR );
			logRecver->QueueRequest( completionKey, (OVERLAPPED*)perIoContext, perIoContext->offset );
		}

		// SQLConnection - .
		ReleasePool( perSQLConnection, !(sqlReturn == SQL_SUCCESS || sqlReturn == SQL_SUCCESS_WITH_INFO) );
	}
	return 0L;
}
