// Include
#include "sqllogstmt.h"

// Local definitions

// Global data

// cSQLLogStmt Constructor.
cSQLLogStmt::cSQLLogStmt(void)
{
}

// ~cSQLLogStmt Destructor.
cSQLLogStmt::~cSQLLogStmt(void)
{
}

// ServerEvent Method.
//	GP_SERVER_EVENT.SQL .
SQLRETURN cSQLLogStmt::ServerEvent(SERVER_EVENT* serverEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SERVER_EVENT(?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       sourceLen   = (long)strlen( serverEvent->source );
	long       cbSource    = SQL_NTS;

	long       messageLen  = (long)strlen( serverEvent->message );
	long       cbMessage   = SQL_LEN_DATA_AT_EXEC(messageLen);

	void*      parmID;
	long       cbBatch     = (long)strlen( serverEvent->message );

	long       computerLen = (long)strlen( serverEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &serverEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        50,                0, &serverEvent->source,       sourceLen,   &cbSource        );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                   0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &serverEvent->computer,     computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	retcode = SQLParamData( mHstmt, &parmID );
	if ( retcode == SQL_NEED_DATA )
	{
		while ( messageLen > cbBatch )
		{
			SQLPutData( mHstmt, serverEvent->message, cbBatch );
			messageLen -= cbBatch;
		}
		// Put final batch.
		SQLPutData( mHstmt, serverEvent->message, messageLen ); 
	}

	// Make final SQLParamData call.
	retcode = SQLParamData( mHstmt, &parmID );

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

// ServerEvent Method.
//	GP_MEMBER_EVENT.SQL .
//   @TYPE          [varchar](50)  --
//   @SOURCE        [varchar](50)  --
//   @CATEGORY      [varchar](50)  --
//   @MEMBER_IDX    [int],         --ȸ ȣ
//   @MESSAGE       [varchar](200) --޽
//   @COMPUTER      [varchar](132) --ǻ
SQLRETURN cSQLLogStmt::MemberEvent(MEMBER_EVENT* memberEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_MEMBER_EVENT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLCHAR* type = NULL;

	switch ( memberEvent->type )
	{
	case EVENT_MEMBER_SUCCESS_AUDIT:
		type = (SQLCHAR*)"Success Audit";
		break;
	case EVENT_MEMBER_FAILURE_AUDIT:
		type = (SQLCHAR*)"Failure Audit";
		break;
	case EVENT_MEMBER_TIMEOUT:
		type = (SQLCHAR*)"Timeout";
		break;
	default:
		type = (SQLCHAR*)"Unknown";
		break;
	}

	SQLCHAR* category = NULL;

	switch ( memberEvent->category )
	{
	case EVENT_MEMBER_LOGIN:
		category = (SQLCHAR*)"Login";
		break;
	case EVENT_MEMBER_LOGOUT:
		category = (SQLCHAR*)"Logout";
		break;
	default:
		category = (SQLCHAR*)"Unknown";
		break;
	}

	long       typeLen     = (long)strlen( (char*)type );
	long       cbType      = SQL_NTS;

	long       sourceLen   = (long)strlen( memberEvent->source );
	long       cbSource    = SQL_NTS;

	long       categoryLen = (long)strlen( (char*)category );
	long       cbCategory  = SQL_NTS;

	long       messageLen  = (long)strlen( memberEvent->message );
	long       cbMessage   = SQL_LEN_DATA_AT_EXEC(messageLen);

	void*      parmID;
	long       cbBatch     = (long)strlen( memberEvent->message );

	long       computerLen = (long)strlen( memberEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &memberEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        50,                0, type,                       typeLen,     &cbType          );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        50,                0, memberEvent->source,        sourceLen,   &cbSource        );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        50,                0, category,                   categoryLen, &cbCategory      );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_SLONG,          SQL_INTEGER,        0,                 0, &memberEvent->memberIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                   0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &memberEvent->computer,     computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	retcode = SQLParamData( mHstmt, &parmID );
	if ( retcode == SQL_NEED_DATA )
	{
		while ( messageLen > cbBatch )
		{
			SQLPutData( mHstmt, memberEvent->message, cbBatch );
			messageLen -= cbBatch;
		}
		// Put final batch.
		SQLPutData( mHstmt, memberEvent->message, messageLen ); 
	}

	// Make final SQLParamData call.
	retcode = SQLParamData( mHstmt, &parmID );

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

// CharacterEvent Method.
SQLRETURN cSQLLogStmt::CharacterEvent(CHARACTER_EVENT* characterEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHARACTER_EVENT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLCHAR*   category    = NULL;

	switch ( characterEvent->category )
	{
	case EVENT_CHARACTER_CREATE:  category = (SQLCHAR*)"Create"; break;
	case EVENT_CHARACTER_DELETE:  category = (SQLCHAR*)"Delete"; break;
	case EVENT_CHARACTER_UPDATE:  category = (SQLCHAR*)"Update"; break;
	default: category = (SQLCHAR*)"Unknow"; break;
	}

	long       categoryLen = (long)strlen( (char*)category );
	long       cbCategory  = SQL_NTS;

	long       messageLen  = (long)strlen( characterEvent->message );
	long       cbMessage   = SQL_LEN_DATA_AT_EXEC(messageLen);

	void*      parmID;
	long       cbBatch     = (long)strlen( characterEvent->message );

	long       computerLen = (long)strlen( characterEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &characterEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        50,                0, category,                      categoryLen, &cbCategory      );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_SLONG,          SQL_INTEGER,        0,                 0, &characterEvent->memberIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_SLONG,          SQL_INTEGER,        0,                 0, &characterEvent->serverIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_SLONG,          SQL_INTEGER,        0,                 0, &characterEvent->characterIdx, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                      0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, characterEvent->computer,      computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	retcode = SQLParamData( mHstmt, &parmID );
	if ( retcode == SQL_NEED_DATA )
	{
		while ( messageLen > cbBatch )
		{
			SQLPutData( mHstmt, characterEvent->message, cbBatch );
			messageLen -= cbBatch;
		}
		// Put final batch.
		SQLPutData( mHstmt, characterEvent->message, messageLen ); 
	}

	// Make final SQLParamData call.
	retcode = SQLParamData( mHstmt, &parmID );

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

// MoneyEvent Method.
//	GP_MONEY_EVENT.SQL .
//   @SERVER_IDX    [int]          --   ȣ(ε)
//	 @CHARACTER_IDX [int]          --ĳ ȣ(ε)
//	 @BEFORE        [int]          -- ݾ
//	 @AFTER         [int]          -- ݾ
//	 @MESSAGE       [text]         --޽
//   @COMPUTER      [varchar](132) --ǻ
SQLRETURN cSQLLogStmt::MoneyEvent(MONEY_EVENT* moneyEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_MONEY_EVENT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       messageLen  = (long)strlen( moneyEvent->message );
	long       cbMessage   = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch     = (long)strlen( moneyEvent->message );

	long       computerLen = (long)strlen( moneyEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &moneyEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &moneyEvent->serverIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &moneyEvent->characterIdx, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &moneyEvent->before,       0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &moneyEvent->after,        0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                  0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &moneyEvent->computer,     computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, moneyEvent->message, cbBatch );
				messageLen -= cbBatch;
			} while ( messageLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, moneyEvent->message, messageLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}
	}

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

// DepositEvent Method.
//	GP_DEPOSIT_EVENT.SQL .
SQLRETURN cSQLLogStmt::DepositEvent(DEPOSIT_EVENT* depositEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_DEPOSIT_EVENT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       messageLen  = (long)strlen( depositEvent->message );
	long       cbMessage   = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch     = (long)strlen( depositEvent->message );

	long       computerLen = (long)strlen( depositEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &depositEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &depositEvent->serverIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &depositEvent->characterIdx, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &depositEvent->before,       0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &depositEvent->after,        0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                    0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &depositEvent->computer,     computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, depositEvent->message, cbBatch );
				messageLen -= cbBatch;
			} while ( messageLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, depositEvent->message, messageLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}
	}

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

// InventoryEvent Method.
//	GP_INVENTORY_EVENT.SQL .
SQLRETURN cSQLLogStmt::InventoryEvent(INVENTORY_EVENT* inventoryEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_INVENTORY_EVENT(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLCHAR*   category    = NULL;

	switch ( inventoryEvent->category )
	{
	case EVENT_INVENTORY_CREATE: category = (SQLCHAR*)"Create"; break;
	case EVENT_INVENTORY_DELETE: category = (SQLCHAR*)"Delete"; break;
	case EVENT_INVENTORY_UPDATE: category = (SQLCHAR*)"Update"; break;
	}
	long       categoryLen = (long)strlen( (char*)category );
	long       cbCategory  = SQL_NTS;

	long       messageLen  = (long)strlen( inventoryEvent->message );
	long       cbMessage   = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch     = (long)strlen( inventoryEvent->message );

	long       computerLen = (long)strlen( inventoryEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1,  SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &inventoryEvent->registerDate,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2,  SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &inventoryEvent->serverIdx,       0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3,  SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        50,                0, category,                         categoryLen, &cbCategory      );
	retcode = SQLBindParameter( mHstmt, 4,  SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &inventoryEvent->inventoryIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5,  SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &inventoryEvent->characterIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6,  SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &inventoryEvent->itemDefineIndex, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 7,  SQL_PARAM_INPUT, SQL_C_SHORT,          SQL_SMALLINT,       0,                 0, &inventoryEvent->count,           0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 8,  SQL_PARAM_INPUT, SQL_C_TINYINT,        SQL_TINYINT,        0,                 0, &inventoryEvent->enhanced,        0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 9,  SQL_PARAM_INPUT, SQL_C_TINYINT,        SQL_TINYINT,        0,                 0, &inventoryEvent->seal,            0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 10, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                         0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 11, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &inventoryEvent->computer,        computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, inventoryEvent->message, cbBatch );
				messageLen -= cbBatch;
			} while ( messageLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, inventoryEvent->message, messageLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}
	}

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

// ConcurrentEvent Method.
//	GP_CONCURRENT_EVENT.SQL .
SQLRETURN cSQLLogStmt::ConcurrentEvent(CONCURRENT_EVENT* concurrentEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CONCURRENT_EVENT(?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	long       messageLen  = (long)strlen( concurrentEvent->message );
	long       cbMessage   = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch     = (long)strlen( concurrentEvent->message );

	long       computerLen = (long)strlen( concurrentEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &concurrentEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &concurrentEvent->serverIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &concurrentEvent->minimum,      0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &concurrentEvent->maximum,      0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                       0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &concurrentEvent->computer,     computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, concurrentEvent->message, cbBatch );
				messageLen -= cbBatch;
			} while ( messageLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, concurrentEvent->message, messageLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}
	}

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

SQLRETURN cSQLLogStmt::GuildEvent(GUILD_EVENT* guildEvent)
{
	SQLCHAR*	statement = (SQLCHAR*)"{call GP_GUILD_EVENT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER  strLenOrInd;
	SQLRETURN   retcode;

	SQLCHAR*   category = NULL;
	
	long       messageLen  = (long)strlen( guildEvent->message );
	long       cbMessage   = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch     = (long)strlen( guildEvent->message );

	long       computerLen = (long)strlen( guildEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &guildEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &guildEvent->serverIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &guildEvent->characterIdx, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &guildEvent->guildIdx,     0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_TINYINT,        SQL_TINYINT,        0,                 0, &guildEvent->guildPosition,0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                  0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &guildEvent->computer,     computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, guildEvent->message, cbBatch );
				messageLen -= cbBatch;
			} while ( messageLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, guildEvent->message, messageLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}
	}

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}

// QuestEvent Method.
//	GP_QUEST_EVENT.SQL .
SQLRETURN cSQLLogStmt::QuestEvent(QUEST_EVENT* questEvent)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_QUEST_EVENT(?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	SQLCHAR*   category = NULL;
	switch ( questEvent->category )
	{
	case EVENT_QUEST_ADD:
		category = (SQLCHAR*)"Add";
		break;
	case EVENT_QUEST_UPDATE:
		category = (SQLCHAR*)"Update";
		break;
	case EVENT_QUEST_DELETE:
		category = (SQLCHAR*)"Delete";
		break;
	case EVENT_QUEST_COMPLETE:
		category = (SQLCHAR*)"Complete";
		break;
	case EVENT_QUEST_REWARD:
		category = (SQLCHAR*)"Reward";
		break;
	case EVENT_QUEST_REMOVE:
		category = (SQLCHAR*)"Remove";
		break;
	case EVENT_QUEST_TIMESELECT:
		category = (SQLCHAR*)"Timeselect";
		break;
	default:
		category = (SQLCHAR*)"Unknown";
		break;
	}
	long       categoryLen = (long)strlen( (char*)category );
	long       cbCategory  = SQL_NTS;

	long       messageLen  = (long)strlen( questEvent->message );
	long       cbMessage   = SQL_DATA_AT_EXEC;

	void*      parmID;
	long       cbBatch     = (long)strlen( questEvent->message );

	long       computerLen = (long)strlen( questEvent->computer );
	long       cbComputer  = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, 1, SQL_PARAM_INPUT, SQL_C_TYPE_TIMESTAMP, SQL_TYPE_TIMESTAMP, SQL_TIMESTAMP_LEN, 0, &questEvent->registerDate, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 2, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &questEvent->serverIdx,    0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 3, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        50,                0, category,                  categoryLen, &cbCategory      );
	retcode = SQLBindParameter( mHstmt, 4, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &questEvent->characterIdx, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 5, SQL_PARAM_INPUT, SQL_C_LONG,           SQL_INTEGER,        0,                 0, &questEvent->questIdx,     0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, 6, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_LONGVARCHAR,    messageLen,        0, (VOID*)1,                  0,           &cbMessage       );
	retcode = SQLBindParameter( mHstmt, 7, SQL_PARAM_INPUT, SQL_C_CHAR,           SQL_VARCHAR,        132,               0, &questEvent->computer,     computerLen, &cbComputer      );

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );
	if ( retcode == SQL_NEED_DATA )
	{
		retcode = SQLParamData( mHstmt, &parmID );
		while ( retcode == SQL_NEED_DATA )
		{
			do {
				SQLPutData( mHstmt, questEvent->message, cbBatch );
				messageLen -= cbBatch;
			} while ( messageLen > cbBatch );

			// Put final batch.
			SQLPutData( mHstmt, questEvent->message, messageLen );

			// Make final SQLParamData call.
			retcode = SQLParamData( mHstmt, &parmID );
		}
	}

	// ν  .
	while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

	// ִ  ݱ. (Close the open result set.)
	SQLCloseCursor( mHstmt );

	return retcode;
}
