/* ====================================================================
 *      :	LoginProcess.h
 *      :	
 *    :	ö
 *    :	06/12/22
 * ǻ :	
 * =================================================================== */
#ifndef __LOGIN_PROCESS_H__
#define __LOGIN_PROCESS_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "iocpserver.h"
#include "loginsrvdefines.h"

#include "packet.h"
#include "protocol.h"
#include "commonnetworkmsgstruct.h"
#include "rc5.h"

#include "servermanager.h"


class cLoginProcess :
	public cIocpServer
{
private:
// ȯ溯.
	union
	{
		struct
		{
			bool serverMatrix : 1;
			bool serverTable  : 1;
		} mRequest;
		long mRequestData;
	};
	union
	{
		struct
		{
			bool startLog     : 1; // ۷α
			bool serverMatrix : 1; // Ʈ ˻
			bool serverTable  : 1; // ̺ ε
			bool serverSync   : 1; // ũ
			bool serverSec    : 1; // (0, 1)
		} mComplete;
		long mCompleteData;
	};

	DWORD           mFrame;
	DWORD           mFpsTick;

	bool            mThreadPriority;
	DWORD           mThreadPriorityTick;

	cServerManager* mServerManager;
	SYSTEMTIME      mSystemTime;
	DWORD           mConcurrentUser;

private:
// LOG  ޼ҵ.
	bool     PostServerEvent     ( LPCTSTR format, ... );
	bool     PostConcurrentEvent ( long serverIdx, long minimum, long maximum, LPCTSTR format, ... );
	bool     PostMemberEvent     ( char type, char category, long memberIdx, char* message );

public:
// SQL  ޼ҵ.
	bool     MatrixCreate        ( long maxServer, long maxChannel );
	bool     ServerList          ( );
	bool     ServerDown          ( long serverNum, long channelNum );
	bool     ChannelUpdate       ( long serverNum, long channelNum, BYTE status );
	bool     ConcurrentUser      ( long serverNum );

	bool     MemberLogin         ( PerSocketContext* perSocketContext, char* uid, char* pwd );
	bool     MemberLogout        ( PerSocketContext* perSocketContext, long loginIdx, long memberIdx );
	bool     ComeinGame          ( PerSocketContext* perSocketContext, long loginIdx, short serverNum, short channelNum, short lastChannel );

private:
//   ޼ҵ - .
	bool     LoginSuccess        ( PerSocketContext* perSocketContext, long result, long memberIdx, long loginIdx );
	bool     ServerList          ( PerSocketContext* perSocketContext, ServerTable* serverTable, char category, char protocol );
	bool     ChannelList         ( PerSocketContext* perSocketContext, PerChannel* perChannel, char category, char protocol );
	bool     ComeinGame          ( PerSocketContext* perSocketContext, long ipv4, short port );

private:
//   ޼ҵ - ȣ.
	void     Decrypt             ( BYTE* ptr, RC5_32_KEY key );
	void     Encrypt             ( BYTE* ptr, RC5_32_KEY key );

private:
//   ޼ҵ - .
	bool     BatchComplete       ( PerSocketContext* perSocketContext, void* ptr );
	void     BackendThreadBegin  ( void );
	void     BackendThreadProc   ( void );
	void     BackendThreadEnd    ( void );
	void     BackendThreadFps    ( DWORD currentTick );

private:
//   ޼ҵ - .
	bool     SendExec            ( PerIoContext* perIoContext );
	bool     AcceptComplete      ( PerSocketContext* perSocketContext );
	bool     RecvComplete        ( PerSocketContext* perSocketContext, PerIoContext* perIoContext, DWORD bytesTransferred );
	bool     CallbackComplete    ( PerSocketContext* perSocketContext, PerIoContext* perIoContext, DWORD bytesTransferred );

public:
//   ޼ҵ - äΰ.
	void     ChannelStatus       ( long cid, BYTE status );

public:
// Ŭ    ޼ҵ.
	cLoginProcess(void);

	bool     Initialize          ( char* ipAddr="", unsigned short port=10000, unsigned short numWorkerThreads=2 );
	void     Shutdown            ( DWORD maxWait=INFINITE );

	int      GetServerSec        ( ) { return (mComplete.serverSec == 0) ? 1 : 0; }

	MSGROOT* GetMsgRoot          ( void** handle, PerSocketContext* perSocketContext );
	bool     SendMsgRoot         ( void* handle, unsigned long length );

	bool     SendMsgError        ( PerSocketContext* perSocketContext, char category, char protocol, int result );

	DWORD    BackendThread       ( );

public:
// Ŭ ı ޼ҵ.
	virtual ~cLoginProcess(void);
};

#endif // __LOGIN_PROCESS_H__