// Include
#include "loginsrv.h"

// Local definitions
#pragma warning( disable: 4127 )

// Global data

// cRecver Constructor
cRecver::cRecver(void)
{
	mRecvUdpCount = 0;
	mRecvUdpSize  = 0;
}

// ~cRecver Destructor
cRecver::~cRecver(void)
{
}

// Initialize Method
bool cRecver::Initialize(char* ipAddr, unsigned short port, unsigned short numWorkerThreads)
{
	return IocpUdpRecv::Initialize( ipAddr, port, numWorkerThreads );
}

// Shutdown Method
void cRecver::Shutdown(DWORD maxWait)
{
	Sleep( 50 );
	IocpUdpRecv::Shutdown( maxWait );
}

// PostServerEvent Method
bool cRecver::PostServerEvent(LPCTSTR format, ...)
{
	bool retvalue = false;
	if ( g_loginSrv != NULL )
	{
		LPVOID  msgBuf = NULL;
		DWORD   bufferLength;

		va_list args;

		va_start( args, format );

		bufferLength = _vscprintf( format, args ) + 1;
		msgBuf       = malloc( bufferLength );

		vsprintf( (char*)msgBuf, format, args );

		va_end( args );

		if ( msgBuf != NULL )
		{
			retvalue = g_loginSrv->PostServerEvent( (char*)msgBuf );
			free( msgBuf );
		}
	}
	return retvalue;
}

// BatchComplete Method
bool cRecver::BatchComplete(char* ptr)
{
	cCSLock lock( &m_cs );
	Packet* packet = (Packet*)ptr;

	if ( g_packet == true )
	{
		// Ŷش(Packet Header)   - // /ü.
		printf( "RECVER::RECV COMPLETE::VER:%d/HLEN:%d/TOS:%d/TLEN:%d\n",
				packet->ver,
				packet->hlen,
				packet->tos,
				packet->tlen );
	}

	//  Ÿ [TOS_LOGIN] Ǵ [TOS_GAME] ƴҰ  ó.
	//  ̰ ּ     ó.
	if ( packet->tos != TOS_GAME || packet->hlen != PHLen )
		return false;

	MSGBUF* msgBuf = (MSGBUF*)(ptr + packet->hlen);
	int     msgLen = packet->tlen - packet->hlen;

	switch ( msgBuf->protocol )
	{
	case MB_CH_STATUS_SYN:
		{
			MB_SYN_CH_STATUS* recvMsg      = (MB_SYN_CH_STATUS*)msgBuf;
			cLoginProcess*    loginProcess = g_loginSrv->GetLoginProcess( );

			if ( loginProcess != NULL )
				loginProcess->ChannelStatus( recvMsg->cid, recvMsg->status );

			if ( g_packet )
				printf( "\tCID(=0x%08xh) STATUS(=%d)\n", recvMsg->cid, recvMsg->status );
		}
		break;
	default:
		return false;
	}
	return true;
}

// RecvComplete Method
//
// UDP:.......User Datagram Protocol.
// Datagram:..Ŷ ȯ,  ܸ ġ      ʰ,
//            ϳϳ Ŷ ߽  ܸ ġ ó  ܸ ġ 
//                  ִ Ŷ.
bool cRecver::RecvComplete(ULONG_PTR completionKey, PerIoContext* perIoContext, DWORD bytesTransferred)
{
	cCSLock lock( &m_cs );

	// Recv Packet Size .
	mRecvUdpCount += 1;
	mRecvUdpSize  += bytesTransferred;

	// ŵ  ó.
	perIoContext->offset = bytesTransferred;

	// ۸ ó.
	PerIoContext** buffer = m_ioContextBackBuffer->buffer;
	long&          offset = m_ioContextBackBuffer->offset;

	if ( offset < MAX_IO_CONTEXT_BUFFER_LEN )
	{
		buffer[ offset ] = perIoContext;
		offset++;
	}
	else
	{
		m_ioContextPool->ReleaseIoContext( perIoContext );
		PostServerEvent( "Warning - cRecver::RecvComplete Method - Overflow I/O Context Buffer." );
	}

	//   I/O Context غѴ.
	perIoContext = m_ioContextPool->GetIoContext( m_socket, IOCP_REQUEST_READ );
	if ( RecvPost( completionKey, perIoContext ) == false )
	{
		PostServerEvent( "Error - cRecver::RecvPost Method - Return value is false." );
		return false;
	}
	return true;
}

// BackendThread Method
DWORD cRecver::BackendThread( )
{
	DWORD currentTick;
	DWORD elapsedTick;

	try {
		while ( true )
		{
			currentTick = GetTickCount( );

			// , Thread .
			if ( m_endServer == true )
				break;

			// Double Buffering ó.
			EnterCriticalSection( &m_cs );

				IoContextBuffer* temp  = m_ioContextBackBuffer;
				m_ioContextBackBuffer  = m_ioContextFrontBuffer;
				m_ioContextFrontBuffer = temp;

			LeaveCriticalSection( &m_cs );

			// ŵ  ó.
			PerIoContext** buffer = m_ioContextFrontBuffer->buffer;
			long&          offset = m_ioContextFrontBuffer->offset;

			while ( offset > 0 )
			{
				try {
					BatchComplete( (*buffer)->buffer );
				} catch ( char* str ) {
					PostServerEvent( "Caught 'BatchComplete' exception type: '%s'. Throwing 'cRecver::BackendThread' exception", str );
					Sleep( 100 );
					throw;
				} catch ( ... ) {
					PostServerEvent( "In BatchComplete Method. Throwing 'cRecver::BackendThread' exception." );
					Sleep( 100 );
					throw;
				}
				m_ioContextPool->ReleaseIoContext( (*buffer) );

				buffer++;
				offset--;
			}

			// ð 16(ms) - CPU ȭ  &  ȭ.
			elapsedTick = GetTickCount( ) - currentTick;
			if ( elapsedTick < 16 )
			{
				Sleep( (16 - elapsedTick) );
			}
		}
	} catch ( char* str ) {
		PostServerEvent( "Caught 'while ( true ) { ... }' exception type: '%s'. Throwing 'cRecver::BackendThread' exception", str );
		Sleep( 100 );
		throw;
	} catch ( ... ) {
		PostServerEvent( "In while ( true ) { ... }. Throwing 'cRecver::BackendThread' exception." );
		Sleep( 100 );
		throw;
	}
	return 0;
}
