// Include
#include "loginsrv.h"

// Local definitions
// memory ϰ 
#define SafeDelete(P) if (P!=NULL) { delete(P); (P)=NULL; }

// Global data

// cSQLAccount Constructor.
cSQLAccount::cSQLAccount(void)
{
}

// ~cSQLAccount Destructor.
cSQLAccount::~cSQLAccount(void)
{
}

// Initialize Method
bool cSQLAccount::Initialize(char* dns, char* uid, char* pwd, int numWorkerThreads)
{
	return cSQLPool::Initialize( dns, uid, pwd, numWorkerThreads );
}

// AllocSQLConnection Method
PerSQLConnection* cSQLAccount::AllocSQLConnection(void)
{
	PerSQLConnection* perSQLConnection = (PerSQLConnection*)GlobalAlloc( GPTR, sizeof(PerSQLConnection) );

	if ( perSQLConnection != NULL )
	{
		// PerSQLConnection - ʱȭ
		perSQLConnection->sqlConnection = new cSQLConnection( );  // 1. SQLConnection  .
		perSQLConnection->sqlStatement  = new cSQLAccountStmt( ); // 2. cSQLAccountStmt .
		perSQLConnection->prev          = NULL;                   // 3. Ʈ  - .
		perSQLConnection->next          = NULL;                   // 3. Ʈ  - .

		// Ŭ  Ȯ.
		if ( perSQLConnection->sqlConnection != NULL && perSQLConnection->sqlStatement != NULL )
		{
			// SQLEnvironment Ŭ Ͽ ڵ .
			if ( perSQLConnection->sqlConnection->AllocDbc( mSqlEnv ) == true )
			{
				// DBC .
				if ( perSQLConnection->sqlConnection->Connect( (SQLCHAR*)mDsn, (SQLCHAR*)mUid, (SQLCHAR*)mPwd ) == true )
				{
					// SQLConnectionŬ Ͽ ڵ .
					if ( perSQLConnection->sqlStatement->AllocStmt( perSQLConnection->sqlConnection ) == true )
					{
						// mWorkingSetSize .
						mWorkingSetSize++;
						return perSQLConnection;
					}
				}
			}
		}
	}

	FreeSQLConnection( &perSQLConnection );
	return perSQLConnection;
}

// PostServerEvent Method
bool cSQLAccount::PostServerEvent(LPCTSTR format, ...)
{
	bool retvalue = false;
	if ( g_loginSrv != NULL )
	{
		LPVOID  msgBuf = NULL;
		DWORD   bufferLength;

		va_list args;

		va_start( args, format );

		bufferLength = _vscprintf( format, args ) + 1;
		msgBuf       = malloc( bufferLength );

		vsprintf( (char*)msgBuf, format, args );

		va_end( args );

		if ( msgBuf != NULL )
		{
			retvalue = g_loginSrv->PostServerEvent( (char*)msgBuf );
			free( msgBuf );
		}
	}
	return retvalue;
}

// WorkerThread Method
DWORD cSQLAccount::WorkerThread(void)
{
	PerSQLConnection* perSQLConnection = NULL;
	cSQLAccountStmt*  sqlAccountStmt   = NULL;
	SQLRETURN         sqlReturn;

	PerIoContext*     perIoContext     = NULL;
	BOOL              retValue;

	DWORD             bytesTransfered;
	ULONG_PTR         completionKey;
	OVERLAPPED*       overlapped;

	while ( true )
	{
		//  I/O .
		retValue = GetQueuedCompletionStatus( mRequestQueue, &bytesTransfered, &completionKey, &overlapped, INFINITE );

		// Shutdown.
		if ( overlapped == POOL_SHUTDOWN )
			break;

		// Error - .
		if ( retValue == FALSE || bytesTransfered == 0 ) 
			continue;

		// SQLConnection - .
		perSQLConnection = GetPool( );

		// SQLConnection - Ȯ.
		if ( perSQLConnection == NULL )
		{
			// 1( ), ð 10/1000(s) - CPU ȭ  .
			Sleep( 10 );

			// 2( ),   Ǿ , ٽ õ.
			QueueRequest( completionKey, overlapped, bytesTransfered );
			continue;
		}

		// SQLStatement cSQLAccountStmt ĳ.
		sqlAccountStmt = (cSQLAccountStmt*)perSQLConnection->sqlStatement;

		// OVERLAPPED PerIoContext ɽ.
		perIoContext   = (PerIoContext*)overlapped;

		// 1. SQL 
		// 2. PerIoContext Ϸ -  ݹ ǵش.
		//	  perIoContext->requestType = IOCP_REQUEST_CALLBACK;
		switch ( perIoContext->iParam )
		{
		case SQL_SERVER_PROC_MATRIX_CREATE:
			sqlReturn = sqlAccountStmt->MatrixCreate( (MATRIX_CREATE*)perIoContext->buffer );
			break;
		case SQL_SERVER_PROC_SERVER_LIST:
			sqlReturn = sqlAccountStmt->ServerList( (SERVER_LIST*)perIoContext->buffer, perIoContext->offset );
			break;
		case SQL_SERVER_PROC_CHANNEL_UPDATE:
			sqlReturn = sqlAccountStmt->ChannelUpdate( (CHANNEL_UPDATE*)perIoContext->buffer );
			break;
		case SQL_SERVER_PROC_CONCURRENT_USER:
			sqlReturn = sqlAccountStmt->ConcurrentUser( (CONCURRENT_USER*)perIoContext->buffer );
			break;
		case SQL_SERVER_PROC_SERVER_DOWN:
			sqlReturn = sqlAccountStmt->ServerDown( (SERVER_DOWN*)perIoContext->buffer );
			break;
		case SQL_CLIENT_PROC_MEMBER_LOGIN:
			sqlReturn = sqlAccountStmt->MemberLogin( (MEMBER_LOGIN*)perIoContext->buffer );
			break;
		case SQL_CLIENT_PROC_MEMBER_LOGOUT:
			sqlReturn = sqlAccountStmt->MemberLogout( (MEMBER_LOGOUT*)perIoContext->buffer );
			break;
		case SQL_CLIENT_PROC_COMEIN_GAME:
			sqlReturn = sqlAccountStmt->ComeinGame( (COMEIN_GAME*)perIoContext->buffer );
			break;
		default:
			sqlReturn = SQL_ERROR;
			break;
		}

		// 2. ̺Ʈ -  Ѵ.
		if ( !SQL_SUCCEEDED( sqlReturn ) )
		{
			SQLHSTMT    hstmt = sqlAccountStmt->GetSqlStmt( );
			SQLCHAR     sqlstate[ SQL_SQLSTATE_SIZE + 1 ]     = "\0";
			SQLINTEGER  nativeErrorPtr                        = 0;
			SQLCHAR     messageText[ SQL_MAX_MESSAGE_LENGTH ] = "\0";
			SQLSMALLINT bufferLength                          = SQL_MAX_MESSAGE_LENGTH;
			SQLSMALLINT textLength                            = 0;
			SQLRETURN   result;

			result = SQLGetDiagRec( SQL_HANDLE_STMT,
									hstmt,
									1,					// [IN ] Status records are numbered from 1.
									sqlstate,			// [OUT] SQL Error State string
									&nativeErrorPtr,	// [OUT] Native Error code
									messageText,		// [OUT] SQL Error Text string
									bufferLength,		// [IN ] Length of the *MessageText buffer in characters.
									&textLength );

			// ν  .
			while ( SQLMoreResults( hstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( hstmt );

			// α.
			PostServerEvent( "cSQLAccount::IParam[%d]:Returns[%d] - SQL Error State string[%s] Native Error code[%d] SQL Error Text string[%s]",
							 perIoContext->iParam,
							 sqlReturn,
							 sqlstate,
							 nativeErrorPtr,
							 messageText );
		}

		// 3. PerIoContext Ϸ -  ݹ ǵش.
		// perIoContext->requestType   = IOCP_REQUEST_CALLBACK;
		// perIoContext->requestResult = IOCP_REQUEST_SUCCESS;
		cLoginProcess* loginProcess = g_loginSrv->GetLoginProcess( );
		if ( loginProcess != NULL )
		{
			perIoContext->requestResult = (sqlReturn == SQL_SUCCESS ? IOCP_REQUEST_SUCCESS : IOCP_REQUEST_ERROR );
			loginProcess->QueueRequest( completionKey, (OVERLAPPED*)perIoContext, perIoContext->offset );
		}

		// SQLConnection - .
		ReleasePool( perSQLConnection, !(sqlReturn == SQL_SUCCESS || sqlReturn == SQL_SUCCESS_WITH_INFO) );
	}
	return 0L;
}
