// Include
#include "sqlaccountstmt.h"

// Local definitions

// Global data

// cSQLAccountStmt Constructor.
cSQLAccountStmt::cSQLAccountStmt(void)
{
}

// ~cSQLAccountStmt Destructor.
cSQLAccountStmt::~cSQLAccountStmt(void)
{
}

// MatrixCreate Method.
// GP_MATRIX_CREATE.SQL .
//   @MAX_SERVER  [smallint]    --ִ ȣ
//   @MAX_CHANNEL [smallint]    --ִ äιȣ
SQLRETURN cSQLAccountStmt::MatrixCreate(MATRIX_CREATE* matrixCreate)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_MATRIX_CREATE(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &matrixCreate->maxServer,  0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &matrixCreate->maxChannel, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &matrixCreate->retvalue,   0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// ServerList Method.
//  GP_SERVER_LIST.SQL .
SQLRETURN cSQLAccountStmt::ServerList(SERVER_LIST* serverList, u_long& cbLength)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SERVER_LIST}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		TB_SERVER* table     = serverList->table;
		SQLINTEGER tableSize = sizeof(serverList->table);

		SQLINTEGER nameSize  = sizeof(table->name);
		SQLINTEGER cbName    = 0;

		SQLINTEGER descSize  = sizeof(table->description);
		SQLINTEGER cbDesc    = 0;

		while ( (retcode = SQLFetch( mHstmt )) == SQL_SUCCESS )
		{
			SQLGetData( mHstmt, 0x01, SQL_C_SLONG,   &table->idx,        0,        &(strLenOrInd=0) );
			SQLGetData( mHstmt, 0x02, SQL_C_WCHAR,   table->name,        nameSize, &cbName          );
			SQLGetData( mHstmt, 0x03, SQL_C_WCHAR,   table->description, descSize, &cbDesc          );
			SQLGetData( mHstmt, 0x04, SQL_C_TINYINT, &table->status,     0,        &(strLenOrInd=0) );
			table++;

			serverList->rowCount++;
			cbLength += tableSize;
		}

		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}
	return SQL_SUCCESS;
}

// ChannelUpdate Method.
//  GP_CHANNEL_UPDATE.SQL .
//   @SERVER_NUM  [smallint]  --ȣ
//   @CHANNEL_NUM [smallint]  --äιȣ
//   @STATUS      [tinyint]   --(0Ȱ/1/2ȥ)
//   @RETVALUE    [int]OUTPUT --ȯ
SQLRETURN cSQLAccountStmt::ChannelUpdate(CHANNEL_UPDATE* channelUpdate)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CHANNEL_UPDATE(?, ?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &channelUpdate->serverNum,  0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT,  SQL_C_SLONG,   SQL_INTEGER, 0, 0, &channelUpdate->channelNum, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0, 0, &channelUpdate->status,     0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x4, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0, 0, &channelUpdate->retvalue,   0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// ConcurrentUser Method.
// GP_CONCURRENT_USER.SQL .
SQLRETURN cSQLAccountStmt::ConcurrentUser(CONCURRENT_USER* concurrentUser)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_CONCURRENT_USER(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER, 0, 0, &concurrentUser->serverIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER, 0, 0, &concurrentUser->value,     0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// ServerDown Method.
// GP_SERVERDOWN.SQL .
//   @SERVER_NUM  [smallint]  --ȣ
//   @CHANNEL_NUM [smallint]  --äιȣ
SQLRETURN cSQLAccountStmt::ServerDown(SERVER_DOWN* serverDown)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_SERVERDOWN(?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &serverDown->serverNum,  0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &serverDown->channelNum, 0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// MemberLogin Method
// GP_MEMBER_LOGIN.SQL .
//   @MEMBER_IDX       [int]OUTPUT   --ȣ - ȸ ̺
//   @LOGON_IDX        [int]OUTPUT   --ȣ - α ̺
//   @LOGINID          [varchar](16) -- (ID)
//   @PASSWORD         [varchar](16) --ȣ
//   @INETNUM          [varchar](20) --IPּ(IPv4)
//   @LAST_SERVER_NUM  [int]OUTPUT   --ȣ( )
//   @LAST_CHANNEL_NUM [int]OUTPUT   --äιȣ( )
//   @RETVALUE         [int]OUTPUT   --ȯ
SQLRETURN cSQLAccountStmt::MemberLogin(MEMBER_LOGIN* memberLogin)
{
	SQLCHAR*     statement = (SQLCHAR*)"{call GP_MEMBER_LOGIN(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER   strLenOrInd;
	SQLRETURN    retcode;
	SQLUSMALLINT param;

	long       loginidLen  = (long)sizeof( memberLogin->loginid );
	long       cbLoginid   = SQL_NTS;
	long       passwordLen = (long)sizeof( memberLogin->password );
	long       cbPassword  = SQL_NTS;
	long       inetnumLen  = (long)sizeof( memberLogin->inetnum );
	long       cbInetnum   = SQL_NTS;

	retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,  0, &memberLogin->memberIdx,      0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,  0, &memberLogin->loginIdx,       0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_VARCHAR, 16, 0, memberLogin->loginid,         loginidLen,  &cbLoginid       );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_VARCHAR, 16, 0, memberLogin->password,        passwordLen, &cbPassword      );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_CHAR,    SQL_VARCHAR, 20, 0, memberLogin->inetnum,         inetnumLen,  &cbInetnum       );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,  0, &memberLogin->lastServerNum,  0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,  0, &memberLogin->lastChannelNum, 0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_TINYINT, SQL_TINYINT, 0,  0, &memberLogin->slevel,         0,           &(strLenOrInd=0) );
	retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,   SQL_INTEGER, 0,  0, &memberLogin->retvalue,       0,           &(strLenOrInd=0) );
	retcode = SQLExecDirect( mHstmt, statement, SQL_NTS );

	if ( SQL_SUCCEEDED( retcode ) )
	{
		// ν  .
		while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

		// ִ  ݱ. (Close the open result set.)
		SQLCloseCursor( mHstmt );
	}

	return retcode;
}

// MemberLogout Method
// GP_MEMBER_LOGOUT.SQL .
//   @LOGIN_IDX   [int]       --ȣ - α ̺
//   @MEMBER_IDX  [int]       --ȣ - ȸ ̺
//   @RETVALUE    [int]OUTPUT --ȯ
SQLRETURN cSQLAccountStmt::MemberLogout(MEMBER_LOGOUT* memberLogout)
{
	SQLCHAR*   statement = (SQLCHAR*)"{call GP_MEMBER_LOGOUT(?, ?, ?)}";
	SQLINTEGER strLenOrInd;
	SQLRETURN  retcode;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, 0x1, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &memberLogout->loginIdx,  0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x2, SQL_PARAM_INPUT,  SQL_C_SLONG, SQL_INTEGER, 0, 0, &memberLogout->memberIdx, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, 0x3, SQL_PARAM_OUTPUT, SQL_C_SLONG, SQL_INTEGER, 0, 0, &memberLogout->retvalue,  0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}

// ComeinGame Method.
// GP_COMEIN_GAME.SQL .
SQLRETURN cSQLAccountStmt::ComeinGame(COMEIN_GAME* comeinGame)
{
	SQLCHAR*     statement = (SQLCHAR*)"{call GP_COMEIN_GAME(?, ?, ?, ?, ?, ?, ?, ?, ?)}";
	SQLINTEGER   strLenOrInd;
	SQLRETURN    retcode;
	SQLUSMALLINT param;

	retcode = SQLPrepare( mHstmt, statement, SQL_NTS );
	if ( SQL_SUCCEEDED( retcode ) )
	{
		retcode = SQLBindParameter( mHstmt, param=1, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->loginIdx,       0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->serverNum,      0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->channelNum,     0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->lastChannel,    0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->characterIdx,   0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_INPUT,  SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->instantDungeon, 0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->ipv4,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SSHORT, SQL_SMALLINT, 0,  0, &comeinGame->port,           0, &(strLenOrInd=0) );
		retcode = SQLBindParameter( mHstmt, ++param, SQL_PARAM_OUTPUT, SQL_C_SLONG,  SQL_INTEGER,  0,  0, &comeinGame->retvalue,       0, &(strLenOrInd=0) );
		retcode = SQLExecute( mHstmt );

		if ( SQL_SUCCEEDED( retcode ) )
		{
			// ν  .
			while ( SQLMoreResults( mHstmt ) == SQL_SUCCESS );

			// ִ  ݱ. (Close the open result set.)
			SQLCloseCursor( mHstmt );
		}
	}

	return retcode;
}
