/* ====================================================================
 *      :	sqlAccountStmt.h
 *      :	
 *    :	ö
 *    :	07/01/12
 * ǻ :	
 * =================================================================== */
#ifndef __SQL_ACCOUNT_STATEMENT_H__
#define __SQL_ACCOUNT_STATEMENT_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "odbcsql.h"
#include "loginsrvdefines.h"

struct MATRIX_CREATE
{
	long maxServer;
	long maxChannel;
	long retvalue;
};

struct SERVER_LIST
{
	long      rowCount;
	TB_SERVER table[1];
};

struct CHANNEL_UPDATE
{
	long  serverNum;
	long  channelNum;
	BYTE  status;
	long  retvalue;
};

struct CONCURRENT_USER
{
	long serverIdx;
	long value;
};

struct SERVER_DOWN
{
	long serverNum;
	long channelNum;
};

struct MEMBER_LOGIN
{
	long memberIdx;
	long loginIdx;

	char loginid[ 17 ];
	char password[ 17 ];
	char inetnum[ 21 ];

	long lastServerNum;
	long lastChannelNum;
	char slevel;
	long retvalue;
};

struct MEMBER_LOGOUT
{
	long loginIdx;
	long memberIdx;
	long retvalue;
};

struct COMEIN_GAME
{
	long  loginIdx;
	long  serverNum;
	long  channelNum;
	long  lastChannel;
	long  characterIdx;
	BYTE  instantDungeon;
	long  ipv4;
	short port;
	long  retvalue;
};

class cSQLAccountStmt :
	public cSQLStatement
{
public:
// Ŭ    ޼ҵ.
	cSQLAccountStmt(void);

	SQLRETURN MatrixCreate   ( MATRIX_CREATE* matrixCreate );
	SQLRETURN ServerList     ( SERVER_LIST* serverList, u_long& cbLength );
	SQLRETURN ChannelUpdate  ( CHANNEL_UPDATE* channelUpdate );
	SQLRETURN ConcurrentUser ( CONCURRENT_USER* concurrentUser );
	SQLRETURN ServerDown     ( SERVER_DOWN* serverDown );

	SQLRETURN MemberLogin    ( MEMBER_LOGIN* memberLogin );
	SQLRETURN MemberLogout   ( MEMBER_LOGOUT* memberLogout );

	SQLRETURN ComeinGame     ( COMEIN_GAME* comeinGame );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSQLAccountStmt(void);
};

#endif // __SQL_ACCOUNT_STATEMENT_H__
