/* ====================================================================
 *      :	Sender.h
 *      :	
 *    :	ö
 *    :	07/02/13
 * ǻ :	
 * =================================================================== */
#ifndef __LOG_SENDER_H__
#define __LOG_SENDER_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "iocpudpsend.h"

#include "packet.h"
#include "logprotocol.h"
#include "serverprotocol.h"

#include "servermanager.h"

class cSender :
	public cIocpUdpSend
{
private:
	SOCKADDR_IN mGame;
	SOCKADDR_IN mLog;

public:
// Ŭ    ޼ҵ.
	cSender(void);

	bool    Initialize          ( char* addr, unsigned short numWorkerThreads=2 );
	void    Shutdown            ( DWORD maxWait=INFINITE );

	MSGBUF* GetPacket           ( void** handle, char tos, char protocol, SOCKADDR_IN addr );
	bool    SendPacket          ( void* handle, unsigned long length );
	void    GetRegisterDate     ( TIMESTAMP_STRUCT* ts );

public:
// Log  ޼ҵ.
	bool    PostServerEvent     ( char* message );
	bool    PostMemberEvent     ( char type, char category, long memberIdx, char* message );
	bool    PostConcurrentEvent ( long serverIdx, long minimum, long maximum, char* message );

public:
// Game  ޼ҵ.
	bool    PostChSync         ( );
	bool    PostChList         ( ServerTable* root );
	bool    PostChStatus       ( long cid, BYTE status );

public:
// Ŭ ı ޼ҵ.
	virtual ~cSender(void);
};

#endif // __LOG_SENDER_H__
