/* ====================================================================
 *      :	ServerManager.h
 *      :	
 *    :	ö
 *    :	08/10/17
 * ǻ :	
 * =================================================================== */
#ifndef __SERVER_MANAGER_H__
#define __SERVER_MANAGER_H__

//#ifndef WINVER
//#define WINVER          0x0500
//#endif
//
//#ifndef _WIN32_WINNT
//#define _WIN32_WINNT    0x0500
//#endif

#pragma once

#include "serverprotocol.h"

struct PerChannel
{
	long   cid;								// Connection Index (Server & Channel Number)
	BYTE   status;							// SERVER_STATUS 
	DWORD  timeToLive;						// TIME TO LIVE

	struct PerChannel* next;				// Linked List - next
	struct PerChannel* prev;				// "           - prev

	struct PerChannel* parent;				// Binary Tree - Parent
	struct PerChannel* left;				// "           - Child, left
	struct PerChannel* right;				// "           - Child, right

	void Status ( BYTE s ) { status = s; }
	void TimeToLive ( DWORD t ) { timeToLive = t; }
};

struct ServerTable
{
	long        idx;						// ȣ
	wchar_t     name[51];					// ̸
	BYTE        status;						// SERVER_STATUS 
	BYTE        channelCounter;				// ä 
	DWORD       concurrentUser;				//  
	DWORD       minConcurrentUser;			// ּ  
	DWORD       maxConcurrentUser;			// ִ  
	PerChannel* pool;						// ä Pool 
	PerChannel* root;						// ä BST Root 
	WORD        lastUpdate;					// ֱ Ʈ ð(HOUR)
};

class cServerManager
{
private:
	ServerTable  mServerTable[ MAX_SERVER ];
	PerChannel*  mNonPagedPoolUsage;        //  ȵ Ǯ.

	SIZE_T       mQuotaPagedPoolUsage;      //    Ǯ   - 뷮.
	SIZE_T       mQuotaNonPagedPoolUsage;   //   ȵ Ǯ - 뷮.
	SIZE_T       mWorkingSetSize;           //  ۾ ũ.

	PerChannel*  AllocChannel    ( );
	void         FreeChannel     ( PerChannel** pch );

	int          CompareCID      ( PerChannel* pch1, PerChannel* pch2 );
	int          CompareCID      ( long cid1, long cid2 );

	void         AttachPool      ( PerChannel** pool, PerChannel* pch );
	void         DetachPool      ( PerChannel** pool, PerChannel* pch );

	bool         AttachBst       ( PerChannel** root, PerChannel* pch );
	bool         DetachBst       ( PerChannel** root, PerChannel* pch );

	PerChannel*  GetPool         ( ServerTable* serverTable, long cid );
	void         ReleasePool     ( ServerTable* serverTable, PerChannel* pch );

	PerChannel*  SearchChannel   ( ServerTable* serverTable, long cid );

public:
	cServerManager( );

	void         GetMemoryInfo   ( SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize );
	void         Shutdown        ( );

	ServerTable* GetServerTable  ( ) { return mServerTable; }
	ServerTable* GetServerTable  ( long cid );

	long         FindChannel     ( long cid );
	bool         CompareChannel  ( long cid, BYTE status );
	bool         UpdateChannel   ( long cid, BYTE status );

	PerChannel*  GetChannel      ( long cid, BYTE status );
	bool         ReleaseChannel  ( long cid );

	void         UpdateProcess   ( DWORD currentTick );

public:
	virtual ~cServerManager(void);
};

inline void cServerManager::GetMemoryInfo(SIZE_T& quotaPagedPoolUsage, SIZE_T& quotaNonPagedPoolUsage, SIZE_T& workingSetSize)
{
	quotaPagedPoolUsage    = mQuotaPagedPoolUsage;
	quotaNonPagedPoolUsage = mQuotaNonPagedPoolUsage;
	workingSetSize         = mWorkingSetSize;
}

#endif // __SERVER_MANAGER_H__