/* ==========================================================================
*    : ̼
*    : 2007.03.09
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

class cSceneNode;
class cAreaSceneNode;
class cAreaTransformDialog;
class cAreaLightDialog;
class cAreaFogDialog;
class cAreaEtcDialog;

///  
/// ʻ  Ѵ.
class cAreaEditor
{
	static cAreaEditor* mSingleton;
	friend class cMapEditorView;
	friend class cObjectEditor;

public:
	cAreaEditor();
	~cAreaEditor();

	/// 
	void Clear();

	/// 
	void Render();

	/// ʱȭ
	void Init();

	/// 
	bool Save( cFileSaver& saver );

	///  
	bool CreateArea();

	///  
	void CopyArea();

	/// ŷ
	bool Pick( CPoint point );

	/// 
	void DeselectAll();
	void SelectArea( cAreaSceneNode* node, bool force = false );

	///   
	void AttachAreaToTerrain( CPoint point );

	///  Ʈ 
	void AttachAreaToObject( CPoint point );

	///  
	void DeleteArea();

	///  ̵
	void SetAreaTranslate( const NiPoint3& trans, bool updateDialog );

	///  
	void SetAreaRadius( float scale, bool updateDialog );

	///  ε
	void SetAreaGroupIndex( unsigned int groupIndex );

	/// ֺ
	void SetSkyAmbient( const NiColor& color );
	//void SetSkyDiffuse( const NiColor& color );
	void SetSkyDimmer( float dimmer );
	void SetTerrainAmbient( const NiColor& color );
	//void SetTerrainDiffuse( const NiColor& color );
	void SetTerrainDimmer( float dimmer );
	void SetStaticObjectAmbient( const NiColor& color );
	//void SetStaticObjectDiffuse( const NiColor& color );
	void SetStaticObjectDimmer( float dimmer );
	void SetDynamicObjectAmbient( const NiColor& color );
	//void SetDynamicObjectDiffuse( const NiColor& color );
	void SetDynamicObjectDimmer( float dimmer );

	/// Ȱ
	void SetFog( bool enabled, const NiColor& color, float depth );
	void SetFogColor( const NiColor& color );
	void SetFogDepth( float depth );

	/// ̾α
	void SetTransformDialog( cAreaTransformDialog* dlg );
	void SetLightDialog( cAreaLightDialog* dlg );
	void SetFogDialog( cAreaFogDialog* dlg );
	void SetEtcDialog( cAreaEtcDialog* dlg );

	///  
	unsigned int GetNumAreas() const;

private:
	/// ش  
	bool Kill( cAreaSceneNode* node );

	/// ش  带 
	///  ο  带 Ѵ.
	cAreaSceneNode* Clone( cAreaSceneNode* node );

private:
	/// ޽ ó
	void OnMouseMove( CPoint point );
	void OnLButtonDown_Transform( CPoint point );
	void OnRButtonDown_Transform( CPoint point, bool ctrl );
	void OnKeyDown( UINT c );

public:
	/// ü 
	static cAreaEditor* GetSingleton();

protected:
	/// ġ ̾α
	cAreaTransformDialog* mTransformDialog;

	/// ֺ ̾α
	cAreaLightDialog* mLightDialog;

	/// Ȱ ̾α
	cAreaFogDialog* mFogDialog;

	/// Ÿ Ӽ ̾α
	cAreaEtcDialog* mEtcDialog;

	///   V
	typedef tHashSet<cAreaSceneNode*> cCreatedSet;
	cCreatedSet mCreatedSet;

	/// 浹 ˻  迭
	typedef tArray<cSceneNode*> cPickedArray;
	cPickedArray mPickedArray;

	/// õ 
	cAreaSceneNode* mSelectedNode;

	///  
	///   ǥϴµ Ѵ.
	NiGeometryPtr mSphereGeom;
	NiMaterialPropertyPtr mMatProp;

	/// 콺 ǥ
	CPoint mMousePos;
};

inline
void cAreaEditor::SetTransformDialog( cAreaTransformDialog* dlg )
{
	assert( dlg && "null area transform dialog" );

	mTransformDialog = dlg;
}

inline
void cAreaEditor::SetLightDialog( cAreaLightDialog* dlg )
{
	assert( dlg && "null area light dialog" );

	mLightDialog = dlg;
}

inline
void cAreaEditor::SetFogDialog( cAreaFogDialog* dlg )
{
	assert( dlg && "null area fog dialog" );

	mFogDialog = dlg;
}

inline
void cAreaEditor::SetEtcDialog( cAreaEtcDialog* dlg )
{
	assert( dlg && "null area etc dialog" );

	mEtcDialog = dlg;
}

inline
unsigned int cAreaEditor::GetNumAreas() const
{
	return mCreatedSet.GetSize();
}

inline
cAreaEditor* cAreaEditor::GetSingleton()
{
	return mSingleton;
}

#define AREAEDIT cAreaEditor::GetSingleton()
