/* ==========================================================================
*    : ̼
*    : 2006.12.05
*      :  
* ǻ : 
*===========================================================================*/
#pragma once

class cDoing;
class cTerrainBuildingInfo;
class cTerrainPaintingInfo;
class cTerrainDetailingInfo;
class cObjectCreatingInfo;
class cObjectSelectingInfo;
class cObjectDeletingInfo;
class cObjectCopyingInfo;
class cNaviMeshBuildingInfo;
class cNaviFieldPaintingInfo;

///  
class cDoingManager
{
	static cDoingManager* mSingleton;

public:
	cDoingManager();
	~cDoingManager();

	/// 
	void ClearTerrain();
	void ClearObject();
	void ClearNaviMesh();
	void ClearNaviField();
	void ClearAll();

	/// Undo
	bool Undo();

	/// Redo
	bool Redo();

	/// Undo  ִ θ 
	bool IsEmpty() const;

	///   ߰
	void PushTerrainBuilding( const cTerrainBuildingInfo& info );
	void PushTerrainPainting( const cTerrainPaintingInfo& info );
	void PushTerrainDetailing( const cTerrainDetailingInfo& info );

	/// Ʈ  ߰
	void PushObjectCreating( const cObjectCreatingInfo& undo );
	void PushObjectSelecting( const cObjectSelectingInfo& undo, const cObjectSelectingInfo& redo );
	void PushObjectDeleting( const cObjectDeletingInfo& undo, const cObjectDeletingInfo& redo );
	void PushObjectCopying( const cObjectCopyingInfo& undo );
	void PushObjectTranslating( const NiPoint3& undo, const NiPoint3& redo );
	void PushObjectRotating( const NiMatrix3& undo, const NiMatrix3& redo );
	void PushObjectScaling( float undo, float redo );

	/// ׺޽  ߰
	void PushNaviMeshBuilding( const cNaviMeshBuildingInfo& info );

	/// ׺ʵ  ߰
	void PushNaviFieldPainting( const cNaviFieldPaintingInfo& info );

protected:
	/// Redo Ʈ 
	void ClearRedo();

	/// Undo  10000 ,  5000 .
	void CheckUndo();

public:
	/// ü 
	static cDoingManager* GetSingleton();

protected:
	/// Undo Ʈ
	typedef tList<cDoing*> cUndoList;
	cUndoList mUndoList;

	/// Redo Ʈ
	typedef tList<cDoing*> cRedoList;
	cRedoList mRedoList;
};

inline
bool cDoingManager::IsEmpty() const
{
	return mUndoList.IsEmpty();
}

inline
cDoingManager* cDoingManager::GetSingleton()
{
	return mSingleton;
}

#define DOINGMAN cDoingManager::GetSingleton()
