#include "stdafx.h"
#include "AppTimer.h"

cAppTimer* cAppTimer::mSingleton = 0;

cAppTimer::cAppTimer()
{
	assert( mSingleton == 0 && "bad singleton!" );
	mSingleton = this;

	mStopped = true;
	mLastElapsedTime = 0.0;
	mBaseTime = 0.0;
	mStopTime = 0.0;
}

cAppTimer::~cAppTimer()
{
	mSingleton = 0;
}

void cAppTimer::Start()
{
	double time;
	time = timeGetTime() * 0.001;

	if( mStopped )
		mBaseTime += time - mStopTime;

	mStopTime = 0;
	mLastElapsedTime = time;
	mStopped = false;
}

void cAppTimer::Stop()
{
	double time;

	if( mStopTime != 0.0 )
		time = mStopTime;
	else
		time = timeGetTime() * 0.001;

	if( !mStopped )
	{
		mStopTime = time;
		mLastElapsedTime = time;
		mStopped = true;
	}
}


void cAppTimer::Reset()
{
	double time;

	if( mStopTime != 0.0 )
		time = mStopTime;
	else
		time = timeGetTime() * 0.001;

	mBaseTime = time;
	mLastElapsedTime = time;
	mStopTime = 0;
	mStopped = false;
}

void cAppTimer::Advance()
{
	double time;

	if( mStopTime != 0.0 )
		time = mStopTime;
	else
		time = timeGetTime() * 0.001;

	mStopTime += 0.1f;
}

float cAppTimer::GetAbsoluteTime()
{
	return (float)( timeGetTime() * 0.001 );
}

float cAppTimer::GetCurrentTime()
{
	double time;

	if( mStopTime != 0.0 )
		time = mStopTime;
	else
		time = timeGetTime() * 0.001;

	return (float)(time - mBaseTime);
}

float cAppTimer::GetElapsedTime()
{
	double time;

	if( mStopTime != 0.0 )
		time = mStopTime;
	else
		time = timeGetTime() * 0.001;

	float elapsedTime = (float)(time - mLastElapsedTime);
	mLastElapsedTime = time;
	return elapsedTime;
}
