#include "stdafx.h"
#include "Application.h"

//#include "DXVersion.h"
#include "AppWindow.h"
#include "AppTimer.h"

#include "FilePackSystem.h"
#include "RenderSystem.h"
#include "SoundSystem.h"
#include "InputSystem.h"
#include "DevSystem.h"

#include "ResourceManager.h"
#include "CameraManager.h"
#include "SceneManager.h"
#include "ObjectManager.h"
#include "WorldManager.h"

cApplication* cApplication::mSingleton = 0;

cApplication::cApplication()
: mFileSystem( 0 )
, mRenderSystem( 0 )
#ifdef MAP_EDITOR
, mSoundSystem( 0 )
#endif
, mInputSystem( 0 )
, mDevSystem( 0 )
, mResourceManager( 0 )
, mCameraManager( 0 )
, mSceneManager( 0 )
, mObjectManager( 0 )
, mWorldManager( 0 )
{
	assert( mSingleton == 0 && "bad singleton!" );
	mSingleton = this;

	///  Ÿ̸ 
	mTimer = new cAppTimer;
	mTimer->Reset();
	mAccumTime = 0;
	mDeltaTime = 0;

	mActive = true;
}

cApplication::~cApplication()
{
	delete mWorldManager;
	delete mObjectManager;
	delete mSceneManager;
	delete mCameraManager;
	delete mResourceManager;
	delete mDevSystem;
	delete mInputSystem;
	delete mRenderSystem;
	delete mFileSystem;
#ifdef MAP_EDITOR
	delete mSoundSystem;
#endif
	delete mWindow;
	delete mTimer;

	mSingleton = 0;
}

void cApplication::Clear()
{
	if( mWorldManager )
		mWorldManager->Clear();

	if( mSceneManager )
		mSceneManager->Clear();

	if( mResourceManager )
		mResourceManager->Clear();
}

bool cApplication::Init( HWND wnd )
{
	///  츦 
	mWindow = new cAppWindow( wnd );

	///  ý 
	mFileSystem = new cFilePackSystem;
	if( !mFileSystem || !mFileSystem->Init() )
	{
		return false;
	}

	///  ý 
	mRenderSystem = new cRenderSystem( mWindow );
	if( mRenderSystem->Init() == false )
	{
		AfxMessageBox( "Failed to init render system" );
		return false;
	}

#ifdef MAP_EDITOR
	///  ý 
	mSoundSystem = new cSoundSystem;
	if( mSoundSystem->Init( wnd ) == false )
	{
		AfxMessageBox( "Failed to init sound system" );
		return false;
	}

	///  ý 
	mDevSystem = new cDevSystem( NiRenderer::GetRenderer() );
	if( mDevSystem->Init() == false )
	{
		AfxMessageBox( "Failed to init dev system" );
		return false;
	}
#endif

	/// Է ý 
	mInputSystem = new cInputSystem;

	/// ڿ ڸ 
	mResourceManager = new cResourceManager;
	//mpResourceManager->SetBaseDir( baseDir );

	/// ī޶ ڸ 
	mCameraManager = new cCameraManager;

	///  ڸ 
	mSceneManager = new cSceneManager;

	///  ڸ 
	mWorldManager = new cWorldManager;

	/// Ʈ ڸ   ʱȭ
	mObjectManager = new cObjectManager;
	if( mObjectManager->Init() == false )
	{
		AfxMessageBox( "Failed to init object manager" );
		return false;
	}

	/// Ÿ̸ 
	mTimer->Start();
	return true;
}

void cApplication::Exit()
{
	if( mObjectManager )
		mObjectManager->Exit();

	/// Ÿ̸ 
	mTimer->Stop();
}

void cApplication::Process( bool playing )
{
	NiSleep(1);

	///  ð 
	mDeltaTime = mTimer->GetElapsedTime();
	mAccumTime += mDeltaTime;

	/// Ʈ ڸ ó
	mObjectManager->Process( mDeltaTime );

	/// Է ڸ ó
	mInputSystem->Process();

	/// ī޶ ڸ ó
	mCameraManager->Process( mDeltaTime );

	///  ڸ ó
	mSceneManager->Process( mDeltaTime, mAccumTime, playing );

	///  ڸ ó
	mWorldManager->Process( mDeltaTime, mAccumTime, playing );

	if( mDevSystem )
		mDevSystem->Process( mAccumTime );
}

void cApplication::Render()
{
	mRenderSystem->Render();
}
