/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      : ø̼
* ǻ : 
*===========================================================================*/
#pragma once

class cAppWindow;
class cAppTimer;
class cFilePackSystem;
class cRenderSystem;
class cSoundSystem;
class cInputSystem;
class cResourceManager;
class cCameraManager;
class cSceneManager;
class cObjectManager;
class cWorldManager;
class cDevSystem;

/// ø̼
class cApplication
{
	static cApplication* mSingleton;

public:
	cApplication();
	~cApplication();

	/// 
	void Clear();

	/// ʱȭ
	bool Init( HWND wnd );

	/// 
	void Exit();

	/// ó
	void Process( bool testing );

	/// 
	void Render();

	/// Ȱȭ 
	void SetActive( bool active );
	bool IsActive();

	/// Ÿ̸
	cAppTimer* GetTimer();
	float GetDeltaTime() const;

public:
	/// ü 
	static cApplication* GetSingleton();

private:
	///  â
	cAppWindow* mWindow;

	///  ý
	cFilePackSystem* mFileSystem;

	///  ý
	cRenderSystem* mRenderSystem;

#ifdef MAP_EDITOR
	///  ý
	cSoundSystem* mSoundSystem;
#endif

	/// Է ý
	cInputSystem* mInputSystem;

	///  ý
	cDevSystem* mDevSystem;

	/// ڿ 
	cResourceManager* mResourceManager;

	/// ī޶ 
	cCameraManager* mCameraManager;

	///  
	cSceneManager* mSceneManager;

	/// Ʈ 
	cObjectManager* mObjectManager;

	///  
	cWorldManager* mWorldManager;

	/// Ÿ̸
	cAppTimer* mTimer;

	///  ð
	float mAccumTime;

	///  ð
	float mDeltaTime;

	/// Ȱȭ 
	bool mActive;
};

inline void cApplication::SetActive( bool active )
{
	mActive = active;
}

inline bool cApplication::IsActive()
{
	return mActive;
}

inline cAppTimer* cApplication::GetTimer()
{
	return mTimer;
}

inline float cApplication::GetDeltaTime() const
{
	return mDeltaTime;
}

inline cApplication* cApplication::GetSingleton()
{
	return mSingleton;
}

#define THEONE cApplication::GetSingleton()
