#include "stdafx.h"
#include "AreaSceneNode.h"

#include "Ray.h"
#include "Sphere.h"
#include "CameraManager.h"

cAreaSceneNode::cAreaSceneNode( eSceneNodeType type )
: cSceneNode( type )
, mRadius( 0.0f )
, mSkyAmbient( NiColor::WHITE )
, mSkyDimmer( 1.0f )
, mTerrainAmbient( NiColor::WHITE )
, mTerrainDimmer( 1.0f )
, mStaticObjectAmbient( NiColor::WHITE )
, mStaticObjectDimmer( 1.0f )
, mDynamicObjectAmbient( NiColor::WHITE )
, mDynamicObjectDimmer( 1.0f )
, mFogEnabled( false )
, mFogColor( NiColor::WHITE )
, mFogDepth( 0.0f )
, mGroupIndex( 0 )
{
}

cAreaSceneNode::~cAreaSceneNode()
{
}

bool cAreaSceneNode::Save( cFileSaver& saver )
{
	///  (̸, ȯ ) 
	if( cSceneNode::Save( saver ) == false )
		return false;

	///  
	saver.WriteFloat( mRadius );

	/// ֺ 
	saver.Write( &mSkyAmbient, sizeof(NiColor) );
	saver.WriteFloat( mSkyDimmer );
	saver.Write( &mTerrainAmbient, sizeof(NiColor) );
	saver.WriteFloat( mTerrainDimmer );
	saver.Write( &mStaticObjectAmbient, sizeof(NiColor) );
	saver.WriteFloat( mStaticObjectDimmer );
	saver.Write( &mDynamicObjectAmbient, sizeof(NiColor) );
	saver.WriteFloat( mDynamicObjectDimmer );

	/// Ȱ 
	saver.WriteUnsignedInt( mFogEnabled );
	saver.Write( &mFogColor, sizeof(NiColor) );
	saver.WriteFloat( mFogDepth );

	///  ε 
	saver.WriteUnsignedInt( mGroupIndex );
	return true;
}

bool cAreaSceneNode::Init( const cAreaSceneNodeParam& param )
{
	///  带 
	NiNode* n = NiNew NiNode;
	mNiNode = n;
	mRadius = param.mRadius;
	mSkyAmbient = param.mSkyAmbient;
	mSkyDimmer = param.mSkyDimmer;
	mTerrainAmbient = param.mTerrainAmbient;
	mTerrainDimmer = param.mTerrainDimmer;
	mStaticObjectAmbient = param.mStaticObjectAmbient;
	mStaticObjectDimmer = param.mStaticObjectDimmer;
	mDynamicObjectAmbient = param.mDynamicObjectAmbient;
	mDynamicObjectDimmer = param.mDynamicObjectDimmer;
	mFogEnabled = param.mFogEnabled;
	mFogColor = param.mFogColor;
	mFogDepth = param.mFogDepth;
	mGroupIndex = param.mGroupIndex;


//	char test[256];
//	::sprintf( test, "AreaSceneInit %f", mDynamicObjectDimmer );
//	NiMessageBox(test, "check");

	///  ʱȭ
	param.mNiObject = n;
	if( cSceneNode::Init( param ) == false )
	{
		return false;
	}

	///    
	n->SetSelectiveUpdate( true );
	n->SetSelectiveUpdateTransforms( true );
	n->SetSelectiveUpdatePropertyControllers( false );
	n->SetSelectiveUpdateRigid( false );
	return true;
}

bool cAreaSceneNode::Pick( const cRay& ray )
{
	return mBoundSphere.IntersectRay( &mPickPos, &mPickDistance, ray );
}
