/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      : ī޶
* ǻ : 
*===========================================================================*/
#pragma once

/// ī޶
//////////////////////////////////////////////////////////////////////////
//       Y                         Z
// NI:   |__ Z         MAX(APP):   |__ X
//      /                         /
//    -X                        -Y
//////////////////////////////////////////////////////////////////////////
class cCamera
{
	friend class cCameraManager;
	static const unsigned int MIN_NEAR_DIST = 1;
	static const unsigned int MAX_FAR_DIST = 200000;

public:
	cCamera();
	virtual ~cCamera();

	/// ʱȭ  
	virtual bool Init( unsigned int screenWidth, unsigned int screenHeight );

	/// ī޶ ġ   
	virtual void Reset(){}// = 0;

	/// 
	virtual void Update( float time );

	/// ٰŸ
	float GetNearDistance() const;

	/// Ÿ
	void SetFarDistance( float farDist );
	float GetFarDistance() const;

	/// þ Դ
	void SetViewFrustum( unsigned int screenWidth, unsigned int screenHeight );
	void SetViewFrustum( unsigned int screenWidth, unsigned int screenHeight, float fovyDegree, float nearDist, float farDist );
	void SetViewFrustum( float left, float right, float top, float bottom, float nearDist, float farDist );
	void SetOrtho( bool ortho );
	bool GetOrtho() const;

	/// Ʈ
	void SetViewPort( float left = 0, float right = 1, float top = 1, float bottom = 0 );

	/// ̵
	void Translate( const NiPoint3& move );
	void SetTranslate( const NiPoint3& trans );
	void SetTranslate( float x, float y, float z );
	const NiPoint3& GetWorldTranslate() const;

	/// ȸ
	void Rotate( const NiPoint3& axis, float angle );
	void SetRotate( const NiMatrix3& rot );
	void Pitch( float angle );
	void Yaw( float angle );
	const NiMatrix3& GetWorldRotate() const;

	/// 
	NiPoint3 GetWorldDirection() const;
	NiPoint3 GetWorldUpVector() const;
	NiPoint3 GetWorldRightVector() const;

	/// ӷ
	void SetTranslateSpeed( float unitsPerSec );
	void SetRotateSpeed( float anglesPerSec );

	/// Ⱦ
	float GetAspectRatio() const;

	/// 콺 ǥ شϴ 
	bool GetRayFromWindowPoint( long mouseX, long mouseY, NiPoint3& origin, NiPoint3& dir ) const;

	///  ī޶ ȯ
	operator NiCamera*() const
	{
		return mNiCamera;
	}

protected:
	/// ó
	virtual void Process( float deltaTime );
	virtual void ProcessInput( float deltaTime ) = 0;

protected:
	/// ȭ ũ
	unsigned int mScreenWidth;
	unsigned int mScreenHeight;

	///  þ߰
	float mFovyDegree;

	/// ٰŸ
	float mNearDistance;

	/// Ÿ
	float mFarDistance;

	/// Ⱦ
	float mAspectRatio;

	/// , , , 
	float mLeft, mRight, mTop, mBottom;

	///   
	bool mOrtho;

	///  ī޶
	NiCameraPtr mNiCamera;

	/// ī޶ ȯ 
	NiNodePtr mOrientNode;

	///   
	NiNodePtr mListenerNode;

	/// ӷ
	float mTranslateSpeed;
	float mRotateSpeed;
};

inline
void cCamera::Update( float time )
{
	mOrientNode->Update( time );
}

inline
void cCamera::SetTranslateSpeed( float unitsPerSec )
{
	mTranslateSpeed = unitsPerSec;
}

inline
void cCamera::SetRotateSpeed( float anglesPerSec )
{
	mRotateSpeed = anglesPerSec;
}

inline
void cCamera::SetOrtho( bool ortho )
{
	mOrtho = ortho;
}

inline
bool cCamera::GetOrtho() const
{
	return mOrtho;
}

inline
const NiPoint3& cCamera::GetWorldTranslate() const
{
	return mNiCamera->GetWorldTranslate();
}

inline
const NiMatrix3& cCamera::GetWorldRotate() const
{
	return mNiCamera->GetWorldRotate();
}

inline
NiPoint3 cCamera::GetWorldDirection() const
{
	return mNiCamera->GetWorldDirection();
}

inline
NiPoint3 cCamera::GetWorldUpVector() const
{
	return mNiCamera->GetWorldUpVector();
}

inline
NiPoint3 cCamera::GetWorldRightVector() const
{
	return mNiCamera->GetWorldRightVector();
}

inline
bool cCamera::GetRayFromWindowPoint( long mouseX, long mouseY, NiPoint3& origin, NiPoint3& dir ) const
{
	return mNiCamera->WindowPointToRay( mouseX, mouseY, origin, dir );
}

inline
float cCamera::GetNearDistance() const
{
	return mNearDistance;
}

inline
float cCamera::GetFarDistance() const
{
	return mFarDistance;
}

inline
float cCamera::GetAspectRatio() const
{
	return mAspectRatio;
}
