#include "stdafx.h"
#include "DynamicSceneNode.h"

#include "SceneTree.h"
#include "SceneManager.h"

#include "ResourceManager.h"
#include "RenderSystem.h"
#include "CameraManager.h"
//#include "LightAgent.h"
//#include "FogAgent.h"
//#include "SoundSystem.h"

//#include "EffectSceneNode.h"
//#include "SoundSceneNode.h"
//#include "ObjectNameCard.h"
#include "TrailGeometry.h"
#include "ShadowGeometry.h"
//
//#include "ChatBubble.h"


cDynamicSceneNode::cDynamicSceneNode( eSceneNodeType type ) 
: cSceneNode( type )
, mTargetAnimation( UINT_MAX )
, mRandomIdle( 0 )
, mModel(0)
//, mpNameCard(0)
//, mpChatBubble(0)
, mLinkInfo(0)
, mActorManager(0)
, mAmbientLight( 0 )
#ifdef MAP_EDITOR
, mRibbonGeom( 0 )
, mShadowGeom( 0 )
, mNeedUpdateShadow( false )
#endif
{
	mHead = 0;
	mHeadDist = 20.0f;

	mMorpherController = 0;
	mEyeMorpherTime = 0;
	mWinkInterval = 4.f;
	mStopMorpherProcess = false;

	mLastTime = -FLT_MAX;
	mScaleFactor = 1.0f;

	mRadius = 0.0f;
}

cDynamicSceneNode::~cDynamicSceneNode()
{
	/// ϵ Ʈ ִٸ   Ѵ.
	//NiTListIterator pos = mEffectList.GetHeadPos();
	//while( pos )
	//{
	//	cEffectSceneNode* pnode = mEffectList.GetNext(pos);
	//	SCENEMAN->DestroyEffectNode( pnode, true );
	//}
	//mEffectList.RemoveAll();

	//pos = mSoundList.GetHeadPos();
	//while( pos )
	//{
	//	cSoundSceneNode* pnode = mSoundList.GetNext(pos);
	//	SCENEMAN->DestroySoundNode( pnode, true );
	//}
	//mSoundList.RemoveAll();


	/// ǳ 
	//SAFE_DELETE(mpChatBubble);

	/// ̸ ü 
	//SAFE_DELETE(mpNameCard);

	if( mLinkInfo )
	{
		sLinkInfo* info = 0;
		for( unsigned int i=0; i<mLinkInfo->GetSize(); ++i )
		{
			info = mLinkInfo->GetAt( i );
			if( info )
			{
				NiDelete info;
			}
		}
		mLinkInfo->RemoveAll();
	}

	SAFE_NIDELETE( mLinkInfo );
	SAFE_NIDELETE( mRandomIdle );
#ifdef MAP_EDITOR
	SAFE_NIDELETE( mRibbonGeom );
	SAFE_DELETE( mShadowGeom );
#endif

	mPartsNameMap.RemoveAll();

	SAFE_NIDELETE( mActorManager );

	mModel = 0;
}

void cDynamicSceneNode::Process( float deltaTime, float accumTime )
{
#ifdef MAP_EDITOR
	/// 
	if( mRibbonGeom )
		mRibbonGeom->Process( deltaTime );
#endif

	/// Ƿ  ϴ 쿡 Ѵ.
	UpdateBipedRootTransforms( accumTime );

	/// Alpha Fade In/Out ó
	ProcessAlpha( accumTime );

	/// ۰ ִٸ, Ѵ.
	if( mMorpherController && !mStopMorpherProcess )
	{
		if( accumTime - mEyeMorpherTime > mWinkInterval )
		{
			mEyeMorpherTime = accumTime;
			mMorpherController->Start();
			mMorpherController->SetManagerControlled( false );
		}

		mMorpherController->OnPreDisplay();

		if( !mMorpherController->GetManagerControlled() )
		{
			if( mMorpherController->GetLastScaledTime() == mMorpherController->GetEndKeyTime() )
			{
				mMorpherController->Stop();
				mMorpherController->SetManagerControlled( true );
			}
		}
	}

	/// actormanager  ð 
	if( mLastTime == -FLT_MAX )
	{
		mLastTime = accumTime;
		mScaleAccumTime = accumTime;
	}

	///  ð * ӵ 
	deltaTime *= mScaleFactor;

	mScaleAccumTime += deltaTime;
	mLastTime = accumTime;

	/// ü Update
	mActorManager->Update( mScaleAccumTime );

	NiNode* pRoot = NiDynamicCast(NiNode, mNiObject);
	pRoot->Update( mScaleAccumTime );
//	mNiObject->Update( mScaleAccumTime );

	/// 豸 
	mBoundSphere.Set( GetCenter(), mRadius );

	///  Ʈ 
	if( mContainer )
		mContainer->Update( this );

	//if( mpChatBubble )
	//{
	//	if( mHead == 0 )
	//	{
	//		assert( 0 );
	//		return;
	//	}

	//	NiPoint3 headPos = mHead->GetWorldTranslate();
	//	headPos.z += mHeadDist;

	//	mpChatBubble->Update( headPos, accumTime );
	//}

	///
	if( mNeedUpdateTransform )
	{
		mNeedUpdateTransform = false;
#ifdef MAP_EDITOR
		mNeedUpdateShadow = true;
#endif
	}
}

//bool cDynamicSceneNode::OnVisible( cSceneCuller& culler )
//{
//	bool ret = cSceneNode::OnVisible( culler );
//
//	if( ret )
//	{
//		assert( mShadowGeom );
//		mShadowGeom->Update( mNeedUpdateShadow, mAlpha );
//
//		mNeedUpdateShadow = false;
//	}
//
//	return ret;
//}

bool cDynamicSceneNode::OnVisible( cSceneCuller& /*culler*/ )
{
#ifdef REGEN_TOOL
	if( mCulled )
		return false;
#endif

#ifdef MAP_EDITOR
	/// ׸
	if( mShadowGeom && mAlpha > 0.00001f )
		mShadowGeom->Process( mNeedUpdateShadow, GetWorldTranslate(), mAlpha );

	mNeedUpdateShadow = false;
#endif
	return true;
}

bool cDynamicSceneNode::Init( const cDynamicSceneNodeParam& param )
{
	//mpGameObject = param.mpObject;
	//assert( mpGameObject && "UnUsed Base Object" );

	/// ҽ ڷ   ȹ..
	//mModel = RESOURCEMAN->GetModelByName( param.mPathName.Cstr() );
	mModel = RESOURCEMAN->GetModel( param.mPathName );

	if( mModel == 0 )
	{
		RESOURCEMAN->LoadKFM( param.mPathName );
		mModel = RESOURCEMAN->GetModel( param.mPathName );

		if( mModel == 0 )
		{
			assert(0 && "Model file not found");
			return false;
		}
	}

	/// ũ  ޸𸮸 ´.
	if( InitLinkInfo() == false )
		return false;

	/// ⺻ Ʈ ̹ ʱȭ
	if( InitPartsName() == false )
	{
		return false;
	}

	/// ActorManager ..
	mActorManager = cActorManagerForPartition::Create( mModel, mPartsNameMap );
	if( mActorManager == 0 )
	{
		assert( 0 );
		return false;
	}

	///   ִٸ Ѵ.
	mMorpherController = mActorManager->GetMorpherController();
	if( mMorpherController )
	{
//		mpMorpherController->SetActive( false );
		mMorpherController->SetAlwaysUpdate( false );
//		mpMorpherController->Stop();

		StartMorpher();
	}

	/// 
	mActorManager->Update(0.0f);

	/// IDLE  ִϸ̼ .. (  IDLE  ϴ )
	InitializeRandomIdle();

	///  带 
	NiNode* n = mActorManager->GetNifRoot();
	if( n == 0 )
	{
		assert( 0 );
		return false;
	}

	///  ܰ ʱȭ
	param.mNiObject = n;
	if( cSceneNode::Init( param ) == false )
	{
		return false;
	}

	///  Ӽ  
	NiAlphaProperty* alphaProp = (NiAlphaProperty*)n->GetProperty( NiProperty::ALPHA );

	if( alphaProp == 0 )
	{
		alphaProp = NiNew NiAlphaProperty;
		alphaProp->SetAlphaBlending( false );
		alphaProp->SetAlphaTesting( false );
		n->AttachProperty( alphaProp );
	}

	/// Ӽ 
	bool blendEnabled = alphaProp->GetAlphaBlending();
	bool testEnabled = alphaProp->GetAlphaTesting();
	NiAlphaProperty::TestFunction testFunc = alphaProp->GetTestMode();
	unsigned char testRef = alphaProp->GetTestRef();
	mAlphaDataList.PushBack( cAlphaData( blendEnabled, testEnabled, testFunc, testRef, alphaProp ) );

	NiAmbientLight* amb = FindAmbientLight( n );
	if( amb )
		n->DetachChild( amb );

//	FindLight( n );
	CollectProperties( n );

	/// picking ͸  Ѵ.
	CollectPickData( mNiObject );

	mPick.SetPickType( NiPick::FIND_FIRST );
	mPick.SetIntersectType( NiPick::TRIANGLE_INTERSECT );
	mPick.SetSortType( NiPick::NO_SORT );
	mPick.SetFrontOnly( false );

	///  
	n->AttachEffect( SCENEMAN->GetAmbientLight( 1 ) );
	n->AttachEffect( SCENEMAN->GetDirLight( 1 ) );

	/// Ȱ Ӽ 
	//n->AttachProperty( SCENEMAN->GetFogProperty() );

	/// 
	bool selectiveUpdate = true;
	bool rigid = false;
	n->SetSelectiveUpdateFlags( selectiveUpdate, true, rigid );

	n->Update( 0.0f );
	n->UpdateProperties();
	n->UpdateEffects();
	n->UpdateNodeBound();

	mRadius = cSceneNode::GetRadius();

	///// ǥø  ü 
	//if( param.mCreateNameCard )
	//{
	//	mpNameCard = CreateNameCard( mpGameObject );
	//	assert(mpNameCard);
	//}

#ifdef MAP_EDITOR
	/// ׸ ϸ 
	if( param.mUseShadow )
	{
		assert( mShadowGeom == 0 );
		mShadowGeom = new cShadowGeometry();
		if( mShadowGeom->Init( RESOURCEMAN->GetShadowTexture(), 140.0f ) == false )
		{
			assert( 0 );
			return false;
		}
	}
#endif
	return true;
}

void cDynamicSceneNode::SetTargetAnimation( unsigned int code )
{
	if( mTargetAnimation != code )
	{
		if( mActorManager->SetTargetAnimation( code ) == false )
			return;

		mTargetAnimation = code;
	}
}

bool cDynamicSceneNode::UpdateTargetAnimation( unsigned int code )
{
	if( mTargetAnimation != code )
	{
		if( mActorManager->SetTargetAnimation( code ) == false )
			return false;

		mTargetAnimation = code;
		return true;;
	}

	return mActorManager->UpdateTargetAnimation( code );
}

/* ------------------------------------------------------------------
* Լ̸ :	ChangeParts( unsigned int index, NiNode* pObj )
*      :	Ʈ üϴµ 
* ǻ :	LOD  ׽Ʈ ´ ƴϴ. ( !!)
*				Ų   ſ Ư  ؾѴ.
* ------------------------------------------------------------------ */
bool cDynamicSceneNode::ChangeParts( unsigned int partsIdx, NiNode* pNode )
{
	/// 1.  Ʈ   Ѵ.
	NiAVObject* pOldNode = mActorManager->GetParts( partsIdx );
	if( !pOldNode )
	{
		///    Keep  ִ üũѴ.
		pOldNode = mActorManager->GetKeepParts( partsIdx );
		if( !pOldNode )
		{
			assert(0);
			return false;
		}
	}

	/// Geomü ȹѴ.
	NiTriBasedGeom* pOldGeom = 0;
	if( NiIsKindOf(NiTriBasedGeom, pOldNode) )
	{
		pOldGeom = (NiTriBasedGeom*)pOldNode;
	}
	else
	{
		//pOldGeom = (NiTriBasedGeom*)GetGeom( pOldNode );
		pOldGeom = (NiTriBasedGeom*)GetGeom( (NiNode*)pOldNode );
	}

	if( !pOldGeom )
	{
		assert(0);
		return false;
	}

	/// Ų ȹ
	NiSkinInstance* pOldSkinInst = ((NiGeometry*)pOldGeom)->GetSkinInstance();
	assert(pOldSkinInst);
	if( !pOldSkinInst )
	{
		return false;
	}
	NiSkinData* pOldSkinData = pOldSkinInst->GetSkinData();
	assert(pOldSkinData);
	if( !pOldSkinData )
	{
		return false;
	}

	/// 2. ü Ǿ Ʈ   
	const char* partsName = 0;
	if( mPartsNameMap.GetAt( partsIdx, partsName) == false )
	{
		assert(0);
		return false;
	}

	/// ü ü Geomü 
	NiTriBasedGeom* pGeom = (NiTriBasedGeom*)GetGeom( pNode );
	assert(pGeom);
	if( !pGeom )
	{
		return false;
	}

	/// ü ü Ų
	NiSkinInstance* pSkinInst = pGeom->GetSkinInstance();
	assert(pSkinInst);
	if( !pSkinInst )
	{
		return false;
	}
	NiSkinData* pSkinData = pSkinInst->GetSkinData();
	assert(pSkinData);
	if( !pSkinData )
	{
		return false;
	}

	/// üǾ Bone
	NiAVObject*const* ppBones = pSkinInst->GetBones();
	assert(ppBones);
	if( !ppBones )
	{
		return false;
	}
	NiSkinData::BoneData* pBoneData = pSkinData->GetBoneData();
	assert(pBoneData);
	if( !pBoneData )
	{
		return false;
	}

	/// ο  Bone  Bone Hierachy Bone Node üѴ.
	/// ϳ ¿  ̹Ƿ   Ѵ.
	///  ü ü ü  ϵ   ´.
	/// !!    ,  ġ  ͷ ؾ Ѵ.
	/// (Ų ϴ ޸ ּҷ ̴.)
	unsigned int i;
	NiAVObject *pBone = 0;
	NiAVObject *pNewBone = 0;
	NiTPrimitiveSet<NiAVObject*> newBones;
	NiTPrimitiveSet<sBoneDataObj*> newBoneDataObjs;
	sBoneDataObj* pBoneDataObj = 0;

	NiAVObject* pRoot= mActorManager->GetNifRoot();
	for( i=0; i<pSkinData->GetBoneCount(); ++i )
	{
		pBone = ppBones[i];
		if( !pBone )
		{
			continue;
		}

		pNewBone = (NiAVObject*)pRoot->GetObjectByName( pBone->GetName() );
		if( !pNewBone )
		{
			continue;
		}

		newBones.Add( pNewBone );
		pBoneDataObj = NiNew sBoneDataObj;
		pBoneDataObj->pBoneData = &pBoneData[i];
		for( unsigned int k = 0; k < pBoneData[i].m_usVerts; ++k )
		{
			pBoneDataObj->BoneVertData.Add( &pBoneData[i].m_pkBoneVertData[k] );
		}
		newBoneDataObjs.Add( pBoneDataObj );
	}

	/// Create the new arrays.
	unsigned int numNewBones = newBones.GetSize();
	NiAVObject** ppNewBones = NiAlloc(NiAVObject*, numNewBones);
	NiSkinData::BoneData* pNewBoneData = NiNew NiSkinData::BoneData[numNewBones];

	/// Fill the new arrays.
	for( i = 0; i<numNewBones; ++i )
	{
		ppNewBones[i] = newBones.GetAt( i );

		pBoneDataObj = newBoneDataObjs.GetAt( i );
		pNewBoneData[i].m_kBound = pBoneDataObj->pBoneData->m_kBound;
		pNewBoneData[i].m_kSkinToBone = pBoneDataObj->pBoneData->m_kSkinToBone;

		///   ƴ,  üũ Ѵ!!
		assert( pBoneDataObj->BoneVertData.GetSize() < (unsigned int) (unsigned short) ~0 );
		pNewBoneData[i].m_usVerts = (unsigned short)pBoneDataObj->BoneVertData.GetSize();
		pNewBoneData[i].m_pkBoneVertData = NiNew NiSkinData::BoneVertData[pNewBoneData[i].m_usVerts];

		for ( unsigned short k = 0; k<pNewBoneData[i].m_usVerts; ++k )
		{
			pNewBoneData[i].m_pkBoneVertData[k].m_fWeight = pBoneDataObj->BoneVertData.GetAt( k )->m_fWeight;
			pNewBoneData[i].m_pkBoneVertData[k].m_usVert = pBoneDataObj->BoneVertData.GetAt( k )->m_usVert;
		}
	}

	/// Create the new NiSkinData and NiSkinInstance objects.
	NiSkinData* pNewSkinData = NiNew NiSkinData( numNewBones, pNewBoneData, 
		pSkinData->GetRootParentToSkin(), pGeom->GetVertices() );
	pNewSkinData->SortAndMergeBoneData();
	NiSkinInstance* pNewSkinInst = NiNew NiSkinInstance( pNewSkinData,
		pOldSkinInst->GetRootParent(), ppNewBones );

	/// Delete allocated memory.
	for( i = 0; i< newBoneDataObjs.GetSize(); ++i )
	{
		NiDelete newBoneDataObjs.GetAt( i );
	}

	/// Clone Object ִ Bone Root Ѵ.
//	pNode->DetachChild( pNode->GetObjectByName("Bip01") );
	pNode->DetachChild( pNode->GetObjectByName("foot_dummy") );

	/// Skin Instance 
	pGeom->SetSkinInstance( pNewSkinInst );

	/// ο ü ٲ۴.
	mActorManager->ChangePartsObject( partsIdx, pNode );

	/// Bone LOD  ..
	NiBoneLODController* pOldCtrl = 0;
	pOldCtrl = mActorManager->GetBoneLODController();
	if( pOldCtrl )
	{
		int curLOD = pOldCtrl->GetBoneLOD();
		pOldCtrl->ProcessScene( mActorManager->GetNifRoot() );
		pOldCtrl->ReplaceSkin( pOldGeom, pGeom );

		mActorManager->RefreshControllerManager();

		NiBoneLODController* pNewCtrl = mActorManager->GetBoneLODController();
		pNewCtrl->SetBoneLOD( curLOD );
	}

	///   
	RecollectGeoms();

	if( partsIdx == 1 /* ePART_FACE */ )
	{
		NiGeomMorpherController* n = mActorManager->GetMorpherController();
		if( mMorpherController != n )
		{
			mMorpherController = n;
			if( mMorpherController )
			{
				mMorpherController->SetAlwaysUpdate( false );

				mMorpherController->Start();
				mMorpherController->SetManagerControlled( false );
			}
		}
	}
	return true;
}

bool cDynamicSceneNode::ChangePartsTexture( unsigned int partsIdx, NiTexture* pTex )
{
	/// 1.  Ʈ   Ѵ.
	NiAVObject* pNode = mActorManager->GetParts( partsIdx );
	if( pNode && pTex )
	{
		//NiAVObject* pGeom = GetGeom( pNode );
		NiAVObject* pGeom = GetGeom( (NiNode*)pNode );

		if( pGeom )
		{
			NiTexturingProperty* pProperty = (NiTexturingProperty*)pGeom->GetProperty( NiProperty::TEXTURING );
			if( pProperty )
			{
				pProperty->SetBaseTexture( pTex );
				pGeom->UpdateProperties();
				return true;
			}
		}
	}

	return false;
}

/* ------------------------------------------------------------------
* Լ̸ :	KeepParts( unsigned int index )
*      :	 ѹ  ΰ Ʈ ϴ ü ؼ .
* ǻ :	
* ------------------------------------------------------------------ */
void cDynamicSceneNode::KeepParts( unsigned int partIdx )
{
	/// Ʈ  󿡼 ŵǰ
	///   ϰ ȴ.
	mActorManager->KeepPartsObject( partIdx );
}

/* ------------------------------------------------------------------
* Լ̸ :	LinkObject( unsigned int index, NiNode* pObj )
*      :	⸦ Ư̿ ũ Ų.
* ǻ :	ϵǴ ε Ȱؼ ŵǹǷ  ޾Ƽ Ұ..
* ------------------------------------------------------------------ */
unsigned int cDynamicSceneNode::LinkObject( unsigned int dummyIdx, NiNode* pNode )
{
	/// Parts Name.. ߸ ε üũ
	const char* partsName = 0;
	if( mPartsNameMap.GetAt( dummyIdx, partsName ) == false )
	{
		assert(0);
		return UINT_MAX;
	}

	/// ũ  ü ȹ..
//	NiGeometry* pGeom = (NiGeometry*)GetGeom( pNode );
//	assert(pGeom);
//	if( pGeom == 0 )
//	{
//		assert(0);
//		return UINT_MAX;
//	}
	NiNode* pobj = NiDynamicCast(NiNode, CollectTestData( pNode ));
	if( pobj == 0 )
	{
		assert(0);
		return UINT_MAX;
	}

	/// ũų ġ ü ȹ..
	NiNode* pDummy = (NiNode*)mActorManager->GetNifRoot()->GetObjectByName( partsName );
	assert(pDummy);
	if( pDummy == 0 )
	{
		assert(0);
		return UINT_MAX;
	}

	/// ü 纻 ..
	NiCloningProcess cloning;
	cloning.m_eCopyType = NiObjectNET::COPY_EXACT;
//	NiGeometry* pNewObj = NiDynamicCast( NiGeometry, pGeom->Clone( cloning ) );
	NiNode* pNewObj = NiDynamicCast( NiNode, pobj->Clone( cloning ) );
	assert(pNewObj);
	if( pNewObj == 0 )
	{
		assert(0);
		return UINT_MAX;
	}

	pNewObj->SetTranslate( 0.0f, 0.0f, 0.0f );

	///  ũ..
	pDummy->AttachChild( pNewObj );

	/// 
	pNewObj->Update(0.0f);
	pNewObj->UpdateProperties();
	pNewObj->UpdateEffects();

	NiNode* pRoot = (NiNode*)(NiAVObject*)mNiObject;
	pRoot->UpdateNodeBound();

	/// ũ  Է..
	sLinkInfo* pkInfo = NiNew sLinkInfo;
	pkInfo->DummyIndex = dummyIdx;
	pkInfo->pObject = pNewObj;

	unsigned int linkIdx = mLinkInfo->Add( pkInfo );

	///   
	RecollectGeoms();

	return linkIdx;
}

/* ------------------------------------------------------------------
* Լ̸ :	UnLinkObject( unsigned int index )
*      :	 ũ ü Ѵ.
* ǻ :	
* ------------------------------------------------------------------ */
void cDynamicSceneNode::UnLinkObject( unsigned int linkIdx )
{
	if( linkIdx == UINT_MAX )
	{
		return;
	}

	sLinkInfo* pInfo = mLinkInfo->GetAt( linkIdx );
	if( pInfo == 0 )
	{
		assert(0);
		return;
	}

	const char* partsName = 0;
	if( mPartsNameMap.GetAt( pInfo->DummyIndex, partsName ) == false )
	{
		assert(0);
		return;
	}

	/// ũ ̸ ã´.
	NiNode* pDummy = (NiNode*)mActorManager->GetNifRoot()->GetObjectByName( partsName );
	if( pDummy == 0 )
	{
		assert(0);
		return;
	}

	/// 
//	pDummy->GetParent()->DetachChild( pInfo->pObject );
	pDummy->DetachChild( pInfo->pObject );
	mLinkInfo->RemoveAt( linkIdx );
	SAFE_NIDELETE(pInfo);

	NiNode* pRoot = (NiNode*)(NiAVObject*)mNiObject;
	pDummy->Update(0.0f, false);
	pRoot->UpdateNodeBound();

	///   
	RecollectGeoms();
}

NiAVObject*	cDynamicSceneNode::GetLinkObject( unsigned int linkId )
{
	if( linkId == UINT_MAX ) return 0;

	sLinkInfo* pInfo = mLinkInfo->GetAt( linkId );
	if( pInfo )
	{
		return pInfo->pObject;
	}
	return 0;
}

//cEffectSceneNode* cDynamicSceneNode::LinkEffect( unsigned int dummyIdx, const char* fileName, NiTransform* trans, bool bLoop, bool bFollow )
//{
//	/// Parts Name.. ߸ ε üũ
//	const char* partsName = 0;
//	if( mPartsNameMap.GetAt( dummyIdx, partsName ) == false )
//	{
//		return 0;
//	}
//
//	/// ũų ġ ü ȹ..
//	NiNode* pDummy = (NiNode*)mActorManager->GetNifRoot()->GetObjectByName( partsName );
//	if( pDummy == 0 )
//	{
//		return 0;
//	}
//
//	cEffectSceneNodeParam param;
//	param.mpFollowSceneNode = this;
//	param.mpDummy = pDummy;
//	param.mPathName = fileName;	
//
//	if( trans != 0 )
//	{
//		param.mTranslate = trans->m_Translate;
//		param.mRotate = trans->m_Rotate;
//		param.mScale = trans->m_fScale;
//	}
//	param.mFollowing = bFollow;
//	param.mLooping = bLoop;
//
//	cEffectSceneNode* pnode = SCENEMAN->CreateEffect( param );
//	if( pnode )
//		mEffectList.AddTail(pnode);
//
//	NiNode* pRoot = (NiNode*)(NiAVObject*)mNiObject;
//	pRoot->UpdateNodeBound();
//
//	return pnode;
//}
//
//cEffectSceneNode* cDynamicSceneNode::LinkDamage( unsigned int dummyIdx, const char* fileName, NiTransform* trans, bool bLoop, bool /*bFollow*/ )
//{
//	/// Parts Name.. ߸ ε üũ
//	const char* partsName = 0;
//	if( mPartsNameMap.GetAt( dummyIdx, partsName ) == false )
//	{
//		return 0;
//	}
//
//	/// ũų ġ ü ȹ..
//	NiNode* pDummy = (NiNode*)mActorManager->GetNifRoot()->GetObjectByName( partsName );
//	if( pDummy == 0 )
//	{
//		return 0;
//	}
//
//	cEffectSceneNodeParam param;
//	param.mpFollowSceneNode = this;
//	param.mpDummy = pDummy;
//	param.mPathName = fileName;	
//
//	if( trans != 0 )
//	{
//		param.mTranslate = trans->m_Translate;
//		param.mRotate = trans->m_Rotate;
//		param.mScale = trans->m_fScale;
//	}
//	param.mFollowing = false;//bFollow;
//	param.mLooping = bLoop;
//
//	cEffectSceneNode* pnode = SCENEMAN->CreateDamageEffect( param );
//	if( pnode )
//		mEffectList.AddTail(pnode);
//
//	NiNode* pRoot = (NiNode*)(NiAVObject*)mNiObject;
//	pRoot->UpdateNodeBound();
//
//	return pnode;
//}
//
///// ǻ :
//void cDynamicSceneNode::UnLinkEffect( cEffectSceneNode* pnode )
//{
//	assert(pnode);
//	if( pnode == 0 )
//		return;
//
//	SCENEMAN->AddDeleteEffectNode( pnode );
//	mEffectList.Remove( pnode );
//}
//
//bool cDynamicSceneNode::IsLinkedEffect( cEffectSceneNode* pnode )
//{
//	return (!mEffectList.FindPos( pnode ))? false:true;
//}
//
//cSoundSceneNode* cDynamicSceneNode::LinkSound( unsigned long soundIdx, bool bLoop )
//{
//	///  ġ ü ȹ..
//	NiNode* pDummy = (NiNode*)mActorManager->GetNifRoot()->GetObjectByName( "body_dummy");
//	if( pDummy == 0 )
//	{
//		return 0;
//	}
//
//	sSoundInfo* pInfo = SOUNDSYS->GetSoundInfo( soundIdx );
//	if( pInfo == 0 )
//		return 0;
//
//	cSoundSceneNodeParam param;
//	if( pInfo->mRadius <= 0.0f )
//	{
//		param.mRadius = 100.0f;
//	}
//	else
//	{
//		param.mRadius = pInfo->mRadius;
//	}
//	param.mLoopCount = bLoop? 0:1;
//	param.mVolumeRatio = pInfo->mVolume;
//
//	/// ⺻ Ӽ ڵ 
//	param.mPathName = pInfo->mFileName;
//	param.mTranslate = pDummy->GetWorldTranslate();
//	param.mManaged = true;
//	param.mpOwnerSceneNode = this;
//
//	cSoundSceneNode* pnode = SCENEMAN->CreateEffectSound( param );
//	if( pnode )
//		mSoundList.AddTail(pnode);
//
//	return pnode;
//}
//
//void cDynamicSceneNode::UnLinkSound( cSoundSceneNode* pnode )
//{
//	assert(pnode);
//	if( pnode == 0 )
//		return;
//
//	SCENEMAN->AddDeleteSoundNode( pnode );
//	mSoundList.Remove( pnode );
//}
//
//bool cDynamicSceneNode::IsLinkedSound( cSoundSceneNode* pnode )
//{
//	return (!mSoundList.FindPos( pnode ))? false:true;
//}

///
void cDynamicSceneNode::StartMorpher()
{
	mStopMorpherProcess = false;
}

///
void cDynamicSceneNode::StopMorpher()
{
	mStopMorpherProcess = true;
}

///
//void cDynamicSceneNode::CreateShadow()
//{
//}

///
//void cDynamicSceneNode::AddToVisibleArray( NiVisibleArray* psolidArray, NiVisibleArray* pskinedArray, NiVisibleArray* palphaArray ) const
//{
//	cSceneNode::AddToVisibleArray( psolidArray, pskinedArray, palphaArray );
//
//	///  ̸ǥ 
//	//AddDepthPlaneObject();
//
//	/// ׸ڿ      ü ߰
//}
//
/////
//void cDynamicSceneNode::AddDepthPlaneObject() const
//{
//	/// ǳ ̱ 
//	if( mpChatBubble && mpChatBubble->IsActive() )
//	{
//		/// ǳ 
//		SCENEMAN->AddPlane( mpChatBubble );
//		return;
//	}
//
//	if( mHead == 0 )
//	{
////		assert( 0 );
//		return;
//	}
//
//	NiPoint3 headPos = mHead->GetWorldTranslate();
//	headPos.z += mHeadDist;
//
//	if( mpNameCard )
//	{
//		mpNameCard->OnUpdate( CAMERAMAN->GetCurrentNi(), headPos );
//
//		SCENEMAN->AddDepthPlane( mpNameCard );
//	}
//}
//
/////
//void cDynamicSceneNode::ActiveChatBubble( LPTSTR msg, unsigned long color )
//{
//	if( mpChatBubble )
//		mpChatBubble->Active( msg, color );
//}
//
//void cDynamicSceneNode::UpdateNameCardTextValue()
//{
//	if( mpNameCard )
//		mpNameCard->ChangeTextValue();
//}
//
//void cDynamicSceneNode::UpdateNameCardGaugeValue()
//{
//	if( mpNameCard )
//		mpNameCard->ChangeGaugeValue();
//}

void cDynamicSceneNode::AddToVisibleArray( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray ) const
{
	cSceneNode::AddToVisibleArray( solidArray, skinedArray, alphaArray );

#ifdef MAP_EDITOR
	if( mRibbonGeom && mRibbonGeom->GetNumVerts() >= 4 )
	{
		mRibbonGeom->SetCenter( GetCenter() );
		alphaArray->Add( *mRibbonGeom );
	}
#endif
}

void cDynamicSceneNode::FindLight( NiAVObject* obj )
{
	if( NiIsKindOf( NiAmbientLight, obj ) )
	{
		mAmbientLight = (NiAmbientLight*)obj;
		SetAmbientLightAmbient( SCENEMAN->GetAmbientLight(1)->GetAmbientColor() );
		SetAmbientLightDiffuse( SCENEMAN->GetAmbientLight(1)->GetDiffuseColor() );
		SetAmbientLightDimmer( SCENEMAN->GetAmbientLight(1)->GetDimmer() );
	}
	else if( NiIsKindOf( NiNode, obj ) )
	{
		NiNode* node = (NiNode*)obj;

		for( unsigned int i = 0, iend = node->GetArrayCount(); i < iend; ++i )
		{
			NiAVObject* child = node->GetAt( i );
			if( child )
				FindLight( child );
		}
	}
}

void cDynamicSceneNode::RecollectGeoms()
{
	mGeomList.Clear();
	CollectGeoms( mNiObject );
}

void cDynamicSceneNode::CollectPickData( NiAVObject* pobj )
{
	if( pobj->GetName() == "PickObj" )
	{
		mPickDataList.PushBack( pobj );
		return;
	}

	if( NiIsKindOf(NiNode, pobj) )
	{
		NiNode* node = (NiNode*)pobj;
		for( unsigned int i = 0, end = node->GetArrayCount(); i < end; ++i )
		{
			NiAVObject* child = node->GetAt(i);
			if( child )
				CollectPickData( child );
		}
	}
}

bool cDynamicSceneNode::Pick( const cRay& ray )
{
	if( mPickDataList.IsEmpty() )
	{
		return cSceneNode::Pick( ray );
	}

	if( mBoundSphere.IntersectRay( ray ) )
	{
		NiAVObject* obj = 0;
		cPickDataList::cConstIterator i = mPickDataList.Begin();
		cPickDataList::cConstIterator end = mPickDataList.End();

		for( ; i != end; ++i )
		{
			obj = (NiAVObject*)*i;
			mPick.SetTarget( obj );

			if( mPick.PickObjects( ray.GetOrigin(), ray.GetDirection() ) )
			{
				NiPick::Record* record = mPick.GetResults().GetAt(0);
				if( record )
				{
					mPickPos = record->GetIntersection();
					mPickDistance = record->GetDistance();
				}
				return true;
			}
		}
	}
	return false;
}

///  : scalefactor  
void cDynamicSceneNode::UpdateAniScaleFactor( float factor )
{
	if( factor <= 0.0f )
		factor = 0.1f;
	if( factor > 2.0f )
		factor = 2.0f;
	mScaleFactor = factor;
}

NiAVObject* cDynamicSceneNode::GetPartObject( unsigned int index ) const
{
	const char* partsName = 0;
	if( mPartsNameMap.GetAt( index, partsName ) == false )
	{
		return 0;
	}

	/// ũų ġ ü ȹ..
	return mActorManager->GetNifRoot()->GetObjectByName( partsName );
}

NiAVObject* cDynamicSceneNode::CollectTestData( NiNode* pobj )
{
	if( pobj->GetChildCount() == 1 )
	{
		if( NiIsKindOf( NiGeometry, pobj->GetAt(0) ) )
		{
			pobj->GetAt(0)->SetTranslate( 0.0f, 0.0f, 0.0f );
			return pobj;
		}

		NiAVObject* p = pobj->GetAt(0);
		if( NiIsKindOf(NiNode, p) )
		{
			return CollectTestData( (NiNode*)p );
		}
	}

	return pobj;
}

void cDynamicSceneNode::GotoLastFrame()
{
	NiControllerSequence* p = mActorManager->GetSequence( mActorManager->GetTargetAnimation() );
	if( p )
	{
		float time = 0.0f;
		time = p->GetEndKeyTime();

		if( time != NiControllerSequence::INVALID_TIME )
			mActorManager->Update( -time );
	}
}

float cDynamicSceneNode::GetRadius() const
{
	return mRadius;
}

void cDynamicSceneNode::SetAmbientLightAmbient( const NiColor& color )
{
	if( mAmbientLight )
		mAmbientLight->SetAmbientColor( color );
}

void cDynamicSceneNode::SetAmbientLightDiffuse( const NiColor& color )
{
	if( mAmbientLight )
		mAmbientLight->SetDiffuseColor( color );
}

void cDynamicSceneNode::SetAmbientLightDimmer( float dimmer )
{
	if( mAmbientLight )
		mAmbientLight->SetDimmer( dimmer );
}

NiAmbientLight* cDynamicSceneNode::FindAmbientLight( NiAVObject* obj )
{
	if( NiIsKindOf( NiAmbientLight, obj ) )
	{
		return (NiAmbientLight*)obj;
	}
	else if( NiIsKindOf( NiNode, obj ) )
	{
		NiAVObject* child = 0;
		NiNode* node = (NiNode*)obj;

		for( unsigned int i = 0, iend = node->GetArrayCount(); i < iend; ++i )
		{
			child = node->GetAt( i );
			if( child )
			{
				NiAmbientLight* amb = FindAmbientLight( child );
				if( amb )
					return amb;
			}
		}
	}
	return 0;
}


#ifdef MAP_EDITOR
cRibbonGeometry* cDynamicSceneNode::CreateRibbonGeom( unsigned int maxVerts, float pushInterval, float alphaInterval, float alphaFactor )
{
	mRibbonGeom = NiNew cRibbonGeometry;
	mRibbonGeom->Init( maxVerts, pushInterval, alphaInterval, alphaFactor );

	return mRibbonGeom;
}
#endif
