/* ==========================================================================
*    : ̼
*    : 2006.12.20
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"
#include "ActorManagerForPartition.h"

#define SAFE_DELETE(x) if(x) { delete x; x = 0; }
#define SAFE_DELETE_ARRAY(x) if(x) { delete[] x; x = 0; }
#define SAFE_RELEASE(x) if(x) { x->Release(); x = 0; }
#define SAFE_NIDELETE(x) if(x) { NiDelete x; x = 0; }
#define SAFE_EXIT_DELETE(x) if(x) { x->Exit(); delete x; x = 0; }

class cRibbonGeometry;
class cShadowGeometry;
//class cEffectSceneNode;
//class cSoundSceneNode;
//class cObjectNameCard;
//class cChatBubble;
//class cBaseObject;

///    
class cDynamicSceneNodeParam : public cSceneNodeParam
{
public:
	cDynamicSceneNodeParam();

public:
	bool mUseShadow;
};

inline cDynamicSceneNodeParam::cDynamicSceneNodeParam()
: mUseShadow( true )
{
}

///   
class cDynamicSceneNode : public cSceneNode
{
	friend class cSceneManager;

public:
	/// ó
	virtual void Process( float deltaTime, float accumTime );
	virtual bool OnVisible( cSceneCuller& culler );

	virtual bool Pick( const cRay& ray );

	/// ̵
	virtual bool Move( float /*x*/, float /*y*/ ) { return true; }

	///  ü ٲ۴. ( ü ο ü üѴ.)
	virtual bool			ChangeParts( unsigned int /*partIdx*/, const char* /*fileName*/ ) { return true; }
	virtual bool			ChangeParts( unsigned int partsIdx, NiNode* pNode );

	virtual bool			ChangePartsTexture( unsigned int /*partsIdx*/, const char* /*fileName*/ ) { return true; }
	virtual bool			ChangePartsTexture( unsigned int /*partsIdx*/, NiTexture* /*pTex*/ );

	/// ̿ ü ũ ũ Ѵ. ( ߰  )
	virtual unsigned int	LinkObject( unsigned int /*dummyIdx*/, const char* /*fileName*/ ) { return UINT_MAX; }
	virtual unsigned int	LinkObject( unsigned int dummyIdx, NiNode* pNode );

	/// ũ
	void					UnLinkObject( unsigned int linkIdx );
	NiAVObject*				GetLinkObject( unsigned int linkId );

	/// 
	void	UpdateAniScaleFactor( float factor );

	///  ü
	virtual NiAVObject*		GetPartObject( unsigned int index ) const;
	virtual NiAVObject*		GetPartWeapon( unsigned int /*objectIdx*/, bool /*left*/ ) { return 0; }

	///  ڸ 
	inline cActorManagerForPartition* GetActorManager() { return mActorManager; }

	///  ִϸ̼
	cActorManagerForPartition::EventCode GetTargetAnimation() const { return mTargetAnimation; }
	virtual void SetTargetAnimation( unsigned int code );
	bool UpdateTargetAnimation( unsigned int code );

	/// ü  Morpher ϱ ؼ..
	void StartMorpher();
	void StopMorpher();

	/// 
	void GotoLastFrame();

	/// 
	void FindLight( NiAVObject* obj );
	void SetAmbientLightAmbient( const NiColor& color );
	void SetAmbientLightDiffuse( const NiColor& color );
	void SetAmbientLightDimmer( float dimmer );

	NiAmbientLight* FindAmbientLight( NiAVObject* obj );

	/// 
	virtual float GetRadius() const;

#ifdef MAP_EDITOR
	/// 
	cRibbonGeometry* CreateRibbonGeom( unsigned int maxVerts, float pushInterval, float alphaInterval, float alphaFactor = 1.0f );
#endif

protected:
	cDynamicSceneNode( eSceneNodeType type = SCENENODE_DYNAMIC );
	virtual ~cDynamicSceneNode();

	/// ʱȭ
	virtual bool Init( const cDynamicSceneNodeParam& param );

	virtual void RecollectGeoms();

	/// picking  ڽ, , Ǹ ü .
	void CollectPickData( NiAVObject* pobj );

	NiAVObject* CollectTestData( NiNode* pobj );

	/// ũ  ʱȭ Ѵ.
	virtual bool InitLinkInfo() = 0;

	///   ʱȭ Ѵ.
	virtual bool InitPartsName() = 0;

	/// Idleִϰ   ʱȭ Ѵ.
	virtual void InitializeRandomIdle() {}

	/// е带  ̴ 쿡 ó (ü ó ..)
	virtual void	UpdateBipedRootTransforms( float /*time*/ ) {}

	/// ü  Ѵ.
	void			KeepParts( unsigned int partIdx );

	///  Ʈ  迭 ߰
	void AddToVisibleArray( NiVisibleArray* solidArray, NiVisibleArray* skinedArray, NiVisibleArray* alphaArray ) const;

protected:
	struct sBoneDataObj : public NiMemObject
	{
		///  
		NiSkinData::BoneData* pBoneData;

		///   
		NiTPrimitiveSet<NiSkinData::BoneVertData*> BoneVertData;
	};

	struct sLinkInfo : public NiMemObject
	{
		///  ε
		unsigned int DummyIndex;

		///  Geom  
		//		NiGeometry* pObject;
		NiAVObject* pObject;
	};

protected:
	///  
	cActorManagerForPartition* mActorManager;

	///  ִ ε
	cActorManagerForPartition::EventCode mTargetAnimation;

	///    
	NiGeomMorpherController* mMorpherController;
	float mEyeMorpherTime;
	bool mStopMorpherProcess;

	/// ũ ֱ
	float mWinkInterval;

	/// Idleִ 
	NiTPrimitiveArray<cActorManagerForPartition::EventCode>* mRandomIdle;

	///  ̿ LinkǾ ü 
	NiTPrimitiveArray<sLinkInfo*>* mLinkInfo;

	///  ɷ ִ Effect 
	//NiTPointerList<cEffectSceneNode*> mEffectList;
	//NiTPointerList<cSoundSceneNode*> mSoundList;

	///  Ʈ Geomü ̸ (׷ ۽  ̸ Ѵ.)
	NiTPointerMap<unsigned int, const char*> mPartsNameMap;

	/// ü   
	NiAVObject*		mHead;
	float			mHeadDist;

	/// ü  ǥϱ  ü
	//cObjectNameCard*		mpNameCard;

	/// ǳ
	//cChatBubble*			mpChatBubble;

	typedef tList<void*> cPickDataList;
	cPickDataList mPickDataList;

private:
	/// ִ ӵ 
	float	mScaleAccumTime;
	float	mLastTime;
	float	mScaleFactor;

	/// ִϸ̼ ε ϱ    ´.
	cModelInstance* mModel;

	///  ü  ( Ӱü ϴ ٸ)
	//cBaseObject*	mpGameObject;

	/// 
	float mRadius;

	/// 
	NiAmbientLight* mAmbientLight;

#ifdef MAP_EDITOR
	///  
	cRibbonGeometry* mRibbonGeom;

	/// ׸ 
	cShadowGeometry* mShadowGeom;
	bool mNeedUpdateShadow;
#endif /// MAP_EDITOR
};
