#include "StdAfx.h"
#include "gatheringscenenode.h"

#include "NaviMesh.h"
#include "NifAnimationInfo.h"

cGatheringSceneNode::cGatheringSceneNode( eSceneNodeType type )
: cStaticSceneNode( type )
, mGatheringIdx(UINT_MAX)
, mAppendZ(0.0f)
{
}

cGatheringSceneNode::~cGatheringSceneNode()
{
}

bool cGatheringSceneNode::Init( cGatheringSceneNodeParam& param )
{
	if( param.mGatheringIdx == UINT_MAX )
	{
		assert(0);
		return false;
	}

	///   ޴´.
	mGatheringIdx = param.mGatheringIdx;
	mAppendZ = param.mAppandZ;

	float height = 0.0f;
	NAVIMESH->CalcHeight( &height, param.mTranslate.x, param.mTranslate.y );
	param.mTranslate.z = height + mAppendZ;

	if( cStaticSceneNode::Init( param ) == false )
		return false;

	return true;
}

void cGatheringSceneNode::Process( float deltaTime, float accumTime )
{
	/// ݺ     带 ó
	if( mNifAniInfo )
	{
		mNeedUpdateTransform = true;
		mNifAniInfo->Update( accumTime );
	}

	cSceneNode::Process( deltaTime, accumTime );

	if( mAlpha < 0.000001f )
		mCheckFrustum = false;
	else
		mCheckFrustum = true;
}

void cGatheringSceneNode::SetTranslate( const NiPoint3& trans )
{
	NiPoint3 pos = trans;
	pos.z += mAppendZ;
	mNiObject->SetTranslate( pos );

	mNeedUpdateTransform = true;
}
