#pragma once
#include "staticscenenode.h"


class cGatheringSceneNodeParam : public cStaticSceneNodeParam
{
public:
	cGatheringSceneNodeParam();

public:

	///   ε
	unsigned long	mGatheringIdx;
	float			mAppandZ;
};

inline cGatheringSceneNodeParam::cGatheringSceneNodeParam()
: mGatheringIdx(UINT_MAX)
, mAppandZ(0.0f)
{
}


class cGatheringSceneNode : public cStaticSceneNode
{
	friend class cSceneManager;

public:
	inline float GetAppendZ() { return mAppendZ; }
	inline void SetAppendZ( float z ) { mAppendZ = z; }

	virtual void SetTranslate( const NiPoint3& trans );

protected:
	cGatheringSceneNode( eSceneNodeType type = SCENENODE_GATHERING );
	virtual ~cGatheringSceneNode();

	/// ʱȭ
	virtual bool Init( cGatheringSceneNodeParam& param );
	virtual void Process( float deltaTime, float accumTime );

protected:
	unsigned long mGatheringIdx;
	float mAppendZ;
};
