/* ==========================================================================
*    : ̼
*    : 2007.01.23
*      :   
* ǻ : 
*===========================================================================*/
#pragma once

#include "SceneNode.h"

class cTerrainLeafNode;

///    
class cLightSceneNodeParam : public cSceneNodeParam
{
public:
	cLightSceneNodeParam();

public:
	/// 
	float mRadius;

	/// ֺ
	NiColor mAmbient;

	/// 
	NiColor mDiffuse0;
	NiColor mDiffuse1;
	float mDiffuseAnimTime;
	bool mFlickering;

	/// ݻ
	NiColor mSpecular;

	///  
	float mConstantAtten0;
	float mConstantAtten1;
	float mConstantAttenAnimTime;
	float mLinearAtten;
	float mQuadricAtten;
};

inline
cLightSceneNodeParam::cLightSceneNodeParam()
: mRadius( 300.0f )
, mAmbient( NiColor::BLACK )
, mDiffuse0( NiColor::WHITE )
, mDiffuse1( NiColor::WHITE )
, mDiffuseAnimTime( 0.0f )
, mFlickering( false )
, mSpecular( NiColor::WHITE )
, mConstantAtten0( 0.0f )
, mConstantAtten1( 0.0f )
, mConstantAttenAnimTime( 0.0f )
, mLinearAtten( 0.0f )
, mQuadricAtten( 0.0f )
{
	mPickType = NiPick::FIND_FIRST;
	mPickSort = NiPick::NO_SORT;
	mPickIntersect = NiPick::BOUND_INTERSECT;
	mPickFrontOnly = false;
}

///   
class cLightSceneNode : public cSceneNode
{
	friend class cSceneManager;
	friend class cLightEditor;

public:
	/// ó
	void Process( float deltaTime, float accumTime );

	/// ŷ
	bool Pick( const cRay& ray );

	/// ߽
	const NiPoint3& GetCenter() const;

	/// 
	void SetRadius( float radius );
	float GetRadius() const;

	///  带 Ż
	void Attach( cSceneNode* node );
	void Detach( cSceneNode* node );
	void Detach( cTerrainLeafNode* node );
	void DetachAll();

	/// ֺ
	const NiColor& GetAmbient() const;

	/// 
	const NiColor& GetDiffuse() const;

	///  
	float GetConstantAtten() const;
	float GetLinearAtten() const;
	float GetQuadricAtten() const;

protected:
	cLightSceneNode( eSceneNodeType type = SCENENODE_LIGHT );
	virtual ~cLightSceneNode();

	/// 
	virtual bool Save( cFileSaver& saver );

	/// ʱȭ
	virtual bool Init( const cLightSceneNodeParam& param );

	/// ֺ
	void SetAmbient( const NiColor& color );

	/// 
	void SetDiffuse0( const NiColor& color );
	void SetDiffuse1( const NiColor& color );
	void SetDiffuseAnimTime( float time );
	const NiColor& GetDiffuse0() const;
	const NiColor& GetDiffuse1() const;
	float GetDiffuseAnimTime() const;

	/// ݻ籤
	void SetSpecular( const NiColor& color );
	const NiColor& GetSpecular() const;

	///  
	void SetConstantAtten0( float value );
	void SetConstantAtten1( float value );
	void SetConstantAttenAnimTime( float time );
	void SetLinearAtten( float value );
	void SetQuadricAtten( float value );
	float GetConstantAtten0() const;
	float GetConstantAtten1() const;
	float GetConstantAttenAnimTime() const;

protected:
	///  
	NiPointLightPtr mLight;

	/// 
	float mRadius;

	/// 
	NiColor mDiffuse0;
	NiColor mDiffuse1;
	float mDiffuseAnimTime;
	float mDiffuseTime;
	bool mDiffuseDir;
	bool mFlickering;

	/// 
	float mConstantAtten0;
	float mConstantAtten1;
	float mConstantAttenAnimTime;
	float mConstantAttenTime;
	bool mConstantAttenDir;

	/// ޴  V
	typedef tHashSet<cSceneNode*> cAffectedSet;
	cAffectedSet mAffectedSet;

	///   迭
	typedef tArray<cTerrainLeafNode*> cTerrainArray;
	cTerrainArray mTerrainArray;
};

inline
const NiPoint3& cLightSceneNode::GetCenter() const
{
	return mLight->GetWorldTranslate();
}

inline
void cLightSceneNode::SetRadius( float radius )
{
	mNeedUpdateTransform = true;
	mRadius = radius;
}

inline
float cLightSceneNode::GetRadius() const
{
	return mRadius;
}

inline
const NiColor& cLightSceneNode::GetAmbient() const
{
	return mLight->GetAmbientColor();
}

inline
const NiColor& cLightSceneNode::GetDiffuse() const
{
	return mLight->GetDiffuseColor();
}

inline
const NiColor& cLightSceneNode::GetDiffuse0() const
{
	return mDiffuse0;
}

inline
const NiColor& cLightSceneNode::GetDiffuse1() const
{
	return mDiffuse1;
}

inline
float cLightSceneNode::GetDiffuseAnimTime() const
{
	return mDiffuseAnimTime;
}

inline
const NiColor& cLightSceneNode::GetSpecular() const
{
	return mLight->GetSpecularColor();
}

inline
float cLightSceneNode::GetConstantAtten() const
{
	return mLight->GetConstantAttenuation();
}

inline
float cLightSceneNode::GetConstantAtten0() const
{
	return mConstantAtten0;
}

inline
float cLightSceneNode::GetConstantAtten1() const
{
	return mConstantAtten1;
}

inline
float cLightSceneNode::GetConstantAttenAnimTime() const
{
	return mConstantAttenAnimTime;
}

inline
float cLightSceneNode::GetLinearAtten() const
{
	return mLight->GetLinearAttenuation();
}

inline
float cLightSceneNode::GetQuadricAtten() const
{
	return mLight->GetQuadraticAttenuation();
}
