/* ==========================================================================
*    : ̼
*    : 2007.02.08
*      :   ī޶ Ŭ
* ǻ : 
*===========================================================================*/
#pragma once

#include "Camera.h"

///   ī޶
class cLookAtCamera : public cCamera
{
public:
	cLookAtCamera();
	virtual ~cLookAtCamera();

	/// 
	void SetLookAt( const NiPoint3& target );
	void SetLookAt( float x, float y, float z );
	const NiPoint3& GetLookAt() const;

	void SetLookAtDistance( float dist );
	float GetLookAtDistance() const;
	float GetDesiredLookAtDistance() const;

	///  
	bool GetNeedUpdate() const;

protected:
	/// ó
	virtual void Process( float deltaTime );
	virtual void ProcessInput( float deltaTime );

protected:
	///  ī޶  Ÿ
	float mDesiredLookAtDistance;
	float mLookAtDistance;

	/// 
	NiPoint3 mTargetLookAt;
	NiPoint3 mLookAt;

	/// ȸ
	float mTargetYawAngle;
	float mTargetPitchAngle;
	float mYawAngle;
	float mPitchAngle;

	///  
	bool mNeedUpdate;
};

inline
void cLookAtCamera::SetLookAt( const NiPoint3& target )
{
	mTargetLookAt = target;
}

inline
void cLookAtCamera::SetLookAt( float x, float y, float z )
{
	mTargetLookAt.x = x;
	mTargetLookAt.y = y;
	mTargetLookAt.z = z;
}

inline
const NiPoint3& cLookAtCamera::GetLookAt() const
{
	return mLookAt;
}

inline
void cLookAtCamera::SetLookAtDistance( float dist )
{
	mLookAtDistance = dist;
}

inline
float cLookAtCamera::GetLookAtDistance() const
{
	return mLookAtDistance;
}

inline
float cLookAtCamera::GetDesiredLookAtDistance() const
{
	return mDesiredLookAtDistance;
}

inline
bool cLookAtCamera::GetNeedUpdate() const
{
	return mNeedUpdate;
}
