/* ==========================================================================
*    : ̼
*    : 2007.01.03
*      : ׺ʵ
* ǻ : 
*===========================================================================*/
#pragma once

#include "Shader.h"

class cRay;
class cNaviFieldBranchNode;
class cNaviFieldLeafNode;
class cNaviFieldPaintDialog;
#ifdef MAP_EDITOR
class cNaviFieldPaintingInfo;
#endif

/// ׺ʵ 
const unsigned int NAVIFIELD_DEFAULT_RESOLUTION = 512;
const unsigned int NAVIFIELD_BUFF_CELL_COUNT = 128;
const unsigned int NAVIFIELD_BUFF_LINE_COUNT = NAVIFIELD_BUFF_CELL_COUNT + 1;
const unsigned int NAVIFIELD_BUFF_VERT_COUNT = NAVIFIELD_BUFF_LINE_COUNT * NAVIFIELD_BUFF_LINE_COUNT;
const unsigned int NAVIFIELD_LEAF_CELL_COUNT = 8;
const unsigned int NAVIFIELD_LEAF_LINE_COUNT = NAVIFIELD_LEAF_CELL_COUNT + 1;
const unsigned int NAVIFIELD_LEAF_LINE_COUNT_X2 = NAVIFIELD_LEAF_LINE_COUNT * 2;
const unsigned int NAVIFIELD_LEAF_VERT_COUNT = NAVIFIELD_LEAF_LINE_COUNT * NAVIFIELD_LEAF_LINE_COUNT;

/// ׺ʵ ε  ڵ
const int NAVIFIELD_LOAD_ERROR_OPEN = -1;
const int NAVIFIELD_LOAD_ERROR_FILE_HEADER = -2;
const int NAVIFIELD_LOAD_ERROR_FILE_TYPE = -3;
const int NAVIFIELD_LOAD_ERROR_FILE_VERSION = -4;
const int NAVIFIELD_LOAD_ERROR_GRID_SIZE = -5;
const int NAVIFIELD_LOAD_ERROR_TEXTURE_NAME = -6;
const int NAVIFIELD_LOAD_ERROR_TEXTURE = -7;
const int NAVIFIELD_LOAD_ERROR_NODE = -8;

/// ׺ʵ  
#pragma pack( push, 1 )
class cNaviFieldFileHeader
{
public:
	/// ĺ ڵ
	char mCode[14];

	/// 
	unsigned int mVersion;

	/// ׸ ũ ( )
	unsigned int mCellCount;

	///   
	float mMetersPerVertex;

	/// ʹ   ( 100 )
	unsigned int mUnitsPerMeter;
};
#pragma pack( pop )

/// ׺ʵ 
class cNaviFieldBuffer
{
	friend class cNaviField;
	friend class cNaviFieldLeafNode;

public:
	cNaviFieldBuffer();
	~cNaviFieldBuffer();

	bool Init( cNaviField* naviField, unsigned int xi, unsigned int yi );

protected:
	void UpdatePosCoord( cNaviField* naviField, unsigned int xstart, unsigned ystart, unsigned int count );
	void UpdateColor( cNaviField* naviField, unsigned int xstart, unsigned ystart, unsigned int count );

private:
	unsigned int mXIndex;
	unsigned int mYIndex;

	/// DX9
	LPDIRECT3DVERTEXBUFFER9 mPosCoordBuffer;
	LPDIRECT3DVERTEXBUFFER9 mColorBuffer;
};

/// ׺ʵ
class cNaviField
{
	static cNaviField* mSingleton;
	friend class cNaviFieldLeafNode;
	friend class cNaviFieldBuffer;
	friend class cNaviFieldPainting;

public:
	cNaviField();
	~cNaviField();

	/// 
	void Clear();

	/// ʱȭ
	void Init( unsigned int cellCount, float metersPerVertex = 1.0f, unsigned int unitsPerMeter = 100 );

	/// ε
	int Load( const cString& pathName );

	/// 
	bool Save( const cString& pathName );

	/// ó
	void Process();

	/// 
	void Render();

	/// 
	cNaviFieldBuffer* GetBuffer( unsigned int xi, unsigned int yi );

	/// ŷ
	bool Pick( NiPoint3* pos, int mouseX, int mouseY );
	bool Pick( NiPoint3* pos, const cRay& ray );

	/// ׺޽ÿ 
	void SyncAllToNaviMesh();

	///   
	bool CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float radius );

#ifdef MAP_EDITOR
	/// ĥ
	bool Color( const NiPoint3& pos, float radius, float red, float green, float blue, unsigned char value );
#endif

	/// ׸ ũ
	unsigned int GetCellCount() const;

	///  
	float GetMetersPerVertex() const;

	/// ʹ 
	unsigned int GetUnitsPerMeter() const;

	///   
	float GetUnitsPerVertex() const;

	/// ʵ尪
	unsigned char GetValue( unsigned int xi, unsigned int yi ) const;
	bool GetValue( unsigned char* value, unsigned int xi, unsigned int yi ) const;
	bool GetValue( unsigned char* value, const NiPoint3& pos ) const;

	/// ̰
	bool GetHeight( float* height, unsigned int xi, unsigned int yi ) const;
	bool GetHeight( float* height, const NiPoint3& pos ) const;

	/// 
	bool GetColor( NiColor* color, const NiPoint3& pos ) const;

	/// ׸ ũ
	unsigned int GetLeafGridSize() const;

	///  
	bool IsModified() const;

private:
#ifdef MAP_EDITOR
	/// 
	/// Undo, Redo ʿ  Ѵ.
	bool BackupPainting( cNaviFieldPaintingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float radius );

	/// 
	void UpdatePainting( cNaviFieldPaintingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float radius );
#endif

	/// ׸ ũ⸦ ˻
	bool CheckCellCount( unsigned int cellCount );

	/// ش ġ  带 
	void SetLeafNode( unsigned int xi, unsigned int yi, cNaviFieldLeafNode* node );

	/// ʵ尪
	void SetValue( unsigned int xi, unsigned int yi, unsigned char value );

	/// ̰
	float GetHeightFast( unsigned int xi, unsigned int yi ) const;

	/// 
	void SetColor( unsigned int xi, unsigned int yi, const NiColor& color );
	const NiColor& GetColorFast( unsigned int xi, unsigned int yi ) const;

	/// ε    false Ѵ.
	bool GetColor( NiColor* color, unsigned int xi, unsigned int yi );

public:
	/// ü 
	static cNaviField* GetSingleton();

private:
	/// ʱȭ 
	bool mInited;

	/// ׸ ũ
	unsigned int mCellCount;
	unsigned int mLineCount;

	///   ( 1 )
	float mMetersPerVertex;

	/// ʹ  ( 100 )
	unsigned int mUnitsPerMeter;

	///  
	float mUnitsPerVertex;

	///   
	float mUnitsPerLeafNode;

	/// Ʈ 
	cNaviFieldBranchNode* mRootNode;

	///   迭
	typedef tArray<cNaviFieldLeafNode*> cLeafNodeArray;
	cLeafNodeArray mNodeArray;

	/// ʵ尪 迭
	unsigned char** mpValues;
	unsigned char* mValues;

	///  迭
	float** mpHeights;
	float* mHeights;

	///  迭
	NiColor* mColors;

	///  迭
	cLeafNodeArray mVisibleArray;

	/// ̴
	cTerrainShader mShader;

	/// 
	cNaviFieldBuffer** mBuffer;

	/// DX9
	LPDIRECT3DVERTEXDECLARATION9 mVertexDeclaration;
	LPDIRECT3DINDEXBUFFER9 mIndexBuffer;

	///  
	bool mModified;
};

inline
cNaviFieldBuffer* cNaviField::GetBuffer( unsigned int xi, unsigned int yi )
{
	return &(mBuffer[yi / NAVIFIELD_BUFF_CELL_COUNT][xi / NAVIFIELD_BUFF_CELL_COUNT]);
}

inline
unsigned int cNaviField::GetCellCount() const
{
	return mCellCount;
}

inline
float cNaviField::GetMetersPerVertex() const
{
	return mMetersPerVertex;
}

inline
unsigned int cNaviField::GetUnitsPerMeter() const
{
	return mUnitsPerMeter;
}

inline
float cNaviField::GetUnitsPerVertex() const
{
	return mUnitsPerVertex;
}

inline
float cNaviField::GetHeightFast( unsigned int xi, unsigned int yi ) const
{
	return mHeights[yi * mLineCount + xi];
}

inline
const NiColor& cNaviField::GetColorFast( unsigned int xi, unsigned int yi ) const
{
	return mColors[yi * mLineCount + xi];
}

inline
bool cNaviField::IsModified() const
{
	return mModified;
}

inline
cNaviField* cNaviField::GetSingleton()
{
	return mSingleton;
}

#define NAVIFIELD cNaviField::GetSingleton()
