/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      : ׺ʵ 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Box.h"

class cRay;
class NiFrustumPlanes;
class cSceneNode;
class cNaviFieldBranchNode;
class cNaviFieldLeafNode;
class cNaviFieldBuffer;
#ifdef MAP_EDITOR
class cNaviFieldNodePaintingInfo;
class cNaviFieldNodePainting;
#endif

/// ׺ʵ 
class cNaviFieldNode
{
public:
	cNaviFieldNode( cNaviFieldBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int cellCount );
	virtual ~cNaviFieldNode();

	/// ȭ
	virtual void SyncHeight() = 0;

	/// ø
	virtual void Cull( tArray<cNaviFieldLeafNode*>* visibleArray, NiFrustumPlanes& frustum ) = 0;

	///  迭 ߰
	virtual void AddToVisibleArray( tArray<cNaviFieldLeafNode*>* visibleArray ) = 0;

	///   浹 ˻
	virtual bool CollideRay( NiPoint3* contact, float* distance, const cRay& ray ) = 0;

	///  ڸ 
	const cBox& GetBoundBox() const;

public:
	/// θ
	cNaviFieldBranchNode* mParent;

	///  
	cBox mBoundBox;
	NiPoint3 mCenter;
	float mRadius;
};

inline
const cBox& cNaviFieldNode::GetBoundBox() const
{
	return mBoundBox;
}

/// ׺ʵ  
class cNaviFieldBranchNode : public cNaviFieldNode
{
	friend class cNaviFieldLeafNode;

public:
	cNaviFieldBranchNode( cNaviFieldBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int cellCount );
	~cNaviFieldBranchNode();

	/// ȭ
	void SyncHeight();

	/// ø
	void Cull( tArray<cNaviFieldLeafNode*>* visibleArray, NiFrustumPlanes& frustum );

	///  迭 ߰
	void AddToVisibleArray( tArray<cNaviFieldLeafNode*>* visibleArray );

	///   浹 ˻
	bool CollideRay( NiPoint3* contact, float* distance, const cRay& ray );

protected:
	///  ڸ 
	void UpdateBoundUpward();

public:
	/// ڽ 迭
	cNaviFieldNode* mChild[4];
};

/// ׺ʵ  
class cNaviFieldLeafNode : public cNaviFieldNode
{
	friend class cNaviField;
	friend class cNaviFieldBranchNode;
	friend class cNaviFieldNodeCompareForRendering;
#ifdef MAP_EDITOR
	friend class cNaviFieldNodePainting;
#endif

public:
	cNaviFieldLeafNode( cNaviFieldBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int gridSize );
	~cNaviFieldLeafNode();

	/// ȭ
	void SyncHeight();

	/// ø
	void Cull( tArray<cNaviFieldLeafNode*>* visibleArray, NiFrustumPlanes& frustum );

	///  迭 ߰
	void AddToVisibleArray( tArray<cNaviFieldLeafNode*>* visibleArray );

	///   浹 ˻
	bool CollideRay( NiPoint3* contact, float* distance, const cRay& ray );

	///  
	bool SyncToNaviField( const NiPoint3& pos, float innerRadius, float radius );

	/// Ʈ 
	bool SyncToObject( const NiPoint3& pos, float innerRadius, float radius, float z );

#ifdef MAP_EDITOR
	/// ĥ
	bool Color( const NiPoint3& pos, float radius, float red, float green, float blue, unsigned char value );
#endif

private:
	///  ڸ 
	void UpdateBoundUpward();

	///   
	void UpdateColors();

#ifdef MAP_EDITOR
	///   
	/// Undo, Redo ʿ  Ѵ.
	bool BackupPainting( cNaviFieldNodePaintingInfo* info, const NiPoint3& pos, float radius );

	/// ׺ʵ ʰ ȭ  
	void UpdatePainting( cNaviFieldNodePaintingInfo* info, const NiPoint3& pos, float radius );

	/// Undo, Redo
	void Undo( const cNaviFieldNodePainting& doing );
	void Redo( const cNaviFieldNodePainting& doing );
#endif

	///   
	bool CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float radius );

private:
	/// ǥ (׺ʵ ׸  ġ)
	unsigned int mXIndex;
	unsigned int mYIndex;

	/// 
	cNaviFieldBuffer* mBuffer;

private:
	///   ׸ ũ
	static unsigned int mCellCount;
	static unsigned int mLineCount;
};

/// ׺ʵ   Լ
class cNaviFieldNodeCompareForRendering
{
public:
	bool operator () ( const cNaviFieldLeafNode* left, const cNaviFieldLeafNode* right ) const
	{
		cNaviFieldBuffer* lbuff = left->mBuffer;
		cNaviFieldBuffer* rbuff = right->mBuffer;

		return lbuff < rbuff;
	};
};
