/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      : ׺޽
* ǻ : 
*===========================================================================*/
#pragma once

#include "Shader.h"

class cRay;
class cBox;
class cSceneNode;
class cNaviMeshBranchNode;
class cNaviMeshLeafNode;
#ifdef MAP_EDITOR
class cNaviMeshBuildingInfo;
#endif

/// ׺޽ 
const unsigned int NAVIMESH_DEFAULT_RESOLUTION = 512;
const unsigned int NAVIMESH_BUFF_CELL_COUNT = 128;
const unsigned int NAVIMESH_BUFF_LINE_COUNT = NAVIMESH_BUFF_CELL_COUNT + 1;
const unsigned int NAVIMESH_BUFF_VERT_COUNT = NAVIMESH_BUFF_LINE_COUNT * NAVIMESH_BUFF_LINE_COUNT;
const unsigned int NAVIMESH_LEAF_CELL_COUNT = 8;
const unsigned int NAVIMESH_LEAF_LINE_COUNT = NAVIMESH_LEAF_CELL_COUNT + 1;
const unsigned int NAVIMESH_LEAF_LINE_COUNT_X2 = NAVIMESH_LEAF_LINE_COUNT * 2;
const unsigned int NAVIMESH_LEAF_VERT_COUNT = NAVIMESH_LEAF_LINE_COUNT * NAVIMESH_LEAF_LINE_COUNT;

/// ׺޽ ε  ڵ
const int NAVIMESH_LOAD_ERROR_OPEN = -1;
const int NAVIMESH_LOAD_ERROR_FILE_HEADER = -2;
const int NAVIMESH_LOAD_ERROR_FILE_TYPE = -3;
const int NAVIMESH_LOAD_ERROR_FILE_VERSION = -4;
const int NAVIMESH_LOAD_ERROR_GRID_SIZE = -5;
const int NAVIMESH_LOAD_ERROR_TEXTURE_NAME = -6;
const int NAVIMESH_LOAD_ERROR_TEXTURE = -7;
const int NAVIMESH_LOAD_ERROR_NODE = -8;

/// ׺޽  
#pragma pack( push, 1 )
class cNaviMeshFileHeader
{
public:
	/// ĺ ڵ
	char mCode[13];

	/// 
	unsigned int mVersion;

	/// ׸ ũ ( )
	unsigned int mCellCount;

	///   
	float mMetersPerVertex;

	/// ʹ   ( 100 )
	unsigned int mUnitsPerMeter;
};
#pragma pack( pop )

/// ׺޽ 
class cNaviMeshBuffer
{
	friend class cNaviMesh;
	friend class cNaviMeshLeafNode;

public:
	cNaviMeshBuffer();
	~cNaviMeshBuffer();

	bool Init( cNaviMesh* naviMesh, unsigned int xi, unsigned int yi );

protected:
	void UpdatePosCoord( cNaviMesh* naviMesh, unsigned int xstart, unsigned ystart, unsigned int count );

private:
	unsigned int mXIndex;
	unsigned int mYIndex;

	/// DX9
	LPDIRECT3DVERTEXBUFFER9 mPosCoordBuffer;
};

/// ׺޽
class cNaviMesh
{
	static cNaviMesh* mSingleton;
	friend class cNaviMeshLeafNode;
	friend class cNaviMeshBuffer;
	friend class cNaviMeshBuilding;

public:
	cNaviMesh();
	~cNaviMesh();

	/// 
	void Clear();

	/// ʱȭ
	void Init( unsigned int cellCount, float metersPerVertex = 1.0f, unsigned int unitsPerMeter = 100 );
	bool IsInited() const;

	/// ε
	int Load( const cString& pathName );

	/// 
	bool Save( const cString& pathName );

	/// ó
	void Process();

	/// 
	void Render();

	/// 
	cNaviMeshBuffer* GetBuffer( unsigned int xi, unsigned int yi );

	/// ŷ
	bool Pick( NiPoint3* pos, int mouseX, int mouseY );
	bool Pick( NiPoint3* pos, const cRay& ray );
	bool Pick( NiPoint3* pos, float* dist, const cRay& ray, float maxDistance );

	/// ̰
	bool CalcHeight( float* height, float x, float y ) const;
	bool GetHeight( float* height, unsigned int xi, unsigned int yi ) const;
	const float* GetHeights() const;

	///  
	void SyncAllToTerrain();

#ifdef MAP_EDITOR
	/// 
	bool Raise( const NiPoint3& pos, float innerRadius, float outerRadius, float strength );
	bool Lower( const NiPoint3& pos, float innerRadius, float outerRadius, float strength );
	bool Flatten( const NiPoint3& pos, float innerRadius, float outerRadius, float strength );
	bool Smooth( const NiPoint3& pos, float outerRadius, float ratio );
#endif
	bool SyncToTerrain( const NiPoint3& pos, float innerRadius, float outerRadius );
	bool SyncToObject( const NiPoint3& pos, float outerRadius );
	bool SyncToPickHeight( const NiPoint3& pos, float innerRadius, float outerRadius, float z );

	/// ׸ ũ
	unsigned int GetCellCount() const;

	///  ͼ
	float GetMetersPerVertex() const;

	/// ʹ 
	unsigned int GetUnitsPerMeter() const;

	///   
	float GetUnitsPerVertex() const;

	///    
	float GetUnitsPerLeafNode() const;

	/// ش ġ  
	cNaviMeshLeafNode* GetLeafNode( float x, float y ) const;

	/// ̴   
	unsigned int GetNumVisibleNodes() const;

	///  
	const cBox& GetBoundBox() const;

	///  
	bool IsModified() const;

private:
#ifdef MAP_EDITOR
	/// 
	/// Undo, Redo ʿ  Ѵ.
	bool BackupBuilding( cNaviMeshBuildingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );

	/// 
	void UpdateBuilding( cNaviMeshBuildingInfo* info, unsigned int xbegin, unsigned int ybegin, unsigned int xend, unsigned int yend, const NiPoint3& pos, float outerRadius );
#endif

	///   
	bool CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float outerRadius );

	/// ׸ ũ⸦ ˻
	bool CheckCellCount( unsigned int cellCount );

	/// ش ġ  带 
	void SetLeafNode( unsigned int xi, unsigned int yi, cNaviMeshLeafNode* node );

	/// ̰
	void SetHeight( unsigned int xi, unsigned int yi, float height );
	float GetHeightFast( unsigned int xi, unsigned int yi ) const;

public:
	/// ü 
	static cNaviMesh* GetSingleton();

private:
	/// ʱȭ 
	bool mInited;

	/// ׸ ũ
	unsigned int mCellCount;
	unsigned int mLineCount;

	///   ( 1 )
	float mMetersPerVertex;

	/// ʹ  ( 100 )
	unsigned int mUnitsPerMeter;

	///  
	float mUnitsPerVertex;

	///   
	float mUnitsPerLeafNode;

	/// Ʈ 
	cNaviMeshBranchNode* mRootNode;

	///   迭
	typedef tArray<cNaviMeshLeafNode*> cLeafNodeArray;
	cLeafNodeArray mNodeArray;

	///  迭
	float* mHeights;

	///  迭
	cLeafNodeArray mVisibleArray;

	/// ̴
	cTerrainShader mShader;

	/// 
	cNaviMeshBuffer** mBuffer;

	/// DX9
	LPDIRECT3DVERTEXDECLARATION9 mVertexDeclaration;
	LPDIRECT3DINDEXBUFFER9 mIndexBuffer;

	///  
	bool mModified;
};

inline
bool cNaviMesh::IsInited() const
{
	return mInited;
}

inline
cNaviMeshBuffer* cNaviMesh::GetBuffer( unsigned int xi, unsigned int yi )
{
	return &(mBuffer[yi / NAVIMESH_BUFF_CELL_COUNT][xi / NAVIMESH_BUFF_CELL_COUNT]);
}

inline
unsigned int cNaviMesh::GetCellCount() const
{
	return mCellCount;
}

inline
float cNaviMesh::GetMetersPerVertex() const
{
	return mMetersPerVertex;
}

inline
unsigned int cNaviMesh::GetUnitsPerMeter() const
{
	return mUnitsPerMeter;
}

inline
float cNaviMesh::GetUnitsPerVertex() const
{
	return mUnitsPerVertex;
}

inline
float cNaviMesh::GetUnitsPerLeafNode() const
{
	return mUnitsPerLeafNode;
}

inline
unsigned int cNaviMesh::GetNumVisibleNodes() const
{
	return mVisibleArray.GetSize();
}

inline
void cNaviMesh::SetHeight( unsigned int xi, unsigned int yi, float height )
{
	mHeights[yi * mLineCount + xi] = height;
}

inline
float cNaviMesh::GetHeightFast( unsigned int xi, unsigned int yi ) const
{
	return mHeights[yi * mLineCount + xi];
}

inline
const float* cNaviMesh::GetHeights() const
{
	return mHeights;
}

inline
bool cNaviMesh::IsModified() const
{
	return mModified;
}

inline
cNaviMesh* cNaviMesh::GetSingleton()
{
	return mSingleton;
}

#define NAVIMESH cNaviMesh::GetSingleton()
