/* ==========================================================================
*    : ̼
*    : 2006.12.04
*      : ׺޽ 
* ǻ : 
*===========================================================================*/
#pragma once

#include "Box.h"

class cRay;
class cNaviMeshBranchNode;
class cNaviMeshLeafNode;
class cNaviMeshBuffer;
#ifdef MAP_EDITOR
class cNaviMeshNodeBuildingInfo;
class cNaviMeshNodeBuilding;
#endif

/// ׺޽ 
class cNaviMeshNode
{
public:
	cNaviMeshNode( cNaviMeshBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int cellCount );
	virtual ~cNaviMeshNode();

	/// ε
	virtual bool Load( cFileLoader& loader ) = 0;

	/// 
	virtual bool Save( cFileSaver& saver ) = 0;

	/// ׺޽ ̸ʰ ȭ
	virtual void SyncHeight() = 0;

	/// ø
	virtual void Cull( tArray<cNaviMeshLeafNode*>* visibleArray, NiFrustumPlanes& frustum ) = 0;

	///  迭 ߰
	virtual void AddToVisibleArray( tArray<cNaviMeshLeafNode*>* visibleArray ) = 0;

	/// 浹 ˻
	virtual bool CollideRay( NiPoint3* contact, float* distance, const cRay& ray, float maxDistance ) = 0;

	///  
	const cBox& GetBoundBox() const;

public:
	/// θ
	cNaviMeshBranchNode* mParent;

	/// 
	cBox mBoundBox;
	NiPoint3 mCenter;
	float mRadius;
};

inline
const cBox& cNaviMeshNode::GetBoundBox() const
{
	return mBoundBox;
}

/// ׺޽  
class cNaviMeshBranchNode : public cNaviMeshNode
{
	friend class cNaviMeshLeafNode;

public:
	cNaviMeshBranchNode( cNaviMeshBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int cellCount );
	~cNaviMeshBranchNode();

	/// ε
	bool Load( cFileLoader& loader );

	/// 
	bool Save( cFileSaver& saver );

	///  ̸ʰ ȭ
	void SyncHeight();

	/// ø
	void Cull( tArray<cNaviMeshLeafNode*>* visibleArray, NiFrustumPlanes& frustum );

	///  迭 ߰
	void AddToVisibleArray( tArray<cNaviMeshLeafNode*>* visibleArray );

	/// 浹 ˻
	bool CollideRay( NiPoint3* contact, float* distance, const cRay& ray, float maxDistance = NI_INFINITY );

protected:
	///  ڸ 
	void UpdateBoundUpward();

public:
	/// ڽ 迭
	cNaviMeshNode* mChild[4];
};

/// ׺޽  
class cNaviMeshLeafNode : public cNaviMeshNode
{
	friend class cNaviMesh;
	friend class cNaviMeshBranchNode;
	friend class cNaviMeshNodeCompareForRendering;
#ifdef MAP_EDITOR
	friend class cNaviMeshNodeBuilding;
	friend class cNaviFieldNodePainting;
#endif

public:
	cNaviMeshLeafNode( cNaviMeshBranchNode* parent, unsigned int xi, unsigned int yi, unsigned int gridSize );
	~cNaviMeshLeafNode();

	/// ε
	bool Load( cFileLoader& loader );

	/// 
	bool Save( cFileSaver& saver );

	///  ̸ʰ ȭ
	void SyncHeight();

	/// ø
	void Cull( tArray<cNaviMeshLeafNode*>* visibleArray, NiFrustumPlanes& frustum );

	///  迭 ߰
	void AddToVisibleArray( tArray<cNaviMeshLeafNode*>* visibleArray );

	/// 浹 ˻
	bool CollideRay( NiPoint3* contact, float* distance, const cRay& ray, float maxDistance = NI_INFINITY );

#ifdef MAP_EDITOR
	/// ø
	bool Raise( const NiPoint3& pos, float innerRadius, float outerRadius, float maxValue );

	/// 
	bool Lower( const NiPoint3& pos, float innerRadius, float outerRadius, float maxValue );

	/// ϰ 
	bool Flatten( const NiPoint3& pos, float innerRadius, float outerRadius, float maxValue );

	/// ε巴 
	/// ratio [0.1, 1]    Ѵ.
	bool Smooth( const NiPoint3& pos, float outerRadius, float ratio );
#endif

	///  
	bool SyncToTerrain( const NiPoint3& pos, float innerRadius, float outerRadius );

	/// Ʈ 
	bool SyncToObject( const NiPoint3& pos, float outerRadius );

	/// ŷ ̿ 
	bool SyncToPickHeight( const NiPoint3& pos, float innerRadius, float outerRadius, float z );

private:
	///  ڸ 
	void UpdateBoundUpward();

	///   
	void UpdatePosCoords();

#ifdef MAP_EDITOR
	///   
	/// Undo, Redo ʿ  Ѵ.
	bool BackupBuilding( cNaviMeshNodeBuildingInfo* info, const NiPoint3& pos, float outerRadius );

	/// ׺޽ ̸ʰ ȭ  
	/// ȭ    ũ Ѵ.
	void UpdateBuilding( cNaviMeshNodeBuildingInfo* info, const NiPoint3& pos, float outerRadius );

	/// Undo, Redo
	void Undo( const cNaviMeshNodeBuilding& doing );
	void Redo( const cNaviMeshNodeBuilding& doing );
#endif

	///   
	bool CalcRange( unsigned int* xbegin, unsigned int* ybegin, unsigned int* xend, unsigned int* yend, const NiPoint3& pos, float outerRadius );

private:
	/// ǥ (׺޽ ׸  ġ)
	unsigned int mXIndex;
	unsigned int mYIndex;

	/// 
	cNaviMeshBuffer* mBuffer;

	///  迭
	float* mHeights;

private:
	/// 
	static unsigned int mVersion;

	///   ׸ ũ
	static unsigned int mCellCount;
	static unsigned int mLineCount;
};

/// ׺޽   Լ
class cNaviMeshNodeCompareForRendering
{
public:
	bool operator () ( const cNaviMeshLeafNode* left, const cNaviMeshLeafNode* right ) const
	{
		cNaviMeshBuffer* lbuff = left->mBuffer;
		cNaviMeshBuffer* rbuff = right->mBuffer;

		return lbuff < rbuff;
	};
};
